/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EpisodeOfCareStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="episodeOfCare-0", level="Warning", location="diagnosis.role", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/diagnosis-role", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/diagnosis-role', 'preferred')", generated=true)
public class EpisodeOfCare
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="EpisodeOfCareStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The status of the episode of care.", valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status|4.0.1")
    @Required
    private final EpisodeOfCareStatus status;
    private final List<StatusHistory> statusHistory;
    @Summary
    @Binding(bindingName="EpisodeOfCareType", strength=BindingStrength.ValueSet.EXAMPLE, description="The type of the episode of care.", valueSet="http://hl7.org/fhir/ValueSet/episodeofcare-type")
    private final List<CodeableConcept> type;
    @Summary
    private final List<Diagnosis> diagnosis;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference managingOrganization;
    @Summary
    private final Period period;
    @ReferenceTarget(value={"ServiceRequest"})
    private final List<Reference> referralRequest;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference careManager;
    @ReferenceTarget(value={"CareTeam"})
    private final List<Reference> team;
    @ReferenceTarget(value={"Account"})
    private final List<Reference> account;
    private volatile int hashCode;

    private EpisodeOfCare(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.statusHistory = Collections.unmodifiableList(ValidationSupport.checkList(builder.statusHistory, "statusHistory", StatusHistory.class));
        this.type = Collections.unmodifiableList(ValidationSupport.checkList(builder.type, "type", CodeableConcept.class));
        this.diagnosis = Collections.unmodifiableList(ValidationSupport.checkList(builder.diagnosis, "diagnosis", Diagnosis.class));
        this.patient = ValidationSupport.requireNonNull(builder.patient, "patient");
        this.managingOrganization = builder.managingOrganization;
        this.period = builder.period;
        this.referralRequest = Collections.unmodifiableList(ValidationSupport.checkList(builder.referralRequest, "referralRequest", Reference.class));
        this.careManager = builder.careManager;
        this.team = Collections.unmodifiableList(ValidationSupport.checkList(builder.team, "team", Reference.class));
        this.account = Collections.unmodifiableList(ValidationSupport.checkList(builder.account, "account", Reference.class));
        ValidationSupport.checkReferenceType(this.patient, "patient", "Patient");
        ValidationSupport.checkReferenceType(this.managingOrganization, "managingOrganization", "Organization");
        ValidationSupport.checkReferenceType(this.referralRequest, "referralRequest", "ServiceRequest");
        ValidationSupport.checkReferenceType(this.careManager, "careManager", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.team, "team", "CareTeam");
        ValidationSupport.checkReferenceType(this.account, "account", "Account");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public EpisodeOfCareStatus getStatus() {
        return this.status;
    }

    public List<StatusHistory> getStatusHistory() {
        return this.statusHistory;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public List<Diagnosis> getDiagnosis() {
        return this.diagnosis;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getManagingOrganization() {
        return this.managingOrganization;
    }

    public Period getPeriod() {
        return this.period;
    }

    public List<Reference> getReferralRequest() {
        return this.referralRequest;
    }

    public Reference getCareManager() {
        return this.careManager;
    }

    public List<Reference> getTeam() {
        return this.team;
    }

    public List<Reference> getAccount() {
        return this.account;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.statusHistory.isEmpty() || !this.type.isEmpty() || !this.diagnosis.isEmpty() || this.patient != null || this.managingOrganization != null || this.period != null || !this.referralRequest.isEmpty() || this.careManager != null || !this.team.isEmpty() || !this.account.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusHistory, "statusHistory", visitor, StatusHistory.class);
                this.accept(this.type, "type", visitor, CodeableConcept.class);
                this.accept(this.diagnosis, "diagnosis", visitor, Diagnosis.class);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.managingOrganization, "managingOrganization", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.referralRequest, "referralRequest", visitor, Reference.class);
                this.accept(this.careManager, "careManager", visitor);
                this.accept(this.team, "team", visitor, Reference.class);
                this.accept(this.account, "account", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EpisodeOfCare other = (EpisodeOfCare)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.statusHistory, other.statusHistory) && Objects.equals(this.type, other.type) && Objects.equals(this.diagnosis, other.diagnosis) && Objects.equals(this.patient, other.patient) && Objects.equals(this.managingOrganization, other.managingOrganization) && Objects.equals(this.period, other.period) && Objects.equals(this.referralRequest, other.referralRequest) && Objects.equals(this.careManager, other.careManager) && Objects.equals(this.team, other.team) && Objects.equals(this.account, other.account);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.statusHistory, this.type, this.diagnosis, this.patient, this.managingOrganization, this.period, this.referralRequest, this.careManager, this.team, this.account);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Diagnosis
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Condition"})
        @Required
        private final Reference condition;
        @Summary
        @Binding(bindingName="DiagnosisRole", strength=BindingStrength.ValueSet.PREFERRED, description="The type of diagnosis this condition represents.", valueSet="http://hl7.org/fhir/ValueSet/diagnosis-role")
        private final CodeableConcept role;
        @Summary
        private final PositiveInt rank;
        private volatile int hashCode;

        private Diagnosis(Builder builder) {
            super(builder);
            this.condition = ValidationSupport.requireNonNull(builder.condition, "condition");
            this.role = builder.role;
            this.rank = builder.rank;
            ValidationSupport.checkReferenceType(this.condition, "condition", "Condition");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Reference getCondition() {
            return this.condition;
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        public PositiveInt getRank() {
            return this.rank;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.condition != null || this.role != null || this.rank != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.condition, "condition", visitor);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.rank, "rank", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Diagnosis other = (Diagnosis)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.condition, other.condition) && Objects.equals(this.role, other.role) && Objects.equals(this.rank, other.rank);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.condition, this.role, this.rank);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference condition;
            private CodeableConcept role;
            private PositiveInt rank;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder condition(Reference condition) {
                this.condition = condition;
                return this;
            }

            public Builder role(CodeableConcept role) {
                this.role = role;
                return this;
            }

            public Builder rank(PositiveInt rank) {
                this.rank = rank;
                return this;
            }

            @Override
            public Diagnosis build() {
                return new Diagnosis(this);
            }

            protected Builder from(Diagnosis diagnosis) {
                super.from(diagnosis);
                this.condition = diagnosis.condition;
                this.role = diagnosis.role;
                this.rank = diagnosis.rank;
                return this;
            }
        }
    }

    public static class StatusHistory
    extends BackboneElement {
        @Binding(bindingName="EpisodeOfCareStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The status of the episode of care.", valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status|4.0.1")
        @Required
        private final EpisodeOfCareStatus status;
        @Required
        private final Period period;
        private volatile int hashCode;

        private StatusHistory(Builder builder) {
            super(builder);
            this.status = ValidationSupport.requireNonNull(builder.status, "status");
            this.period = ValidationSupport.requireNonNull(builder.period, "period");
            ValidationSupport.requireValueOrChildren(this);
        }

        public EpisodeOfCareStatus getStatus() {
            return this.status;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.status != null || this.period != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatusHistory other = (StatusHistory)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.status, other.status) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.status, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private EpisodeOfCareStatus status;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder status(EpisodeOfCareStatus status) {
                this.status = status;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public StatusHistory build() {
                return new StatusHistory(this);
            }

            protected Builder from(StatusHistory statusHistory) {
                super.from(statusHistory);
                this.status = statusHistory.status;
                this.period = statusHistory.period;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private EpisodeOfCareStatus status;
        private List<StatusHistory> statusHistory = new ArrayList<StatusHistory>();
        private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        private List<Diagnosis> diagnosis = new ArrayList<Diagnosis>();
        private Reference patient;
        private Reference managingOrganization;
        private Period period;
        private List<Reference> referralRequest = new ArrayList<Reference>();
        private Reference careManager;
        private List<Reference> team = new ArrayList<Reference>();
        private List<Reference> account = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(EpisodeOfCareStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusHistory(StatusHistory ... statusHistory) {
            for (StatusHistory value : statusHistory) {
                this.statusHistory.add(value);
            }
            return this;
        }

        public Builder statusHistory(Collection<StatusHistory> statusHistory) {
            this.statusHistory = new ArrayList<StatusHistory>(statusHistory);
            return this;
        }

        public Builder type(CodeableConcept ... type) {
            for (CodeableConcept value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<CodeableConcept> type) {
            this.type = new ArrayList<CodeableConcept>(type);
            return this;
        }

        public Builder diagnosis(Diagnosis ... diagnosis) {
            for (Diagnosis value : diagnosis) {
                this.diagnosis.add(value);
            }
            return this;
        }

        public Builder diagnosis(Collection<Diagnosis> diagnosis) {
            this.diagnosis = new ArrayList<Diagnosis>(diagnosis);
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder managingOrganization(Reference managingOrganization) {
            this.managingOrganization = managingOrganization;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder referralRequest(Reference ... referralRequest) {
            for (Reference value : referralRequest) {
                this.referralRequest.add(value);
            }
            return this;
        }

        public Builder referralRequest(Collection<Reference> referralRequest) {
            this.referralRequest = new ArrayList<Reference>(referralRequest);
            return this;
        }

        public Builder careManager(Reference careManager) {
            this.careManager = careManager;
            return this;
        }

        public Builder team(Reference ... team) {
            for (Reference value : team) {
                this.team.add(value);
            }
            return this;
        }

        public Builder team(Collection<Reference> team) {
            this.team = new ArrayList<Reference>(team);
            return this;
        }

        public Builder account(Reference ... account) {
            for (Reference value : account) {
                this.account.add(value);
            }
            return this;
        }

        public Builder account(Collection<Reference> account) {
            this.account = new ArrayList<Reference>(account);
            return this;
        }

        @Override
        public EpisodeOfCare build() {
            return new EpisodeOfCare(this);
        }

        protected Builder from(EpisodeOfCare episodeOfCare) {
            super.from(episodeOfCare);
            this.identifier.addAll(episodeOfCare.identifier);
            this.status = episodeOfCare.status;
            this.statusHistory.addAll(episodeOfCare.statusHistory);
            this.type.addAll(episodeOfCare.type);
            this.diagnosis.addAll(episodeOfCare.diagnosis);
            this.patient = episodeOfCare.patient;
            this.managingOrganization = episodeOfCare.managingOrganization;
            this.period = episodeOfCare.period;
            this.referralRequest.addAll(episodeOfCare.referralRequest);
            this.careManager = episodeOfCare.careManager;
            this.team.addAll(episodeOfCare.team);
            this.account.addAll(episodeOfCare.account);
            return this;
        }
    }
}

