/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CompartmentCode;
import com.ibm.fhir.model.type.code.GraphCompartmentRule;
import com.ibm.fhir.model.type.code.GraphCompartmentUse;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="gdf-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')"), @Constraint(id="graphDefinition-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", generated=true)})
public class GraphDefinition
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final String version;
    @Summary
    @Required
    private final String name;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    @Summary
    @Binding(bindingName="ResourceType", strength=BindingStrength.ValueSet.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
    @Required
    private final ResourceType start;
    private final Canonical profile;
    private final List<Link> link;
    private volatile int hashCode;

    private GraphDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.version = builder.version;
        this.name = ValidationSupport.requireNonNull(builder.name, "name");
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactDetail.class));
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(ValidationSupport.checkList(builder.useContext, "useContext", UsageContext.class));
        this.jurisdiction = Collections.unmodifiableList(ValidationSupport.checkList(builder.jurisdiction, "jurisdiction", CodeableConcept.class));
        this.purpose = builder.purpose;
        this.start = ValidationSupport.requireNonNull(builder.start, "start");
        this.profile = builder.profile;
        this.link = Collections.unmodifiableList(ValidationSupport.checkList(builder.link, "link", Link.class));
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public ResourceType getStart() {
        return this.start;
    }

    public Canonical getProfile() {
        return this.profile;
    }

    public List<Link> getLink() {
        return this.link;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.version != null || this.name != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.start != null || this.profile != null || !this.link.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.start, "start", visitor);
                this.accept(this.profile, "profile", visitor);
                this.accept(this.link, "link", visitor, Link.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphDefinition other = (GraphDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.start, other.start) && Objects.equals(this.profile, other.profile) && Objects.equals(this.link, other.link);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.version, this.name, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.start, this.profile, this.link);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Link
    extends BackboneElement {
        private final String path;
        private final String sliceName;
        private final Integer min;
        private final String max;
        private final String description;
        private final List<Target> target;
        private volatile int hashCode;

        private Link(Builder builder) {
            super(builder);
            this.path = builder.path;
            this.sliceName = builder.sliceName;
            this.min = builder.min;
            this.max = builder.max;
            this.description = builder.description;
            this.target = Collections.unmodifiableList(ValidationSupport.checkList(builder.target, "target", Target.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public String getPath() {
            return this.path;
        }

        public String getSliceName() {
            return this.sliceName;
        }

        public Integer getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Target> getTarget() {
            return this.target;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.path != null || this.sliceName != null || this.min != null || this.max != null || this.description != null || !this.target.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.path, "path", visitor);
                    this.accept(this.sliceName, "sliceName", visitor);
                    this.accept(this.min, "min", visitor);
                    this.accept(this.max, "max", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.target, "target", visitor, Target.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.sliceName, other.sliceName) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.description, other.description) && Objects.equals(this.target, other.target);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.sliceName, this.min, this.max, this.description, this.target);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Target
        extends BackboneElement {
            @Binding(bindingName="ResourceType", strength=BindingStrength.ValueSet.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
            @Required
            private final ResourceType type;
            private final String params;
            private final Canonical profile;
            private final List<Compartment> compartment;
            private final List<Link> link;
            private volatile int hashCode;

            private Target(Builder builder) {
                super(builder);
                this.type = ValidationSupport.requireNonNull(builder.type, "type");
                this.params = builder.params;
                this.profile = builder.profile;
                this.compartment = Collections.unmodifiableList(ValidationSupport.checkList(builder.compartment, "compartment", Compartment.class));
                this.link = Collections.unmodifiableList(ValidationSupport.checkList(builder.link, "link", Link.class));
                ValidationSupport.requireValueOrChildren(this);
            }

            public ResourceType getType() {
                return this.type;
            }

            public String getParams() {
                return this.params;
            }

            public Canonical getProfile() {
                return this.profile;
            }

            public List<Compartment> getCompartment() {
                return this.compartment;
            }

            public List<Link> getLink() {
                return this.link;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.params != null || this.profile != null || !this.compartment.isEmpty() || !this.link.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.params, "params", visitor);
                        this.accept(this.profile, "profile", visitor);
                        this.accept(this.compartment, "compartment", visitor, Compartment.class);
                        this.accept(this.link, "link", visitor, Link.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Target other = (Target)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.params, other.params) && Objects.equals(this.profile, other.profile) && Objects.equals(this.compartment, other.compartment) && Objects.equals(this.link, other.link);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.params, this.profile, this.compartment, this.link);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Compartment
            extends BackboneElement {
                @Binding(bindingName="GraphCompartmentUse", strength=BindingStrength.ValueSet.REQUIRED, description="Defines how a compartment rule is used.", valueSet="http://hl7.org/fhir/ValueSet/graph-compartment-use|4.0.1")
                @Required
                private final GraphCompartmentUse use;
                @Binding(bindingName="CompartmentCode", strength=BindingStrength.ValueSet.REQUIRED, description="Identifies a compartment.", valueSet="http://hl7.org/fhir/ValueSet/compartment-type|4.0.1")
                @Required
                private final CompartmentCode code;
                @Binding(bindingName="GraphCompartmentRule", strength=BindingStrength.ValueSet.REQUIRED, description="How a compartment must be linked.", valueSet="http://hl7.org/fhir/ValueSet/graph-compartment-rule|4.0.1")
                @Required
                private final GraphCompartmentRule rule;
                private final String expression;
                private final String description;
                private volatile int hashCode;

                private Compartment(Builder builder) {
                    super(builder);
                    this.use = ValidationSupport.requireNonNull(builder.use, "use");
                    this.code = ValidationSupport.requireNonNull(builder.code, "code");
                    this.rule = ValidationSupport.requireNonNull(builder.rule, "rule");
                    this.expression = builder.expression;
                    this.description = builder.description;
                    ValidationSupport.requireValueOrChildren(this);
                }

                public GraphCompartmentUse getUse() {
                    return this.use;
                }

                public CompartmentCode getCode() {
                    return this.code;
                }

                public GraphCompartmentRule getRule() {
                    return this.rule;
                }

                public String getExpression() {
                    return this.expression;
                }

                public String getDescription() {
                    return this.description;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.use != null || this.code != null || this.rule != null || this.expression != null || this.description != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.use, "use", visitor);
                            this.accept(this.code, "code", visitor);
                            this.accept(this.rule, "rule", visitor);
                            this.accept(this.expression, "expression", visitor);
                            this.accept(this.description, "description", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Compartment other = (Compartment)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.use, other.use) && Objects.equals(this.code, other.code) && Objects.equals(this.rule, other.rule) && Objects.equals(this.expression, other.expression) && Objects.equals(this.description, other.description);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.use, this.code, this.rule, this.expression, this.description);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private GraphCompartmentUse use;
                    private CompartmentCode code;
                    private GraphCompartmentRule rule;
                    private String expression;
                    private String description;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder use(GraphCompartmentUse use) {
                        this.use = use;
                        return this;
                    }

                    public Builder code(CompartmentCode code) {
                        this.code = code;
                        return this;
                    }

                    public Builder rule(GraphCompartmentRule rule) {
                        this.rule = rule;
                        return this;
                    }

                    public Builder expression(String expression) {
                        this.expression = expression;
                        return this;
                    }

                    public Builder description(String description) {
                        this.description = description;
                        return this;
                    }

                    @Override
                    public Compartment build() {
                        return new Compartment(this);
                    }

                    protected Builder from(Compartment compartment) {
                        super.from(compartment);
                        this.use = compartment.use;
                        this.code = compartment.code;
                        this.rule = compartment.rule;
                        this.expression = compartment.expression;
                        this.description = compartment.description;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ResourceType type;
                private String params;
                private Canonical profile;
                private List<Compartment> compartment = new ArrayList<Compartment>();
                private List<Link> link = new ArrayList<Link>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(ResourceType type) {
                    this.type = type;
                    return this;
                }

                public Builder params(String params) {
                    this.params = params;
                    return this;
                }

                public Builder profile(Canonical profile) {
                    this.profile = profile;
                    return this;
                }

                public Builder compartment(Compartment ... compartment) {
                    for (Compartment value : compartment) {
                        this.compartment.add(value);
                    }
                    return this;
                }

                public Builder compartment(Collection<Compartment> compartment) {
                    this.compartment = new ArrayList<Compartment>(compartment);
                    return this;
                }

                public Builder link(Link ... link) {
                    for (Link value : link) {
                        this.link.add(value);
                    }
                    return this;
                }

                public Builder link(Collection<Link> link) {
                    this.link = new ArrayList<Link>(link);
                    return this;
                }

                @Override
                public Target build() {
                    return new Target(this);
                }

                protected Builder from(Target target) {
                    super.from(target);
                    this.type = target.type;
                    this.params = target.params;
                    this.profile = target.profile;
                    this.compartment.addAll(target.compartment);
                    this.link.addAll(target.link);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String path;
            private String sliceName;
            private Integer min;
            private String max;
            private String description;
            private List<Target> target = new ArrayList<Target>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder sliceName(String sliceName) {
                this.sliceName = sliceName;
                return this;
            }

            public Builder min(Integer min) {
                this.min = min;
                return this;
            }

            public Builder max(String max) {
                this.max = max;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder target(Target ... target) {
                for (Target value : target) {
                    this.target.add(value);
                }
                return this;
            }

            public Builder target(Collection<Target> target) {
                this.target = new ArrayList<Target>(target);
                return this;
            }

            @Override
            public Link build() {
                return new Link(this);
            }

            protected Builder from(Link link) {
                super.from(link);
                this.path = link.path;
                this.sliceName = link.sliceName;
                this.min = link.min;
                this.max = link.max;
                this.description = link.description;
                this.target.addAll(link.target);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private String version;
        private String name;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private ResourceType start;
        private Canonical profile;
        private List<Link> link = new ArrayList<Link>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder start(ResourceType start) {
            this.start = start;
            return this;
        }

        public Builder profile(Canonical profile) {
            this.profile = profile;
            return this;
        }

        public Builder link(Link ... link) {
            for (Link value : link) {
                this.link.add(value);
            }
            return this;
        }

        public Builder link(Collection<Link> link) {
            this.link = new ArrayList<Link>(link);
            return this;
        }

        @Override
        public GraphDefinition build() {
            return new GraphDefinition(this);
        }

        protected Builder from(GraphDefinition graphDefinition) {
            super.from(graphDefinition);
            this.url = graphDefinition.url;
            this.version = graphDefinition.version;
            this.name = graphDefinition.name;
            this.status = graphDefinition.status;
            this.experimental = graphDefinition.experimental;
            this.date = graphDefinition.date;
            this.publisher = graphDefinition.publisher;
            this.contact.addAll(graphDefinition.contact);
            this.description = graphDefinition.description;
            this.useContext.addAll(graphDefinition.useContext);
            this.jurisdiction.addAll(graphDefinition.jurisdiction);
            this.purpose = graphDefinition.purpose;
            this.start = graphDefinition.start;
            this.profile = graphDefinition.profile;
            this.link.addAll(graphDefinition.link);
            return this;
        }
    }
}

