/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.GroupType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="grp-1", level="Rule", location="(base)", description="Can only have members if group is \"actual\"", expression="member.empty() or (actual = true)")
public class Group
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    @Binding(bindingName="GroupType", strength=BindingStrength.ValueSet.REQUIRED, description="Types of resources that are part of group.", valueSet="http://hl7.org/fhir/ValueSet/group-type|4.0.1")
    @Required
    private final GroupType type;
    @Summary
    @Required
    private final Boolean actual;
    @Summary
    @Binding(bindingName="GroupKind", strength=BindingStrength.ValueSet.EXAMPLE, description="Kind of particular resource; e.g. cow, syringe, lake, etc.")
    private final CodeableConcept code;
    @Summary
    private final String name;
    @Summary
    private final UnsignedInt quantity;
    @Summary
    @ReferenceTarget(value={"Organization", "RelatedPerson", "Practitioner", "PractitionerRole"})
    private final Reference managingEntity;
    private final List<Characteristic> characteristic;
    private final List<Member> member;
    private volatile int hashCode;

    private Group(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.active = builder.active;
        this.type = ValidationSupport.requireNonNull(builder.type, "type");
        this.actual = ValidationSupport.requireNonNull(builder.actual, "actual");
        this.code = builder.code;
        this.name = builder.name;
        this.quantity = builder.quantity;
        this.managingEntity = builder.managingEntity;
        this.characteristic = Collections.unmodifiableList(ValidationSupport.checkList(builder.characteristic, "characteristic", Characteristic.class));
        this.member = Collections.unmodifiableList(ValidationSupport.checkList(builder.member, "member", Member.class));
        ValidationSupport.checkReferenceType(this.managingEntity, "managingEntity", "Organization", "RelatedPerson", "Practitioner", "PractitionerRole");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public GroupType getType() {
        return this.type;
    }

    public Boolean getActual() {
        return this.actual;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public UnsignedInt getQuantity() {
        return this.quantity;
    }

    public Reference getManagingEntity() {
        return this.managingEntity;
    }

    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public List<Member> getMember() {
        return this.member;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || this.type != null || this.actual != null || this.code != null || this.name != null || this.quantity != null || this.managingEntity != null || !this.characteristic.isEmpty() || !this.member.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.actual, "actual", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.managingEntity, "managingEntity", visitor);
                this.accept(this.characteristic, "characteristic", visitor, Characteristic.class);
                this.accept(this.member, "member", visitor, Member.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.type, other.type) && Objects.equals(this.actual, other.actual) && Objects.equals(this.code, other.code) && Objects.equals(this.name, other.name) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.managingEntity, other.managingEntity) && Objects.equals(this.characteristic, other.characteristic) && Objects.equals(this.member, other.member);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.type, this.actual, this.code, this.name, this.quantity, this.managingEntity, this.characteristic, this.member);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Member
    extends BackboneElement {
        @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "Device", "Medication", "Substance", "Group"})
        @Required
        private final Reference entity;
        private final Period period;
        private final Boolean inactive;
        private volatile int hashCode;

        private Member(Builder builder) {
            super(builder);
            this.entity = ValidationSupport.requireNonNull(builder.entity, "entity");
            this.period = builder.period;
            this.inactive = builder.inactive;
            ValidationSupport.checkReferenceType(this.entity, "entity", "Patient", "Practitioner", "PractitionerRole", "Device", "Medication", "Substance", "Group");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Reference getEntity() {
            return this.entity;
        }

        public Period getPeriod() {
            return this.period;
        }

        public Boolean getInactive() {
            return this.inactive;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.entity != null || this.period != null || this.inactive != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.entity, "entity", visitor);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.inactive, "inactive", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.entity, other.entity) && Objects.equals(this.period, other.period) && Objects.equals(this.inactive, other.inactive);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.entity, this.period, this.inactive);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference entity;
            private Period period;
            private Boolean inactive;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder entity(Reference entity) {
                this.entity = entity;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            public Builder inactive(Boolean inactive) {
                this.inactive = inactive;
                return this;
            }

            @Override
            public Member build() {
                return new Member(this);
            }

            protected Builder from(Member member) {
                super.from(member);
                this.entity = member.entity;
                this.period = member.period;
                this.inactive = member.inactive;
                return this;
            }
        }
    }

    public static class Characteristic
    extends BackboneElement {
        @Binding(bindingName="GroupCharacteristicKind", strength=BindingStrength.ValueSet.EXAMPLE, description="List of characteristics used to describe group members; e.g. gender, age, owner, location, etc.")
        @Required
        private final CodeableConcept code;
        @Choice(value={CodeableConcept.class, Boolean.class, Quantity.class, Range.class, Reference.class})
        @Binding(bindingName="GroupCharacteristicValue", strength=BindingStrength.ValueSet.EXAMPLE, description="Value of descriptive member characteristic; e.g. red, male, pneumonia, Caucasian, etc.")
        @Required
        private final Element value;
        @Required
        private final Boolean exclude;
        private final Period period;
        private volatile int hashCode;

        private Characteristic(Builder builder) {
            super(builder);
            this.code = ValidationSupport.requireNonNull(builder.code, "code");
            this.value = ValidationSupport.requireChoiceElement(builder.value, "value", CodeableConcept.class, Boolean.class, Quantity.class, Range.class, Reference.class);
            this.exclude = ValidationSupport.requireNonNull(builder.exclude, "exclude");
            this.period = builder.period;
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Element getValue() {
            return this.value;
        }

        public Boolean getExclude() {
            return this.exclude;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.value != null || this.exclude != null || this.period != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.exclude, "exclude", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Characteristic other = (Characteristic)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value, this.exclude, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private Element value;
            private Boolean exclude;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            public Builder exclude(Boolean exclude) {
                this.exclude = exclude;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public Characteristic build() {
                return new Characteristic(this);
            }

            protected Builder from(Characteristic characteristic) {
                super.from(characteristic);
                this.code = characteristic.code;
                this.value = characteristic.value;
                this.exclude = characteristic.exclude;
                this.period = characteristic.period;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private GroupType type;
        private Boolean actual;
        private CodeableConcept code;
        private String name;
        private UnsignedInt quantity;
        private Reference managingEntity;
        private List<Characteristic> characteristic = new ArrayList<Characteristic>();
        private List<Member> member = new ArrayList<Member>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder type(GroupType type) {
            this.type = type;
            return this;
        }

        public Builder actual(Boolean actual) {
            this.actual = actual;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder quantity(UnsignedInt quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder managingEntity(Reference managingEntity) {
            this.managingEntity = managingEntity;
            return this;
        }

        public Builder characteristic(Characteristic ... characteristic) {
            for (Characteristic value : characteristic) {
                this.characteristic.add(value);
            }
            return this;
        }

        public Builder characteristic(Collection<Characteristic> characteristic) {
            this.characteristic = new ArrayList<Characteristic>(characteristic);
            return this;
        }

        public Builder member(Member ... member) {
            for (Member value : member) {
                this.member.add(value);
            }
            return this;
        }

        public Builder member(Collection<Member> member) {
            this.member = new ArrayList<Member>(member);
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }

        protected Builder from(Group group) {
            super.from(group);
            this.identifier.addAll(group.identifier);
            this.active = group.active;
            this.type = group.type;
            this.actual = group.actual;
            this.code = group.code;
            this.name = group.name;
            this.quantity = group.quantity;
            this.managingEntity = group.managingEntity;
            this.characteristic.addAll(group.characteristic);
            this.member.addAll(group.member);
            return this;
        }
    }
}

