/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.DaysOfWeek;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="healthcareService-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/c80-practice-codes", expression="specialty.exists() implies (specialty.all(memberOf('http://hl7.org/fhir/ValueSet/c80-practice-codes', 'preferred')))", generated=true), @Constraint(id="healthcareService-1", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="communication.exists() implies (communication.all(memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')))", generated=true)})
public class HealthcareService
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference providedBy;
    @Summary
    @Binding(bindingName="service-category", strength=BindingStrength.ValueSet.EXAMPLE, description="A category of the service(s) that could be provided.", valueSet="http://hl7.org/fhir/ValueSet/service-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="service-type", strength=BindingStrength.ValueSet.EXAMPLE, description="Additional details about where the content was created (e.g. clinical specialty).", valueSet="http://hl7.org/fhir/ValueSet/service-type")
    private final List<CodeableConcept> type;
    @Summary
    @Binding(bindingName="service-specialty", strength=BindingStrength.ValueSet.PREFERRED, description="A specialty that a healthcare service may provide.", valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    private final List<CodeableConcept> specialty;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final List<Reference> location;
    @Summary
    private final String name;
    @Summary
    private final String comment;
    private final Markdown extraDetails;
    @Summary
    private final Attachment photo;
    private final List<ContactPoint> telecom;
    @ReferenceTarget(value={"Location"})
    private final List<Reference> coverageArea;
    @Binding(bindingName="ServiceProvisionConditions", strength=BindingStrength.ValueSet.EXAMPLE, description="The code(s) that detail the conditions under which the healthcare service is available/offered.", valueSet="http://hl7.org/fhir/ValueSet/service-provision-conditions")
    private final List<CodeableConcept> serviceProvisionCode;
    private final List<Eligibility> eligibility;
    @Binding(bindingName="Program", strength=BindingStrength.ValueSet.EXAMPLE, description="Government or local programs that this service applies to.", valueSet="http://hl7.org/fhir/ValueSet/program")
    private final List<CodeableConcept> program;
    @Binding(bindingName="ServiceCharacteristic", strength=BindingStrength.ValueSet.EXAMPLE, description="A custom attribute that could be provided at a service (e.g. Wheelchair accessibiliy).")
    private final List<CodeableConcept> characteristic;
    @Binding(bindingName="Language", strength=BindingStrength.ValueSet.PREFERRED, description="A human language.", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
    private final List<CodeableConcept> communication;
    @Binding(bindingName="ReferralMethod", strength=BindingStrength.ValueSet.EXAMPLE, description="The methods of referral can be used when referring to a specific HealthCareService resource.", valueSet="http://hl7.org/fhir/ValueSet/service-referral-method")
    private final List<CodeableConcept> referralMethod;
    private final Boolean appointmentRequired;
    private final List<AvailableTime> availableTime;
    private final List<NotAvailable> notAvailable;
    private final String availabilityExceptions;
    @ReferenceTarget(value={"Endpoint"})
    private final List<Reference> endpoint;
    private volatile int hashCode;

    private HealthcareService(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.active = builder.active;
        this.providedBy = builder.providedBy;
        this.category = Collections.unmodifiableList(ValidationSupport.checkList(builder.category, "category", CodeableConcept.class));
        this.type = Collections.unmodifiableList(ValidationSupport.checkList(builder.type, "type", CodeableConcept.class));
        this.specialty = Collections.unmodifiableList(ValidationSupport.checkList(builder.specialty, "specialty", CodeableConcept.class));
        this.location = Collections.unmodifiableList(ValidationSupport.checkList(builder.location, "location", Reference.class));
        this.name = builder.name;
        this.comment = builder.comment;
        this.extraDetails = builder.extraDetails;
        this.photo = builder.photo;
        this.telecom = Collections.unmodifiableList(ValidationSupport.checkList(builder.telecom, "telecom", ContactPoint.class));
        this.coverageArea = Collections.unmodifiableList(ValidationSupport.checkList(builder.coverageArea, "coverageArea", Reference.class));
        this.serviceProvisionCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.serviceProvisionCode, "serviceProvisionCode", CodeableConcept.class));
        this.eligibility = Collections.unmodifiableList(ValidationSupport.checkList(builder.eligibility, "eligibility", Eligibility.class));
        this.program = Collections.unmodifiableList(ValidationSupport.checkList(builder.program, "program", CodeableConcept.class));
        this.characteristic = Collections.unmodifiableList(ValidationSupport.checkList(builder.characteristic, "characteristic", CodeableConcept.class));
        this.communication = Collections.unmodifiableList(ValidationSupport.checkList(builder.communication, "communication", CodeableConcept.class));
        this.referralMethod = Collections.unmodifiableList(ValidationSupport.checkList(builder.referralMethod, "referralMethod", CodeableConcept.class));
        this.appointmentRequired = builder.appointmentRequired;
        this.availableTime = Collections.unmodifiableList(ValidationSupport.checkList(builder.availableTime, "availableTime", AvailableTime.class));
        this.notAvailable = Collections.unmodifiableList(ValidationSupport.checkList(builder.notAvailable, "notAvailable", NotAvailable.class));
        this.availabilityExceptions = builder.availabilityExceptions;
        this.endpoint = Collections.unmodifiableList(ValidationSupport.checkList(builder.endpoint, "endpoint", Reference.class));
        ValidationSupport.checkValueSetBinding(this.communication, "communication", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new java.lang.String[0]);
        ValidationSupport.checkReferenceType(this.providedBy, "providedBy", "Organization");
        ValidationSupport.checkReferenceType(this.location, "location", "Location");
        ValidationSupport.checkReferenceType(this.coverageArea, "coverageArea", "Location");
        ValidationSupport.checkReferenceType(this.endpoint, "endpoint", "Endpoint");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Reference getProvidedBy() {
        return this.providedBy;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public List<CodeableConcept> getSpecialty() {
        return this.specialty;
    }

    public List<Reference> getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public Markdown getExtraDetails() {
        return this.extraDetails;
    }

    public Attachment getPhoto() {
        return this.photo;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public List<Reference> getCoverageArea() {
        return this.coverageArea;
    }

    public List<CodeableConcept> getServiceProvisionCode() {
        return this.serviceProvisionCode;
    }

    public List<Eligibility> getEligibility() {
        return this.eligibility;
    }

    public List<CodeableConcept> getProgram() {
        return this.program;
    }

    public List<CodeableConcept> getCharacteristic() {
        return this.characteristic;
    }

    public List<CodeableConcept> getCommunication() {
        return this.communication;
    }

    public List<CodeableConcept> getReferralMethod() {
        return this.referralMethod;
    }

    public Boolean getAppointmentRequired() {
        return this.appointmentRequired;
    }

    public List<AvailableTime> getAvailableTime() {
        return this.availableTime;
    }

    public List<NotAvailable> getNotAvailable() {
        return this.notAvailable;
    }

    public String getAvailabilityExceptions() {
        return this.availabilityExceptions;
    }

    public List<Reference> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || this.providedBy != null || !this.category.isEmpty() || !this.type.isEmpty() || !this.specialty.isEmpty() || !this.location.isEmpty() || this.name != null || this.comment != null || this.extraDetails != null || this.photo != null || !this.telecom.isEmpty() || !this.coverageArea.isEmpty() || !this.serviceProvisionCode.isEmpty() || !this.eligibility.isEmpty() || !this.program.isEmpty() || !this.characteristic.isEmpty() || !this.communication.isEmpty() || !this.referralMethod.isEmpty() || this.appointmentRequired != null || !this.availableTime.isEmpty() || !this.notAvailable.isEmpty() || this.availabilityExceptions != null || !this.endpoint.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.providedBy, "providedBy", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.type, "type", visitor, CodeableConcept.class);
                this.accept(this.specialty, "specialty", visitor, CodeableConcept.class);
                this.accept(this.location, "location", visitor, Reference.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.comment, "comment", visitor);
                this.accept(this.extraDetails, "extraDetails", visitor);
                this.accept(this.photo, "photo", visitor);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.coverageArea, "coverageArea", visitor, Reference.class);
                this.accept(this.serviceProvisionCode, "serviceProvisionCode", visitor, CodeableConcept.class);
                this.accept(this.eligibility, "eligibility", visitor, Eligibility.class);
                this.accept(this.program, "program", visitor, CodeableConcept.class);
                this.accept(this.characteristic, "characteristic", visitor, CodeableConcept.class);
                this.accept(this.communication, "communication", visitor, CodeableConcept.class);
                this.accept(this.referralMethod, "referralMethod", visitor, CodeableConcept.class);
                this.accept(this.appointmentRequired, "appointmentRequired", visitor);
                this.accept(this.availableTime, "availableTime", visitor, AvailableTime.class);
                this.accept(this.notAvailable, "notAvailable", visitor, NotAvailable.class);
                this.accept(this.availabilityExceptions, "availabilityExceptions", visitor);
                this.accept(this.endpoint, "endpoint", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HealthcareService other = (HealthcareService)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.providedBy, other.providedBy) && Objects.equals(this.category, other.category) && Objects.equals(this.type, other.type) && Objects.equals(this.specialty, other.specialty) && Objects.equals(this.location, other.location) && Objects.equals(this.name, other.name) && Objects.equals(this.comment, other.comment) && Objects.equals(this.extraDetails, other.extraDetails) && Objects.equals(this.photo, other.photo) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.coverageArea, other.coverageArea) && Objects.equals(this.serviceProvisionCode, other.serviceProvisionCode) && Objects.equals(this.eligibility, other.eligibility) && Objects.equals(this.program, other.program) && Objects.equals(this.characteristic, other.characteristic) && Objects.equals(this.communication, other.communication) && Objects.equals(this.referralMethod, other.referralMethod) && Objects.equals(this.appointmentRequired, other.appointmentRequired) && Objects.equals(this.availableTime, other.availableTime) && Objects.equals(this.notAvailable, other.notAvailable) && Objects.equals(this.availabilityExceptions, other.availabilityExceptions) && Objects.equals(this.endpoint, other.endpoint);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.providedBy, this.category, this.type, this.specialty, this.location, this.name, this.comment, this.extraDetails, this.photo, this.telecom, this.coverageArea, this.serviceProvisionCode, this.eligibility, this.program, this.characteristic, this.communication, this.referralMethod, this.appointmentRequired, this.availableTime, this.notAvailable, this.availabilityExceptions, this.endpoint);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class NotAvailable
    extends BackboneElement {
        @Required
        private final String description;
        private final Period during;
        private volatile int hashCode;

        private NotAvailable(Builder builder) {
            super(builder);
            this.description = ValidationSupport.requireNonNull(builder.description, "description");
            this.during = builder.during;
            ValidationSupport.requireValueOrChildren(this);
        }

        public String getDescription() {
            return this.description;
        }

        public Period getDuring() {
            return this.during;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.during != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.during, "during", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotAvailable other = (NotAvailable)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.during, other.during);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.during);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private Period during;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder during(Period during) {
                this.during = during;
                return this;
            }

            @Override
            public NotAvailable build() {
                return new NotAvailable(this);
            }

            protected Builder from(NotAvailable notAvailable) {
                super.from(notAvailable);
                this.description = notAvailable.description;
                this.during = notAvailable.during;
                return this;
            }
        }
    }

    public static class AvailableTime
    extends BackboneElement {
        @Binding(bindingName="DaysOfWeek", strength=BindingStrength.ValueSet.REQUIRED, description="The days of the week.", valueSet="http://hl7.org/fhir/ValueSet/days-of-week|4.0.1")
        private final List<DaysOfWeek> daysOfWeek;
        private final Boolean allDay;
        private final Time availableStartTime;
        private final Time availableEndTime;
        private volatile int hashCode;

        private AvailableTime(Builder builder) {
            super(builder);
            this.daysOfWeek = Collections.unmodifiableList(ValidationSupport.checkList(builder.daysOfWeek, "daysOfWeek", DaysOfWeek.class));
            this.allDay = builder.allDay;
            this.availableStartTime = builder.availableStartTime;
            this.availableEndTime = builder.availableEndTime;
            ValidationSupport.requireValueOrChildren(this);
        }

        public List<DaysOfWeek> getDaysOfWeek() {
            return this.daysOfWeek;
        }

        public Boolean getAllDay() {
            return this.allDay;
        }

        public Time getAvailableStartTime() {
            return this.availableStartTime;
        }

        public Time getAvailableEndTime() {
            return this.availableEndTime;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.daysOfWeek.isEmpty() || this.allDay != null || this.availableStartTime != null || this.availableEndTime != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.daysOfWeek, "daysOfWeek", visitor, DaysOfWeek.class);
                    this.accept(this.allDay, "allDay", visitor);
                    this.accept(this.availableStartTime, "availableStartTime", visitor);
                    this.accept(this.availableEndTime, "availableEndTime", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AvailableTime other = (AvailableTime)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.daysOfWeek, other.daysOfWeek) && Objects.equals(this.allDay, other.allDay) && Objects.equals(this.availableStartTime, other.availableStartTime) && Objects.equals(this.availableEndTime, other.availableEndTime);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.daysOfWeek, this.allDay, this.availableStartTime, this.availableEndTime);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<DaysOfWeek> daysOfWeek = new ArrayList<DaysOfWeek>();
            private Boolean allDay;
            private Time availableStartTime;
            private Time availableEndTime;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder daysOfWeek(DaysOfWeek ... daysOfWeek) {
                for (DaysOfWeek value : daysOfWeek) {
                    this.daysOfWeek.add(value);
                }
                return this;
            }

            public Builder daysOfWeek(Collection<DaysOfWeek> daysOfWeek) {
                this.daysOfWeek = new ArrayList<DaysOfWeek>(daysOfWeek);
                return this;
            }

            public Builder allDay(Boolean allDay) {
                this.allDay = allDay;
                return this;
            }

            public Builder availableStartTime(Time availableStartTime) {
                this.availableStartTime = availableStartTime;
                return this;
            }

            public Builder availableEndTime(Time availableEndTime) {
                this.availableEndTime = availableEndTime;
                return this;
            }

            @Override
            public AvailableTime build() {
                return new AvailableTime(this);
            }

            protected Builder from(AvailableTime availableTime) {
                super.from(availableTime);
                this.daysOfWeek.addAll(availableTime.daysOfWeek);
                this.allDay = availableTime.allDay;
                this.availableStartTime = availableTime.availableStartTime;
                this.availableEndTime = availableTime.availableEndTime;
                return this;
            }
        }
    }

    public static class Eligibility
    extends BackboneElement {
        @Binding(bindingName="ServiceEligibility", strength=BindingStrength.ValueSet.EXAMPLE, description="Coded values underwhich a specific service is made available.")
        private final CodeableConcept code;
        private final Markdown comment;
        private volatile int hashCode;

        private Eligibility(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.comment = builder.comment;
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Markdown getComment() {
            return this.comment;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.comment != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.comment, "comment", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Eligibility other = (Eligibility)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.comment, other.comment);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.comment);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private Markdown comment;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder comment(Markdown comment) {
                this.comment = comment;
                return this;
            }

            @Override
            public Eligibility build() {
                return new Eligibility(this);
            }

            protected Builder from(Eligibility eligibility) {
                super.from(eligibility);
                this.code = eligibility.code;
                this.comment = eligibility.comment;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private Reference providedBy;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> specialty = new ArrayList<CodeableConcept>();
        private List<Reference> location = new ArrayList<Reference>();
        private String name;
        private String comment;
        private Markdown extraDetails;
        private Attachment photo;
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private List<Reference> coverageArea = new ArrayList<Reference>();
        private List<CodeableConcept> serviceProvisionCode = new ArrayList<CodeableConcept>();
        private List<Eligibility> eligibility = new ArrayList<Eligibility>();
        private List<CodeableConcept> program = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> characteristic = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> communication = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> referralMethod = new ArrayList<CodeableConcept>();
        private Boolean appointmentRequired;
        private List<AvailableTime> availableTime = new ArrayList<AvailableTime>();
        private List<NotAvailable> notAvailable = new ArrayList<NotAvailable>();
        private String availabilityExceptions;
        private List<Reference> endpoint = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder providedBy(Reference providedBy) {
            this.providedBy = providedBy;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder type(CodeableConcept ... type) {
            for (CodeableConcept value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<CodeableConcept> type) {
            this.type = new ArrayList<CodeableConcept>(type);
            return this;
        }

        public Builder specialty(CodeableConcept ... specialty) {
            for (CodeableConcept value : specialty) {
                this.specialty.add(value);
            }
            return this;
        }

        public Builder specialty(Collection<CodeableConcept> specialty) {
            this.specialty = new ArrayList<CodeableConcept>(specialty);
            return this;
        }

        public Builder location(Reference ... location) {
            for (Reference value : location) {
                this.location.add(value);
            }
            return this;
        }

        public Builder location(Collection<Reference> location) {
            this.location = new ArrayList<Reference>(location);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder extraDetails(Markdown extraDetails) {
            this.extraDetails = extraDetails;
            return this;
        }

        public Builder photo(Attachment photo) {
            this.photo = photo;
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder coverageArea(Reference ... coverageArea) {
            for (Reference value : coverageArea) {
                this.coverageArea.add(value);
            }
            return this;
        }

        public Builder coverageArea(Collection<Reference> coverageArea) {
            this.coverageArea = new ArrayList<Reference>(coverageArea);
            return this;
        }

        public Builder serviceProvisionCode(CodeableConcept ... serviceProvisionCode) {
            for (CodeableConcept value : serviceProvisionCode) {
                this.serviceProvisionCode.add(value);
            }
            return this;
        }

        public Builder serviceProvisionCode(Collection<CodeableConcept> serviceProvisionCode) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>(serviceProvisionCode);
            return this;
        }

        public Builder eligibility(Eligibility ... eligibility) {
            for (Eligibility value : eligibility) {
                this.eligibility.add(value);
            }
            return this;
        }

        public Builder eligibility(Collection<Eligibility> eligibility) {
            this.eligibility = new ArrayList<Eligibility>(eligibility);
            return this;
        }

        public Builder program(CodeableConcept ... program) {
            for (CodeableConcept value : program) {
                this.program.add(value);
            }
            return this;
        }

        public Builder program(Collection<CodeableConcept> program) {
            this.program = new ArrayList<CodeableConcept>(program);
            return this;
        }

        public Builder characteristic(CodeableConcept ... characteristic) {
            for (CodeableConcept value : characteristic) {
                this.characteristic.add(value);
            }
            return this;
        }

        public Builder characteristic(Collection<CodeableConcept> characteristic) {
            this.characteristic = new ArrayList<CodeableConcept>(characteristic);
            return this;
        }

        public Builder communication(CodeableConcept ... communication) {
            for (CodeableConcept value : communication) {
                this.communication.add(value);
            }
            return this;
        }

        public Builder communication(Collection<CodeableConcept> communication) {
            this.communication = new ArrayList<CodeableConcept>(communication);
            return this;
        }

        public Builder referralMethod(CodeableConcept ... referralMethod) {
            for (CodeableConcept value : referralMethod) {
                this.referralMethod.add(value);
            }
            return this;
        }

        public Builder referralMethod(Collection<CodeableConcept> referralMethod) {
            this.referralMethod = new ArrayList<CodeableConcept>(referralMethod);
            return this;
        }

        public Builder appointmentRequired(Boolean appointmentRequired) {
            this.appointmentRequired = appointmentRequired;
            return this;
        }

        public Builder availableTime(AvailableTime ... availableTime) {
            for (AvailableTime value : availableTime) {
                this.availableTime.add(value);
            }
            return this;
        }

        public Builder availableTime(Collection<AvailableTime> availableTime) {
            this.availableTime = new ArrayList<AvailableTime>(availableTime);
            return this;
        }

        public Builder notAvailable(NotAvailable ... notAvailable) {
            for (NotAvailable value : notAvailable) {
                this.notAvailable.add(value);
            }
            return this;
        }

        public Builder notAvailable(Collection<NotAvailable> notAvailable) {
            this.notAvailable = new ArrayList<NotAvailable>(notAvailable);
            return this;
        }

        public Builder availabilityExceptions(String availabilityExceptions) {
            this.availabilityExceptions = availabilityExceptions;
            return this;
        }

        public Builder endpoint(Reference ... endpoint) {
            for (Reference value : endpoint) {
                this.endpoint.add(value);
            }
            return this;
        }

        public Builder endpoint(Collection<Reference> endpoint) {
            this.endpoint = new ArrayList<Reference>(endpoint);
            return this;
        }

        @Override
        public HealthcareService build() {
            return new HealthcareService(this);
        }

        protected Builder from(HealthcareService healthcareService) {
            super.from(healthcareService);
            this.identifier.addAll(healthcareService.identifier);
            this.active = healthcareService.active;
            this.providedBy = healthcareService.providedBy;
            this.category.addAll(healthcareService.category);
            this.type.addAll(healthcareService.type);
            this.specialty.addAll(healthcareService.specialty);
            this.location.addAll(healthcareService.location);
            this.name = healthcareService.name;
            this.comment = healthcareService.comment;
            this.extraDetails = healthcareService.extraDetails;
            this.photo = healthcareService.photo;
            this.telecom.addAll(healthcareService.telecom);
            this.coverageArea.addAll(healthcareService.coverageArea);
            this.serviceProvisionCode.addAll(healthcareService.serviceProvisionCode);
            this.eligibility.addAll(healthcareService.eligibility);
            this.program.addAll(healthcareService.program);
            this.characteristic.addAll(healthcareService.characteristic);
            this.communication.addAll(healthcareService.communication);
            this.referralMethod.addAll(healthcareService.referralMethod);
            this.appointmentRequired = healthcareService.appointmentRequired;
            this.availableTime.addAll(healthcareService.availableTime);
            this.notAvailable.addAll(healthcareService.notAvailable);
            this.availabilityExceptions = healthcareService.availabilityExceptions;
            this.endpoint.addAll(healthcareService.endpoint);
            return this;
        }
    }
}

