/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ImagingStudyStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="imagingStudy-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html", expression="modality.exists() implies (modality.all(memberOf('http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html', 'extensible')))", generated=true), @Constraint(id="imagingStudy-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://www.rsna.org/RadLex_Playbook.aspx", expression="procedureCode.exists() implies (procedureCode.all(memberOf('http://www.rsna.org/RadLex_Playbook.aspx', 'extensible')))", generated=true), @Constraint(id="imagingStudy-2", level="Warning", location="series.modality", description="SHALL, if possible, contain a code from value set http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html", expression="$this.memberOf('http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html', 'extensible')", generated=true), @Constraint(id="imagingStudy-3", level="Warning", location="series.performer.function", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/series-performer-function", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/series-performer-function', 'extensible')", generated=true), @Constraint(id="imagingStudy-4", level="Warning", location="series.instance.sopClass", description="SHALL, if possible, contain a code from value set http://dicom.nema.org/medical/dicom/current/output/chtml/part04/sect_B.5.html#table_B.5-1", expression="$this.memberOf('http://dicom.nema.org/medical/dicom/current/output/chtml/part04/sect_B.5.html#table_B.5-1', 'extensible')", generated=true)})
public class ImagingStudy
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ImagingStudyStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The status of the ImagingStudy.", valueSet="http://hl7.org/fhir/ValueSet/imagingstudy-status|4.0.1")
    @Required
    private final ImagingStudyStatus status;
    @Summary
    @Binding(bindingName="ImagingModality", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Type of acquired data in the instance.", valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html")
    private final List<Coding> modality;
    @Summary
    @ReferenceTarget(value={"Patient", "Device", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    private final DateTime started;
    @Summary
    @ReferenceTarget(value={"CarePlan", "ServiceRequest", "Appointment", "AppointmentResponse", "Task"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference referrer;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final List<Reference> interpreter;
    @Summary
    @ReferenceTarget(value={"Endpoint"})
    private final List<Reference> endpoint;
    @Summary
    private final UnsignedInt numberOfSeries;
    @Summary
    private final UnsignedInt numberOfInstances;
    @Summary
    @ReferenceTarget(value={"Procedure"})
    private final Reference procedureReference;
    @Summary
    @Binding(bindingName="ImagingProcedureCode", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The performed procedure type.", valueSet="http://www.rsna.org/RadLex_Playbook.aspx")
    private final List<CodeableConcept> procedureCode;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    @Summary
    @Binding(bindingName="ImagingReason", strength=BindingStrength.ValueSet.EXAMPLE, description="The reason for the study.", valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "Media", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    @Summary
    private final List<Annotation> note;
    @Summary
    private final String description;
    @Summary
    private final List<Series> series;
    private volatile int hashCode;

    private ImagingStudy(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.modality = Collections.unmodifiableList(ValidationSupport.checkList(builder.modality, "modality", Coding.class));
        this.subject = ValidationSupport.requireNonNull(builder.subject, "subject");
        this.encounter = builder.encounter;
        this.started = builder.started;
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.referrer = builder.referrer;
        this.interpreter = Collections.unmodifiableList(ValidationSupport.checkList(builder.interpreter, "interpreter", Reference.class));
        this.endpoint = Collections.unmodifiableList(ValidationSupport.checkList(builder.endpoint, "endpoint", Reference.class));
        this.numberOfSeries = builder.numberOfSeries;
        this.numberOfInstances = builder.numberOfInstances;
        this.procedureReference = builder.procedureReference;
        this.procedureCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.procedureCode, "procedureCode", CodeableConcept.class));
        this.location = builder.location;
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.description = builder.description;
        this.series = Collections.unmodifiableList(ValidationSupport.checkList(builder.series, "series", Series.class));
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Device", "Group");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "CarePlan", "ServiceRequest", "Appointment", "AppointmentResponse", "Task");
        ValidationSupport.checkReferenceType(this.referrer, "referrer", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.interpreter, "interpreter", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.endpoint, "endpoint", "Endpoint");
        ValidationSupport.checkReferenceType(this.procedureReference, "procedureReference", "Procedure");
        ValidationSupport.checkReferenceType(this.location, "location", "Location");
        ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Observation", "Media", "DiagnosticReport", "DocumentReference");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ImagingStudyStatus getStatus() {
        return this.status;
    }

    public List<Coding> getModality() {
        return this.modality;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getStarted() {
        return this.started;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public Reference getReferrer() {
        return this.referrer;
    }

    public List<Reference> getInterpreter() {
        return this.interpreter;
    }

    public List<Reference> getEndpoint() {
        return this.endpoint;
    }

    public UnsignedInt getNumberOfSeries() {
        return this.numberOfSeries;
    }

    public UnsignedInt getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public Reference getProcedureReference() {
        return this.procedureReference;
    }

    public List<CodeableConcept> getProcedureCode() {
        return this.procedureCode;
    }

    public Reference getLocation() {
        return this.location;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Series> getSeries() {
        return this.series;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.modality.isEmpty() || this.subject != null || this.encounter != null || this.started != null || !this.basedOn.isEmpty() || this.referrer != null || !this.interpreter.isEmpty() || !this.endpoint.isEmpty() || this.numberOfSeries != null || this.numberOfInstances != null || this.procedureReference != null || !this.procedureCode.isEmpty() || this.location != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.note.isEmpty() || this.description != null || !this.series.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.modality, "modality", visitor, Coding.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.started, "started", visitor);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.referrer, "referrer", visitor);
                this.accept(this.interpreter, "interpreter", visitor, Reference.class);
                this.accept(this.endpoint, "endpoint", visitor, Reference.class);
                this.accept(this.numberOfSeries, "numberOfSeries", visitor);
                this.accept(this.numberOfInstances, "numberOfInstances", visitor);
                this.accept(this.procedureReference, "procedureReference", visitor);
                this.accept(this.procedureCode, "procedureCode", visitor, CodeableConcept.class);
                this.accept(this.location, "location", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.series, "series", visitor, Series.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImagingStudy other = (ImagingStudy)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.modality, other.modality) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.started, other.started) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.referrer, other.referrer) && Objects.equals(this.interpreter, other.interpreter) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.numberOfSeries, other.numberOfSeries) && Objects.equals(this.numberOfInstances, other.numberOfInstances) && Objects.equals(this.procedureReference, other.procedureReference) && Objects.equals(this.procedureCode, other.procedureCode) && Objects.equals(this.location, other.location) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.note, other.note) && Objects.equals(this.description, other.description) && Objects.equals(this.series, other.series);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.modality, this.subject, this.encounter, this.started, this.basedOn, this.referrer, this.interpreter, this.endpoint, this.numberOfSeries, this.numberOfInstances, this.procedureReference, this.procedureCode, this.location, this.reasonCode, this.reasonReference, this.note, this.description, this.series);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Series
    extends BackboneElement {
        @Summary
        @Required
        private final Id uid;
        @Summary
        private final UnsignedInt number;
        @Summary
        @Binding(bindingName="ImagingModality", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Type of acquired data in the instance.", valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html")
        @Required
        private final Coding modality;
        @Summary
        private final String description;
        @Summary
        private final UnsignedInt numberOfInstances;
        @Summary
        @ReferenceTarget(value={"Endpoint"})
        private final List<Reference> endpoint;
        @Summary
        @Binding(bindingName="BodySite", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
        private final Coding bodySite;
        @Summary
        @Binding(bindingName="Laterality", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes describing body site laterality (left, right, etc.).", valueSet="http://hl7.org/fhir/ValueSet/bodysite-laterality")
        private final Coding laterality;
        @Summary
        @ReferenceTarget(value={"Specimen"})
        private final List<Reference> specimen;
        @Summary
        private final DateTime started;
        @Summary
        private final List<Performer> performer;
        private final List<Instance> instance;
        private volatile int hashCode;

        private Series(Builder builder) {
            super(builder);
            this.uid = ValidationSupport.requireNonNull(builder.uid, "uid");
            this.number = builder.number;
            this.modality = ValidationSupport.requireNonNull(builder.modality, "modality");
            this.description = builder.description;
            this.numberOfInstances = builder.numberOfInstances;
            this.endpoint = Collections.unmodifiableList(ValidationSupport.checkList(builder.endpoint, "endpoint", Reference.class));
            this.bodySite = builder.bodySite;
            this.laterality = builder.laterality;
            this.specimen = Collections.unmodifiableList(ValidationSupport.checkList(builder.specimen, "specimen", Reference.class));
            this.started = builder.started;
            this.performer = Collections.unmodifiableList(ValidationSupport.checkList(builder.performer, "performer", Performer.class));
            this.instance = Collections.unmodifiableList(ValidationSupport.checkList(builder.instance, "instance", Instance.class));
            ValidationSupport.checkReferenceType(this.endpoint, "endpoint", "Endpoint");
            ValidationSupport.checkReferenceType(this.specimen, "specimen", "Specimen");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Id getUid() {
            return this.uid;
        }

        public UnsignedInt getNumber() {
            return this.number;
        }

        public Coding getModality() {
            return this.modality;
        }

        public String getDescription() {
            return this.description;
        }

        public UnsignedInt getNumberOfInstances() {
            return this.numberOfInstances;
        }

        public List<Reference> getEndpoint() {
            return this.endpoint;
        }

        public Coding getBodySite() {
            return this.bodySite;
        }

        public Coding getLaterality() {
            return this.laterality;
        }

        public List<Reference> getSpecimen() {
            return this.specimen;
        }

        public DateTime getStarted() {
            return this.started;
        }

        public List<Performer> getPerformer() {
            return this.performer;
        }

        public List<Instance> getInstance() {
            return this.instance;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.uid != null || this.number != null || this.modality != null || this.description != null || this.numberOfInstances != null || !this.endpoint.isEmpty() || this.bodySite != null || this.laterality != null || !this.specimen.isEmpty() || this.started != null || !this.performer.isEmpty() || !this.instance.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.uid, "uid", visitor);
                    this.accept(this.number, "number", visitor);
                    this.accept(this.modality, "modality", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.numberOfInstances, "numberOfInstances", visitor);
                    this.accept(this.endpoint, "endpoint", visitor, Reference.class);
                    this.accept(this.bodySite, "bodySite", visitor);
                    this.accept(this.laterality, "laterality", visitor);
                    this.accept(this.specimen, "specimen", visitor, Reference.class);
                    this.accept(this.started, "started", visitor);
                    this.accept(this.performer, "performer", visitor, Performer.class);
                    this.accept(this.instance, "instance", visitor, Instance.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Series other = (Series)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.uid, other.uid) && Objects.equals(this.number, other.number) && Objects.equals(this.modality, other.modality) && Objects.equals(this.description, other.description) && Objects.equals(this.numberOfInstances, other.numberOfInstances) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.laterality, other.laterality) && Objects.equals(this.specimen, other.specimen) && Objects.equals(this.started, other.started) && Objects.equals(this.performer, other.performer) && Objects.equals(this.instance, other.instance);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.uid, this.number, this.modality, this.description, this.numberOfInstances, this.endpoint, this.bodySite, this.laterality, this.specimen, this.started, this.performer, this.instance);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Instance
        extends BackboneElement {
            @Required
            private final Id uid;
            @Binding(bindingName="sopClass", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The sopClass for the instance.", valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part04/sect_B.5.html#table_B.5-1")
            @Required
            private final Coding sopClass;
            private final UnsignedInt number;
            private final String title;
            private volatile int hashCode;

            private Instance(Builder builder) {
                super(builder);
                this.uid = ValidationSupport.requireNonNull(builder.uid, "uid");
                this.sopClass = ValidationSupport.requireNonNull(builder.sopClass, "sopClass");
                this.number = builder.number;
                this.title = builder.title;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Id getUid() {
                return this.uid;
            }

            public Coding getSopClass() {
                return this.sopClass;
            }

            public UnsignedInt getNumber() {
                return this.number;
            }

            public String getTitle() {
                return this.title;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.uid != null || this.sopClass != null || this.number != null || this.title != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.uid, "uid", visitor);
                        this.accept(this.sopClass, "sopClass", visitor);
                        this.accept(this.number, "number", visitor);
                        this.accept(this.title, "title", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Instance other = (Instance)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.uid, other.uid) && Objects.equals(this.sopClass, other.sopClass) && Objects.equals(this.number, other.number) && Objects.equals(this.title, other.title);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.uid, this.sopClass, this.number, this.title);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Id uid;
                private Coding sopClass;
                private UnsignedInt number;
                private String title;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder uid(Id uid) {
                    this.uid = uid;
                    return this;
                }

                public Builder sopClass(Coding sopClass) {
                    this.sopClass = sopClass;
                    return this;
                }

                public Builder number(UnsignedInt number) {
                    this.number = number;
                    return this;
                }

                public Builder title(String title) {
                    this.title = title;
                    return this;
                }

                @Override
                public Instance build() {
                    return new Instance(this);
                }

                protected Builder from(Instance instance) {
                    super.from(instance);
                    this.uid = instance.uid;
                    this.sopClass = instance.sopClass;
                    this.number = instance.number;
                    this.title = instance.title;
                    return this;
                }
            }
        }

        public static class Performer
        extends BackboneElement {
            @Summary
            @Binding(bindingName="EventPerformerFunction", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The type of involvement of the performer.", valueSet="http://hl7.org/fhir/ValueSet/series-performer-function")
            private final CodeableConcept function;
            @Summary
            @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "Device", "RelatedPerson"})
            @Required
            private final Reference actor;
            private volatile int hashCode;

            private Performer(Builder builder) {
                super(builder);
                this.function = builder.function;
                this.actor = ValidationSupport.requireNonNull(builder.actor, "actor");
                ValidationSupport.checkReferenceType(this.actor, "actor", "Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "Device", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(this);
            }

            public CodeableConcept getFunction() {
                return this.function;
            }

            public Reference getActor() {
                return this.actor;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.function != null || this.actor != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.function, "function", visitor);
                        this.accept(this.actor, "actor", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Performer other = (Performer)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.function, other.function) && Objects.equals(this.actor, other.actor);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.function, this.actor);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept function;
                private Reference actor;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder function(CodeableConcept function) {
                    this.function = function;
                    return this;
                }

                public Builder actor(Reference actor) {
                    this.actor = actor;
                    return this;
                }

                @Override
                public Performer build() {
                    return new Performer(this);
                }

                protected Builder from(Performer performer) {
                    super.from(performer);
                    this.function = performer.function;
                    this.actor = performer.actor;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Id uid;
            private UnsignedInt number;
            private Coding modality;
            private String description;
            private UnsignedInt numberOfInstances;
            private List<Reference> endpoint = new ArrayList<Reference>();
            private Coding bodySite;
            private Coding laterality;
            private List<Reference> specimen = new ArrayList<Reference>();
            private DateTime started;
            private List<Performer> performer = new ArrayList<Performer>();
            private List<Instance> instance = new ArrayList<Instance>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder uid(Id uid) {
                this.uid = uid;
                return this;
            }

            public Builder number(UnsignedInt number) {
                this.number = number;
                return this;
            }

            public Builder modality(Coding modality) {
                this.modality = modality;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder numberOfInstances(UnsignedInt numberOfInstances) {
                this.numberOfInstances = numberOfInstances;
                return this;
            }

            public Builder endpoint(Reference ... endpoint) {
                for (Reference value : endpoint) {
                    this.endpoint.add(value);
                }
                return this;
            }

            public Builder endpoint(Collection<Reference> endpoint) {
                this.endpoint = new ArrayList<Reference>(endpoint);
                return this;
            }

            public Builder bodySite(Coding bodySite) {
                this.bodySite = bodySite;
                return this;
            }

            public Builder laterality(Coding laterality) {
                this.laterality = laterality;
                return this;
            }

            public Builder specimen(Reference ... specimen) {
                for (Reference value : specimen) {
                    this.specimen.add(value);
                }
                return this;
            }

            public Builder specimen(Collection<Reference> specimen) {
                this.specimen = new ArrayList<Reference>(specimen);
                return this;
            }

            public Builder started(DateTime started) {
                this.started = started;
                return this;
            }

            public Builder performer(Performer ... performer) {
                for (Performer value : performer) {
                    this.performer.add(value);
                }
                return this;
            }

            public Builder performer(Collection<Performer> performer) {
                this.performer = new ArrayList<Performer>(performer);
                return this;
            }

            public Builder instance(Instance ... instance) {
                for (Instance value : instance) {
                    this.instance.add(value);
                }
                return this;
            }

            public Builder instance(Collection<Instance> instance) {
                this.instance = new ArrayList<Instance>(instance);
                return this;
            }

            @Override
            public Series build() {
                return new Series(this);
            }

            protected Builder from(Series series) {
                super.from(series);
                this.uid = series.uid;
                this.number = series.number;
                this.modality = series.modality;
                this.description = series.description;
                this.numberOfInstances = series.numberOfInstances;
                this.endpoint.addAll(series.endpoint);
                this.bodySite = series.bodySite;
                this.laterality = series.laterality;
                this.specimen.addAll(series.specimen);
                this.started = series.started;
                this.performer.addAll(series.performer);
                this.instance.addAll(series.instance);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ImagingStudyStatus status;
        private List<Coding> modality = new ArrayList<Coding>();
        private Reference subject;
        private Reference encounter;
        private DateTime started;
        private List<Reference> basedOn = new ArrayList<Reference>();
        private Reference referrer;
        private List<Reference> interpreter = new ArrayList<Reference>();
        private List<Reference> endpoint = new ArrayList<Reference>();
        private UnsignedInt numberOfSeries;
        private UnsignedInt numberOfInstances;
        private Reference procedureReference;
        private List<CodeableConcept> procedureCode = new ArrayList<CodeableConcept>();
        private Reference location;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private String description;
        private List<Series> series = new ArrayList<Series>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ImagingStudyStatus status) {
            this.status = status;
            return this;
        }

        public Builder modality(Coding ... modality) {
            for (Coding value : modality) {
                this.modality.add(value);
            }
            return this;
        }

        public Builder modality(Collection<Coding> modality) {
            this.modality = new ArrayList<Coding>(modality);
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder started(DateTime started) {
            this.started = started;
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder referrer(Reference referrer) {
            this.referrer = referrer;
            return this;
        }

        public Builder interpreter(Reference ... interpreter) {
            for (Reference value : interpreter) {
                this.interpreter.add(value);
            }
            return this;
        }

        public Builder interpreter(Collection<Reference> interpreter) {
            this.interpreter = new ArrayList<Reference>(interpreter);
            return this;
        }

        public Builder endpoint(Reference ... endpoint) {
            for (Reference value : endpoint) {
                this.endpoint.add(value);
            }
            return this;
        }

        public Builder endpoint(Collection<Reference> endpoint) {
            this.endpoint = new ArrayList<Reference>(endpoint);
            return this;
        }

        public Builder numberOfSeries(UnsignedInt numberOfSeries) {
            this.numberOfSeries = numberOfSeries;
            return this;
        }

        public Builder numberOfInstances(UnsignedInt numberOfInstances) {
            this.numberOfInstances = numberOfInstances;
            return this;
        }

        public Builder procedureReference(Reference procedureReference) {
            this.procedureReference = procedureReference;
            return this;
        }

        public Builder procedureCode(CodeableConcept ... procedureCode) {
            for (CodeableConcept value : procedureCode) {
                this.procedureCode.add(value);
            }
            return this;
        }

        public Builder procedureCode(Collection<CodeableConcept> procedureCode) {
            this.procedureCode = new ArrayList<CodeableConcept>(procedureCode);
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder series(Series ... series) {
            for (Series value : series) {
                this.series.add(value);
            }
            return this;
        }

        public Builder series(Collection<Series> series) {
            this.series = new ArrayList<Series>(series);
            return this;
        }

        @Override
        public ImagingStudy build() {
            return new ImagingStudy(this);
        }

        protected Builder from(ImagingStudy imagingStudy) {
            super.from(imagingStudy);
            this.identifier.addAll(imagingStudy.identifier);
            this.status = imagingStudy.status;
            this.modality.addAll(imagingStudy.modality);
            this.subject = imagingStudy.subject;
            this.encounter = imagingStudy.encounter;
            this.started = imagingStudy.started;
            this.basedOn.addAll(imagingStudy.basedOn);
            this.referrer = imagingStudy.referrer;
            this.interpreter.addAll(imagingStudy.interpreter);
            this.endpoint.addAll(imagingStudy.endpoint);
            this.numberOfSeries = imagingStudy.numberOfSeries;
            this.numberOfInstances = imagingStudy.numberOfInstances;
            this.procedureReference = imagingStudy.procedureReference;
            this.procedureCode.addAll(imagingStudy.procedureCode);
            this.location = imagingStudy.location;
            this.reasonCode.addAll(imagingStudy.reasonCode);
            this.reasonReference.addAll(imagingStudy.reasonReference);
            this.note.addAll(imagingStudy.note);
            this.description = imagingStudy.description;
            this.series.addAll(imagingStudy.series);
            return this;
        }
    }
}

