/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.FHIRVersion;
import com.ibm.fhir.model.type.code.GuidePageGeneration;
import com.ibm.fhir.model.type.code.GuideParameterCode;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.SPDXLicense;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="ig-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')"), @Constraint(id="ig-1", level="Rule", location="ImplementationGuide.definition", description="If a resource has a groupingId, it must refer to a grouping defined in the Implementation Guide", expression="resource.groupingId.all(%context.grouping.id contains $this)"), @Constraint(id="ig-2", level="Rule", location="(base)", description="If a resource has a fhirVersion, it must be oe of the versions defined for the Implementation Guide", expression="definition.resource.fhirVersion.all(%context.fhirVersion contains $this)"), @Constraint(id="implementationGuide-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", generated=true)})
public class ImplementationGuide
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final String version;
    @Summary
    @Required
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown copyright;
    @Summary
    @Required
    private final Id packageId;
    @Summary
    @Binding(bindingName="SPDXLicense", strength=BindingStrength.ValueSet.REQUIRED, description="The license that applies to an Implementation Guide (using an SPDX license Identifiers, or 'not-open-source'). The binding is required but new SPDX license Identifiers are allowed to be used (https://spdx.org/licenses/).", valueSet="http://hl7.org/fhir/ValueSet/spdx-license|4.0.1")
    private final SPDXLicense license;
    @Summary
    @Binding(bindingName="FHIRVersion", strength=BindingStrength.ValueSet.REQUIRED, description="All published FHIR Versions.", valueSet="http://hl7.org/fhir/ValueSet/FHIR-version|4.0.1")
    @Required
    private final List<FHIRVersion> fhirVersion;
    @Summary
    private final List<DependsOn> dependsOn;
    @Summary
    private final List<Global> global;
    private final Definition definition;
    private final Manifest manifest;
    private volatile int hashCode;

    private ImplementationGuide(Builder builder) {
        super(builder);
        this.url = ValidationSupport.requireNonNull(builder.url, "url");
        this.version = builder.version;
        this.name = ValidationSupport.requireNonNull(builder.name, "name");
        this.title = builder.title;
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactDetail.class));
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(ValidationSupport.checkList(builder.useContext, "useContext", UsageContext.class));
        this.jurisdiction = Collections.unmodifiableList(ValidationSupport.checkList(builder.jurisdiction, "jurisdiction", CodeableConcept.class));
        this.copyright = builder.copyright;
        this.packageId = ValidationSupport.requireNonNull(builder.packageId, "packageId");
        this.license = builder.license;
        this.fhirVersion = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.fhirVersion, "fhirVersion", FHIRVersion.class));
        this.dependsOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.dependsOn, "dependsOn", DependsOn.class));
        this.global = Collections.unmodifiableList(ValidationSupport.checkList(builder.global, "global", Global.class));
        this.definition = builder.definition;
        this.manifest = builder.manifest;
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Id getPackageId() {
        return this.packageId;
    }

    public SPDXLicense getLicense() {
        return this.license;
    }

    public List<FHIRVersion> getFhirVersion() {
        return this.fhirVersion;
    }

    public List<DependsOn> getDependsOn() {
        return this.dependsOn;
    }

    public List<Global> getGlobal() {
        return this.global;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.copyright != null || this.packageId != null || this.license != null || !this.fhirVersion.isEmpty() || !this.dependsOn.isEmpty() || !this.global.isEmpty() || this.definition != null || this.manifest != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.packageId, "packageId", visitor);
                this.accept(this.license, "license", visitor);
                this.accept(this.fhirVersion, "fhirVersion", visitor, FHIRVersion.class);
                this.accept(this.dependsOn, "dependsOn", visitor, DependsOn.class);
                this.accept(this.global, "global", visitor, Global.class);
                this.accept(this.definition, "definition", visitor);
                this.accept(this.manifest, "manifest", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImplementationGuide other = (ImplementationGuide)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.packageId, other.packageId) && Objects.equals(this.license, other.license) && Objects.equals(this.fhirVersion, other.fhirVersion) && Objects.equals(this.dependsOn, other.dependsOn) && Objects.equals(this.global, other.global) && Objects.equals(this.definition, other.definition) && Objects.equals(this.manifest, other.manifest);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.copyright, this.packageId, this.license, this.fhirVersion, this.dependsOn, this.global, this.definition, this.manifest);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Manifest
    extends BackboneElement {
        @Summary
        private final Url rendering;
        @Summary
        @Required
        private final List<Resource> resource;
        private final List<Page> page;
        private final List<String> image;
        private final List<String> other;
        private volatile int hashCode;

        private Manifest(Builder builder) {
            super(builder);
            this.rendering = builder.rendering;
            this.resource = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.resource, "resource", Resource.class));
            this.page = Collections.unmodifiableList(ValidationSupport.checkList(builder.page, "page", Page.class));
            this.image = Collections.unmodifiableList(ValidationSupport.checkList(builder.image, "image", String.class));
            this.other = Collections.unmodifiableList(ValidationSupport.checkList(builder.other, "other", String.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public Url getRendering() {
            return this.rendering;
        }

        public List<Resource> getResource() {
            return this.resource;
        }

        public List<Page> getPage() {
            return this.page;
        }

        public List<String> getImage() {
            return this.image;
        }

        public List<String> getOther() {
            return this.other;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.rendering != null || !this.resource.isEmpty() || !this.page.isEmpty() || !this.image.isEmpty() || !this.other.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.rendering, "rendering", visitor);
                    this.accept(this.resource, "resource", visitor, Resource.class);
                    this.accept(this.page, "page", visitor, Page.class);
                    this.accept(this.image, "image", visitor, String.class);
                    this.accept(this.other, "other", visitor, String.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Manifest other = (Manifest)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.rendering, other.rendering) && Objects.equals(this.resource, other.resource) && Objects.equals(this.page, other.page) && Objects.equals(this.image, other.image) && Objects.equals(this.other, other.other);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.rendering, this.resource, this.page, this.image, this.other);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Page
        extends BackboneElement {
            @Required
            private final String name;
            private final String title;
            private final List<String> anchor;
            private volatile int hashCode;

            private Page(Builder builder) {
                super(builder);
                this.name = ValidationSupport.requireNonNull(builder.name, "name");
                this.title = builder.title;
                this.anchor = Collections.unmodifiableList(ValidationSupport.checkList(builder.anchor, "anchor", String.class));
                ValidationSupport.requireValueOrChildren(this);
            }

            public String getName() {
                return this.name;
            }

            public String getTitle() {
                return this.title;
            }

            public List<String> getAnchor() {
                return this.anchor;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.title != null || !this.anchor.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.title, "title", visitor);
                        this.accept(this.anchor, "anchor", visitor, String.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Page other = (Page)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.anchor, other.anchor);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.title, this.anchor);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String name;
                private String title;
                private List<String> anchor = new ArrayList<String>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder title(String title) {
                    this.title = title;
                    return this;
                }

                public Builder anchor(String ... anchor) {
                    for (String value : anchor) {
                        this.anchor.add(value);
                    }
                    return this;
                }

                public Builder anchor(Collection<String> anchor) {
                    this.anchor = new ArrayList<String>(anchor);
                    return this;
                }

                @Override
                public Page build() {
                    return new Page(this);
                }

                protected Builder from(Page page) {
                    super.from(page);
                    this.name = page.name;
                    this.title = page.title;
                    this.anchor.addAll(page.anchor);
                    return this;
                }
            }
        }

        public static class Resource
        extends BackboneElement {
            @Summary
            @Required
            private final Reference reference;
            @Choice(value={Boolean.class, Canonical.class})
            private final Element example;
            private final Url relativePath;
            private volatile int hashCode;

            private Resource(Builder builder) {
                super(builder);
                this.reference = ValidationSupport.requireNonNull(builder.reference, "reference");
                this.example = ValidationSupport.choiceElement(builder.example, "example", Boolean.class, Canonical.class);
                this.relativePath = builder.relativePath;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Reference getReference() {
                return this.reference;
            }

            public Element getExample() {
                return this.example;
            }

            public Url getRelativePath() {
                return this.relativePath;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.reference != null || this.example != null || this.relativePath != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.reference, "reference", visitor);
                        this.accept(this.example, "example", visitor);
                        this.accept(this.relativePath, "relativePath", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Resource other = (Resource)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.example, other.example) && Objects.equals(this.relativePath, other.relativePath);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.reference, this.example, this.relativePath);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Reference reference;
                private Element example;
                private Url relativePath;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder reference(Reference reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder example(Element example) {
                    this.example = example;
                    return this;
                }

                public Builder relativePath(Url relativePath) {
                    this.relativePath = relativePath;
                    return this;
                }

                @Override
                public Resource build() {
                    return new Resource(this);
                }

                protected Builder from(Resource resource) {
                    super.from(resource);
                    this.reference = resource.reference;
                    this.example = resource.example;
                    this.relativePath = resource.relativePath;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Url rendering;
            private List<Resource> resource = new ArrayList<Resource>();
            private List<Page> page = new ArrayList<Page>();
            private List<String> image = new ArrayList<String>();
            private List<String> other = new ArrayList<String>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder rendering(Url rendering) {
                this.rendering = rendering;
                return this;
            }

            public Builder resource(Resource ... resource) {
                for (Resource value : resource) {
                    this.resource.add(value);
                }
                return this;
            }

            public Builder resource(Collection<Resource> resource) {
                this.resource = new ArrayList<Resource>(resource);
                return this;
            }

            public Builder page(Page ... page) {
                for (Page value : page) {
                    this.page.add(value);
                }
                return this;
            }

            public Builder page(Collection<Page> page) {
                this.page = new ArrayList<Page>(page);
                return this;
            }

            public Builder image(String ... image) {
                for (String value : image) {
                    this.image.add(value);
                }
                return this;
            }

            public Builder image(Collection<String> image) {
                this.image = new ArrayList<String>(image);
                return this;
            }

            public Builder other(String ... other) {
                for (String value : other) {
                    this.other.add(value);
                }
                return this;
            }

            public Builder other(Collection<String> other) {
                this.other = new ArrayList<String>(other);
                return this;
            }

            @Override
            public Manifest build() {
                return new Manifest(this);
            }

            protected Builder from(Manifest manifest) {
                super.from(manifest);
                this.rendering = manifest.rendering;
                this.resource.addAll(manifest.resource);
                this.page.addAll(manifest.page);
                this.image.addAll(manifest.image);
                this.other.addAll(manifest.other);
                return this;
            }
        }
    }

    public static class Definition
    extends BackboneElement {
        private final List<Grouping> grouping;
        @Required
        private final List<Resource> resource;
        private final Page page;
        private final List<Parameter> parameter;
        private final List<Template> template;
        private volatile int hashCode;

        private Definition(Builder builder) {
            super(builder);
            this.grouping = Collections.unmodifiableList(ValidationSupport.checkList(builder.grouping, "grouping", Grouping.class));
            this.resource = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.resource, "resource", Resource.class));
            this.page = builder.page;
            this.parameter = Collections.unmodifiableList(ValidationSupport.checkList(builder.parameter, "parameter", Parameter.class));
            this.template = Collections.unmodifiableList(ValidationSupport.checkList(builder.template, "template", Template.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public List<Grouping> getGrouping() {
            return this.grouping;
        }

        public List<Resource> getResource() {
            return this.resource;
        }

        public Page getPage() {
            return this.page;
        }

        public List<Parameter> getParameter() {
            return this.parameter;
        }

        public List<Template> getTemplate() {
            return this.template;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.grouping.isEmpty() || !this.resource.isEmpty() || this.page != null || !this.parameter.isEmpty() || !this.template.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.grouping, "grouping", visitor, Grouping.class);
                    this.accept(this.resource, "resource", visitor, Resource.class);
                    this.accept(this.page, "page", visitor);
                    this.accept(this.parameter, "parameter", visitor, Parameter.class);
                    this.accept(this.template, "template", visitor, Template.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Definition other = (Definition)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.grouping, other.grouping) && Objects.equals(this.resource, other.resource) && Objects.equals(this.page, other.page) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.template, other.template);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.grouping, this.resource, this.page, this.parameter, this.template);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Template
        extends BackboneElement {
            @Required
            private final Code code;
            @Required
            private final String source;
            private final String scope;
            private volatile int hashCode;

            private Template(Builder builder) {
                super(builder);
                this.code = ValidationSupport.requireNonNull(builder.code, "code");
                this.source = ValidationSupport.requireNonNull(builder.source, "source");
                this.scope = builder.scope;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Code getCode() {
                return this.code;
            }

            public String getSource() {
                return this.source;
            }

            public String getScope() {
                return this.scope;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.source != null || this.scope != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.source, "source", visitor);
                        this.accept(this.scope, "scope", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Template other = (Template)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.source, other.source) && Objects.equals(this.scope, other.scope);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.source, this.scope);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Code code;
                private String source;
                private String scope;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(Code code) {
                    this.code = code;
                    return this;
                }

                public Builder source(String source) {
                    this.source = source;
                    return this;
                }

                public Builder scope(String scope) {
                    this.scope = scope;
                    return this;
                }

                @Override
                public Template build() {
                    return new Template(this);
                }

                protected Builder from(Template template) {
                    super.from(template);
                    this.code = template.code;
                    this.source = template.source;
                    this.scope = template.scope;
                    return this;
                }
            }
        }

        public static class Parameter
        extends BackboneElement {
            @Binding(bindingName="GuideParameterCode", strength=BindingStrength.ValueSet.REQUIRED, description="Code of parameter that is input to the guide.", valueSet="http://hl7.org/fhir/ValueSet/guide-parameter-code|4.0.1")
            @Required
            private final GuideParameterCode code;
            @Required
            private final String value;
            private volatile int hashCode;

            private Parameter(Builder builder) {
                super(builder);
                this.code = ValidationSupport.requireNonNull(builder.code, "code");
                this.value = ValidationSupport.requireNonNull(builder.value, "value");
                ValidationSupport.requireValueOrChildren(this);
            }

            public GuideParameterCode getCode() {
                return this.code;
            }

            public String getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.value != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Parameter other = (Parameter)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private GuideParameterCode code;
                private String value;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(GuideParameterCode code) {
                    this.code = code;
                    return this;
                }

                public Builder value(String value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Parameter build() {
                    return new Parameter(this);
                }

                protected Builder from(Parameter parameter) {
                    super.from(parameter);
                    this.code = parameter.code;
                    this.value = parameter.value;
                    return this;
                }
            }
        }

        public static class Page
        extends BackboneElement {
            @ReferenceTarget(value={"Binary"})
            @Choice(value={Url.class, Reference.class})
            @Required
            private final Element name;
            @Required
            private final String title;
            @Binding(bindingName="GuidePageGeneration", strength=BindingStrength.ValueSet.REQUIRED, description="A code that indicates how the page is generated.", valueSet="http://hl7.org/fhir/ValueSet/guide-page-generation|4.0.1")
            @Required
            private final GuidePageGeneration generation;
            private final List<Page> page;
            private volatile int hashCode;

            private Page(Builder builder) {
                super(builder);
                this.name = ValidationSupport.requireChoiceElement(builder.name, "name", Url.class, Reference.class);
                this.title = ValidationSupport.requireNonNull(builder.title, "title");
                this.generation = ValidationSupport.requireNonNull(builder.generation, "generation");
                this.page = Collections.unmodifiableList(ValidationSupport.checkList(builder.page, "page", Page.class));
                ValidationSupport.checkReferenceType(this.name, "name", "Binary");
                ValidationSupport.requireValueOrChildren(this);
            }

            public Element getName() {
                return this.name;
            }

            public String getTitle() {
                return this.title;
            }

            public GuidePageGeneration getGeneration() {
                return this.generation;
            }

            public List<Page> getPage() {
                return this.page;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.title != null || this.generation != null || !this.page.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.title, "title", visitor);
                        this.accept(this.generation, "generation", visitor);
                        this.accept(this.page, "page", visitor, Page.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Page other = (Page)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.generation, other.generation) && Objects.equals(this.page, other.page);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.title, this.generation, this.page);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element name;
                private String title;
                private GuidePageGeneration generation;
                private List<Page> page = new ArrayList<Page>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(Element name) {
                    this.name = name;
                    return this;
                }

                public Builder title(String title) {
                    this.title = title;
                    return this;
                }

                public Builder generation(GuidePageGeneration generation) {
                    this.generation = generation;
                    return this;
                }

                public Builder page(Page ... page) {
                    for (Page value : page) {
                        this.page.add(value);
                    }
                    return this;
                }

                public Builder page(Collection<Page> page) {
                    this.page = new ArrayList<Page>(page);
                    return this;
                }

                @Override
                public Page build() {
                    return new Page(this);
                }

                protected Builder from(Page page) {
                    super.from(page);
                    this.name = page.name;
                    this.title = page.title;
                    this.generation = page.generation;
                    this.page.addAll(page.page);
                    return this;
                }
            }
        }

        public static class Resource
        extends BackboneElement {
            @Required
            private final Reference reference;
            @Binding(bindingName="FHIRVersion", strength=BindingStrength.ValueSet.REQUIRED, description="All published FHIR Versions.", valueSet="http://hl7.org/fhir/ValueSet/FHIR-version|4.0.1")
            private final List<FHIRVersion> fhirVersion;
            private final String name;
            private final String description;
            @Choice(value={Boolean.class, Canonical.class})
            private final Element example;
            private final Id groupingId;
            private volatile int hashCode;

            private Resource(Builder builder) {
                super(builder);
                this.reference = ValidationSupport.requireNonNull(builder.reference, "reference");
                this.fhirVersion = Collections.unmodifiableList(ValidationSupport.checkList(builder.fhirVersion, "fhirVersion", FHIRVersion.class));
                this.name = builder.name;
                this.description = builder.description;
                this.example = ValidationSupport.choiceElement(builder.example, "example", Boolean.class, Canonical.class);
                this.groupingId = builder.groupingId;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Reference getReference() {
                return this.reference;
            }

            public List<FHIRVersion> getFhirVersion() {
                return this.fhirVersion;
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public Element getExample() {
                return this.example;
            }

            public Id getGroupingId() {
                return this.groupingId;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.reference != null || !this.fhirVersion.isEmpty() || this.name != null || this.description != null || this.example != null || this.groupingId != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.reference, "reference", visitor);
                        this.accept(this.fhirVersion, "fhirVersion", visitor, FHIRVersion.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.example, "example", visitor);
                        this.accept(this.groupingId, "groupingId", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Resource other = (Resource)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.fhirVersion, other.fhirVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.example, other.example) && Objects.equals(this.groupingId, other.groupingId);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.reference, this.fhirVersion, this.name, this.description, this.example, this.groupingId);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Reference reference;
                private List<FHIRVersion> fhirVersion = new ArrayList<FHIRVersion>();
                private String name;
                private String description;
                private Element example;
                private Id groupingId;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder reference(Reference reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder fhirVersion(FHIRVersion ... fhirVersion) {
                    for (FHIRVersion value : fhirVersion) {
                        this.fhirVersion.add(value);
                    }
                    return this;
                }

                public Builder fhirVersion(Collection<FHIRVersion> fhirVersion) {
                    this.fhirVersion = new ArrayList<FHIRVersion>(fhirVersion);
                    return this;
                }

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description;
                    return this;
                }

                public Builder example(Element example) {
                    this.example = example;
                    return this;
                }

                public Builder groupingId(Id groupingId) {
                    this.groupingId = groupingId;
                    return this;
                }

                @Override
                public Resource build() {
                    return new Resource(this);
                }

                protected Builder from(Resource resource) {
                    super.from(resource);
                    this.reference = resource.reference;
                    this.fhirVersion.addAll(resource.fhirVersion);
                    this.name = resource.name;
                    this.description = resource.description;
                    this.example = resource.example;
                    this.groupingId = resource.groupingId;
                    return this;
                }
            }
        }

        public static class Grouping
        extends BackboneElement {
            @Required
            private final String name;
            private final String description;
            private volatile int hashCode;

            private Grouping(Builder builder) {
                super(builder);
                this.name = ValidationSupport.requireNonNull(builder.name, "name");
                this.description = builder.description;
                ValidationSupport.requireValueOrChildren(this);
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.description != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.description, "description", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Grouping other = (Grouping)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.description);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String name;
                private String description;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description;
                    return this;
                }

                @Override
                public Grouping build() {
                    return new Grouping(this);
                }

                protected Builder from(Grouping grouping) {
                    super.from(grouping);
                    this.name = grouping.name;
                    this.description = grouping.description;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Grouping> grouping = new ArrayList<Grouping>();
            private List<Resource> resource = new ArrayList<Resource>();
            private Page page;
            private List<Parameter> parameter = new ArrayList<Parameter>();
            private List<Template> template = new ArrayList<Template>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder grouping(Grouping ... grouping) {
                for (Grouping value : grouping) {
                    this.grouping.add(value);
                }
                return this;
            }

            public Builder grouping(Collection<Grouping> grouping) {
                this.grouping = new ArrayList<Grouping>(grouping);
                return this;
            }

            public Builder resource(Resource ... resource) {
                for (Resource value : resource) {
                    this.resource.add(value);
                }
                return this;
            }

            public Builder resource(Collection<Resource> resource) {
                this.resource = new ArrayList<Resource>(resource);
                return this;
            }

            public Builder page(Page page) {
                this.page = page;
                return this;
            }

            public Builder parameter(Parameter ... parameter) {
                for (Parameter value : parameter) {
                    this.parameter.add(value);
                }
                return this;
            }

            public Builder parameter(Collection<Parameter> parameter) {
                this.parameter = new ArrayList<Parameter>(parameter);
                return this;
            }

            public Builder template(Template ... template) {
                for (Template value : template) {
                    this.template.add(value);
                }
                return this;
            }

            public Builder template(Collection<Template> template) {
                this.template = new ArrayList<Template>(template);
                return this;
            }

            @Override
            public Definition build() {
                return new Definition(this);
            }

            protected Builder from(Definition definition) {
                super.from(definition);
                this.grouping.addAll(definition.grouping);
                this.resource.addAll(definition.resource);
                this.page = definition.page;
                this.parameter.addAll(definition.parameter);
                this.template.addAll(definition.template);
                return this;
            }
        }
    }

    public static class Global
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ResourceType", strength=BindingStrength.ValueSet.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
        @Required
        private final ResourceType type;
        @Summary
        @Required
        private final Canonical profile;
        private volatile int hashCode;

        private Global(Builder builder) {
            super(builder);
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            this.profile = ValidationSupport.requireNonNull(builder.profile, "profile");
            ValidationSupport.requireValueOrChildren(this);
        }

        public ResourceType getType() {
            return this.type;
        }

        public Canonical getProfile() {
            return this.profile;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.profile != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.profile, "profile", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.profile, other.profile);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.profile);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ResourceType type;
            private Canonical profile;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(ResourceType type) {
                this.type = type;
                return this;
            }

            public Builder profile(Canonical profile) {
                this.profile = profile;
                return this;
            }

            @Override
            public Global build() {
                return new Global(this);
            }

            protected Builder from(Global global) {
                super.from(global);
                this.type = global.type;
                this.profile = global.profile;
                return this;
            }
        }
    }

    public static class DependsOn
    extends BackboneElement {
        @Summary
        @Required
        private final Canonical uri;
        @Summary
        private final Id packageId;
        @Summary
        private final String version;
        private volatile int hashCode;

        private DependsOn(Builder builder) {
            super(builder);
            this.uri = ValidationSupport.requireNonNull(builder.uri, "uri");
            this.packageId = builder.packageId;
            this.version = builder.version;
            ValidationSupport.requireValueOrChildren(this);
        }

        public Canonical getUri() {
            return this.uri;
        }

        public Id getPackageId() {
            return this.packageId;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.uri != null || this.packageId != null || this.version != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.uri, "uri", visitor);
                    this.accept(this.packageId, "packageId", visitor);
                    this.accept(this.version, "version", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependsOn other = (DependsOn)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.uri, other.uri) && Objects.equals(this.packageId, other.packageId) && Objects.equals(this.version, other.version);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.uri, this.packageId, this.version);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Canonical uri;
            private Id packageId;
            private String version;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder uri(Canonical uri) {
                this.uri = uri;
                return this;
            }

            public Builder packageId(Id packageId) {
                this.packageId = packageId;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            @Override
            public DependsOn build() {
                return new DependsOn(this);
            }

            protected Builder from(DependsOn dependsOn) {
                super.from(dependsOn);
                this.uri = dependsOn.uri;
                this.packageId = dependsOn.packageId;
                this.version = dependsOn.version;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown copyright;
        private Id packageId;
        private SPDXLicense license;
        private List<FHIRVersion> fhirVersion = new ArrayList<FHIRVersion>();
        private List<DependsOn> dependsOn = new ArrayList<DependsOn>();
        private List<Global> global = new ArrayList<Global>();
        private Definition definition;
        private Manifest manifest;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder packageId(Id packageId) {
            this.packageId = packageId;
            return this;
        }

        public Builder license(SPDXLicense license) {
            this.license = license;
            return this;
        }

        public Builder fhirVersion(FHIRVersion ... fhirVersion) {
            for (FHIRVersion value : fhirVersion) {
                this.fhirVersion.add(value);
            }
            return this;
        }

        public Builder fhirVersion(Collection<FHIRVersion> fhirVersion) {
            this.fhirVersion = new ArrayList<FHIRVersion>(fhirVersion);
            return this;
        }

        public Builder dependsOn(DependsOn ... dependsOn) {
            for (DependsOn value : dependsOn) {
                this.dependsOn.add(value);
            }
            return this;
        }

        public Builder dependsOn(Collection<DependsOn> dependsOn) {
            this.dependsOn = new ArrayList<DependsOn>(dependsOn);
            return this;
        }

        public Builder global(Global ... global) {
            for (Global value : global) {
                this.global.add(value);
            }
            return this;
        }

        public Builder global(Collection<Global> global) {
            this.global = new ArrayList<Global>(global);
            return this;
        }

        public Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public Builder manifest(Manifest manifest) {
            this.manifest = manifest;
            return this;
        }

        @Override
        public ImplementationGuide build() {
            return new ImplementationGuide(this);
        }

        protected Builder from(ImplementationGuide implementationGuide) {
            super.from(implementationGuide);
            this.url = implementationGuide.url;
            this.version = implementationGuide.version;
            this.name = implementationGuide.name;
            this.title = implementationGuide.title;
            this.status = implementationGuide.status;
            this.experimental = implementationGuide.experimental;
            this.date = implementationGuide.date;
            this.publisher = implementationGuide.publisher;
            this.contact.addAll(implementationGuide.contact);
            this.description = implementationGuide.description;
            this.useContext.addAll(implementationGuide.useContext);
            this.jurisdiction.addAll(implementationGuide.jurisdiction);
            this.copyright = implementationGuide.copyright;
            this.packageId = implementationGuide.packageId;
            this.license = implementationGuide.license;
            this.fhirVersion.addAll(implementationGuide.fhirVersion);
            this.dependsOn.addAll(implementationGuide.dependsOn);
            this.global.addAll(implementationGuide.global);
            this.definition = implementationGuide.definition;
            this.manifest = implementationGuide.manifest;
            return this;
        }
    }
}

