/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MediaStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="media-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/media-type", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/media-type', 'extensible'))", generated=true)
public class Media
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"ServiceRequest", "CarePlan"})
    private final List<Reference> basedOn;
    @Summary
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="MediaStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Codes identifying the lifecycle stage of an event.", valueSet="http://hl7.org/fhir/ValueSet/event-status|4.0.1")
    @Required
    private final MediaStatus status;
    @Summary
    @Binding(bindingName="MediaType", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Codes for high level media categories.", valueSet="http://hl7.org/fhir/ValueSet/media-type")
    private final CodeableConcept type;
    @Summary
    @Binding(bindingName="MediaModality", strength=BindingStrength.ValueSet.EXAMPLE, description="Detailed information about the type of the image - its kind, purpose, or the kind of equipment used to generate it.", valueSet="http://hl7.org/fhir/ValueSet/media-modality")
    private final CodeableConcept modality;
    @Summary
    @Binding(bindingName="MediaView", strength=BindingStrength.ValueSet.EXAMPLE, description="Imaging view (projection) used when collecting an image.", valueSet="http://hl7.org/fhir/ValueSet/media-view")
    private final CodeableConcept view;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "Group", "Device", "Specimen", "Location"})
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    private final Element created;
    @Summary
    private final Instant issued;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "Device", "RelatedPerson"})
    private final Reference operator;
    @Summary
    @Binding(bindingName="MediaReason", strength=BindingStrength.ValueSet.EXAMPLE, description="The reason for the media.", valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @Binding(bindingName="BodySite", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final CodeableConcept bodySite;
    @Summary
    private final String deviceName;
    @Summary
    @ReferenceTarget(value={"Device", "DeviceMetric", "Device"})
    private final Reference device;
    @Summary
    private final PositiveInt height;
    @Summary
    private final PositiveInt width;
    @Summary
    private final PositiveInt frames;
    @Summary
    private final Decimal duration;
    @Summary
    @Required
    private final Attachment content;
    private final List<Annotation> note;
    private volatile int hashCode;

    private Media(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.partOf = Collections.unmodifiableList(ValidationSupport.checkList(builder.partOf, "partOf", Reference.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.type = builder.type;
        this.modality = builder.modality;
        this.view = builder.view;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.created = ValidationSupport.choiceElement(builder.created, "created", DateTime.class, Period.class);
        this.issued = builder.issued;
        this.operator = builder.operator;
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.bodySite = builder.bodySite;
        this.deviceName = builder.deviceName;
        this.device = builder.device;
        this.height = builder.height;
        this.width = builder.width;
        this.frames = builder.frames;
        this.duration = builder.duration;
        this.content = ValidationSupport.requireNonNull(builder.content, "content");
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "ServiceRequest", "CarePlan");
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Practitioner", "PractitionerRole", "Group", "Device", "Specimen", "Location");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.operator, "operator", "Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "Device", "RelatedPerson");
        ValidationSupport.checkReferenceType(this.device, "device", "Device", "DeviceMetric", "Device");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public MediaStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public CodeableConcept getModality() {
        return this.modality;
    }

    public CodeableConcept getView() {
        return this.view;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getCreated() {
        return this.created;
    }

    public Instant getIssued() {
        return this.issued;
    }

    public Reference getOperator() {
        return this.operator;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public CodeableConcept getBodySite() {
        return this.bodySite;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Reference getDevice() {
        return this.device;
    }

    public PositiveInt getHeight() {
        return this.height;
    }

    public PositiveInt getWidth() {
        return this.width;
    }

    public PositiveInt getFrames() {
        return this.frames;
    }

    public Decimal getDuration() {
        return this.duration;
    }

    public Attachment getContent() {
        return this.content;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.basedOn.isEmpty() || !this.partOf.isEmpty() || this.status != null || this.type != null || this.modality != null || this.view != null || this.subject != null || this.encounter != null || this.created != null || this.issued != null || this.operator != null || !this.reasonCode.isEmpty() || this.bodySite != null || this.deviceName != null || this.device != null || this.height != null || this.width != null || this.frames != null || this.duration != null || this.content != null || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.modality, "modality", visitor);
                this.accept(this.view, "view", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.issued, "issued", visitor);
                this.accept(this.operator, "operator", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.bodySite, "bodySite", visitor);
                this.accept(this.deviceName, "deviceName", visitor);
                this.accept(this.device, "device", visitor);
                this.accept(this.height, "height", visitor);
                this.accept(this.width, "width", visitor);
                this.accept(this.frames, "frames", visitor);
                this.accept(this.duration, "duration", visitor);
                this.accept(this.content, "content", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Media other = (Media)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.modality, other.modality) && Objects.equals(this.view, other.view) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.created, other.created) && Objects.equals(this.issued, other.issued) && Objects.equals(this.operator, other.operator) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.deviceName, other.deviceName) && Objects.equals(this.device, other.device) && Objects.equals(this.height, other.height) && Objects.equals(this.width, other.width) && Objects.equals(this.frames, other.frames) && Objects.equals(this.duration, other.duration) && Objects.equals(this.content, other.content) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.partOf, this.status, this.type, this.modality, this.view, this.subject, this.encounter, this.created, this.issued, this.operator, this.reasonCode, this.bodySite, this.deviceName, this.device, this.height, this.width, this.frames, this.duration, this.content, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private MediaStatus status;
        private CodeableConcept type;
        private CodeableConcept modality;
        private CodeableConcept view;
        private Reference subject;
        private Reference encounter;
        private Element created;
        private Instant issued;
        private Reference operator;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private CodeableConcept bodySite;
        private String deviceName;
        private Reference device;
        private PositiveInt height;
        private PositiveInt width;
        private PositiveInt frames;
        private Decimal duration;
        private Attachment content;
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(MediaStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder modality(CodeableConcept modality) {
            this.modality = modality;
            return this;
        }

        public Builder view(CodeableConcept view) {
            this.view = view;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder created(Element created) {
            this.created = created;
            return this;
        }

        public Builder issued(Instant issued) {
            this.issued = issued;
            return this;
        }

        public Builder operator(Reference operator) {
            this.operator = operator;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder bodySite(CodeableConcept bodySite) {
            this.bodySite = bodySite;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder device(Reference device) {
            this.device = device;
            return this;
        }

        public Builder height(PositiveInt height) {
            this.height = height;
            return this;
        }

        public Builder width(PositiveInt width) {
            this.width = width;
            return this;
        }

        public Builder frames(PositiveInt frames) {
            this.frames = frames;
            return this;
        }

        public Builder duration(Decimal duration) {
            this.duration = duration;
            return this;
        }

        public Builder content(Attachment content) {
            this.content = content;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public Media build() {
            return new Media(this);
        }

        protected Builder from(Media media) {
            super.from(media);
            this.identifier.addAll(media.identifier);
            this.basedOn.addAll(media.basedOn);
            this.partOf.addAll(media.partOf);
            this.status = media.status;
            this.type = media.type;
            this.modality = media.modality;
            this.view = media.view;
            this.subject = media.subject;
            this.encounter = media.encounter;
            this.created = media.created;
            this.issued = media.issued;
            this.operator = media.operator;
            this.reasonCode.addAll(media.reasonCode);
            this.bodySite = media.bodySite;
            this.deviceName = media.deviceName;
            this.device = media.device;
            this.height = media.height;
            this.width = media.width;
            this.frames = media.frames;
            this.duration = media.duration;
            this.content = media.content;
            this.note.addAll(media.note);
            return this;
        }
    }
}

