/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MedicationRequestIntent;
import com.ibm.fhir.model.type.code.MedicationRequestPriority;
import com.ibm.fhir.model.type.code.MedicationRequestStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.ValueSet.TRIAL_USE)
public class MedicationRequest
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="MedicationRequestStatus", strength=BindingStrength.ValueSet.REQUIRED, description="A coded concept specifying the state of the prescribing event. Describes the lifecycle of the prescription.", valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-status|4.0.1")
    @Required
    private final MedicationRequestStatus status;
    @Binding(bindingName="MedicationRequestStatusReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Identifies the reasons for a given status.", valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-status-reason")
    private final CodeableConcept statusReason;
    @Summary
    @Binding(bindingName="MedicationRequestIntent", strength=BindingStrength.ValueSet.REQUIRED, description="The kind of medication order.", valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-intent|4.0.1")
    @Required
    private final MedicationRequestIntent intent;
    @Binding(bindingName="MedicationRequestCategory", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept identifying the category of medication request.  For example, where the medication is to be consumed or administered, or the type of medication treatment.", valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="MedicationRequestPriority", strength=BindingStrength.ValueSet.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.0.1")
    private final MedicationRequestPriority priority;
    @Summary
    private final Boolean doNotPerform;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Organization"})
    @Choice(value={Boolean.class, Reference.class})
    private final Element reported;
    @Summary
    @ReferenceTarget(value={"Medication"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="MedicationCode", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept identifying substance or product that can be ordered.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    @Required
    private final Element medication;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    private final List<Reference> supportingInformation;
    @Summary
    private final DateTime authoredOn;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device"})
    private final Reference requester;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "Device", "RelatedPerson", "CareTeam"})
    private final Reference performer;
    @Summary
    @Binding(bindingName="MedicationRequestPerformerType", strength=BindingStrength.ValueSet.EXAMPLE, description="Identifies the type of individual that is desired to administer the medication.", valueSet="http://hl7.org/fhir/ValueSet/performer-role")
    private final CodeableConcept performerType;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference recorder;
    @Binding(bindingName="MedicationRequestReason", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept indicating why the medication was ordered.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation"})
    private final List<Reference> reasonReference;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    @Summary
    @ReferenceTarget(value={"CarePlan", "MedicationRequest", "ServiceRequest", "ImmunizationRecommendation"})
    private final List<Reference> basedOn;
    @Summary
    private final Identifier groupIdentifier;
    @Binding(bindingName="MedicationRequestCourseOfTherapy", strength=BindingStrength.ValueSet.EXAMPLE, description="Identifies the overall pattern of medication administratio.", valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-course-of-therapy")
    private final CodeableConcept courseOfTherapyType;
    @ReferenceTarget(value={"Coverage", "ClaimResponse"})
    private final List<Reference> insurance;
    private final List<Annotation> note;
    private final List<Dosage> dosageInstruction;
    private final DispenseRequest dispenseRequest;
    private final Substitution substitution;
    @ReferenceTarget(value={"MedicationRequest"})
    private final Reference priorPrescription;
    @ReferenceTarget(value={"DetectedIssue"})
    private final List<Reference> detectedIssue;
    @ReferenceTarget(value={"Provenance"})
    private final List<Reference> eventHistory;
    private volatile int hashCode;

    private MedicationRequest(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.statusReason = builder.statusReason;
        this.intent = ValidationSupport.requireNonNull(builder.intent, "intent");
        this.category = Collections.unmodifiableList(ValidationSupport.checkList(builder.category, "category", CodeableConcept.class));
        this.priority = builder.priority;
        this.doNotPerform = builder.doNotPerform;
        this.reported = ValidationSupport.choiceElement(builder.reported, "reported", Boolean.class, Reference.class);
        this.medication = ValidationSupport.requireChoiceElement(builder.medication, "medication", CodeableConcept.class, Reference.class);
        this.subject = ValidationSupport.requireNonNull(builder.subject, "subject");
        this.encounter = builder.encounter;
        this.supportingInformation = Collections.unmodifiableList(ValidationSupport.checkList(builder.supportingInformation, "supportingInformation", Reference.class));
        this.authoredOn = builder.authoredOn;
        this.requester = builder.requester;
        this.performer = builder.performer;
        this.performerType = builder.performerType;
        this.recorder = builder.recorder;
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
        this.instantiatesCanonical = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesCanonical, "instantiatesCanonical", Canonical.class));
        this.instantiatesUri = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesUri, "instantiatesUri", Uri.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.groupIdentifier = builder.groupIdentifier;
        this.courseOfTherapyType = builder.courseOfTherapyType;
        this.insurance = Collections.unmodifiableList(ValidationSupport.checkList(builder.insurance, "insurance", Reference.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.dosageInstruction = Collections.unmodifiableList(ValidationSupport.checkList(builder.dosageInstruction, "dosageInstruction", Dosage.class));
        this.dispenseRequest = builder.dispenseRequest;
        this.substitution = builder.substitution;
        this.priorPrescription = builder.priorPrescription;
        this.detectedIssue = Collections.unmodifiableList(ValidationSupport.checkList(builder.detectedIssue, "detectedIssue", Reference.class));
        this.eventHistory = Collections.unmodifiableList(ValidationSupport.checkList(builder.eventHistory, "eventHistory", Reference.class));
        ValidationSupport.checkReferenceType(this.reported, "reported", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Organization");
        ValidationSupport.checkReferenceType(this.medication, "medication", "Medication");
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Group");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.requester, "requester", "Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device");
        ValidationSupport.checkReferenceType(this.performer, "performer", "Practitioner", "PractitionerRole", "Organization", "Patient", "Device", "RelatedPerson", "CareTeam");
        ValidationSupport.checkReferenceType(this.recorder, "recorder", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Observation");
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "CarePlan", "MedicationRequest", "ServiceRequest", "ImmunizationRecommendation");
        ValidationSupport.checkReferenceType(this.insurance, "insurance", "Coverage", "ClaimResponse");
        ValidationSupport.checkReferenceType(this.priorPrescription, "priorPrescription", "MedicationRequest");
        ValidationSupport.checkReferenceType(this.detectedIssue, "detectedIssue", "DetectedIssue");
        ValidationSupport.checkReferenceType(this.eventHistory, "eventHistory", "Provenance");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public MedicationRequestStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public MedicationRequestIntent getIntent() {
        return this.intent;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public MedicationRequestPriority getPriority() {
        return this.priority;
    }

    public Boolean getDoNotPerform() {
        return this.doNotPerform;
    }

    public Element getReported() {
        return this.reported;
    }

    public Element getMedication() {
        return this.medication;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public List<Reference> getSupportingInformation() {
        return this.supportingInformation;
    }

    public DateTime getAuthoredOn() {
        return this.authoredOn;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public CodeableConcept getPerformerType() {
        return this.performerType;
    }

    public Reference getRecorder() {
        return this.recorder;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public Identifier getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public CodeableConcept getCourseOfTherapyType() {
        return this.courseOfTherapyType;
    }

    public List<Reference> getInsurance() {
        return this.insurance;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Dosage> getDosageInstruction() {
        return this.dosageInstruction;
    }

    public DispenseRequest getDispenseRequest() {
        return this.dispenseRequest;
    }

    public Substitution getSubstitution() {
        return this.substitution;
    }

    public Reference getPriorPrescription() {
        return this.priorPrescription;
    }

    public List<Reference> getDetectedIssue() {
        return this.detectedIssue;
    }

    public List<Reference> getEventHistory() {
        return this.eventHistory;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.statusReason != null || this.intent != null || !this.category.isEmpty() || this.priority != null || this.doNotPerform != null || this.reported != null || this.medication != null || this.subject != null || this.encounter != null || !this.supportingInformation.isEmpty() || this.authoredOn != null || this.requester != null || this.performer != null || this.performerType != null || this.recorder != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || !this.basedOn.isEmpty() || this.groupIdentifier != null || this.courseOfTherapyType != null || !this.insurance.isEmpty() || !this.note.isEmpty() || !this.dosageInstruction.isEmpty() || this.dispenseRequest != null || this.substitution != null || this.priorPrescription != null || !this.detectedIssue.isEmpty() || !this.eventHistory.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.doNotPerform, "doNotPerform", visitor);
                this.accept(this.reported, "reported", visitor);
                this.accept(this.medication, "medication", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.supportingInformation, "supportingInformation", visitor, Reference.class);
                this.accept(this.authoredOn, "authoredOn", visitor);
                this.accept(this.requester, "requester", visitor);
                this.accept(this.performer, "performer", visitor);
                this.accept(this.performerType, "performerType", visitor);
                this.accept(this.recorder, "recorder", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.groupIdentifier, "groupIdentifier", visitor);
                this.accept(this.courseOfTherapyType, "courseOfTherapyType", visitor);
                this.accept(this.insurance, "insurance", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.dosageInstruction, "dosageInstruction", visitor, Dosage.class);
                this.accept(this.dispenseRequest, "dispenseRequest", visitor);
                this.accept(this.substitution, "substitution", visitor);
                this.accept(this.priorPrescription, "priorPrescription", visitor);
                this.accept(this.detectedIssue, "detectedIssue", visitor, Reference.class);
                this.accept(this.eventHistory, "eventHistory", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationRequest other = (MedicationRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.intent, other.intent) && Objects.equals(this.category, other.category) && Objects.equals(this.priority, other.priority) && Objects.equals(this.doNotPerform, other.doNotPerform) && Objects.equals(this.reported, other.reported) && Objects.equals(this.medication, other.medication) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.supportingInformation, other.supportingInformation) && Objects.equals(this.authoredOn, other.authoredOn) && Objects.equals(this.requester, other.requester) && Objects.equals(this.performer, other.performer) && Objects.equals(this.performerType, other.performerType) && Objects.equals(this.recorder, other.recorder) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.groupIdentifier, other.groupIdentifier) && Objects.equals(this.courseOfTherapyType, other.courseOfTherapyType) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.note, other.note) && Objects.equals(this.dosageInstruction, other.dosageInstruction) && Objects.equals(this.dispenseRequest, other.dispenseRequest) && Objects.equals(this.substitution, other.substitution) && Objects.equals(this.priorPrescription, other.priorPrescription) && Objects.equals(this.detectedIssue, other.detectedIssue) && Objects.equals(this.eventHistory, other.eventHistory);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.statusReason, this.intent, this.category, this.priority, this.doNotPerform, this.reported, this.medication, this.subject, this.encounter, this.supportingInformation, this.authoredOn, this.requester, this.performer, this.performerType, this.recorder, this.reasonCode, this.reasonReference, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.groupIdentifier, this.courseOfTherapyType, this.insurance, this.note, this.dosageInstruction, this.dispenseRequest, this.substitution, this.priorPrescription, this.detectedIssue, this.eventHistory);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Substitution
    extends BackboneElement {
        @Choice(value={Boolean.class, CodeableConcept.class})
        @Binding(bindingName="MedicationRequestSubstitution", strength=BindingStrength.ValueSet.EXAMPLE, description="Identifies the type of substitution allowed.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActSubstanceAdminSubstitutionCode")
        @Required
        private final Element allowed;
        @Binding(bindingName="MedicationIntendedSubstitutionReason", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept describing the reason that a different medication should (or should not) be substituted from what was prescribed.", valueSet="http://terminology.hl7.org/ValueSet/v3-SubstanceAdminSubstitutionReason")
        private final CodeableConcept reason;
        private volatile int hashCode;

        private Substitution(Builder builder) {
            super(builder);
            this.allowed = ValidationSupport.requireChoiceElement(builder.allowed, "allowed", Boolean.class, CodeableConcept.class);
            this.reason = builder.reason;
            ValidationSupport.requireValueOrChildren(this);
        }

        public Element getAllowed() {
            return this.allowed;
        }

        public CodeableConcept getReason() {
            return this.reason;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.allowed != null || this.reason != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.allowed, "allowed", visitor);
                    this.accept(this.reason, "reason", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Substitution other = (Substitution)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.allowed, other.allowed) && Objects.equals(this.reason, other.reason);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.allowed, this.reason);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element allowed;
            private CodeableConcept reason;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder allowed(Element allowed) {
                this.allowed = allowed;
                return this;
            }

            public Builder reason(CodeableConcept reason) {
                this.reason = reason;
                return this;
            }

            @Override
            public Substitution build() {
                return new Substitution(this);
            }

            protected Builder from(Substitution substitution) {
                super.from(substitution);
                this.allowed = substitution.allowed;
                this.reason = substitution.reason;
                return this;
            }
        }
    }

    public static class DispenseRequest
    extends BackboneElement {
        private final InitialFill initialFill;
        private final Duration dispenseInterval;
        private final Period validityPeriod;
        private final UnsignedInt numberOfRepeatsAllowed;
        private final SimpleQuantity quantity;
        private final Duration expectedSupplyDuration;
        @ReferenceTarget(value={"Organization"})
        private final Reference performer;
        private volatile int hashCode;

        private DispenseRequest(Builder builder) {
            super(builder);
            this.initialFill = builder.initialFill;
            this.dispenseInterval = builder.dispenseInterval;
            this.validityPeriod = builder.validityPeriod;
            this.numberOfRepeatsAllowed = builder.numberOfRepeatsAllowed;
            this.quantity = builder.quantity;
            this.expectedSupplyDuration = builder.expectedSupplyDuration;
            this.performer = builder.performer;
            ValidationSupport.checkReferenceType(this.performer, "performer", "Organization");
            ValidationSupport.requireValueOrChildren(this);
        }

        public InitialFill getInitialFill() {
            return this.initialFill;
        }

        public Duration getDispenseInterval() {
            return this.dispenseInterval;
        }

        public Period getValidityPeriod() {
            return this.validityPeriod;
        }

        public UnsignedInt getNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public Duration getExpectedSupplyDuration() {
            return this.expectedSupplyDuration;
        }

        public Reference getPerformer() {
            return this.performer;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.initialFill != null || this.dispenseInterval != null || this.validityPeriod != null || this.numberOfRepeatsAllowed != null || this.quantity != null || this.expectedSupplyDuration != null || this.performer != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.initialFill, "initialFill", visitor);
                    this.accept(this.dispenseInterval, "dispenseInterval", visitor);
                    this.accept(this.validityPeriod, "validityPeriod", visitor);
                    this.accept(this.numberOfRepeatsAllowed, "numberOfRepeatsAllowed", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.expectedSupplyDuration, "expectedSupplyDuration", visitor);
                    this.accept(this.performer, "performer", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DispenseRequest other = (DispenseRequest)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.initialFill, other.initialFill) && Objects.equals(this.dispenseInterval, other.dispenseInterval) && Objects.equals(this.validityPeriod, other.validityPeriod) && Objects.equals(this.numberOfRepeatsAllowed, other.numberOfRepeatsAllowed) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.expectedSupplyDuration, other.expectedSupplyDuration) && Objects.equals(this.performer, other.performer);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.initialFill, this.dispenseInterval, this.validityPeriod, this.numberOfRepeatsAllowed, this.quantity, this.expectedSupplyDuration, this.performer);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class InitialFill
        extends BackboneElement {
            private final SimpleQuantity quantity;
            private final Duration duration;
            private volatile int hashCode;

            private InitialFill(Builder builder) {
                super(builder);
                this.quantity = builder.quantity;
                this.duration = builder.duration;
                ValidationSupport.requireValueOrChildren(this);
            }

            public SimpleQuantity getQuantity() {
                return this.quantity;
            }

            public Duration getDuration() {
                return this.duration;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.quantity != null || this.duration != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.duration, "duration", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                InitialFill other = (InitialFill)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.duration, other.duration);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.quantity, this.duration);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private SimpleQuantity quantity;
                private Duration duration;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder quantity(SimpleQuantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder duration(Duration duration) {
                    this.duration = duration;
                    return this;
                }

                @Override
                public InitialFill build() {
                    return new InitialFill(this);
                }

                protected Builder from(InitialFill initialFill) {
                    super.from(initialFill);
                    this.quantity = initialFill.quantity;
                    this.duration = initialFill.duration;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private InitialFill initialFill;
            private Duration dispenseInterval;
            private Period validityPeriod;
            private UnsignedInt numberOfRepeatsAllowed;
            private SimpleQuantity quantity;
            private Duration expectedSupplyDuration;
            private Reference performer;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder initialFill(InitialFill initialFill) {
                this.initialFill = initialFill;
                return this;
            }

            public Builder dispenseInterval(Duration dispenseInterval) {
                this.dispenseInterval = dispenseInterval;
                return this;
            }

            public Builder validityPeriod(Period validityPeriod) {
                this.validityPeriod = validityPeriod;
                return this;
            }

            public Builder numberOfRepeatsAllowed(UnsignedInt numberOfRepeatsAllowed) {
                this.numberOfRepeatsAllowed = numberOfRepeatsAllowed;
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder expectedSupplyDuration(Duration expectedSupplyDuration) {
                this.expectedSupplyDuration = expectedSupplyDuration;
                return this;
            }

            public Builder performer(Reference performer) {
                this.performer = performer;
                return this;
            }

            @Override
            public DispenseRequest build() {
                return new DispenseRequest(this);
            }

            protected Builder from(DispenseRequest dispenseRequest) {
                super.from(dispenseRequest);
                this.initialFill = dispenseRequest.initialFill;
                this.dispenseInterval = dispenseRequest.dispenseInterval;
                this.validityPeriod = dispenseRequest.validityPeriod;
                this.numberOfRepeatsAllowed = dispenseRequest.numberOfRepeatsAllowed;
                this.quantity = dispenseRequest.quantity;
                this.expectedSupplyDuration = dispenseRequest.expectedSupplyDuration;
                this.performer = dispenseRequest.performer;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private MedicationRequestStatus status;
        private CodeableConcept statusReason;
        private MedicationRequestIntent intent;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private MedicationRequestPriority priority;
        private Boolean doNotPerform;
        private Element reported;
        private Element medication;
        private Reference subject;
        private Reference encounter;
        private List<Reference> supportingInformation = new ArrayList<Reference>();
        private DateTime authoredOn;
        private Reference requester;
        private Reference performer;
        private CodeableConcept performerType;
        private Reference recorder;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private Identifier groupIdentifier;
        private CodeableConcept courseOfTherapyType;
        private List<Reference> insurance = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Dosage> dosageInstruction = new ArrayList<Dosage>();
        private DispenseRequest dispenseRequest;
        private Substitution substitution;
        private Reference priorPrescription;
        private List<Reference> detectedIssue = new ArrayList<Reference>();
        private List<Reference> eventHistory = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(MedicationRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder intent(MedicationRequestIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder priority(MedicationRequestPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder doNotPerform(Boolean doNotPerform) {
            this.doNotPerform = doNotPerform;
            return this;
        }

        public Builder reported(Element reported) {
            this.reported = reported;
            return this;
        }

        public Builder medication(Element medication) {
            this.medication = medication;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder supportingInformation(Reference ... supportingInformation) {
            for (Reference value : supportingInformation) {
                this.supportingInformation.add(value);
            }
            return this;
        }

        public Builder supportingInformation(Collection<Reference> supportingInformation) {
            this.supportingInformation = new ArrayList<Reference>(supportingInformation);
            return this;
        }

        public Builder authoredOn(DateTime authoredOn) {
            this.authoredOn = authoredOn;
            return this;
        }

        public Builder requester(Reference requester) {
            this.requester = requester;
            return this;
        }

        public Builder performer(Reference performer) {
            this.performer = performer;
            return this;
        }

        public Builder performerType(CodeableConcept performerType) {
            this.performerType = performerType;
            return this;
        }

        public Builder recorder(Reference recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder groupIdentifier(Identifier groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public Builder courseOfTherapyType(CodeableConcept courseOfTherapyType) {
            this.courseOfTherapyType = courseOfTherapyType;
            return this;
        }

        public Builder insurance(Reference ... insurance) {
            for (Reference value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Reference> insurance) {
            this.insurance = new ArrayList<Reference>(insurance);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder dosageInstruction(Dosage ... dosageInstruction) {
            for (Dosage value : dosageInstruction) {
                this.dosageInstruction.add(value);
            }
            return this;
        }

        public Builder dosageInstruction(Collection<Dosage> dosageInstruction) {
            this.dosageInstruction = new ArrayList<Dosage>(dosageInstruction);
            return this;
        }

        public Builder dispenseRequest(DispenseRequest dispenseRequest) {
            this.dispenseRequest = dispenseRequest;
            return this;
        }

        public Builder substitution(Substitution substitution) {
            this.substitution = substitution;
            return this;
        }

        public Builder priorPrescription(Reference priorPrescription) {
            this.priorPrescription = priorPrescription;
            return this;
        }

        public Builder detectedIssue(Reference ... detectedIssue) {
            for (Reference value : detectedIssue) {
                this.detectedIssue.add(value);
            }
            return this;
        }

        public Builder detectedIssue(Collection<Reference> detectedIssue) {
            this.detectedIssue = new ArrayList<Reference>(detectedIssue);
            return this;
        }

        public Builder eventHistory(Reference ... eventHistory) {
            for (Reference value : eventHistory) {
                this.eventHistory.add(value);
            }
            return this;
        }

        public Builder eventHistory(Collection<Reference> eventHistory) {
            this.eventHistory = new ArrayList<Reference>(eventHistory);
            return this;
        }

        @Override
        public MedicationRequest build() {
            return new MedicationRequest(this);
        }

        protected Builder from(MedicationRequest medicationRequest) {
            super.from(medicationRequest);
            this.identifier.addAll(medicationRequest.identifier);
            this.status = medicationRequest.status;
            this.statusReason = medicationRequest.statusReason;
            this.intent = medicationRequest.intent;
            this.category.addAll(medicationRequest.category);
            this.priority = medicationRequest.priority;
            this.doNotPerform = medicationRequest.doNotPerform;
            this.reported = medicationRequest.reported;
            this.medication = medicationRequest.medication;
            this.subject = medicationRequest.subject;
            this.encounter = medicationRequest.encounter;
            this.supportingInformation.addAll(medicationRequest.supportingInformation);
            this.authoredOn = medicationRequest.authoredOn;
            this.requester = medicationRequest.requester;
            this.performer = medicationRequest.performer;
            this.performerType = medicationRequest.performerType;
            this.recorder = medicationRequest.recorder;
            this.reasonCode.addAll(medicationRequest.reasonCode);
            this.reasonReference.addAll(medicationRequest.reasonReference);
            this.instantiatesCanonical.addAll(medicationRequest.instantiatesCanonical);
            this.instantiatesUri.addAll(medicationRequest.instantiatesUri);
            this.basedOn.addAll(medicationRequest.basedOn);
            this.groupIdentifier = medicationRequest.groupIdentifier;
            this.courseOfTherapyType = medicationRequest.courseOfTherapyType;
            this.insurance.addAll(medicationRequest.insurance);
            this.note.addAll(medicationRequest.note);
            this.dosageInstruction.addAll(medicationRequest.dosageInstruction);
            this.dispenseRequest = medicationRequest.dispenseRequest;
            this.substitution = medicationRequest.substitution;
            this.priorPrescription = medicationRequest.priorPrescription;
            this.detectedIssue.addAll(medicationRequest.detectedIssue);
            this.eventHistory.addAll(medicationRequest.eventHistory);
            return this;
        }
    }
}

