/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MedicationStatementStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="medicationStatement-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/medication-statement-category", expression="category.exists() implies (category.memberOf('http://hl7.org/fhir/ValueSet/medication-statement-category', 'preferred'))", generated=true)
public class MedicationStatement
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"MedicationRequest", "CarePlan", "ServiceRequest"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"MedicationAdministration", "MedicationDispense", "MedicationStatement", "Procedure", "Observation"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="MedicationStatementStatus", strength=BindingStrength.ValueSet.REQUIRED, description="A coded concept indicating the current status of a MedicationStatement.", valueSet="http://hl7.org/fhir/ValueSet/medication-statement-status|4.0.1")
    @Required
    private final MedicationStatementStatus status;
    @Binding(bindingName="MedicationStatementStatusReason", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept indicating the reason for the status of the statement.", valueSet="http://hl7.org/fhir/ValueSet/reason-medication-status-codes")
    private final List<CodeableConcept> statusReason;
    @Summary
    @Binding(bindingName="MedicationStatementCategory", strength=BindingStrength.ValueSet.PREFERRED, description="A coded concept identifying where the medication included in the MedicationStatement is expected to be consumed or administered.", valueSet="http://hl7.org/fhir/ValueSet/medication-statement-category")
    private final CodeableConcept category;
    @Summary
    @ReferenceTarget(value={"Medication"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="MedicationCode", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept identifying the substance or product being taken.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    @Required
    private final Element medication;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter", "EpisodeOfCare"})
    private final Reference context;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    private final Element effective;
    @Summary
    private final DateTime dateAsserted;
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Organization"})
    private final Reference informationSource;
    private final List<Reference> derivedFrom;
    @Binding(bindingName="MedicationReason", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept identifying why the medication is being taken.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport"})
    private final List<Reference> reasonReference;
    private final List<Annotation> note;
    private final List<Dosage> dosage;
    private volatile int hashCode;

    private MedicationStatement(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.partOf = Collections.unmodifiableList(ValidationSupport.checkList(builder.partOf, "partOf", Reference.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.statusReason = Collections.unmodifiableList(ValidationSupport.checkList(builder.statusReason, "statusReason", CodeableConcept.class));
        this.category = builder.category;
        this.medication = ValidationSupport.requireChoiceElement(builder.medication, "medication", CodeableConcept.class, Reference.class);
        this.subject = ValidationSupport.requireNonNull(builder.subject, "subject");
        this.context = builder.context;
        this.effective = ValidationSupport.choiceElement(builder.effective, "effective", DateTime.class, Period.class);
        this.dateAsserted = builder.dateAsserted;
        this.informationSource = builder.informationSource;
        this.derivedFrom = Collections.unmodifiableList(ValidationSupport.checkList(builder.derivedFrom, "derivedFrom", Reference.class));
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.dosage = Collections.unmodifiableList(ValidationSupport.checkList(builder.dosage, "dosage", Dosage.class));
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "MedicationRequest", "CarePlan", "ServiceRequest");
        ValidationSupport.checkReferenceType(this.partOf, "partOf", "MedicationAdministration", "MedicationDispense", "MedicationStatement", "Procedure", "Observation");
        ValidationSupport.checkReferenceType(this.medication, "medication", "Medication");
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Group");
        ValidationSupport.checkReferenceType(this.context, "context", "Encounter", "EpisodeOfCare");
        ValidationSupport.checkReferenceType(this.informationSource, "informationSource", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Organization");
        ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public MedicationStatementStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public Element getMedication() {
        return this.medication;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getContext() {
        return this.context;
    }

    public Element getEffective() {
        return this.effective;
    }

    public DateTime getDateAsserted() {
        return this.dateAsserted;
    }

    public Reference getInformationSource() {
        return this.informationSource;
    }

    public List<Reference> getDerivedFrom() {
        return this.derivedFrom;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Dosage> getDosage() {
        return this.dosage;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.basedOn.isEmpty() || !this.partOf.isEmpty() || this.status != null || !this.statusReason.isEmpty() || this.category != null || this.medication != null || this.subject != null || this.context != null || this.effective != null || this.dateAsserted != null || this.informationSource != null || !this.derivedFrom.isEmpty() || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.note.isEmpty() || !this.dosage.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor, CodeableConcept.class);
                this.accept(this.category, "category", visitor);
                this.accept(this.medication, "medication", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.context, "context", visitor);
                this.accept(this.effective, "effective", visitor);
                this.accept(this.dateAsserted, "dateAsserted", visitor);
                this.accept(this.informationSource, "informationSource", visitor);
                this.accept(this.derivedFrom, "derivedFrom", visitor, Reference.class);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.dosage, "dosage", visitor, Dosage.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationStatement other = (MedicationStatement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.category, other.category) && Objects.equals(this.medication, other.medication) && Objects.equals(this.subject, other.subject) && Objects.equals(this.context, other.context) && Objects.equals(this.effective, other.effective) && Objects.equals(this.dateAsserted, other.dateAsserted) && Objects.equals(this.informationSource, other.informationSource) && Objects.equals(this.derivedFrom, other.derivedFrom) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.note, other.note) && Objects.equals(this.dosage, other.dosage);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.partOf, this.status, this.statusReason, this.category, this.medication, this.subject, this.context, this.effective, this.dateAsserted, this.informationSource, this.derivedFrom, this.reasonCode, this.reasonReference, this.note, this.dosage);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private MedicationStatementStatus status;
        private List<CodeableConcept> statusReason = new ArrayList<CodeableConcept>();
        private CodeableConcept category;
        private Element medication;
        private Reference subject;
        private Reference context;
        private Element effective;
        private DateTime dateAsserted;
        private Reference informationSource;
        private List<Reference> derivedFrom = new ArrayList<Reference>();
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Dosage> dosage = new ArrayList<Dosage>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(MedicationStatementStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept ... statusReason) {
            for (CodeableConcept value : statusReason) {
                this.statusReason.add(value);
            }
            return this;
        }

        public Builder statusReason(Collection<CodeableConcept> statusReason) {
            this.statusReason = new ArrayList<CodeableConcept>(statusReason);
            return this;
        }

        public Builder category(CodeableConcept category) {
            this.category = category;
            return this;
        }

        public Builder medication(Element medication) {
            this.medication = medication;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder context(Reference context) {
            this.context = context;
            return this;
        }

        public Builder effective(Element effective) {
            this.effective = effective;
            return this;
        }

        public Builder dateAsserted(DateTime dateAsserted) {
            this.dateAsserted = dateAsserted;
            return this;
        }

        public Builder informationSource(Reference informationSource) {
            this.informationSource = informationSource;
            return this;
        }

        public Builder derivedFrom(Reference ... derivedFrom) {
            for (Reference value : derivedFrom) {
                this.derivedFrom.add(value);
            }
            return this;
        }

        public Builder derivedFrom(Collection<Reference> derivedFrom) {
            this.derivedFrom = new ArrayList<Reference>(derivedFrom);
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder dosage(Dosage ... dosage) {
            for (Dosage value : dosage) {
                this.dosage.add(value);
            }
            return this;
        }

        public Builder dosage(Collection<Dosage> dosage) {
            this.dosage = new ArrayList<Dosage>(dosage);
            return this;
        }

        @Override
        public MedicationStatement build() {
            return new MedicationStatement(this);
        }

        protected Builder from(MedicationStatement medicationStatement) {
            super.from(medicationStatement);
            this.identifier.addAll(medicationStatement.identifier);
            this.basedOn.addAll(medicationStatement.basedOn);
            this.partOf.addAll(medicationStatement.partOf);
            this.status = medicationStatement.status;
            this.statusReason.addAll(medicationStatement.statusReason);
            this.category = medicationStatement.category;
            this.medication = medicationStatement.medication;
            this.subject = medicationStatement.subject;
            this.context = medicationStatement.context;
            this.effective = medicationStatement.effective;
            this.dateAsserted = medicationStatement.dateAsserted;
            this.informationSource = medicationStatement.informationSource;
            this.derivedFrom.addAll(medicationStatement.derivedFrom);
            this.reasonCode.addAll(medicationStatement.reasonCode);
            this.reasonReference.addAll(medicationStatement.reasonReference);
            this.note.addAll(medicationStatement.note);
            this.dosage.addAll(medicationStatement.dosage);
            return this;
        }
    }
}

