/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Population;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class MedicinalProductIndication
extends DomainResource {
    @Summary
    @ReferenceTarget(value={"MedicinalProduct", "Medication"})
    private final List<Reference> subject;
    @Summary
    private final CodeableConcept diseaseSymptomProcedure;
    @Summary
    private final CodeableConcept diseaseStatus;
    @Summary
    private final List<CodeableConcept> comorbidity;
    @Summary
    private final CodeableConcept intendedEffect;
    @Summary
    private final Quantity duration;
    @Summary
    private final List<OtherTherapy> otherTherapy;
    @Summary
    @ReferenceTarget(value={"MedicinalProductUndesirableEffect"})
    private final List<Reference> undesirableEffect;
    @Summary
    private final List<Population> population;
    private volatile int hashCode;

    private MedicinalProductIndication(Builder builder) {
        super(builder);
        this.subject = Collections.unmodifiableList(ValidationSupport.checkList(builder.subject, "subject", Reference.class));
        this.diseaseSymptomProcedure = builder.diseaseSymptomProcedure;
        this.diseaseStatus = builder.diseaseStatus;
        this.comorbidity = Collections.unmodifiableList(ValidationSupport.checkList(builder.comorbidity, "comorbidity", CodeableConcept.class));
        this.intendedEffect = builder.intendedEffect;
        this.duration = builder.duration;
        this.otherTherapy = Collections.unmodifiableList(ValidationSupport.checkList(builder.otherTherapy, "otherTherapy", OtherTherapy.class));
        this.undesirableEffect = Collections.unmodifiableList(ValidationSupport.checkList(builder.undesirableEffect, "undesirableEffect", Reference.class));
        this.population = Collections.unmodifiableList(ValidationSupport.checkList(builder.population, "population", Population.class));
        ValidationSupport.checkReferenceType(this.subject, "subject", "MedicinalProduct", "Medication");
        ValidationSupport.checkReferenceType(this.undesirableEffect, "undesirableEffect", "MedicinalProductUndesirableEffect");
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public CodeableConcept getDiseaseSymptomProcedure() {
        return this.diseaseSymptomProcedure;
    }

    public CodeableConcept getDiseaseStatus() {
        return this.diseaseStatus;
    }

    public List<CodeableConcept> getComorbidity() {
        return this.comorbidity;
    }

    public CodeableConcept getIntendedEffect() {
        return this.intendedEffect;
    }

    public Quantity getDuration() {
        return this.duration;
    }

    public List<OtherTherapy> getOtherTherapy() {
        return this.otherTherapy;
    }

    public List<Reference> getUndesirableEffect() {
        return this.undesirableEffect;
    }

    public List<Population> getPopulation() {
        return this.population;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.subject.isEmpty() || this.diseaseSymptomProcedure != null || this.diseaseStatus != null || !this.comorbidity.isEmpty() || this.intendedEffect != null || this.duration != null || !this.otherTherapy.isEmpty() || !this.undesirableEffect.isEmpty() || !this.population.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.diseaseSymptomProcedure, "diseaseSymptomProcedure", visitor);
                this.accept(this.diseaseStatus, "diseaseStatus", visitor);
                this.accept(this.comorbidity, "comorbidity", visitor, CodeableConcept.class);
                this.accept(this.intendedEffect, "intendedEffect", visitor);
                this.accept(this.duration, "duration", visitor);
                this.accept(this.otherTherapy, "otherTherapy", visitor, OtherTherapy.class);
                this.accept(this.undesirableEffect, "undesirableEffect", visitor, Reference.class);
                this.accept(this.population, "population", visitor, Population.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductIndication other = (MedicinalProductIndication)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.subject, other.subject) && Objects.equals(this.diseaseSymptomProcedure, other.diseaseSymptomProcedure) && Objects.equals(this.diseaseStatus, other.diseaseStatus) && Objects.equals(this.comorbidity, other.comorbidity) && Objects.equals(this.intendedEffect, other.intendedEffect) && Objects.equals(this.duration, other.duration) && Objects.equals(this.otherTherapy, other.otherTherapy) && Objects.equals(this.undesirableEffect, other.undesirableEffect) && Objects.equals(this.population, other.population);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.subject, this.diseaseSymptomProcedure, this.diseaseStatus, this.comorbidity, this.intendedEffect, this.duration, this.otherTherapy, this.undesirableEffect, this.population);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class OtherTherapy
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableConcept therapyRelationshipType;
        @Summary
        @ReferenceTarget(value={"MedicinalProduct", "Medication", "Substance", "SubstanceSpecification"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Required
        private final Element medication;
        private volatile int hashCode;

        private OtherTherapy(Builder builder) {
            super(builder);
            this.therapyRelationshipType = ValidationSupport.requireNonNull(builder.therapyRelationshipType, "therapyRelationshipType");
            this.medication = ValidationSupport.requireChoiceElement(builder.medication, "medication", CodeableConcept.class, Reference.class);
            ValidationSupport.checkReferenceType(this.medication, "medication", "MedicinalProduct", "Medication", "Substance", "SubstanceSpecification");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getTherapyRelationshipType() {
            return this.therapyRelationshipType;
        }

        public Element getMedication() {
            return this.medication;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.therapyRelationshipType != null || this.medication != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.therapyRelationshipType, "therapyRelationshipType", visitor);
                    this.accept(this.medication, "medication", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OtherTherapy other = (OtherTherapy)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.therapyRelationshipType, other.therapyRelationshipType) && Objects.equals(this.medication, other.medication);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.therapyRelationshipType, this.medication);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept therapyRelationshipType;
            private Element medication;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder therapyRelationshipType(CodeableConcept therapyRelationshipType) {
                this.therapyRelationshipType = therapyRelationshipType;
                return this;
            }

            public Builder medication(Element medication) {
                this.medication = medication;
                return this;
            }

            @Override
            public OtherTherapy build() {
                return new OtherTherapy(this);
            }

            protected Builder from(OtherTherapy otherTherapy) {
                super.from(otherTherapy);
                this.therapyRelationshipType = otherTherapy.therapyRelationshipType;
                this.medication = otherTherapy.medication;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Reference> subject = new ArrayList<Reference>();
        private CodeableConcept diseaseSymptomProcedure;
        private CodeableConcept diseaseStatus;
        private List<CodeableConcept> comorbidity = new ArrayList<CodeableConcept>();
        private CodeableConcept intendedEffect;
        private Quantity duration;
        private List<OtherTherapy> otherTherapy = new ArrayList<OtherTherapy>();
        private List<Reference> undesirableEffect = new ArrayList<Reference>();
        private List<Population> population = new ArrayList<Population>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder diseaseSymptomProcedure(CodeableConcept diseaseSymptomProcedure) {
            this.diseaseSymptomProcedure = diseaseSymptomProcedure;
            return this;
        }

        public Builder diseaseStatus(CodeableConcept diseaseStatus) {
            this.diseaseStatus = diseaseStatus;
            return this;
        }

        public Builder comorbidity(CodeableConcept ... comorbidity) {
            for (CodeableConcept value : comorbidity) {
                this.comorbidity.add(value);
            }
            return this;
        }

        public Builder comorbidity(Collection<CodeableConcept> comorbidity) {
            this.comorbidity = new ArrayList<CodeableConcept>(comorbidity);
            return this;
        }

        public Builder intendedEffect(CodeableConcept intendedEffect) {
            this.intendedEffect = intendedEffect;
            return this;
        }

        public Builder duration(Quantity duration) {
            this.duration = duration;
            return this;
        }

        public Builder otherTherapy(OtherTherapy ... otherTherapy) {
            for (OtherTherapy value : otherTherapy) {
                this.otherTherapy.add(value);
            }
            return this;
        }

        public Builder otherTherapy(Collection<OtherTherapy> otherTherapy) {
            this.otherTherapy = new ArrayList<OtherTherapy>(otherTherapy);
            return this;
        }

        public Builder undesirableEffect(Reference ... undesirableEffect) {
            for (Reference value : undesirableEffect) {
                this.undesirableEffect.add(value);
            }
            return this;
        }

        public Builder undesirableEffect(Collection<Reference> undesirableEffect) {
            this.undesirableEffect = new ArrayList<Reference>(undesirableEffect);
            return this;
        }

        public Builder population(Population ... population) {
            for (Population value : population) {
                this.population.add(value);
            }
            return this;
        }

        public Builder population(Collection<Population> population) {
            this.population = new ArrayList<Population>(population);
            return this;
        }

        @Override
        public MedicinalProductIndication build() {
            return new MedicinalProductIndication(this);
        }

        protected Builder from(MedicinalProductIndication medicinalProductIndication) {
            super.from(medicinalProductIndication);
            this.subject.addAll(medicinalProductIndication.subject);
            this.diseaseSymptomProcedure = medicinalProductIndication.diseaseSymptomProcedure;
            this.diseaseStatus = medicinalProductIndication.diseaseStatus;
            this.comorbidity.addAll(medicinalProductIndication.comorbidity);
            this.intendedEffect = medicinalProductIndication.intendedEffect;
            this.duration = medicinalProductIndication.duration;
            this.otherTherapy.addAll(medicinalProductIndication.otherTherapy);
            this.undesirableEffect.addAll(medicinalProductIndication.undesirableEffect);
            this.population.addAll(medicinalProductIndication.population);
            return this;
        }
    }
}

