/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.ProdCharacteristic;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class MedicinalProductManufactured
extends DomainResource {
    @Summary
    @Required
    private final CodeableConcept manufacturedDoseForm;
    @Summary
    private final CodeableConcept unitOfPresentation;
    @Summary
    @Required
    private final Quantity quantity;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> manufacturer;
    @Summary
    @ReferenceTarget(value={"MedicinalProductIngredient"})
    private final List<Reference> ingredient;
    @Summary
    private final ProdCharacteristic physicalCharacteristics;
    @Summary
    private final List<CodeableConcept> otherCharacteristics;
    private volatile int hashCode;

    private MedicinalProductManufactured(Builder builder) {
        super(builder);
        this.manufacturedDoseForm = ValidationSupport.requireNonNull(builder.manufacturedDoseForm, "manufacturedDoseForm");
        this.unitOfPresentation = builder.unitOfPresentation;
        this.quantity = ValidationSupport.requireNonNull(builder.quantity, "quantity");
        this.manufacturer = Collections.unmodifiableList(ValidationSupport.checkList(builder.manufacturer, "manufacturer", Reference.class));
        this.ingredient = Collections.unmodifiableList(ValidationSupport.checkList(builder.ingredient, "ingredient", Reference.class));
        this.physicalCharacteristics = builder.physicalCharacteristics;
        this.otherCharacteristics = Collections.unmodifiableList(ValidationSupport.checkList(builder.otherCharacteristics, "otherCharacteristics", CodeableConcept.class));
        ValidationSupport.checkReferenceType(this.manufacturer, "manufacturer", "Organization");
        ValidationSupport.checkReferenceType(this.ingredient, "ingredient", "MedicinalProductIngredient");
    }

    public CodeableConcept getManufacturedDoseForm() {
        return this.manufacturedDoseForm;
    }

    public CodeableConcept getUnitOfPresentation() {
        return this.unitOfPresentation;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public List<Reference> getManufacturer() {
        return this.manufacturer;
    }

    public List<Reference> getIngredient() {
        return this.ingredient;
    }

    public ProdCharacteristic getPhysicalCharacteristics() {
        return this.physicalCharacteristics;
    }

    public List<CodeableConcept> getOtherCharacteristics() {
        return this.otherCharacteristics;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.manufacturedDoseForm != null || this.unitOfPresentation != null || this.quantity != null || !this.manufacturer.isEmpty() || !this.ingredient.isEmpty() || this.physicalCharacteristics != null || !this.otherCharacteristics.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.manufacturedDoseForm, "manufacturedDoseForm", visitor);
                this.accept(this.unitOfPresentation, "unitOfPresentation", visitor);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                this.accept(this.ingredient, "ingredient", visitor, Reference.class);
                this.accept(this.physicalCharacteristics, "physicalCharacteristics", visitor);
                this.accept(this.otherCharacteristics, "otherCharacteristics", visitor, CodeableConcept.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductManufactured other = (MedicinalProductManufactured)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.manufacturedDoseForm, other.manufacturedDoseForm) && Objects.equals(this.unitOfPresentation, other.unitOfPresentation) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.physicalCharacteristics, other.physicalCharacteristics) && Objects.equals(this.otherCharacteristics, other.otherCharacteristics);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.manufacturedDoseForm, this.unitOfPresentation, this.quantity, this.manufacturer, this.ingredient, this.physicalCharacteristics, this.otherCharacteristics);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private CodeableConcept manufacturedDoseForm;
        private CodeableConcept unitOfPresentation;
        private Quantity quantity;
        private List<Reference> manufacturer = new ArrayList<Reference>();
        private List<Reference> ingredient = new ArrayList<Reference>();
        private ProdCharacteristic physicalCharacteristics;
        private List<CodeableConcept> otherCharacteristics = new ArrayList<CodeableConcept>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder manufacturedDoseForm(CodeableConcept manufacturedDoseForm) {
            this.manufacturedDoseForm = manufacturedDoseForm;
            return this;
        }

        public Builder unitOfPresentation(CodeableConcept unitOfPresentation) {
            this.unitOfPresentation = unitOfPresentation;
            return this;
        }

        public Builder quantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder manufacturer(Reference ... manufacturer) {
            for (Reference value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Reference> manufacturer) {
            this.manufacturer = new ArrayList<Reference>(manufacturer);
            return this;
        }

        public Builder ingredient(Reference ... ingredient) {
            for (Reference value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<Reference> ingredient) {
            this.ingredient = new ArrayList<Reference>(ingredient);
            return this;
        }

        public Builder physicalCharacteristics(ProdCharacteristic physicalCharacteristics) {
            this.physicalCharacteristics = physicalCharacteristics;
            return this;
        }

        public Builder otherCharacteristics(CodeableConcept ... otherCharacteristics) {
            for (CodeableConcept value : otherCharacteristics) {
                this.otherCharacteristics.add(value);
            }
            return this;
        }

        public Builder otherCharacteristics(Collection<CodeableConcept> otherCharacteristics) {
            this.otherCharacteristics = new ArrayList<CodeableConcept>(otherCharacteristics);
            return this;
        }

        @Override
        public MedicinalProductManufactured build() {
            return new MedicinalProductManufactured(this);
        }

        protected Builder from(MedicinalProductManufactured medicinalProductManufactured) {
            super.from(medicinalProductManufactured);
            this.manufacturedDoseForm = medicinalProductManufactured.manufacturedDoseForm;
            this.unitOfPresentation = medicinalProductManufactured.unitOfPresentation;
            this.quantity = medicinalProductManufactured.quantity;
            this.manufacturer.addAll(medicinalProductManufactured.manufacturer);
            this.ingredient.addAll(medicinalProductManufactured.ingredient);
            this.physicalCharacteristics = medicinalProductManufactured.physicalCharacteristics;
            this.otherCharacteristics.addAll(medicinalProductManufactured.otherCharacteristics);
            return this;
        }
    }
}

