/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Population;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class MedicinalProductUndesirableEffect
extends DomainResource {
    @Summary
    @ReferenceTarget(value={"MedicinalProduct", "Medication"})
    private final List<Reference> subject;
    @Summary
    private final CodeableConcept symptomConditionEffect;
    @Summary
    private final CodeableConcept classification;
    @Summary
    private final CodeableConcept frequencyOfOccurrence;
    @Summary
    private final List<Population> population;
    private volatile int hashCode;

    private MedicinalProductUndesirableEffect(Builder builder) {
        super(builder);
        this.subject = Collections.unmodifiableList(ValidationSupport.checkList(builder.subject, "subject", Reference.class));
        this.symptomConditionEffect = builder.symptomConditionEffect;
        this.classification = builder.classification;
        this.frequencyOfOccurrence = builder.frequencyOfOccurrence;
        this.population = Collections.unmodifiableList(ValidationSupport.checkList(builder.population, "population", Population.class));
        ValidationSupport.checkReferenceType(this.subject, "subject", "MedicinalProduct", "Medication");
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public CodeableConcept getSymptomConditionEffect() {
        return this.symptomConditionEffect;
    }

    public CodeableConcept getClassification() {
        return this.classification;
    }

    public CodeableConcept getFrequencyOfOccurrence() {
        return this.frequencyOfOccurrence;
    }

    public List<Population> getPopulation() {
        return this.population;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.subject.isEmpty() || this.symptomConditionEffect != null || this.classification != null || this.frequencyOfOccurrence != null || !this.population.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.symptomConditionEffect, "symptomConditionEffect", visitor);
                this.accept(this.classification, "classification", visitor);
                this.accept(this.frequencyOfOccurrence, "frequencyOfOccurrence", visitor);
                this.accept(this.population, "population", visitor, Population.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductUndesirableEffect other = (MedicinalProductUndesirableEffect)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.subject, other.subject) && Objects.equals(this.symptomConditionEffect, other.symptomConditionEffect) && Objects.equals(this.classification, other.classification) && Objects.equals(this.frequencyOfOccurrence, other.frequencyOfOccurrence) && Objects.equals(this.population, other.population);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.subject, this.symptomConditionEffect, this.classification, this.frequencyOfOccurrence, this.population);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Reference> subject = new ArrayList<Reference>();
        private CodeableConcept symptomConditionEffect;
        private CodeableConcept classification;
        private CodeableConcept frequencyOfOccurrence;
        private List<Population> population = new ArrayList<Population>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder symptomConditionEffect(CodeableConcept symptomConditionEffect) {
            this.symptomConditionEffect = symptomConditionEffect;
            return this;
        }

        public Builder classification(CodeableConcept classification) {
            this.classification = classification;
            return this;
        }

        public Builder frequencyOfOccurrence(CodeableConcept frequencyOfOccurrence) {
            this.frequencyOfOccurrence = frequencyOfOccurrence;
            return this;
        }

        public Builder population(Population ... population) {
            for (Population value : population) {
                this.population.add(value);
            }
            return this;
        }

        public Builder population(Collection<Population> population) {
            this.population = new ArrayList<Population>(population);
            return this;
        }

        @Override
        public MedicinalProductUndesirableEffect build() {
            return new MedicinalProductUndesirableEffect(this);
        }

        protected Builder from(MedicinalProductUndesirableEffect medicinalProductUndesirableEffect) {
            super.from(medicinalProductUndesirableEffect);
            this.subject.addAll(medicinalProductUndesirableEffect.subject);
            this.symptomConditionEffect = medicinalProductUndesirableEffect.symptomConditionEffect;
            this.classification = medicinalProductUndesirableEffect.classification;
            this.frequencyOfOccurrence = medicinalProductUndesirableEffect.frequencyOfOccurrence;
            this.population.addAll(medicinalProductUndesirableEffect.population);
            return this;
        }
    }
}

