/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.IssueSeverity;
import com.ibm.fhir.model.type.code.IssueType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.ValueSet.NORMATIVE)
public class OperationOutcome
extends DomainResource {
    @Summary
    @Required
    private final List<Issue> issue;
    private volatile int hashCode;

    private OperationOutcome(Builder builder) {
        super(builder);
        this.issue = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.issue, "issue", Issue.class));
    }

    public List<Issue> getIssue() {
        return this.issue;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.issue.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.issue, "issue", visitor, Issue.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationOutcome other = (OperationOutcome)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.issue, other.issue);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.issue);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Issue
    extends BackboneElement {
        @Summary
        @Binding(bindingName="IssueSeverity", strength=BindingStrength.ValueSet.REQUIRED, description="How the issue affects the success of the action.", valueSet="http://hl7.org/fhir/ValueSet/issue-severity|4.0.1")
        @Required
        private final IssueSeverity severity;
        @Summary
        @Binding(bindingName="IssueType", strength=BindingStrength.ValueSet.REQUIRED, description="A code that describes the type of issue.", valueSet="http://hl7.org/fhir/ValueSet/issue-type|4.0.1")
        @Required
        private final IssueType code;
        @Summary
        @Binding(bindingName="IssueDetails", strength=BindingStrength.ValueSet.EXAMPLE, description="A code that provides details as the exact issue.", valueSet="http://hl7.org/fhir/ValueSet/operation-outcome")
        private final CodeableConcept details;
        @Summary
        private final String diagnostics;
        @Summary
        private final List<String> location;
        @Summary
        private final List<String> expression;
        private volatile int hashCode;

        private Issue(Builder builder) {
            super(builder);
            this.severity = ValidationSupport.requireNonNull(builder.severity, "severity");
            this.code = ValidationSupport.requireNonNull(builder.code, "code");
            this.details = builder.details;
            this.diagnostics = builder.diagnostics;
            this.location = Collections.unmodifiableList(ValidationSupport.checkList(builder.location, "location", String.class));
            this.expression = Collections.unmodifiableList(ValidationSupport.checkList(builder.expression, "expression", String.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public IssueSeverity getSeverity() {
            return this.severity;
        }

        public IssueType getCode() {
            return this.code;
        }

        public CodeableConcept getDetails() {
            return this.details;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public List<String> getLocation() {
            return this.location;
        }

        public List<String> getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.severity != null || this.code != null || this.details != null || this.diagnostics != null || !this.location.isEmpty() || !this.expression.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.severity, "severity", visitor);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.details, "details", visitor);
                    this.accept(this.diagnostics, "diagnostics", visitor);
                    this.accept(this.location, "location", visitor, String.class);
                    this.accept(this.expression, "expression", visitor, String.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Issue other = (Issue)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.severity, other.severity) && Objects.equals(this.code, other.code) && Objects.equals(this.details, other.details) && Objects.equals(this.diagnostics, other.diagnostics) && Objects.equals(this.location, other.location) && Objects.equals(this.expression, other.expression);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.severity, this.code, this.details, this.diagnostics, this.location, this.expression);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private IssueSeverity severity;
            private IssueType code;
            private CodeableConcept details;
            private String diagnostics;
            private List<String> location = new ArrayList<String>();
            private List<String> expression = new ArrayList<String>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder severity(IssueSeverity severity) {
                this.severity = severity;
                return this;
            }

            public Builder code(IssueType code) {
                this.code = code;
                return this;
            }

            public Builder details(CodeableConcept details) {
                this.details = details;
                return this;
            }

            public Builder diagnostics(String diagnostics) {
                this.diagnostics = diagnostics;
                return this;
            }

            public Builder location(String ... location) {
                for (String value : location) {
                    this.location.add(value);
                }
                return this;
            }

            public Builder location(Collection<String> location) {
                this.location = new ArrayList<String>(location);
                return this;
            }

            public Builder expression(String ... expression) {
                for (String value : expression) {
                    this.expression.add(value);
                }
                return this;
            }

            public Builder expression(Collection<String> expression) {
                this.expression = new ArrayList<String>(expression);
                return this;
            }

            @Override
            public Issue build() {
                return new Issue(this);
            }

            protected Builder from(Issue issue) {
                super.from(issue);
                this.severity = issue.severity;
                this.code = issue.code;
                this.details = issue.details;
                this.diagnostics = issue.diagnostics;
                this.location.addAll(issue.location);
                this.expression.addAll(issue.expression);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Issue> issue = new ArrayList<Issue>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder issue(Issue ... issue) {
            for (Issue value : issue) {
                this.issue.add(value);
            }
            return this;
        }

        public Builder issue(Collection<Issue> issue) {
            this.issue = new ArrayList<Issue>(issue);
            return this;
        }

        @Override
        public OperationOutcome build() {
            return new OperationOutcome(this);
        }

        protected Builder from(OperationOutcome operationOutcome) {
            super.from(operationOutcome);
            this.issue.addAll(operationOutcome.issue);
            return this;
        }
    }
}

