/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.AdministrativeGender;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.LinkType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.ValueSet.NORMATIVE)
@Constraints(value={@Constraint(id="pat-1", level="Rule", location="Patient.contact", description="SHALL at least contain a contact's details or a reference to an organization", expression="name.exists() or telecom.exists() or address.exists() or organization.exists()"), @Constraint(id="patient-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/marital-status", expression="maritalStatus.exists() implies (maritalStatus.memberOf('http://hl7.org/fhir/ValueSet/marital-status', 'extensible'))", generated=true), @Constraint(id="patient-3", level="Warning", location="contact.relationship", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/patient-contactrelationship", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/patient-contactrelationship', 'extensible')", generated=true), @Constraint(id="patient-4", level="Warning", location="communication.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", generated=true)})
public class Patient
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    private final List<HumanName> name;
    @Summary
    private final List<ContactPoint> telecom;
    @Summary
    @Binding(bindingName="AdministrativeGender", strength=BindingStrength.ValueSet.REQUIRED, description="The gender of a person used for administrative purposes.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1")
    private final AdministrativeGender gender;
    @Summary
    private final Date birthDate;
    @Summary
    @Choice(value={Boolean.class, DateTime.class})
    private final Element deceased;
    @Summary
    private final List<Address> address;
    @Binding(bindingName="MaritalStatus", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The domestic partnership status of a person.", valueSet="http://hl7.org/fhir/ValueSet/marital-status")
    private final CodeableConcept maritalStatus;
    @Choice(value={Boolean.class, Integer.class})
    private final Element multipleBirth;
    private final List<Attachment> photo;
    private final List<Contact> contact;
    private final List<Communication> communication;
    @ReferenceTarget(value={"Organization", "Practitioner", "PractitionerRole"})
    private final List<Reference> generalPractitioner;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference managingOrganization;
    @Summary
    private final List<Link> link;
    private volatile int hashCode;

    private Patient(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.active = builder.active;
        this.name = Collections.unmodifiableList(ValidationSupport.checkList(builder.name, "name", HumanName.class));
        this.telecom = Collections.unmodifiableList(ValidationSupport.checkList(builder.telecom, "telecom", ContactPoint.class));
        this.gender = builder.gender;
        this.birthDate = builder.birthDate;
        this.deceased = ValidationSupport.choiceElement(builder.deceased, "deceased", Boolean.class, DateTime.class);
        this.address = Collections.unmodifiableList(ValidationSupport.checkList(builder.address, "address", Address.class));
        this.maritalStatus = builder.maritalStatus;
        this.multipleBirth = ValidationSupport.choiceElement(builder.multipleBirth, "multipleBirth", Boolean.class, Integer.class);
        this.photo = Collections.unmodifiableList(ValidationSupport.checkList(builder.photo, "photo", Attachment.class));
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", Contact.class));
        this.communication = Collections.unmodifiableList(ValidationSupport.checkList(builder.communication, "communication", Communication.class));
        this.generalPractitioner = Collections.unmodifiableList(ValidationSupport.checkList(builder.generalPractitioner, "generalPractitioner", Reference.class));
        this.managingOrganization = builder.managingOrganization;
        this.link = Collections.unmodifiableList(ValidationSupport.checkList(builder.link, "link", Link.class));
        ValidationSupport.checkReferenceType(this.generalPractitioner, "generalPractitioner", "Organization", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.managingOrganization, "managingOrganization", "Organization");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public List<HumanName> getName() {
        return this.name;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public AdministrativeGender getGender() {
        return this.gender;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public Element getDeceased() {
        return this.deceased;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public CodeableConcept getMaritalStatus() {
        return this.maritalStatus;
    }

    public Element getMultipleBirth() {
        return this.multipleBirth;
    }

    public List<Attachment> getPhoto() {
        return this.photo;
    }

    public List<Contact> getContact() {
        return this.contact;
    }

    public List<Communication> getCommunication() {
        return this.communication;
    }

    public List<Reference> getGeneralPractitioner() {
        return this.generalPractitioner;
    }

    public Reference getManagingOrganization() {
        return this.managingOrganization;
    }

    public List<Link> getLink() {
        return this.link;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || !this.name.isEmpty() || !this.telecom.isEmpty() || this.gender != null || this.birthDate != null || this.deceased != null || !this.address.isEmpty() || this.maritalStatus != null || this.multipleBirth != null || !this.photo.isEmpty() || !this.contact.isEmpty() || !this.communication.isEmpty() || !this.generalPractitioner.isEmpty() || this.managingOrganization != null || !this.link.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.name, "name", visitor, HumanName.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.gender, "gender", visitor);
                this.accept(this.birthDate, "birthDate", visitor);
                this.accept(this.deceased, "deceased", visitor);
                this.accept(this.address, "address", visitor, Address.class);
                this.accept(this.maritalStatus, "maritalStatus", visitor);
                this.accept(this.multipleBirth, "multipleBirth", visitor);
                this.accept(this.photo, "photo", visitor, Attachment.class);
                this.accept(this.contact, "contact", visitor, Contact.class);
                this.accept(this.communication, "communication", visitor, Communication.class);
                this.accept(this.generalPractitioner, "generalPractitioner", visitor, Reference.class);
                this.accept(this.managingOrganization, "managingOrganization", visitor);
                this.accept(this.link, "link", visitor, Link.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Patient other = (Patient)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.gender, other.gender) && Objects.equals(this.birthDate, other.birthDate) && Objects.equals(this.deceased, other.deceased) && Objects.equals(this.address, other.address) && Objects.equals(this.maritalStatus, other.maritalStatus) && Objects.equals(this.multipleBirth, other.multipleBirth) && Objects.equals(this.photo, other.photo) && Objects.equals(this.contact, other.contact) && Objects.equals(this.communication, other.communication) && Objects.equals(this.generalPractitioner, other.generalPractitioner) && Objects.equals(this.managingOrganization, other.managingOrganization) && Objects.equals(this.link, other.link);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.name, this.telecom, this.gender, this.birthDate, this.deceased, this.address, this.maritalStatus, this.multipleBirth, this.photo, this.contact, this.communication, this.generalPractitioner, this.managingOrganization, this.link);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Link
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Patient", "RelatedPerson"})
        @Required
        private final Reference other;
        @Summary
        @Binding(bindingName="LinkType", strength=BindingStrength.ValueSet.REQUIRED, description="The type of link between this patient resource and another patient resource.", valueSet="http://hl7.org/fhir/ValueSet/link-type|4.0.1")
        @Required
        private final LinkType type;
        private volatile int hashCode;

        private Link(Builder builder) {
            super(builder);
            this.other = ValidationSupport.requireNonNull(builder.other, "other");
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            ValidationSupport.checkReferenceType(this.other, "other", "Patient", "RelatedPerson");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Reference getOther() {
            return this.other;
        }

        public LinkType getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.other != null || this.type != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.other, "other", visitor);
                    this.accept(this.type, "type", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.other, other.other) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.other, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference other;
            private LinkType type;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder other(Reference other) {
                this.other = other;
                return this;
            }

            public Builder type(LinkType type) {
                this.type = type;
                return this;
            }

            @Override
            public Link build() {
                return new Link(this);
            }

            protected Builder from(Link link) {
                super.from(link);
                this.other = link.other;
                this.type = link.type;
                return this;
            }
        }
    }

    public static class Communication
    extends BackboneElement {
        @Binding(bindingName="Language", strength=BindingStrength.ValueSet.PREFERRED, description="A human language.", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
        @Required
        private final CodeableConcept language;
        private final Boolean preferred;
        private volatile int hashCode;

        private Communication(Builder builder) {
            super(builder);
            this.language = ValidationSupport.requireNonNull(builder.language, "language");
            this.preferred = builder.preferred;
            ValidationSupport.checkValueSetBinding(this.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getLanguage() {
            return this.language;
        }

        public Boolean getPreferred() {
            return this.preferred;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.language != null || this.preferred != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.language, "language", visitor);
                    this.accept(this.preferred, "preferred", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Communication other = (Communication)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.language, other.language) && Objects.equals(this.preferred, other.preferred);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.language, this.preferred);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept language;
            private Boolean preferred;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder language(CodeableConcept language) {
                this.language = language;
                return this;
            }

            public Builder preferred(Boolean preferred) {
                this.preferred = preferred;
                return this;
            }

            @Override
            public Communication build() {
                return new Communication(this);
            }

            protected Builder from(Communication communication) {
                super.from(communication);
                this.language = communication.language;
                this.preferred = communication.preferred;
                return this;
            }
        }
    }

    public static class Contact
    extends BackboneElement {
        @Binding(bindingName="ContactRelationship", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The nature of the relationship between a patient and a contact person for that patient.", valueSet="http://hl7.org/fhir/ValueSet/patient-contactrelationship")
        private final List<CodeableConcept> relationship;
        private final HumanName name;
        private final List<ContactPoint> telecom;
        private final Address address;
        @Binding(bindingName="AdministrativeGender", strength=BindingStrength.ValueSet.REQUIRED, description="The gender of a person used for administrative purposes.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1")
        private final AdministrativeGender gender;
        @ReferenceTarget(value={"Organization"})
        private final Reference organization;
        private final Period period;
        private volatile int hashCode;

        private Contact(Builder builder) {
            super(builder);
            this.relationship = Collections.unmodifiableList(ValidationSupport.checkList(builder.relationship, "relationship", CodeableConcept.class));
            this.name = builder.name;
            this.telecom = Collections.unmodifiableList(ValidationSupport.checkList(builder.telecom, "telecom", ContactPoint.class));
            this.address = builder.address;
            this.gender = builder.gender;
            this.organization = builder.organization;
            this.period = builder.period;
            ValidationSupport.checkReferenceType(this.organization, "organization", "Organization");
            ValidationSupport.requireValueOrChildren(this);
        }

        public List<CodeableConcept> getRelationship() {
            return this.relationship;
        }

        public HumanName getName() {
            return this.name;
        }

        public List<ContactPoint> getTelecom() {
            return this.telecom;
        }

        public Address getAddress() {
            return this.address;
        }

        public AdministrativeGender getGender() {
            return this.gender;
        }

        public Reference getOrganization() {
            return this.organization;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.relationship.isEmpty() || this.name != null || !this.telecom.isEmpty() || this.address != null || this.gender != null || this.organization != null || this.period != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.relationship, "relationship", visitor, CodeableConcept.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                    this.accept(this.address, "address", visitor);
                    this.accept(this.gender, "gender", visitor);
                    this.accept(this.organization, "organization", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Contact other = (Contact)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.address, other.address) && Objects.equals(this.gender, other.gender) && Objects.equals(this.organization, other.organization) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.relationship, this.name, this.telecom, this.address, this.gender, this.organization, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> relationship = new ArrayList<CodeableConcept>();
            private HumanName name;
            private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
            private Address address;
            private AdministrativeGender gender;
            private Reference organization;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder relationship(CodeableConcept ... relationship) {
                for (CodeableConcept value : relationship) {
                    this.relationship.add(value);
                }
                return this;
            }

            public Builder relationship(Collection<CodeableConcept> relationship) {
                this.relationship = new ArrayList<CodeableConcept>(relationship);
                return this;
            }

            public Builder name(HumanName name) {
                this.name = name;
                return this;
            }

            public Builder telecom(ContactPoint ... telecom) {
                for (ContactPoint value : telecom) {
                    this.telecom.add(value);
                }
                return this;
            }

            public Builder telecom(Collection<ContactPoint> telecom) {
                this.telecom = new ArrayList<ContactPoint>(telecom);
                return this;
            }

            public Builder address(Address address) {
                this.address = address;
                return this;
            }

            public Builder gender(AdministrativeGender gender) {
                this.gender = gender;
                return this;
            }

            public Builder organization(Reference organization) {
                this.organization = organization;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public Contact build() {
                return new Contact(this);
            }

            protected Builder from(Contact contact) {
                super.from(contact);
                this.relationship.addAll(contact.relationship);
                this.name = contact.name;
                this.telecom.addAll(contact.telecom);
                this.address = contact.address;
                this.gender = contact.gender;
                this.organization = contact.organization;
                this.period = contact.period;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private List<HumanName> name = new ArrayList<HumanName>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private AdministrativeGender gender;
        private Date birthDate;
        private Element deceased;
        private List<Address> address = new ArrayList<Address>();
        private CodeableConcept maritalStatus;
        private Element multipleBirth;
        private List<Attachment> photo = new ArrayList<Attachment>();
        private List<Contact> contact = new ArrayList<Contact>();
        private List<Communication> communication = new ArrayList<Communication>();
        private List<Reference> generalPractitioner = new ArrayList<Reference>();
        private Reference managingOrganization;
        private List<Link> link = new ArrayList<Link>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder name(HumanName ... name) {
            for (HumanName value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<HumanName> name) {
            this.name = new ArrayList<HumanName>(name);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder gender(AdministrativeGender gender) {
            this.gender = gender;
            return this;
        }

        public Builder birthDate(Date birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Builder deceased(Element deceased) {
            this.deceased = deceased;
            return this;
        }

        public Builder address(Address ... address) {
            for (Address value : address) {
                this.address.add(value);
            }
            return this;
        }

        public Builder address(Collection<Address> address) {
            this.address = new ArrayList<Address>(address);
            return this;
        }

        public Builder maritalStatus(CodeableConcept maritalStatus) {
            this.maritalStatus = maritalStatus;
            return this;
        }

        public Builder multipleBirth(Element multipleBirth) {
            this.multipleBirth = multipleBirth;
            return this;
        }

        public Builder photo(Attachment ... photo) {
            for (Attachment value : photo) {
                this.photo.add(value);
            }
            return this;
        }

        public Builder photo(Collection<Attachment> photo) {
            this.photo = new ArrayList<Attachment>(photo);
            return this;
        }

        public Builder contact(Contact ... contact) {
            for (Contact value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<Contact> contact) {
            this.contact = new ArrayList<Contact>(contact);
            return this;
        }

        public Builder communication(Communication ... communication) {
            for (Communication value : communication) {
                this.communication.add(value);
            }
            return this;
        }

        public Builder communication(Collection<Communication> communication) {
            this.communication = new ArrayList<Communication>(communication);
            return this;
        }

        public Builder generalPractitioner(Reference ... generalPractitioner) {
            for (Reference value : generalPractitioner) {
                this.generalPractitioner.add(value);
            }
            return this;
        }

        public Builder generalPractitioner(Collection<Reference> generalPractitioner) {
            this.generalPractitioner = new ArrayList<Reference>(generalPractitioner);
            return this;
        }

        public Builder managingOrganization(Reference managingOrganization) {
            this.managingOrganization = managingOrganization;
            return this;
        }

        public Builder link(Link ... link) {
            for (Link value : link) {
                this.link.add(value);
            }
            return this;
        }

        public Builder link(Collection<Link> link) {
            this.link = new ArrayList<Link>(link);
            return this;
        }

        @Override
        public Patient build() {
            return new Patient(this);
        }

        protected Builder from(Patient patient) {
            super.from(patient);
            this.identifier.addAll(patient.identifier);
            this.active = patient.active;
            this.name.addAll(patient.name);
            this.telecom.addAll(patient.telecom);
            this.gender = patient.gender;
            this.birthDate = patient.birthDate;
            this.deceased = patient.deceased;
            this.address.addAll(patient.address);
            this.maritalStatus = patient.maritalStatus;
            this.multipleBirth = patient.multipleBirth;
            this.photo.addAll(patient.photo);
            this.contact.addAll(patient.contact);
            this.communication.addAll(patient.communication);
            this.generalPractitioner.addAll(patient.generalPractitioner);
            this.managingOrganization = patient.managingOrganization;
            this.link.addAll(patient.link);
            return this;
        }
    }
}

