/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ProcedureStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="procedure-0", level="Warning", location="focalDevice.action", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/device-action", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/device-action', 'preferred')", generated=true)
public class Procedure
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    @Summary
    @ReferenceTarget(value={"CarePlan", "ServiceRequest"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"Procedure", "Observation", "MedicationAdministration"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="ProcedureStatus", strength=BindingStrength.ValueSet.REQUIRED, description="A code specifying the state of the procedure.", valueSet="http://hl7.org/fhir/ValueSet/event-status|4.0.1")
    @Required
    private final ProcedureStatus status;
    @Summary
    @Binding(bindingName="ProcedureNegationReason", strength=BindingStrength.ValueSet.EXAMPLE, description="A code that identifies the reason a procedure was not performed.", valueSet="http://hl7.org/fhir/ValueSet/procedure-not-performed-reason")
    private final CodeableConcept statusReason;
    @Summary
    @Binding(bindingName="ProcedureCategory", strength=BindingStrength.ValueSet.EXAMPLE, description="A code that classifies a procedure for searching, sorting and display purposes.", valueSet="http://hl7.org/fhir/ValueSet/procedure-category")
    private final CodeableConcept category;
    @Summary
    @Binding(bindingName="ProcedureCode", strength=BindingStrength.ValueSet.EXAMPLE, description="A code to identify a specific procedure .", valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class, String.class, Age.class, Range.class})
    private final Element performed;
    @Summary
    @ReferenceTarget(value={"Patient", "RelatedPerson", "Practitioner", "PractitionerRole"})
    private final Reference recorder;
    @Summary
    @ReferenceTarget(value={"Patient", "RelatedPerson", "Practitioner", "PractitionerRole"})
    private final Reference asserter;
    @Summary
    private final List<Performer> performer;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    @Summary
    @Binding(bindingName="ProcedureReason", strength=BindingStrength.ValueSet.EXAMPLE, description="A code that identifies the reason a procedure is  required.", valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "Procedure", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    @Summary
    @Binding(bindingName="BodySite", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final List<CodeableConcept> bodySite;
    @Summary
    @Binding(bindingName="ProcedureOutcome", strength=BindingStrength.ValueSet.EXAMPLE, description="An outcome of a procedure - whether it was resolved or otherwise.", valueSet="http://hl7.org/fhir/ValueSet/procedure-outcome")
    private final CodeableConcept outcome;
    @ReferenceTarget(value={"DiagnosticReport", "DocumentReference", "Composition"})
    private final List<Reference> report;
    @Binding(bindingName="ProcedureComplication", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes describing complications that resulted from a procedure.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    private final List<CodeableConcept> complication;
    @ReferenceTarget(value={"Condition"})
    private final List<Reference> complicationDetail;
    @Binding(bindingName="ProcedureFollowUp", strength=BindingStrength.ValueSet.EXAMPLE, description="Specific follow up required for a procedure e.g. removal of sutures.", valueSet="http://hl7.org/fhir/ValueSet/procedure-followup")
    private final List<CodeableConcept> followUp;
    private final List<Annotation> note;
    private final List<FocalDevice> focalDevice;
    @ReferenceTarget(value={"Device", "Medication", "Substance"})
    private final List<Reference> usedReference;
    @Binding(bindingName="ProcedureUsed", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes describing items used during a procedure.", valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    private final List<CodeableConcept> usedCode;
    private volatile int hashCode;

    private Procedure(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.instantiatesCanonical = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesCanonical, "instantiatesCanonical", Canonical.class));
        this.instantiatesUri = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesUri, "instantiatesUri", Uri.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.partOf = Collections.unmodifiableList(ValidationSupport.checkList(builder.partOf, "partOf", Reference.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.statusReason = builder.statusReason;
        this.category = builder.category;
        this.code = builder.code;
        this.subject = ValidationSupport.requireNonNull(builder.subject, "subject");
        this.encounter = builder.encounter;
        this.performed = ValidationSupport.choiceElement(builder.performed, "performed", DateTime.class, Period.class, String.class, Age.class, Range.class);
        this.recorder = builder.recorder;
        this.asserter = builder.asserter;
        this.performer = Collections.unmodifiableList(ValidationSupport.checkList(builder.performer, "performer", Performer.class));
        this.location = builder.location;
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
        this.bodySite = Collections.unmodifiableList(ValidationSupport.checkList(builder.bodySite, "bodySite", CodeableConcept.class));
        this.outcome = builder.outcome;
        this.report = Collections.unmodifiableList(ValidationSupport.checkList(builder.report, "report", Reference.class));
        this.complication = Collections.unmodifiableList(ValidationSupport.checkList(builder.complication, "complication", CodeableConcept.class));
        this.complicationDetail = Collections.unmodifiableList(ValidationSupport.checkList(builder.complicationDetail, "complicationDetail", Reference.class));
        this.followUp = Collections.unmodifiableList(ValidationSupport.checkList(builder.followUp, "followUp", CodeableConcept.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.focalDevice = Collections.unmodifiableList(ValidationSupport.checkList(builder.focalDevice, "focalDevice", FocalDevice.class));
        this.usedReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.usedReference, "usedReference", Reference.class));
        this.usedCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.usedCode, "usedCode", CodeableConcept.class));
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "CarePlan", "ServiceRequest");
        ValidationSupport.checkReferenceType(this.partOf, "partOf", "Procedure", "Observation", "MedicationAdministration");
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Group");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.recorder, "recorder", "Patient", "RelatedPerson", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.asserter, "asserter", "Patient", "RelatedPerson", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.location, "location", "Location");
        ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Observation", "Procedure", "DiagnosticReport", "DocumentReference");
        ValidationSupport.checkReferenceType(this.report, "report", "DiagnosticReport", "DocumentReference", "Composition");
        ValidationSupport.checkReferenceType(this.complicationDetail, "complicationDetail", "Condition");
        ValidationSupport.checkReferenceType(this.usedReference, "usedReference", "Device", "Medication", "Substance");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public ProcedureStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getPerformed() {
        return this.performed;
    }

    public Reference getRecorder() {
        return this.recorder;
    }

    public Reference getAsserter() {
        return this.asserter;
    }

    public List<Performer> getPerformer() {
        return this.performer;
    }

    public Reference getLocation() {
        return this.location;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<CodeableConcept> getBodySite() {
        return this.bodySite;
    }

    public CodeableConcept getOutcome() {
        return this.outcome;
    }

    public List<Reference> getReport() {
        return this.report;
    }

    public List<CodeableConcept> getComplication() {
        return this.complication;
    }

    public List<Reference> getComplicationDetail() {
        return this.complicationDetail;
    }

    public List<CodeableConcept> getFollowUp() {
        return this.followUp;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<FocalDevice> getFocalDevice() {
        return this.focalDevice;
    }

    public List<Reference> getUsedReference() {
        return this.usedReference;
    }

    public List<CodeableConcept> getUsedCode() {
        return this.usedCode;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || !this.basedOn.isEmpty() || !this.partOf.isEmpty() || this.status != null || this.statusReason != null || this.category != null || this.code != null || this.subject != null || this.encounter != null || this.performed != null || this.recorder != null || this.asserter != null || !this.performer.isEmpty() || this.location != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.bodySite.isEmpty() || this.outcome != null || !this.report.isEmpty() || !this.complication.isEmpty() || !this.complicationDetail.isEmpty() || !this.followUp.isEmpty() || !this.note.isEmpty() || !this.focalDevice.isEmpty() || !this.usedReference.isEmpty() || !this.usedCode.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.category, "category", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.performed, "performed", visitor);
                this.accept(this.recorder, "recorder", visitor);
                this.accept(this.asserter, "asserter", visitor);
                this.accept(this.performer, "performer", visitor, Performer.class);
                this.accept(this.location, "location", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.bodySite, "bodySite", visitor, CodeableConcept.class);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.report, "report", visitor, Reference.class);
                this.accept(this.complication, "complication", visitor, CodeableConcept.class);
                this.accept(this.complicationDetail, "complicationDetail", visitor, Reference.class);
                this.accept(this.followUp, "followUp", visitor, CodeableConcept.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.focalDevice, "focalDevice", visitor, FocalDevice.class);
                this.accept(this.usedReference, "usedReference", visitor, Reference.class);
                this.accept(this.usedCode, "usedCode", visitor, CodeableConcept.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Procedure other = (Procedure)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.performed, other.performed) && Objects.equals(this.recorder, other.recorder) && Objects.equals(this.asserter, other.asserter) && Objects.equals(this.performer, other.performer) && Objects.equals(this.location, other.location) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.report, other.report) && Objects.equals(this.complication, other.complication) && Objects.equals(this.complicationDetail, other.complicationDetail) && Objects.equals(this.followUp, other.followUp) && Objects.equals(this.note, other.note) && Objects.equals(this.focalDevice, other.focalDevice) && Objects.equals(this.usedReference, other.usedReference) && Objects.equals(this.usedCode, other.usedCode);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.partOf, this.status, this.statusReason, this.category, this.code, this.subject, this.encounter, this.performed, this.recorder, this.asserter, this.performer, this.location, this.reasonCode, this.reasonReference, this.bodySite, this.outcome, this.report, this.complication, this.complicationDetail, this.followUp, this.note, this.focalDevice, this.usedReference, this.usedCode);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class FocalDevice
    extends BackboneElement {
        @Binding(bindingName="DeviceActionKind", strength=BindingStrength.ValueSet.PREFERRED, description="A kind of change that happened to the device during the procedure.", valueSet="http://hl7.org/fhir/ValueSet/device-action")
        private final CodeableConcept action;
        @ReferenceTarget(value={"Device"})
        @Required
        private final Reference manipulated;
        private volatile int hashCode;

        private FocalDevice(Builder builder) {
            super(builder);
            this.action = builder.action;
            this.manipulated = ValidationSupport.requireNonNull(builder.manipulated, "manipulated");
            ValidationSupport.checkReferenceType(this.manipulated, "manipulated", "Device");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getAction() {
            return this.action;
        }

        public Reference getManipulated() {
            return this.manipulated;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.action != null || this.manipulated != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.action, "action", visitor);
                    this.accept(this.manipulated, "manipulated", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FocalDevice other = (FocalDevice)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.action, other.action) && Objects.equals(this.manipulated, other.manipulated);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.action, this.manipulated);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept action;
            private Reference manipulated;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder action(CodeableConcept action) {
                this.action = action;
                return this;
            }

            public Builder manipulated(Reference manipulated) {
                this.manipulated = manipulated;
                return this;
            }

            @Override
            public FocalDevice build() {
                return new FocalDevice(this);
            }

            protected Builder from(FocalDevice focalDevice) {
                super.from(focalDevice);
                this.action = focalDevice.action;
                this.manipulated = focalDevice.manipulated;
                return this;
            }
        }
    }

    public static class Performer
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ProcedurePerformerRole", strength=BindingStrength.ValueSet.EXAMPLE, description="A code that identifies the role of a performer of the procedure.", valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        private final CodeableConcept function;
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device"})
        @Required
        private final Reference actor;
        @ReferenceTarget(value={"Organization"})
        private final Reference onBehalfOf;
        private volatile int hashCode;

        private Performer(Builder builder) {
            super(builder);
            this.function = builder.function;
            this.actor = ValidationSupport.requireNonNull(builder.actor, "actor");
            this.onBehalfOf = builder.onBehalfOf;
            ValidationSupport.checkReferenceType(this.actor, "actor", "Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device");
            ValidationSupport.checkReferenceType(this.onBehalfOf, "onBehalfOf", "Organization");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getFunction() {
            return this.function;
        }

        public Reference getActor() {
            return this.actor;
        }

        public Reference getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.function != null || this.actor != null || this.onBehalfOf != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.function, "function", visitor);
                    this.accept(this.actor, "actor", visitor);
                    this.accept(this.onBehalfOf, "onBehalfOf", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Performer other = (Performer)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.function, other.function) && Objects.equals(this.actor, other.actor) && Objects.equals(this.onBehalfOf, other.onBehalfOf);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.function, this.actor, this.onBehalfOf);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept function;
            private Reference actor;
            private Reference onBehalfOf;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder function(CodeableConcept function) {
                this.function = function;
                return this;
            }

            public Builder actor(Reference actor) {
                this.actor = actor;
                return this;
            }

            public Builder onBehalfOf(Reference onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            @Override
            public Performer build() {
                return new Performer(this);
            }

            protected Builder from(Performer performer) {
                super.from(performer);
                this.function = performer.function;
                this.actor = performer.actor;
                this.onBehalfOf = performer.onBehalfOf;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private ProcedureStatus status;
        private CodeableConcept statusReason;
        private CodeableConcept category;
        private CodeableConcept code;
        private Reference subject;
        private Reference encounter;
        private Element performed;
        private Reference recorder;
        private Reference asserter;
        private List<Performer> performer = new ArrayList<Performer>();
        private Reference location;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<CodeableConcept> bodySite = new ArrayList<CodeableConcept>();
        private CodeableConcept outcome;
        private List<Reference> report = new ArrayList<Reference>();
        private List<CodeableConcept> complication = new ArrayList<CodeableConcept>();
        private List<Reference> complicationDetail = new ArrayList<Reference>();
        private List<CodeableConcept> followUp = new ArrayList<CodeableConcept>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<FocalDevice> focalDevice = new ArrayList<FocalDevice>();
        private List<Reference> usedReference = new ArrayList<Reference>();
        private List<CodeableConcept> usedCode = new ArrayList<CodeableConcept>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(ProcedureStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder category(CodeableConcept category) {
            this.category = category;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder performed(Element performed) {
            this.performed = performed;
            return this;
        }

        public Builder recorder(Reference recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder asserter(Reference asserter) {
            this.asserter = asserter;
            return this;
        }

        public Builder performer(Performer ... performer) {
            for (Performer value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Performer> performer) {
            this.performer = new ArrayList<Performer>(performer);
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder bodySite(CodeableConcept ... bodySite) {
            for (CodeableConcept value : bodySite) {
                this.bodySite.add(value);
            }
            return this;
        }

        public Builder bodySite(Collection<CodeableConcept> bodySite) {
            this.bodySite = new ArrayList<CodeableConcept>(bodySite);
            return this;
        }

        public Builder outcome(CodeableConcept outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder report(Reference ... report) {
            for (Reference value : report) {
                this.report.add(value);
            }
            return this;
        }

        public Builder report(Collection<Reference> report) {
            this.report = new ArrayList<Reference>(report);
            return this;
        }

        public Builder complication(CodeableConcept ... complication) {
            for (CodeableConcept value : complication) {
                this.complication.add(value);
            }
            return this;
        }

        public Builder complication(Collection<CodeableConcept> complication) {
            this.complication = new ArrayList<CodeableConcept>(complication);
            return this;
        }

        public Builder complicationDetail(Reference ... complicationDetail) {
            for (Reference value : complicationDetail) {
                this.complicationDetail.add(value);
            }
            return this;
        }

        public Builder complicationDetail(Collection<Reference> complicationDetail) {
            this.complicationDetail = new ArrayList<Reference>(complicationDetail);
            return this;
        }

        public Builder followUp(CodeableConcept ... followUp) {
            for (CodeableConcept value : followUp) {
                this.followUp.add(value);
            }
            return this;
        }

        public Builder followUp(Collection<CodeableConcept> followUp) {
            this.followUp = new ArrayList<CodeableConcept>(followUp);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder focalDevice(FocalDevice ... focalDevice) {
            for (FocalDevice value : focalDevice) {
                this.focalDevice.add(value);
            }
            return this;
        }

        public Builder focalDevice(Collection<FocalDevice> focalDevice) {
            this.focalDevice = new ArrayList<FocalDevice>(focalDevice);
            return this;
        }

        public Builder usedReference(Reference ... usedReference) {
            for (Reference value : usedReference) {
                this.usedReference.add(value);
            }
            return this;
        }

        public Builder usedReference(Collection<Reference> usedReference) {
            this.usedReference = new ArrayList<Reference>(usedReference);
            return this;
        }

        public Builder usedCode(CodeableConcept ... usedCode) {
            for (CodeableConcept value : usedCode) {
                this.usedCode.add(value);
            }
            return this;
        }

        public Builder usedCode(Collection<CodeableConcept> usedCode) {
            this.usedCode = new ArrayList<CodeableConcept>(usedCode);
            return this;
        }

        @Override
        public Procedure build() {
            return new Procedure(this);
        }

        protected Builder from(Procedure procedure) {
            super.from(procedure);
            this.identifier.addAll(procedure.identifier);
            this.instantiatesCanonical.addAll(procedure.instantiatesCanonical);
            this.instantiatesUri.addAll(procedure.instantiatesUri);
            this.basedOn.addAll(procedure.basedOn);
            this.partOf.addAll(procedure.partOf);
            this.status = procedure.status;
            this.statusReason = procedure.statusReason;
            this.category = procedure.category;
            this.code = procedure.code;
            this.subject = procedure.subject;
            this.encounter = procedure.encounter;
            this.performed = procedure.performed;
            this.recorder = procedure.recorder;
            this.asserter = procedure.asserter;
            this.performer.addAll(procedure.performer);
            this.location = procedure.location;
            this.reasonCode.addAll(procedure.reasonCode);
            this.reasonReference.addAll(procedure.reasonReference);
            this.bodySite.addAll(procedure.bodySite);
            this.outcome = procedure.outcome;
            this.report.addAll(procedure.report);
            this.complication.addAll(procedure.complication);
            this.complicationDetail.addAll(procedure.complicationDetail);
            this.followUp.addAll(procedure.followUp);
            this.note.addAll(procedure.note);
            this.focalDevice.addAll(procedure.focalDevice);
            this.usedReference.addAll(procedure.usedReference);
            this.usedCode.addAll(procedure.usedCode);
            return this;
        }
    }
}

