/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.AdministrativeGender;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="relatedPerson-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype", expression="relationship.exists() implies (relationship.all(memberOf('http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype', 'preferred')))", generated=true), @Constraint(id="relatedPerson-1", level="Warning", location="communication.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", generated=true)})
public class RelatedPerson
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Summary
    @Binding(bindingName="PatientRelationshipType", strength=BindingStrength.ValueSet.PREFERRED, description="The nature of the relationship between a patient and the related person.", valueSet="http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype")
    private final List<CodeableConcept> relationship;
    @Summary
    private final List<HumanName> name;
    @Summary
    private final List<ContactPoint> telecom;
    @Summary
    @Binding(bindingName="AdministrativeGender", strength=BindingStrength.ValueSet.REQUIRED, description="The gender of a person used for administrative purposes.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1")
    private final AdministrativeGender gender;
    @Summary
    private final Date birthDate;
    @Summary
    private final List<Address> address;
    private final List<Attachment> photo;
    private final Period period;
    private final List<Communication> communication;
    private volatile int hashCode;

    private RelatedPerson(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.active = builder.active;
        this.patient = ValidationSupport.requireNonNull(builder.patient, "patient");
        this.relationship = Collections.unmodifiableList(ValidationSupport.checkList(builder.relationship, "relationship", CodeableConcept.class));
        this.name = Collections.unmodifiableList(ValidationSupport.checkList(builder.name, "name", HumanName.class));
        this.telecom = Collections.unmodifiableList(ValidationSupport.checkList(builder.telecom, "telecom", ContactPoint.class));
        this.gender = builder.gender;
        this.birthDate = builder.birthDate;
        this.address = Collections.unmodifiableList(ValidationSupport.checkList(builder.address, "address", Address.class));
        this.photo = Collections.unmodifiableList(ValidationSupport.checkList(builder.photo, "photo", Attachment.class));
        this.period = builder.period;
        this.communication = Collections.unmodifiableList(ValidationSupport.checkList(builder.communication, "communication", Communication.class));
        ValidationSupport.checkReferenceType(this.patient, "patient", "Patient");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public List<CodeableConcept> getRelationship() {
        return this.relationship;
    }

    public List<HumanName> getName() {
        return this.name;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public AdministrativeGender getGender() {
        return this.gender;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public List<Attachment> getPhoto() {
        return this.photo;
    }

    public Period getPeriod() {
        return this.period;
    }

    public List<Communication> getCommunication() {
        return this.communication;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || this.patient != null || !this.relationship.isEmpty() || !this.name.isEmpty() || !this.telecom.isEmpty() || this.gender != null || this.birthDate != null || !this.address.isEmpty() || !this.photo.isEmpty() || this.period != null || !this.communication.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.relationship, "relationship", visitor, CodeableConcept.class);
                this.accept(this.name, "name", visitor, HumanName.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.gender, "gender", visitor);
                this.accept(this.birthDate, "birthDate", visitor);
                this.accept(this.address, "address", visitor, Address.class);
                this.accept(this.photo, "photo", visitor, Attachment.class);
                this.accept(this.period, "period", visitor);
                this.accept(this.communication, "communication", visitor, Communication.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelatedPerson other = (RelatedPerson)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.patient, other.patient) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.gender, other.gender) && Objects.equals(this.birthDate, other.birthDate) && Objects.equals(this.address, other.address) && Objects.equals(this.photo, other.photo) && Objects.equals(this.period, other.period) && Objects.equals(this.communication, other.communication);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.patient, this.relationship, this.name, this.telecom, this.gender, this.birthDate, this.address, this.photo, this.period, this.communication);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Communication
    extends BackboneElement {
        @Binding(bindingName="Language", strength=BindingStrength.ValueSet.PREFERRED, description="A human language.", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
        @Required
        private final CodeableConcept language;
        private final Boolean preferred;
        private volatile int hashCode;

        private Communication(Builder builder) {
            super(builder);
            this.language = ValidationSupport.requireNonNull(builder.language, "language");
            this.preferred = builder.preferred;
            ValidationSupport.checkValueSetBinding(this.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getLanguage() {
            return this.language;
        }

        public Boolean getPreferred() {
            return this.preferred;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.language != null || this.preferred != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.language, "language", visitor);
                    this.accept(this.preferred, "preferred", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Communication other = (Communication)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.language, other.language) && Objects.equals(this.preferred, other.preferred);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.language, this.preferred);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept language;
            private Boolean preferred;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder language(CodeableConcept language) {
                this.language = language;
                return this;
            }

            public Builder preferred(Boolean preferred) {
                this.preferred = preferred;
                return this;
            }

            @Override
            public Communication build() {
                return new Communication(this);
            }

            protected Builder from(Communication communication) {
                super.from(communication);
                this.language = communication.language;
                this.preferred = communication.preferred;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private Reference patient;
        private List<CodeableConcept> relationship = new ArrayList<CodeableConcept>();
        private List<HumanName> name = new ArrayList<HumanName>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private AdministrativeGender gender;
        private Date birthDate;
        private List<Address> address = new ArrayList<Address>();
        private List<Attachment> photo = new ArrayList<Attachment>();
        private Period period;
        private List<Communication> communication = new ArrayList<Communication>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder relationship(CodeableConcept ... relationship) {
            for (CodeableConcept value : relationship) {
                this.relationship.add(value);
            }
            return this;
        }

        public Builder relationship(Collection<CodeableConcept> relationship) {
            this.relationship = new ArrayList<CodeableConcept>(relationship);
            return this;
        }

        public Builder name(HumanName ... name) {
            for (HumanName value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<HumanName> name) {
            this.name = new ArrayList<HumanName>(name);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder gender(AdministrativeGender gender) {
            this.gender = gender;
            return this;
        }

        public Builder birthDate(Date birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Builder address(Address ... address) {
            for (Address value : address) {
                this.address.add(value);
            }
            return this;
        }

        public Builder address(Collection<Address> address) {
            this.address = new ArrayList<Address>(address);
            return this;
        }

        public Builder photo(Attachment ... photo) {
            for (Attachment value : photo) {
                this.photo.add(value);
            }
            return this;
        }

        public Builder photo(Collection<Attachment> photo) {
            this.photo = new ArrayList<Attachment>(photo);
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder communication(Communication ... communication) {
            for (Communication value : communication) {
                this.communication.add(value);
            }
            return this;
        }

        public Builder communication(Collection<Communication> communication) {
            this.communication = new ArrayList<Communication>(communication);
            return this;
        }

        @Override
        public RelatedPerson build() {
            return new RelatedPerson(this);
        }

        protected Builder from(RelatedPerson relatedPerson) {
            super.from(relatedPerson);
            this.identifier.addAll(relatedPerson.identifier);
            this.active = relatedPerson.active;
            this.patient = relatedPerson.patient;
            this.relationship.addAll(relatedPerson.relationship);
            this.name.addAll(relatedPerson.name);
            this.telecom.addAll(relatedPerson.telecom);
            this.gender = relatedPerson.gender;
            this.birthDate = relatedPerson.birthDate;
            this.address.addAll(relatedPerson.address);
            this.photo.addAll(relatedPerson.photo);
            this.period = relatedPerson.period;
            this.communication.addAll(relatedPerson.communication);
            return this;
        }
    }
}

