/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="rsd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')"), @Constraint(id="researchDefinition-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="subject.as(CodeableConcept).exists() implies (subject.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible'))", generated=true), @Constraint(id="researchDefinition-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", generated=true)})
public class ResearchDefinition
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    private final String shortTitle;
    private final String subtitle;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @ReferenceTarget(value={"Group"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SubjectType", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The possible types of subjects for the research (E.g. Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    private final Element subject;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    private final List<String> comment;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final String usage;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Binding(bindingName="DefinitionTopic", strength=BindingStrength.ValueSet.EXAMPLE, description="High-level categorization of the definition, used for searching, sorting, and filtering.", valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    private final List<CodeableConcept> topic;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final List<Canonical> library;
    @Summary
    @ReferenceTarget(value={"ResearchElementDefinition"})
    @Required
    private final Reference population;
    @Summary
    @ReferenceTarget(value={"ResearchElementDefinition"})
    private final Reference exposure;
    @Summary
    @ReferenceTarget(value={"ResearchElementDefinition"})
    private final Reference exposureAlternative;
    @Summary
    @ReferenceTarget(value={"ResearchElementDefinition"})
    private final Reference outcome;
    private volatile int hashCode;

    private ResearchDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.shortTitle = builder.shortTitle;
        this.subtitle = builder.subtitle;
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.experimental = builder.experimental;
        this.subject = ValidationSupport.choiceElement(builder.subject, "subject", CodeableConcept.class, Reference.class);
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactDetail.class));
        this.description = builder.description;
        this.comment = Collections.unmodifiableList(ValidationSupport.checkList(builder.comment, "comment", String.class));
        this.useContext = Collections.unmodifiableList(ValidationSupport.checkList(builder.useContext, "useContext", UsageContext.class));
        this.jurisdiction = Collections.unmodifiableList(ValidationSupport.checkList(builder.jurisdiction, "jurisdiction", CodeableConcept.class));
        this.purpose = builder.purpose;
        this.usage = builder.usage;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.topic = Collections.unmodifiableList(ValidationSupport.checkList(builder.topic, "topic", CodeableConcept.class));
        this.author = Collections.unmodifiableList(ValidationSupport.checkList(builder.author, "author", ContactDetail.class));
        this.editor = Collections.unmodifiableList(ValidationSupport.checkList(builder.editor, "editor", ContactDetail.class));
        this.reviewer = Collections.unmodifiableList(ValidationSupport.checkList(builder.reviewer, "reviewer", ContactDetail.class));
        this.endorser = Collections.unmodifiableList(ValidationSupport.checkList(builder.endorser, "endorser", ContactDetail.class));
        this.relatedArtifact = Collections.unmodifiableList(ValidationSupport.checkList(builder.relatedArtifact, "relatedArtifact", RelatedArtifact.class));
        this.library = Collections.unmodifiableList(ValidationSupport.checkList(builder.library, "library", Canonical.class));
        this.population = ValidationSupport.requireNonNull(builder.population, "population");
        this.exposure = builder.exposure;
        this.exposureAlternative = builder.exposureAlternative;
        this.outcome = builder.outcome;
        ValidationSupport.checkReferenceType(this.subject, "subject", "Group");
        ValidationSupport.checkReferenceType(this.population, "population", "ResearchElementDefinition");
        ValidationSupport.checkReferenceType(this.exposure, "exposure", "ResearchElementDefinition");
        ValidationSupport.checkReferenceType(this.exposureAlternative, "exposureAlternative", "ResearchElementDefinition");
        ValidationSupport.checkReferenceType(this.outcome, "outcome", "ResearchElementDefinition");
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public Element getSubject() {
        return this.subject;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public String getUsage() {
        return this.usage;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<CodeableConcept> getTopic() {
        return this.topic;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public List<Canonical> getLibrary() {
        return this.library;
    }

    public Reference getPopulation() {
        return this.population;
    }

    public Reference getExposure() {
        return this.exposure;
    }

    public Reference getExposureAlternative() {
        return this.exposureAlternative;
    }

    public Reference getOutcome() {
        return this.outcome;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.shortTitle != null || this.subtitle != null || this.status != null || this.experimental != null || this.subject != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.comment.isEmpty() || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.usage != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.topic.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || !this.library.isEmpty() || this.population != null || this.exposure != null || this.exposureAlternative != null || this.outcome != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.shortTitle, "shortTitle", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.comment, "comment", visitor, String.class);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.usage, "usage", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.topic, "topic", visitor, CodeableConcept.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.library, "library", visitor, Canonical.class);
                this.accept(this.population, "population", visitor);
                this.accept(this.exposure, "exposure", visitor);
                this.accept(this.exposureAlternative, "exposureAlternative", visitor);
                this.accept(this.outcome, "outcome", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchDefinition other = (ResearchDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.shortTitle, other.shortTitle) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.comment, other.comment) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.usage, other.usage) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.topic, other.topic) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.library, other.library) && Objects.equals(this.population, other.population) && Objects.equals(this.exposure, other.exposure) && Objects.equals(this.exposureAlternative, other.exposureAlternative) && Objects.equals(this.outcome, other.outcome);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.shortTitle, this.subtitle, this.status, this.experimental, this.subject, this.date, this.publisher, this.contact, this.description, this.comment, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.population, this.exposure, this.exposureAlternative, this.outcome);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private String shortTitle;
        private String subtitle;
        private PublicationStatus status;
        private Boolean experimental;
        private Element subject;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<String> comment = new ArrayList<String>();
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private String usage;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<CodeableConcept> topic = new ArrayList<CodeableConcept>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private List<Canonical> library = new ArrayList<Canonical>();
        private Reference population;
        private Reference exposure;
        private Reference exposureAlternative;
        private Reference outcome;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder shortTitle(String shortTitle) {
            this.shortTitle = shortTitle;
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder subject(Element subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder comment(String ... comment) {
            for (String value : comment) {
                this.comment.add(value);
            }
            return this;
        }

        public Builder comment(Collection<String> comment) {
            this.comment = new ArrayList<String>(comment);
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder topic(CodeableConcept ... topic) {
            for (CodeableConcept value : topic) {
                this.topic.add(value);
            }
            return this;
        }

        public Builder topic(Collection<CodeableConcept> topic) {
            this.topic = new ArrayList<CodeableConcept>(topic);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder library(Canonical ... library) {
            for (Canonical value : library) {
                this.library.add(value);
            }
            return this;
        }

        public Builder library(Collection<Canonical> library) {
            this.library = new ArrayList<Canonical>(library);
            return this;
        }

        public Builder population(Reference population) {
            this.population = population;
            return this;
        }

        public Builder exposure(Reference exposure) {
            this.exposure = exposure;
            return this;
        }

        public Builder exposureAlternative(Reference exposureAlternative) {
            this.exposureAlternative = exposureAlternative;
            return this;
        }

        public Builder outcome(Reference outcome) {
            this.outcome = outcome;
            return this;
        }

        @Override
        public ResearchDefinition build() {
            return new ResearchDefinition(this);
        }

        protected Builder from(ResearchDefinition researchDefinition) {
            super.from(researchDefinition);
            this.url = researchDefinition.url;
            this.identifier.addAll(researchDefinition.identifier);
            this.version = researchDefinition.version;
            this.name = researchDefinition.name;
            this.title = researchDefinition.title;
            this.shortTitle = researchDefinition.shortTitle;
            this.subtitle = researchDefinition.subtitle;
            this.status = researchDefinition.status;
            this.experimental = researchDefinition.experimental;
            this.subject = researchDefinition.subject;
            this.date = researchDefinition.date;
            this.publisher = researchDefinition.publisher;
            this.contact.addAll(researchDefinition.contact);
            this.description = researchDefinition.description;
            this.comment.addAll(researchDefinition.comment);
            this.useContext.addAll(researchDefinition.useContext);
            this.jurisdiction.addAll(researchDefinition.jurisdiction);
            this.purpose = researchDefinition.purpose;
            this.usage = researchDefinition.usage;
            this.copyright = researchDefinition.copyright;
            this.approvalDate = researchDefinition.approvalDate;
            this.lastReviewDate = researchDefinition.lastReviewDate;
            this.effectivePeriod = researchDefinition.effectivePeriod;
            this.topic.addAll(researchDefinition.topic);
            this.author.addAll(researchDefinition.author);
            this.editor.addAll(researchDefinition.editor);
            this.reviewer.addAll(researchDefinition.reviewer);
            this.endorser.addAll(researchDefinition.endorser);
            this.relatedArtifact.addAll(researchDefinition.relatedArtifact);
            this.library.addAll(researchDefinition.library);
            this.population = researchDefinition.population;
            this.exposure = researchDefinition.exposure;
            this.exposureAlternative = researchDefinition.exposureAlternative;
            this.outcome = researchDefinition.outcome;
            return this;
        }
    }
}

