/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ResearchSubjectStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.ValueSet.TRIAL_USE)
public class ResearchSubject
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ResearchSubjectStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Indicates the progression of a study subject through a study.", valueSet="http://hl7.org/fhir/ValueSet/research-subject-status|4.0.1")
    @Required
    private final ResearchSubjectStatus status;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"ResearchStudy"})
    @Required
    private final Reference study;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference individual;
    private final String assignedArm;
    private final String actualArm;
    @ReferenceTarget(value={"Consent"})
    private final Reference consent;
    private volatile int hashCode;

    private ResearchSubject(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.period = builder.period;
        this.study = ValidationSupport.requireNonNull(builder.study, "study");
        this.individual = ValidationSupport.requireNonNull(builder.individual, "individual");
        this.assignedArm = builder.assignedArm;
        this.actualArm = builder.actualArm;
        this.consent = builder.consent;
        ValidationSupport.checkReferenceType(this.study, "study", "ResearchStudy");
        ValidationSupport.checkReferenceType(this.individual, "individual", "Patient");
        ValidationSupport.checkReferenceType(this.consent, "consent", "Consent");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ResearchSubjectStatus getStatus() {
        return this.status;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getStudy() {
        return this.study;
    }

    public Reference getIndividual() {
        return this.individual;
    }

    public String getAssignedArm() {
        return this.assignedArm;
    }

    public String getActualArm() {
        return this.actualArm;
    }

    public Reference getConsent() {
        return this.consent;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.period != null || this.study != null || this.individual != null || this.assignedArm != null || this.actualArm != null || this.consent != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.study, "study", visitor);
                this.accept(this.individual, "individual", visitor);
                this.accept(this.assignedArm, "assignedArm", visitor);
                this.accept(this.actualArm, "actualArm", visitor);
                this.accept(this.consent, "consent", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchSubject other = (ResearchSubject)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.period, other.period) && Objects.equals(this.study, other.study) && Objects.equals(this.individual, other.individual) && Objects.equals(this.assignedArm, other.assignedArm) && Objects.equals(this.actualArm, other.actualArm) && Objects.equals(this.consent, other.consent);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.period, this.study, this.individual, this.assignedArm, this.actualArm, this.consent);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ResearchSubjectStatus status;
        private Period period;
        private Reference study;
        private Reference individual;
        private String assignedArm;
        private String actualArm;
        private Reference consent;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ResearchSubjectStatus status) {
            this.status = status;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder study(Reference study) {
            this.study = study;
            return this;
        }

        public Builder individual(Reference individual) {
            this.individual = individual;
            return this;
        }

        public Builder assignedArm(String assignedArm) {
            this.assignedArm = assignedArm;
            return this;
        }

        public Builder actualArm(String actualArm) {
            this.actualArm = actualArm;
            return this;
        }

        public Builder consent(Reference consent) {
            this.consent = consent;
            return this;
        }

        @Override
        public ResearchSubject build() {
            return new ResearchSubject(this);
        }

        protected Builder from(ResearchSubject researchSubject) {
            super.from(researchSubject);
            this.identifier.addAll(researchSubject.identifier);
            this.status = researchSubject.status;
            this.period = researchSubject.period;
            this.study = researchSubject.study;
            this.individual = researchSubject.individual;
            this.assignedArm = researchSubject.assignedArm;
            this.actualArm = researchSubject.actualArm;
            this.consent = researchSubject.consent;
            return this;
        }
    }
}

