/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.SearchComparator;
import com.ibm.fhir.model.type.code.SearchModifierCode;
import com.ibm.fhir.model.type.code.SearchParamType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.XPathUsageType;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="spd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')"), @Constraint(id="spd-1", level="Rule", location="(base)", description="If an xpath is present, there SHALL be an xpathUsage", expression="xpath.empty() or xpathUsage.exists()"), @Constraint(id="spd-2", level="Rule", location="(base)", description="Search parameters can only have chain names when the search parameter type is 'reference'", expression="chain.empty() or type = 'reference'"), @Constraint(id="searchParameter-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", generated=true)})
public class SearchParameter
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final String version;
    @Summary
    @Required
    private final String name;
    private final Canonical derivedFrom;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    @Required
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    @Summary
    @Required
    private final Code code;
    @Summary
    @Binding(bindingName="ResourceType", strength=BindingStrength.ValueSet.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
    @Required
    private final List<ResourceType> base;
    @Summary
    @Binding(bindingName="SearchParamType", strength=BindingStrength.ValueSet.REQUIRED, description="Data types allowed to be used for search parameters.", valueSet="http://hl7.org/fhir/ValueSet/search-param-type|4.0.1")
    @Required
    private final SearchParamType type;
    private final String expression;
    private final String xpath;
    @Binding(bindingName="XPathUsageType", strength=BindingStrength.ValueSet.REQUIRED, description="How a search parameter relates to the set of elements returned by evaluating its xpath query.", valueSet="http://hl7.org/fhir/ValueSet/search-xpath-usage|4.0.1")
    private final XPathUsageType xpathUsage;
    @Binding(bindingName="ResourceType", strength=BindingStrength.ValueSet.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
    private final List<ResourceType> target;
    private final Boolean multipleOr;
    private final Boolean multipleAnd;
    @Binding(bindingName="SearchComparator", strength=BindingStrength.ValueSet.REQUIRED, description="What Search Comparator Codes are supported in search.", valueSet="http://hl7.org/fhir/ValueSet/search-comparator|4.0.1")
    private final List<SearchComparator> comparator;
    @Binding(bindingName="SearchModifierCode", strength=BindingStrength.ValueSet.REQUIRED, description="A supported modifier for a search parameter.", valueSet="http://hl7.org/fhir/ValueSet/search-modifier-code|4.0.1")
    private final List<SearchModifierCode> modifier;
    private final List<String> chain;
    private final List<Component> component;
    private volatile int hashCode;

    private SearchParameter(Builder builder) {
        super(builder);
        this.url = ValidationSupport.requireNonNull(builder.url, "url");
        this.version = builder.version;
        this.name = ValidationSupport.requireNonNull(builder.name, "name");
        this.derivedFrom = builder.derivedFrom;
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactDetail.class));
        this.description = ValidationSupport.requireNonNull(builder.description, "description");
        this.useContext = Collections.unmodifiableList(ValidationSupport.checkList(builder.useContext, "useContext", UsageContext.class));
        this.jurisdiction = Collections.unmodifiableList(ValidationSupport.checkList(builder.jurisdiction, "jurisdiction", CodeableConcept.class));
        this.purpose = builder.purpose;
        this.code = ValidationSupport.requireNonNull(builder.code, "code");
        this.base = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.base, "base", ResourceType.class));
        this.type = ValidationSupport.requireNonNull(builder.type, "type");
        this.expression = builder.expression;
        this.xpath = builder.xpath;
        this.xpathUsage = builder.xpathUsage;
        this.target = Collections.unmodifiableList(ValidationSupport.checkList(builder.target, "target", ResourceType.class));
        this.multipleOr = builder.multipleOr;
        this.multipleAnd = builder.multipleAnd;
        this.comparator = Collections.unmodifiableList(ValidationSupport.checkList(builder.comparator, "comparator", SearchComparator.class));
        this.modifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.modifier, "modifier", SearchModifierCode.class));
        this.chain = Collections.unmodifiableList(ValidationSupport.checkList(builder.chain, "chain", String.class));
        this.component = Collections.unmodifiableList(ValidationSupport.checkList(builder.component, "component", Component.class));
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Canonical getDerivedFrom() {
        return this.derivedFrom;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Code getCode() {
        return this.code;
    }

    public List<ResourceType> getBase() {
        return this.base;
    }

    public SearchParamType getType() {
        return this.type;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getXpath() {
        return this.xpath;
    }

    public XPathUsageType getXpathUsage() {
        return this.xpathUsage;
    }

    public List<ResourceType> getTarget() {
        return this.target;
    }

    public Boolean getMultipleOr() {
        return this.multipleOr;
    }

    public Boolean getMultipleAnd() {
        return this.multipleAnd;
    }

    public List<SearchComparator> getComparator() {
        return this.comparator;
    }

    public List<SearchModifierCode> getModifier() {
        return this.modifier;
    }

    public List<String> getChain() {
        return this.chain;
    }

    public List<Component> getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.version != null || this.name != null || this.derivedFrom != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.code != null || !this.base.isEmpty() || this.type != null || this.expression != null || this.xpath != null || this.xpathUsage != null || !this.target.isEmpty() || this.multipleOr != null || this.multipleAnd != null || !this.comparator.isEmpty() || !this.modifier.isEmpty() || !this.chain.isEmpty() || !this.component.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.derivedFrom, "derivedFrom", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.base, "base", visitor, ResourceType.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.expression, "expression", visitor);
                this.accept(this.xpath, "xpath", visitor);
                this.accept(this.xpathUsage, "xpathUsage", visitor);
                this.accept(this.target, "target", visitor, ResourceType.class);
                this.accept(this.multipleOr, "multipleOr", visitor);
                this.accept(this.multipleAnd, "multipleAnd", visitor);
                this.accept(this.comparator, "comparator", visitor, SearchComparator.class);
                this.accept(this.modifier, "modifier", visitor, SearchModifierCode.class);
                this.accept(this.chain, "chain", visitor, String.class);
                this.accept(this.component, "component", visitor, Component.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParameter other = (SearchParameter)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.derivedFrom, other.derivedFrom) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.code, other.code) && Objects.equals(this.base, other.base) && Objects.equals(this.type, other.type) && Objects.equals(this.expression, other.expression) && Objects.equals(this.xpath, other.xpath) && Objects.equals(this.xpathUsage, other.xpathUsage) && Objects.equals(this.target, other.target) && Objects.equals(this.multipleOr, other.multipleOr) && Objects.equals(this.multipleAnd, other.multipleAnd) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.chain, other.chain) && Objects.equals(this.component, other.component);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.version, this.name, this.derivedFrom, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.code, this.base, this.type, this.expression, this.xpath, this.xpathUsage, this.target, this.multipleOr, this.multipleAnd, this.comparator, this.modifier, this.chain, this.component);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Component
    extends BackboneElement {
        @Required
        private final Canonical definition;
        @Required
        private final String expression;
        private volatile int hashCode;

        private Component(Builder builder) {
            super(builder);
            this.definition = ValidationSupport.requireNonNull(builder.definition, "definition");
            this.expression = ValidationSupport.requireNonNull(builder.expression, "expression");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Canonical getDefinition() {
            return this.definition;
        }

        public String getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.definition != null || this.expression != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.definition, "definition", visitor);
                    this.accept(this.expression, "expression", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Component other = (Component)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.definition, other.definition) && Objects.equals(this.expression, other.expression);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.definition, this.expression);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Canonical definition;
            private String expression;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder definition(Canonical definition) {
                this.definition = definition;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            @Override
            public Component build() {
                return new Component(this);
            }

            protected Builder from(Component component) {
                super.from(component);
                this.definition = component.definition;
                this.expression = component.expression;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private String version;
        private String name;
        private Canonical derivedFrom;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Code code;
        private List<ResourceType> base = new ArrayList<ResourceType>();
        private SearchParamType type;
        private String expression;
        private String xpath;
        private XPathUsageType xpathUsage;
        private List<ResourceType> target = new ArrayList<ResourceType>();
        private Boolean multipleOr;
        private Boolean multipleAnd;
        private List<SearchComparator> comparator = new ArrayList<SearchComparator>();
        private List<SearchModifierCode> modifier = new ArrayList<SearchModifierCode>();
        private List<String> chain = new ArrayList<String>();
        private List<Component> component = new ArrayList<Component>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder derivedFrom(Canonical derivedFrom) {
            this.derivedFrom = derivedFrom;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder code(Code code) {
            this.code = code;
            return this;
        }

        public Builder base(ResourceType ... base) {
            for (ResourceType value : base) {
                this.base.add(value);
            }
            return this;
        }

        public Builder base(Collection<ResourceType> base) {
            this.base = new ArrayList<ResourceType>(base);
            return this;
        }

        public Builder type(SearchParamType type) {
            this.type = type;
            return this;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder xpath(String xpath) {
            this.xpath = xpath;
            return this;
        }

        public Builder xpathUsage(XPathUsageType xpathUsage) {
            this.xpathUsage = xpathUsage;
            return this;
        }

        public Builder target(ResourceType ... target) {
            for (ResourceType value : target) {
                this.target.add(value);
            }
            return this;
        }

        public Builder target(Collection<ResourceType> target) {
            this.target = new ArrayList<ResourceType>(target);
            return this;
        }

        public Builder multipleOr(Boolean multipleOr) {
            this.multipleOr = multipleOr;
            return this;
        }

        public Builder multipleAnd(Boolean multipleAnd) {
            this.multipleAnd = multipleAnd;
            return this;
        }

        public Builder comparator(SearchComparator ... comparator) {
            for (SearchComparator value : comparator) {
                this.comparator.add(value);
            }
            return this;
        }

        public Builder comparator(Collection<SearchComparator> comparator) {
            this.comparator = new ArrayList<SearchComparator>(comparator);
            return this;
        }

        public Builder modifier(SearchModifierCode ... modifier) {
            for (SearchModifierCode value : modifier) {
                this.modifier.add(value);
            }
            return this;
        }

        public Builder modifier(Collection<SearchModifierCode> modifier) {
            this.modifier = new ArrayList<SearchModifierCode>(modifier);
            return this;
        }

        public Builder chain(String ... chain) {
            for (String value : chain) {
                this.chain.add(value);
            }
            return this;
        }

        public Builder chain(Collection<String> chain) {
            this.chain = new ArrayList<String>(chain);
            return this;
        }

        public Builder component(Component ... component) {
            for (Component value : component) {
                this.component.add(value);
            }
            return this;
        }

        public Builder component(Collection<Component> component) {
            this.component = new ArrayList<Component>(component);
            return this;
        }

        @Override
        public SearchParameter build() {
            return new SearchParameter(this);
        }

        protected Builder from(SearchParameter searchParameter) {
            super.from(searchParameter);
            this.url = searchParameter.url;
            this.version = searchParameter.version;
            this.name = searchParameter.name;
            this.derivedFrom = searchParameter.derivedFrom;
            this.status = searchParameter.status;
            this.experimental = searchParameter.experimental;
            this.date = searchParameter.date;
            this.publisher = searchParameter.publisher;
            this.contact.addAll(searchParameter.contact);
            this.description = searchParameter.description;
            this.useContext.addAll(searchParameter.useContext);
            this.jurisdiction.addAll(searchParameter.jurisdiction);
            this.purpose = searchParameter.purpose;
            this.code = searchParameter.code;
            this.base.addAll(searchParameter.base);
            this.type = searchParameter.type;
            this.expression = searchParameter.expression;
            this.xpath = searchParameter.xpath;
            this.xpathUsage = searchParameter.xpathUsage;
            this.target.addAll(searchParameter.target);
            this.multipleOr = searchParameter.multipleOr;
            this.multipleAnd = searchParameter.multipleAnd;
            this.comparator.addAll(searchParameter.comparator);
            this.modifier.addAll(searchParameter.modifier);
            this.chain.addAll(searchParameter.chain);
            this.component.addAll(searchParameter.component);
            return this;
        }
    }
}

