/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ServiceRequestIntent;
import com.ibm.fhir.model.type.code.ServiceRequestPriority;
import com.ibm.fhir.model.type.code.ServiceRequestStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="prr-1", level="Rule", location="(base)", description="orderDetail SHALL only be present if code is present", expression="orderDetail.empty() or code.exists()")
public class ServiceRequest
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    @Summary
    @ReferenceTarget(value={"CarePlan", "ServiceRequest", "MedicationRequest"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"ServiceRequest"})
    private final List<Reference> replaces;
    @Summary
    private final Identifier requisition;
    @Summary
    @Binding(bindingName="ServiceRequestStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The status of a service order.", valueSet="http://hl7.org/fhir/ValueSet/request-status|4.0.1")
    @Required
    private final ServiceRequestStatus status;
    @Summary
    @Binding(bindingName="ServiceRequestIntent", strength=BindingStrength.ValueSet.REQUIRED, description="The kind of service request.", valueSet="http://hl7.org/fhir/ValueSet/request-intent|4.0.1")
    @Required
    private final ServiceRequestIntent intent;
    @Summary
    @Binding(bindingName="ServiceRequestCategory", strength=BindingStrength.ValueSet.EXAMPLE, description="Classification of the requested service.", valueSet="http://hl7.org/fhir/ValueSet/servicerequest-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="ServiceRequestPriority", strength=BindingStrength.ValueSet.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.0.1")
    private final ServiceRequestPriority priority;
    @Summary
    private final Boolean doNotPerform;
    @Summary
    @Binding(bindingName="ServiceRequestCode", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes for tests or services that can be carried out by a designated individual, organization or healthcare service.  For laboratory, LOINC is  (preferred)[http://build.fhir.org/terminologies.html#preferred] and a valueset using LOINC Order codes is available [here](valueset-diagnostic-requests.html).", valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    private final CodeableConcept code;
    @Summary
    @Binding(bindingName="OrderDetail", strength=BindingStrength.ValueSet.EXAMPLE, description="Codified order entry details which are based on order context.", valueSet="http://hl7.org/fhir/ValueSet/servicerequest-orderdetail")
    private final List<CodeableConcept> orderDetail;
    @Summary
    @Choice(value={Quantity.class, Ratio.class, Range.class})
    private final Element quantity;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Location", "Device"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class, Timing.class})
    private final Element occurrence;
    @Summary
    @Choice(value={Boolean.class, CodeableConcept.class})
    @Binding(bindingName="ProcedureAsNeededReason", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept identifying the pre-condition that should hold prior to performing a procedure.  For example \"pain\", \"on flare-up\", etc.", valueSet="http://hl7.org/fhir/ValueSet/medication-as-needed-reason")
    private final Element asNeeded;
    @Summary
    private final DateTime authoredOn;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device"})
    private final Reference requester;
    @Summary
    @Binding(bindingName="ServiceRequestParticipantRole", strength=BindingStrength.ValueSet.EXAMPLE, description="Indicates specific responsibility of an individual within the care team, such as \"Primary physician\", \"Team coordinator\", \"Caregiver\", etc.", valueSet="http://hl7.org/fhir/ValueSet/participant-role")
    private final CodeableConcept performerType;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam", "HealthcareService", "Patient", "Device", "RelatedPerson"})
    private final List<Reference> performer;
    @Summary
    @Binding(bindingName="ServiceRequestLocation", strength=BindingStrength.ValueSet.EXAMPLE, description="A location type where services are delivered.", valueSet="http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType")
    private final List<CodeableConcept> locationCode;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final List<Reference> locationReference;
    @Summary
    @Binding(bindingName="ServiceRequestReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Diagnosis or problem codes justifying the reason for requesting the service investigation.", valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    @ReferenceTarget(value={"Coverage", "ClaimResponse"})
    private final List<Reference> insurance;
    private final List<Reference> supportingInfo;
    @Summary
    @ReferenceTarget(value={"Specimen"})
    private final List<Reference> specimen;
    @Summary
    @Binding(bindingName="BodySite", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final List<CodeableConcept> bodySite;
    private final List<Annotation> note;
    @Summary
    private final String patientInstruction;
    @ReferenceTarget(value={"Provenance"})
    private final List<Reference> relevantHistory;
    private volatile int hashCode;

    private ServiceRequest(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.instantiatesCanonical = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesCanonical, "instantiatesCanonical", Canonical.class));
        this.instantiatesUri = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesUri, "instantiatesUri", Uri.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.replaces = Collections.unmodifiableList(ValidationSupport.checkList(builder.replaces, "replaces", Reference.class));
        this.requisition = builder.requisition;
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.intent = ValidationSupport.requireNonNull(builder.intent, "intent");
        this.category = Collections.unmodifiableList(ValidationSupport.checkList(builder.category, "category", CodeableConcept.class));
        this.priority = builder.priority;
        this.doNotPerform = builder.doNotPerform;
        this.code = builder.code;
        this.orderDetail = Collections.unmodifiableList(ValidationSupport.checkList(builder.orderDetail, "orderDetail", CodeableConcept.class));
        this.quantity = ValidationSupport.choiceElement(builder.quantity, "quantity", Quantity.class, Ratio.class, Range.class);
        this.subject = ValidationSupport.requireNonNull(builder.subject, "subject");
        this.encounter = builder.encounter;
        this.occurrence = ValidationSupport.choiceElement(builder.occurrence, "occurrence", DateTime.class, Period.class, Timing.class);
        this.asNeeded = ValidationSupport.choiceElement(builder.asNeeded, "asNeeded", Boolean.class, CodeableConcept.class);
        this.authoredOn = builder.authoredOn;
        this.requester = builder.requester;
        this.performerType = builder.performerType;
        this.performer = Collections.unmodifiableList(ValidationSupport.checkList(builder.performer, "performer", Reference.class));
        this.locationCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.locationCode, "locationCode", CodeableConcept.class));
        this.locationReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.locationReference, "locationReference", Reference.class));
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
        this.insurance = Collections.unmodifiableList(ValidationSupport.checkList(builder.insurance, "insurance", Reference.class));
        this.supportingInfo = Collections.unmodifiableList(ValidationSupport.checkList(builder.supportingInfo, "supportingInfo", Reference.class));
        this.specimen = Collections.unmodifiableList(ValidationSupport.checkList(builder.specimen, "specimen", Reference.class));
        this.bodySite = Collections.unmodifiableList(ValidationSupport.checkList(builder.bodySite, "bodySite", CodeableConcept.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.patientInstruction = builder.patientInstruction;
        this.relevantHistory = Collections.unmodifiableList(ValidationSupport.checkList(builder.relevantHistory, "relevantHistory", Reference.class));
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "CarePlan", "ServiceRequest", "MedicationRequest");
        ValidationSupport.checkReferenceType(this.replaces, "replaces", "ServiceRequest");
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Group", "Location", "Device");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.requester, "requester", "Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device");
        ValidationSupport.checkReferenceType(this.performer, "performer", "Practitioner", "PractitionerRole", "Organization", "CareTeam", "HealthcareService", "Patient", "Device", "RelatedPerson");
        ValidationSupport.checkReferenceType(this.locationReference, "locationReference", "Location");
        ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
        ValidationSupport.checkReferenceType(this.insurance, "insurance", "Coverage", "ClaimResponse");
        ValidationSupport.checkReferenceType(this.specimen, "specimen", "Specimen");
        ValidationSupport.checkReferenceType(this.relevantHistory, "relevantHistory", "Provenance");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getReplaces() {
        return this.replaces;
    }

    public Identifier getRequisition() {
        return this.requisition;
    }

    public ServiceRequestStatus getStatus() {
        return this.status;
    }

    public ServiceRequestIntent getIntent() {
        return this.intent;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public ServiceRequestPriority getPriority() {
        return this.priority;
    }

    public Boolean getDoNotPerform() {
        return this.doNotPerform;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public List<CodeableConcept> getOrderDetail() {
        return this.orderDetail;
    }

    public Element getQuantity() {
        return this.quantity;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public Element getAsNeeded() {
        return this.asNeeded;
    }

    public DateTime getAuthoredOn() {
        return this.authoredOn;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public CodeableConcept getPerformerType() {
        return this.performerType;
    }

    public List<Reference> getPerformer() {
        return this.performer;
    }

    public List<CodeableConcept> getLocationCode() {
        return this.locationCode;
    }

    public List<Reference> getLocationReference() {
        return this.locationReference;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Reference> getInsurance() {
        return this.insurance;
    }

    public List<Reference> getSupportingInfo() {
        return this.supportingInfo;
    }

    public List<Reference> getSpecimen() {
        return this.specimen;
    }

    public List<CodeableConcept> getBodySite() {
        return this.bodySite;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public String getPatientInstruction() {
        return this.patientInstruction;
    }

    public List<Reference> getRelevantHistory() {
        return this.relevantHistory;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || !this.basedOn.isEmpty() || !this.replaces.isEmpty() || this.requisition != null || this.status != null || this.intent != null || !this.category.isEmpty() || this.priority != null || this.doNotPerform != null || this.code != null || !this.orderDetail.isEmpty() || this.quantity != null || this.subject != null || this.encounter != null || this.occurrence != null || this.asNeeded != null || this.authoredOn != null || this.requester != null || this.performerType != null || !this.performer.isEmpty() || !this.locationCode.isEmpty() || !this.locationReference.isEmpty() || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.insurance.isEmpty() || !this.supportingInfo.isEmpty() || !this.specimen.isEmpty() || !this.bodySite.isEmpty() || !this.note.isEmpty() || this.patientInstruction != null || !this.relevantHistory.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.replaces, "replaces", visitor, Reference.class);
                this.accept(this.requisition, "requisition", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.doNotPerform, "doNotPerform", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.orderDetail, "orderDetail", visitor, CodeableConcept.class);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.asNeeded, "asNeeded", visitor);
                this.accept(this.authoredOn, "authoredOn", visitor);
                this.accept(this.requester, "requester", visitor);
                this.accept(this.performerType, "performerType", visitor);
                this.accept(this.performer, "performer", visitor, Reference.class);
                this.accept(this.locationCode, "locationCode", visitor, CodeableConcept.class);
                this.accept(this.locationReference, "locationReference", visitor, Reference.class);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.insurance, "insurance", visitor, Reference.class);
                this.accept(this.supportingInfo, "supportingInfo", visitor, Reference.class);
                this.accept(this.specimen, "specimen", visitor, Reference.class);
                this.accept(this.bodySite, "bodySite", visitor, CodeableConcept.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.patientInstruction, "patientInstruction", visitor);
                this.accept(this.relevantHistory, "relevantHistory", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceRequest other = (ServiceRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.replaces, other.replaces) && Objects.equals(this.requisition, other.requisition) && Objects.equals(this.status, other.status) && Objects.equals(this.intent, other.intent) && Objects.equals(this.category, other.category) && Objects.equals(this.priority, other.priority) && Objects.equals(this.doNotPerform, other.doNotPerform) && Objects.equals(this.code, other.code) && Objects.equals(this.orderDetail, other.orderDetail) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.asNeeded, other.asNeeded) && Objects.equals(this.authoredOn, other.authoredOn) && Objects.equals(this.requester, other.requester) && Objects.equals(this.performerType, other.performerType) && Objects.equals(this.performer, other.performer) && Objects.equals(this.locationCode, other.locationCode) && Objects.equals(this.locationReference, other.locationReference) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.supportingInfo, other.supportingInfo) && Objects.equals(this.specimen, other.specimen) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.note, other.note) && Objects.equals(this.patientInstruction, other.patientInstruction) && Objects.equals(this.relevantHistory, other.relevantHistory);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.replaces, this.requisition, this.status, this.intent, this.category, this.priority, this.doNotPerform, this.code, this.orderDetail, this.quantity, this.subject, this.encounter, this.occurrence, this.asNeeded, this.authoredOn, this.requester, this.performerType, this.performer, this.locationCode, this.locationReference, this.reasonCode, this.reasonReference, this.insurance, this.supportingInfo, this.specimen, this.bodySite, this.note, this.patientInstruction, this.relevantHistory);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> replaces = new ArrayList<Reference>();
        private Identifier requisition;
        private ServiceRequestStatus status;
        private ServiceRequestIntent intent;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private ServiceRequestPriority priority;
        private Boolean doNotPerform;
        private CodeableConcept code;
        private List<CodeableConcept> orderDetail = new ArrayList<CodeableConcept>();
        private Element quantity;
        private Reference subject;
        private Reference encounter;
        private Element occurrence;
        private Element asNeeded;
        private DateTime authoredOn;
        private Reference requester;
        private CodeableConcept performerType;
        private List<Reference> performer = new ArrayList<Reference>();
        private List<CodeableConcept> locationCode = new ArrayList<CodeableConcept>();
        private List<Reference> locationReference = new ArrayList<Reference>();
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Reference> insurance = new ArrayList<Reference>();
        private List<Reference> supportingInfo = new ArrayList<Reference>();
        private List<Reference> specimen = new ArrayList<Reference>();
        private List<CodeableConcept> bodySite = new ArrayList<CodeableConcept>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private String patientInstruction;
        private List<Reference> relevantHistory = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder replaces(Reference ... replaces) {
            for (Reference value : replaces) {
                this.replaces.add(value);
            }
            return this;
        }

        public Builder replaces(Collection<Reference> replaces) {
            this.replaces = new ArrayList<Reference>(replaces);
            return this;
        }

        public Builder requisition(Identifier requisition) {
            this.requisition = requisition;
            return this;
        }

        public Builder status(ServiceRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder intent(ServiceRequestIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder priority(ServiceRequestPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder doNotPerform(Boolean doNotPerform) {
            this.doNotPerform = doNotPerform;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder orderDetail(CodeableConcept ... orderDetail) {
            for (CodeableConcept value : orderDetail) {
                this.orderDetail.add(value);
            }
            return this;
        }

        public Builder orderDetail(Collection<CodeableConcept> orderDetail) {
            this.orderDetail = new ArrayList<CodeableConcept>(orderDetail);
            return this;
        }

        public Builder quantity(Element quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder asNeeded(Element asNeeded) {
            this.asNeeded = asNeeded;
            return this;
        }

        public Builder authoredOn(DateTime authoredOn) {
            this.authoredOn = authoredOn;
            return this;
        }

        public Builder requester(Reference requester) {
            this.requester = requester;
            return this;
        }

        public Builder performerType(CodeableConcept performerType) {
            this.performerType = performerType;
            return this;
        }

        public Builder performer(Reference ... performer) {
            for (Reference value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Reference> performer) {
            this.performer = new ArrayList<Reference>(performer);
            return this;
        }

        public Builder locationCode(CodeableConcept ... locationCode) {
            for (CodeableConcept value : locationCode) {
                this.locationCode.add(value);
            }
            return this;
        }

        public Builder locationCode(Collection<CodeableConcept> locationCode) {
            this.locationCode = new ArrayList<CodeableConcept>(locationCode);
            return this;
        }

        public Builder locationReference(Reference ... locationReference) {
            for (Reference value : locationReference) {
                this.locationReference.add(value);
            }
            return this;
        }

        public Builder locationReference(Collection<Reference> locationReference) {
            this.locationReference = new ArrayList<Reference>(locationReference);
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder insurance(Reference ... insurance) {
            for (Reference value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Reference> insurance) {
            this.insurance = new ArrayList<Reference>(insurance);
            return this;
        }

        public Builder supportingInfo(Reference ... supportingInfo) {
            for (Reference value : supportingInfo) {
                this.supportingInfo.add(value);
            }
            return this;
        }

        public Builder supportingInfo(Collection<Reference> supportingInfo) {
            this.supportingInfo = new ArrayList<Reference>(supportingInfo);
            return this;
        }

        public Builder specimen(Reference ... specimen) {
            for (Reference value : specimen) {
                this.specimen.add(value);
            }
            return this;
        }

        public Builder specimen(Collection<Reference> specimen) {
            this.specimen = new ArrayList<Reference>(specimen);
            return this;
        }

        public Builder bodySite(CodeableConcept ... bodySite) {
            for (CodeableConcept value : bodySite) {
                this.bodySite.add(value);
            }
            return this;
        }

        public Builder bodySite(Collection<CodeableConcept> bodySite) {
            this.bodySite = new ArrayList<CodeableConcept>(bodySite);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder patientInstruction(String patientInstruction) {
            this.patientInstruction = patientInstruction;
            return this;
        }

        public Builder relevantHistory(Reference ... relevantHistory) {
            for (Reference value : relevantHistory) {
                this.relevantHistory.add(value);
            }
            return this;
        }

        public Builder relevantHistory(Collection<Reference> relevantHistory) {
            this.relevantHistory = new ArrayList<Reference>(relevantHistory);
            return this;
        }

        @Override
        public ServiceRequest build() {
            return new ServiceRequest(this);
        }

        protected Builder from(ServiceRequest serviceRequest) {
            super.from(serviceRequest);
            this.identifier.addAll(serviceRequest.identifier);
            this.instantiatesCanonical.addAll(serviceRequest.instantiatesCanonical);
            this.instantiatesUri.addAll(serviceRequest.instantiatesUri);
            this.basedOn.addAll(serviceRequest.basedOn);
            this.replaces.addAll(serviceRequest.replaces);
            this.requisition = serviceRequest.requisition;
            this.status = serviceRequest.status;
            this.intent = serviceRequest.intent;
            this.category.addAll(serviceRequest.category);
            this.priority = serviceRequest.priority;
            this.doNotPerform = serviceRequest.doNotPerform;
            this.code = serviceRequest.code;
            this.orderDetail.addAll(serviceRequest.orderDetail);
            this.quantity = serviceRequest.quantity;
            this.subject = serviceRequest.subject;
            this.encounter = serviceRequest.encounter;
            this.occurrence = serviceRequest.occurrence;
            this.asNeeded = serviceRequest.asNeeded;
            this.authoredOn = serviceRequest.authoredOn;
            this.requester = serviceRequest.requester;
            this.performerType = serviceRequest.performerType;
            this.performer.addAll(serviceRequest.performer);
            this.locationCode.addAll(serviceRequest.locationCode);
            this.locationReference.addAll(serviceRequest.locationReference);
            this.reasonCode.addAll(serviceRequest.reasonCode);
            this.reasonReference.addAll(serviceRequest.reasonReference);
            this.insurance.addAll(serviceRequest.insurance);
            this.supportingInfo.addAll(serviceRequest.supportingInfo);
            this.specimen.addAll(serviceRequest.specimen);
            this.bodySite.addAll(serviceRequest.bodySite);
            this.note.addAll(serviceRequest.note);
            this.patientInstruction = serviceRequest.patientInstruction;
            this.relevantHistory.addAll(serviceRequest.relevantHistory);
            return this;
        }
    }
}

