/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Contributor;
import com.ibm.fhir.model.type.Count;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Distance;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Oid;
import com.ibm.fhir.model.type.ParameterDefinition;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.SampledData;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.TriggerDefinition;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.Uuid;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.StructureMapContextType;
import com.ibm.fhir.model.type.code.StructureMapGroupTypeMode;
import com.ibm.fhir.model.type.code.StructureMapInputMode;
import com.ibm.fhir.model.type.code.StructureMapModelMode;
import com.ibm.fhir.model.type.code.StructureMapSourceListMode;
import com.ibm.fhir.model.type.code.StructureMapTargetListMode;
import com.ibm.fhir.model.type.code.StructureMapTransform;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="smp-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')"), @Constraint(id="smp-1", level="Rule", location="StructureMap.group.rule.target", description="Can only have an element if you have a context", expression="element.exists() implies context.exists()"), @Constraint(id="smp-2", level="Rule", location="StructureMap.group.rule.target", description="Must have a contextType if you have a context", expression="context.exists() implies contextType.exists()"), @Constraint(id="structureMap-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", generated=true)})
public class StructureMap
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    @Required
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    @Summary
    private final List<Structure> structure;
    @Summary
    private final List<Canonical> _import;
    @Summary
    @Required
    private final List<Group> group;
    private volatile int hashCode;

    private StructureMap(Builder builder) {
        super(builder);
        this.url = ValidationSupport.requireNonNull(builder.url, "url");
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.version = builder.version;
        this.name = ValidationSupport.requireNonNull(builder.name, "name");
        this.title = builder.title;
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactDetail.class));
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(ValidationSupport.checkList(builder.useContext, "useContext", UsageContext.class));
        this.jurisdiction = Collections.unmodifiableList(ValidationSupport.checkList(builder.jurisdiction, "jurisdiction", CodeableConcept.class));
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.structure = Collections.unmodifiableList(ValidationSupport.checkList(builder.structure, "structure", Structure.class));
        this._import = Collections.unmodifiableList(ValidationSupport.checkList(builder._import, "import", Canonical.class));
        this.group = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.group, "group", Group.class));
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public List<Structure> getStructure() {
        return this.structure;
    }

    public List<Canonical> getImport() {
        return this._import;
    }

    public List<Group> getGroup() {
        return this.group;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || !this.structure.isEmpty() || !this._import.isEmpty() || !this.group.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.structure, "structure", visitor, Structure.class);
                this.accept(this._import, "import", visitor, Canonical.class);
                this.accept(this.group, "group", visitor, Group.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureMap other = (StructureMap)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.structure, other.structure) && Objects.equals(this._import, other._import) && Objects.equals(this.group, other.group);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.structure, this._import, this.group);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Group
    extends BackboneElement {
        @Summary
        @Required
        private final Id name;
        @Summary
        private final Id _extends;
        @Summary
        @Binding(bindingName="StructureMapGroupTypeMode", strength=BindingStrength.ValueSet.REQUIRED, description="If this is the default rule set to apply for the source type, or this combination of types.", valueSet="http://hl7.org/fhir/ValueSet/map-group-type-mode|4.0.1")
        @Required
        private final StructureMapGroupTypeMode typeMode;
        @Summary
        private final String documentation;
        @Summary
        @Required
        private final List<Input> input;
        @Summary
        @Required
        private final List<Rule> rule;
        private volatile int hashCode;

        private Group(Builder builder) {
            super(builder);
            this.name = ValidationSupport.requireNonNull(builder.name, "name");
            this._extends = builder._extends;
            this.typeMode = ValidationSupport.requireNonNull(builder.typeMode, "typeMode");
            this.documentation = builder.documentation;
            this.input = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.input, "input", Input.class));
            this.rule = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.rule, "rule", Rule.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public Id getName() {
            return this.name;
        }

        public Id getExtends() {
            return this._extends;
        }

        public StructureMapGroupTypeMode getTypeMode() {
            return this.typeMode;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public List<Input> getInput() {
            return this.input;
        }

        public List<Rule> getRule() {
            return this.rule;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this._extends != null || this.typeMode != null || this.documentation != null || !this.input.isEmpty() || !this.rule.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this._extends, "extends", visitor);
                    this.accept(this.typeMode, "typeMode", visitor);
                    this.accept(this.documentation, "documentation", visitor);
                    this.accept(this.input, "input", visitor, Input.class);
                    this.accept(this.rule, "rule", visitor, Rule.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this._extends, other._extends) && Objects.equals(this.typeMode, other.typeMode) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.input, other.input) && Objects.equals(this.rule, other.rule);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this._extends, this.typeMode, this.documentation, this.input, this.rule);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Rule
        extends BackboneElement {
            @Summary
            @Required
            private final Id name;
            @Summary
            @Required
            private final List<Source> source;
            @Summary
            private final List<Target> target;
            @Summary
            private final List<Rule> rule;
            @Summary
            private final List<Dependent> dependent;
            private final String documentation;
            private volatile int hashCode;

            private Rule(Builder builder) {
                super(builder);
                this.name = ValidationSupport.requireNonNull(builder.name, "name");
                this.source = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.source, "source", Source.class));
                this.target = Collections.unmodifiableList(ValidationSupport.checkList(builder.target, "target", Target.class));
                this.rule = Collections.unmodifiableList(ValidationSupport.checkList(builder.rule, "rule", Rule.class));
                this.dependent = Collections.unmodifiableList(ValidationSupport.checkList(builder.dependent, "dependent", Dependent.class));
                this.documentation = builder.documentation;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Id getName() {
                return this.name;
            }

            public List<Source> getSource() {
                return this.source;
            }

            public List<Target> getTarget() {
                return this.target;
            }

            public List<Rule> getRule() {
                return this.rule;
            }

            public List<Dependent> getDependent() {
                return this.dependent;
            }

            public String getDocumentation() {
                return this.documentation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || !this.source.isEmpty() || !this.target.isEmpty() || !this.rule.isEmpty() || !this.dependent.isEmpty() || this.documentation != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.source, "source", visitor, Source.class);
                        this.accept(this.target, "target", visitor, Target.class);
                        this.accept(this.rule, "rule", visitor, Rule.class);
                        this.accept(this.dependent, "dependent", visitor, Dependent.class);
                        this.accept(this.documentation, "documentation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Rule other = (Rule)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.source, other.source) && Objects.equals(this.target, other.target) && Objects.equals(this.rule, other.rule) && Objects.equals(this.dependent, other.dependent) && Objects.equals(this.documentation, other.documentation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.source, this.target, this.rule, this.dependent, this.documentation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Dependent
            extends BackboneElement {
                @Summary
                @Required
                private final Id name;
                @Summary
                @Required
                private final List<String> variable;
                private volatile int hashCode;

                private Dependent(Builder builder) {
                    super(builder);
                    this.name = ValidationSupport.requireNonNull(builder.name, "name");
                    this.variable = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.variable, "variable", String.class));
                    ValidationSupport.requireValueOrChildren(this);
                }

                public Id getName() {
                    return this.name;
                }

                public List<String> getVariable() {
                    return this.variable;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.name != null || !this.variable.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.name, "name", visitor);
                            this.accept(this.variable, "variable", visitor, String.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Dependent other = (Dependent)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.variable, other.variable);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.variable);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Id name;
                    private List<String> variable = new ArrayList<String>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder name(Id name) {
                        this.name = name;
                        return this;
                    }

                    public Builder variable(String ... variable) {
                        for (String value : variable) {
                            this.variable.add(value);
                        }
                        return this;
                    }

                    public Builder variable(Collection<String> variable) {
                        this.variable = new ArrayList<String>(variable);
                        return this;
                    }

                    @Override
                    public Dependent build() {
                        return new Dependent(this);
                    }

                    protected Builder from(Dependent dependent) {
                        super.from(dependent);
                        this.name = dependent.name;
                        this.variable.addAll(dependent.variable);
                        return this;
                    }
                }
            }

            public static class Target
            extends BackboneElement {
                @Summary
                private final Id context;
                @Summary
                @Binding(bindingName="StructureMapContextType", strength=BindingStrength.ValueSet.REQUIRED, description="How to interpret the context.", valueSet="http://hl7.org/fhir/ValueSet/map-context-type|4.0.1")
                private final StructureMapContextType contextType;
                @Summary
                private final String element;
                @Summary
                private final Id variable;
                @Summary
                @Binding(bindingName="StructureMapTargetListMode", strength=BindingStrength.ValueSet.REQUIRED, description="If field is a list, how to manage the production.", valueSet="http://hl7.org/fhir/ValueSet/map-target-list-mode|4.0.1")
                private final List<StructureMapTargetListMode> listMode;
                @Summary
                private final Id listRuleId;
                @Summary
                @Binding(bindingName="StructureMapTransform", strength=BindingStrength.ValueSet.REQUIRED, description="How data is copied/created.", valueSet="http://hl7.org/fhir/ValueSet/map-transform|4.0.1")
                private final StructureMapTransform transform;
                @Summary
                private final List<Parameter> parameter;
                private volatile int hashCode;

                private Target(Builder builder) {
                    super(builder);
                    this.context = builder.context;
                    this.contextType = builder.contextType;
                    this.element = builder.element;
                    this.variable = builder.variable;
                    this.listMode = Collections.unmodifiableList(ValidationSupport.checkList(builder.listMode, "listMode", StructureMapTargetListMode.class));
                    this.listRuleId = builder.listRuleId;
                    this.transform = builder.transform;
                    this.parameter = Collections.unmodifiableList(ValidationSupport.checkList(builder.parameter, "parameter", Parameter.class));
                    ValidationSupport.requireValueOrChildren(this);
                }

                public Id getContext() {
                    return this.context;
                }

                public StructureMapContextType getContextType() {
                    return this.contextType;
                }

                public String getElement() {
                    return this.element;
                }

                public Id getVariable() {
                    return this.variable;
                }

                public List<StructureMapTargetListMode> getListMode() {
                    return this.listMode;
                }

                public Id getListRuleId() {
                    return this.listRuleId;
                }

                public StructureMapTransform getTransform() {
                    return this.transform;
                }

                public List<Parameter> getParameter() {
                    return this.parameter;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.context != null || this.contextType != null || this.element != null || this.variable != null || !this.listMode.isEmpty() || this.listRuleId != null || this.transform != null || !this.parameter.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.context, "context", visitor);
                            this.accept(this.contextType, "contextType", visitor);
                            this.accept(this.element, "element", visitor);
                            this.accept(this.variable, "variable", visitor);
                            this.accept(this.listMode, "listMode", visitor, StructureMapTargetListMode.class);
                            this.accept(this.listRuleId, "listRuleId", visitor);
                            this.accept(this.transform, "transform", visitor);
                            this.accept(this.parameter, "parameter", visitor, Parameter.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Target other = (Target)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.context, other.context) && Objects.equals(this.contextType, other.contextType) && Objects.equals(this.element, other.element) && Objects.equals(this.variable, other.variable) && Objects.equals(this.listMode, other.listMode) && Objects.equals(this.listRuleId, other.listRuleId) && Objects.equals(this.transform, other.transform) && Objects.equals(this.parameter, other.parameter);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.context, this.contextType, this.element, this.variable, this.listMode, this.listRuleId, this.transform, this.parameter);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Parameter
                extends BackboneElement {
                    @Summary
                    @Choice(value={Id.class, String.class, Boolean.class, Integer.class, Decimal.class})
                    @Required
                    private final Element value;
                    private volatile int hashCode;

                    private Parameter(Builder builder) {
                        super(builder);
                        this.value = ValidationSupport.requireChoiceElement(builder.value, "value", Id.class, String.class, Boolean.class, Integer.class, Decimal.class);
                        ValidationSupport.requireValueOrChildren(this);
                    }

                    public Element getValue() {
                        return this.value;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.value != null;
                    }

                    @Override
                    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.value, "value", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Parameter other = (Parameter)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private Element value;

                        private Builder() {
                        }

                        @Override
                        public Builder id(java.lang.String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder value(Element value) {
                            this.value = value;
                            return this;
                        }

                        @Override
                        public Parameter build() {
                            return new Parameter(this);
                        }

                        protected Builder from(Parameter parameter) {
                            super.from(parameter);
                            this.value = parameter.value;
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Id context;
                    private StructureMapContextType contextType;
                    private String element;
                    private Id variable;
                    private List<StructureMapTargetListMode> listMode = new ArrayList<StructureMapTargetListMode>();
                    private Id listRuleId;
                    private StructureMapTransform transform;
                    private List<Parameter> parameter = new ArrayList<Parameter>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder context(Id context) {
                        this.context = context;
                        return this;
                    }

                    public Builder contextType(StructureMapContextType contextType) {
                        this.contextType = contextType;
                        return this;
                    }

                    public Builder element(String element) {
                        this.element = element;
                        return this;
                    }

                    public Builder variable(Id variable) {
                        this.variable = variable;
                        return this;
                    }

                    public Builder listMode(StructureMapTargetListMode ... listMode) {
                        for (StructureMapTargetListMode value : listMode) {
                            this.listMode.add(value);
                        }
                        return this;
                    }

                    public Builder listMode(Collection<StructureMapTargetListMode> listMode) {
                        this.listMode = new ArrayList<StructureMapTargetListMode>(listMode);
                        return this;
                    }

                    public Builder listRuleId(Id listRuleId) {
                        this.listRuleId = listRuleId;
                        return this;
                    }

                    public Builder transform(StructureMapTransform transform) {
                        this.transform = transform;
                        return this;
                    }

                    public Builder parameter(Parameter ... parameter) {
                        for (Parameter value : parameter) {
                            this.parameter.add(value);
                        }
                        return this;
                    }

                    public Builder parameter(Collection<Parameter> parameter) {
                        this.parameter = new ArrayList<Parameter>(parameter);
                        return this;
                    }

                    @Override
                    public Target build() {
                        return new Target(this);
                    }

                    protected Builder from(Target target) {
                        super.from(target);
                        this.context = target.context;
                        this.contextType = target.contextType;
                        this.element = target.element;
                        this.variable = target.variable;
                        this.listMode.addAll(target.listMode);
                        this.listRuleId = target.listRuleId;
                        this.transform = target.transform;
                        this.parameter.addAll(target.parameter);
                        return this;
                    }
                }
            }

            public static class Source
            extends BackboneElement {
                @Summary
                @Required
                private final Id context;
                @Summary
                private final Integer min;
                @Summary
                private final String max;
                @Summary
                private final String type;
                @Summary
                @Choice(value={Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class})
                private final Element defaultValue;
                @Summary
                private final String element;
                @Summary
                @Binding(bindingName="StructureMapSourceListMode", strength=BindingStrength.ValueSet.REQUIRED, description="If field is a list, how to manage the source.", valueSet="http://hl7.org/fhir/ValueSet/map-source-list-mode|4.0.1")
                private final StructureMapSourceListMode listMode;
                @Summary
                private final Id variable;
                @Summary
                private final String condition;
                @Summary
                private final String check;
                @Summary
                private final String logMessage;
                private volatile int hashCode;

                private Source(Builder builder) {
                    super(builder);
                    this.context = ValidationSupport.requireNonNull(builder.context, "context");
                    this.min = builder.min;
                    this.max = builder.max;
                    this.type = builder.type;
                    this.defaultValue = ValidationSupport.choiceElement(builder.defaultValue, "defaultValue", Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class);
                    this.element = builder.element;
                    this.listMode = builder.listMode;
                    this.variable = builder.variable;
                    this.condition = builder.condition;
                    this.check = builder.check;
                    this.logMessage = builder.logMessage;
                    ValidationSupport.requireValueOrChildren(this);
                }

                public Id getContext() {
                    return this.context;
                }

                public Integer getMin() {
                    return this.min;
                }

                public String getMax() {
                    return this.max;
                }

                public String getType() {
                    return this.type;
                }

                public Element getDefaultValue() {
                    return this.defaultValue;
                }

                public String getElement() {
                    return this.element;
                }

                public StructureMapSourceListMode getListMode() {
                    return this.listMode;
                }

                public Id getVariable() {
                    return this.variable;
                }

                public String getCondition() {
                    return this.condition;
                }

                public String getCheck() {
                    return this.check;
                }

                public String getLogMessage() {
                    return this.logMessage;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.context != null || this.min != null || this.max != null || this.type != null || this.defaultValue != null || this.element != null || this.listMode != null || this.variable != null || this.condition != null || this.check != null || this.logMessage != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.context, "context", visitor);
                            this.accept(this.min, "min", visitor);
                            this.accept(this.max, "max", visitor);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.defaultValue, "defaultValue", visitor);
                            this.accept(this.element, "element", visitor);
                            this.accept(this.listMode, "listMode", visitor);
                            this.accept(this.variable, "variable", visitor);
                            this.accept(this.condition, "condition", visitor);
                            this.accept(this.check, "check", visitor);
                            this.accept(this.logMessage, "logMessage", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Source other = (Source)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.context, other.context) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.type, other.type) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.element, other.element) && Objects.equals(this.listMode, other.listMode) && Objects.equals(this.variable, other.variable) && Objects.equals(this.condition, other.condition) && Objects.equals(this.check, other.check) && Objects.equals(this.logMessage, other.logMessage);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.context, this.min, this.max, this.type, this.defaultValue, this.element, this.listMode, this.variable, this.condition, this.check, this.logMessage);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Id context;
                    private Integer min;
                    private String max;
                    private String type;
                    private Element defaultValue;
                    private String element;
                    private StructureMapSourceListMode listMode;
                    private Id variable;
                    private String condition;
                    private String check;
                    private String logMessage;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder context(Id context) {
                        this.context = context;
                        return this;
                    }

                    public Builder min(Integer min) {
                        this.min = min;
                        return this;
                    }

                    public Builder max(String max) {
                        this.max = max;
                        return this;
                    }

                    public Builder type(String type) {
                        this.type = type;
                        return this;
                    }

                    public Builder defaultValue(Element defaultValue) {
                        this.defaultValue = defaultValue;
                        return this;
                    }

                    public Builder element(String element) {
                        this.element = element;
                        return this;
                    }

                    public Builder listMode(StructureMapSourceListMode listMode) {
                        this.listMode = listMode;
                        return this;
                    }

                    public Builder variable(Id variable) {
                        this.variable = variable;
                        return this;
                    }

                    public Builder condition(String condition) {
                        this.condition = condition;
                        return this;
                    }

                    public Builder check(String check) {
                        this.check = check;
                        return this;
                    }

                    public Builder logMessage(String logMessage) {
                        this.logMessage = logMessage;
                        return this;
                    }

                    @Override
                    public Source build() {
                        return new Source(this);
                    }

                    protected Builder from(Source source) {
                        super.from(source);
                        this.context = source.context;
                        this.min = source.min;
                        this.max = source.max;
                        this.type = source.type;
                        this.defaultValue = source.defaultValue;
                        this.element = source.element;
                        this.listMode = source.listMode;
                        this.variable = source.variable;
                        this.condition = source.condition;
                        this.check = source.check;
                        this.logMessage = source.logMessage;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Id name;
                private List<Source> source = new ArrayList<Source>();
                private List<Target> target = new ArrayList<Target>();
                private List<Rule> rule = new ArrayList<Rule>();
                private List<Dependent> dependent = new ArrayList<Dependent>();
                private String documentation;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(Id name) {
                    this.name = name;
                    return this;
                }

                public Builder source(Source ... source) {
                    for (Source value : source) {
                        this.source.add(value);
                    }
                    return this;
                }

                public Builder source(Collection<Source> source) {
                    this.source = new ArrayList<Source>(source);
                    return this;
                }

                public Builder target(Target ... target) {
                    for (Target value : target) {
                        this.target.add(value);
                    }
                    return this;
                }

                public Builder target(Collection<Target> target) {
                    this.target = new ArrayList<Target>(target);
                    return this;
                }

                public Builder rule(Rule ... rule) {
                    for (Rule value : rule) {
                        this.rule.add(value);
                    }
                    return this;
                }

                public Builder rule(Collection<Rule> rule) {
                    this.rule = new ArrayList<Rule>(rule);
                    return this;
                }

                public Builder dependent(Dependent ... dependent) {
                    for (Dependent value : dependent) {
                        this.dependent.add(value);
                    }
                    return this;
                }

                public Builder dependent(Collection<Dependent> dependent) {
                    this.dependent = new ArrayList<Dependent>(dependent);
                    return this;
                }

                public Builder documentation(String documentation) {
                    this.documentation = documentation;
                    return this;
                }

                @Override
                public Rule build() {
                    return new Rule(this);
                }

                protected Builder from(Rule rule) {
                    super.from(rule);
                    this.name = rule.name;
                    this.source.addAll(rule.source);
                    this.target.addAll(rule.target);
                    this.rule.addAll(rule.rule);
                    this.dependent.addAll(rule.dependent);
                    this.documentation = rule.documentation;
                    return this;
                }
            }
        }

        public static class Input
        extends BackboneElement {
            @Summary
            @Required
            private final Id name;
            @Summary
            private final String type;
            @Summary
            @Binding(bindingName="StructureMapInputMode", strength=BindingStrength.ValueSet.REQUIRED, description="Mode for this instance of data.", valueSet="http://hl7.org/fhir/ValueSet/map-input-mode|4.0.1")
            @Required
            private final StructureMapInputMode mode;
            private final String documentation;
            private volatile int hashCode;

            private Input(Builder builder) {
                super(builder);
                this.name = ValidationSupport.requireNonNull(builder.name, "name");
                this.type = builder.type;
                this.mode = ValidationSupport.requireNonNull(builder.mode, "mode");
                this.documentation = builder.documentation;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Id getName() {
                return this.name;
            }

            public String getType() {
                return this.type;
            }

            public StructureMapInputMode getMode() {
                return this.mode;
            }

            public String getDocumentation() {
                return this.documentation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.type != null || this.mode != null || this.documentation != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.mode, "mode", visitor);
                        this.accept(this.documentation, "documentation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Input other = (Input)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.mode, other.mode) && Objects.equals(this.documentation, other.documentation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.type, this.mode, this.documentation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Id name;
                private String type;
                private StructureMapInputMode mode;
                private String documentation;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(Id name) {
                    this.name = name;
                    return this;
                }

                public Builder type(String type) {
                    this.type = type;
                    return this;
                }

                public Builder mode(StructureMapInputMode mode) {
                    this.mode = mode;
                    return this;
                }

                public Builder documentation(String documentation) {
                    this.documentation = documentation;
                    return this;
                }

                @Override
                public Input build() {
                    return new Input(this);
                }

                protected Builder from(Input input) {
                    super.from(input);
                    this.name = input.name;
                    this.type = input.type;
                    this.mode = input.mode;
                    this.documentation = input.documentation;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Id name;
            private Id _extends;
            private StructureMapGroupTypeMode typeMode;
            private String documentation;
            private List<Input> input = new ArrayList<Input>();
            private List<Rule> rule = new ArrayList<Rule>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(Id name) {
                this.name = name;
                return this;
            }

            public Builder _extends(Id _extends) {
                this._extends = _extends;
                return this;
            }

            public Builder typeMode(StructureMapGroupTypeMode typeMode) {
                this.typeMode = typeMode;
                return this;
            }

            public Builder documentation(String documentation) {
                this.documentation = documentation;
                return this;
            }

            public Builder input(Input ... input) {
                for (Input value : input) {
                    this.input.add(value);
                }
                return this;
            }

            public Builder input(Collection<Input> input) {
                this.input = new ArrayList<Input>(input);
                return this;
            }

            public Builder rule(Rule ... rule) {
                for (Rule value : rule) {
                    this.rule.add(value);
                }
                return this;
            }

            public Builder rule(Collection<Rule> rule) {
                this.rule = new ArrayList<Rule>(rule);
                return this;
            }

            @Override
            public Group build() {
                return new Group(this);
            }

            protected Builder from(Group group) {
                super.from(group);
                this.name = group.name;
                this._extends = group._extends;
                this.typeMode = group.typeMode;
                this.documentation = group.documentation;
                this.input.addAll(group.input);
                this.rule.addAll(group.rule);
                return this;
            }
        }
    }

    public static class Structure
    extends BackboneElement {
        @Summary
        @Required
        private final Canonical url;
        @Summary
        @Binding(bindingName="StructureMapModelMode", strength=BindingStrength.ValueSet.REQUIRED, description="How the referenced structure is used in this mapping.", valueSet="http://hl7.org/fhir/ValueSet/map-model-mode|4.0.1")
        @Required
        private final StructureMapModelMode mode;
        @Summary
        private final String alias;
        private final String documentation;
        private volatile int hashCode;

        private Structure(Builder builder) {
            super(builder);
            this.url = ValidationSupport.requireNonNull(builder.url, "url");
            this.mode = ValidationSupport.requireNonNull(builder.mode, "mode");
            this.alias = builder.alias;
            this.documentation = builder.documentation;
            ValidationSupport.requireValueOrChildren(this);
        }

        public Canonical getUrl() {
            return this.url;
        }

        public StructureMapModelMode getMode() {
            return this.mode;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.url != null || this.mode != null || this.alias != null || this.documentation != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.url, "url", visitor);
                    this.accept(this.mode, "mode", visitor);
                    this.accept(this.alias, "alias", visitor);
                    this.accept(this.documentation, "documentation", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Structure other = (Structure)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.mode, other.mode) && Objects.equals(this.alias, other.alias) && Objects.equals(this.documentation, other.documentation);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.url, this.mode, this.alias, this.documentation);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Canonical url;
            private StructureMapModelMode mode;
            private String alias;
            private String documentation;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder url(Canonical url) {
                this.url = url;
                return this;
            }

            public Builder mode(StructureMapModelMode mode) {
                this.mode = mode;
                return this;
            }

            public Builder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public Builder documentation(String documentation) {
                this.documentation = documentation;
                return this;
            }

            @Override
            public Structure build() {
                return new Structure(this);
            }

            protected Builder from(Structure structure) {
                super.from(structure);
                this.url = structure.url;
                this.mode = structure.mode;
                this.alias = structure.alias;
                this.documentation = structure.documentation;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private List<Structure> structure = new ArrayList<Structure>();
        private List<Canonical> _import = new ArrayList<Canonical>();
        private List<Group> group = new ArrayList<Group>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder structure(Structure ... structure) {
            for (Structure value : structure) {
                this.structure.add(value);
            }
            return this;
        }

        public Builder structure(Collection<Structure> structure) {
            this.structure = new ArrayList<Structure>(structure);
            return this;
        }

        public Builder _import(Canonical ... _import) {
            for (Canonical value : _import) {
                this._import.add(value);
            }
            return this;
        }

        public Builder _import(Collection<Canonical> _import) {
            this._import = new ArrayList<Canonical>(_import);
            return this;
        }

        public Builder group(Group ... group) {
            for (Group value : group) {
                this.group.add(value);
            }
            return this;
        }

        public Builder group(Collection<Group> group) {
            this.group = new ArrayList<Group>(group);
            return this;
        }

        @Override
        public StructureMap build() {
            return new StructureMap(this);
        }

        protected Builder from(StructureMap structureMap) {
            super.from(structureMap);
            this.url = structureMap.url;
            this.identifier.addAll(structureMap.identifier);
            this.version = structureMap.version;
            this.name = structureMap.name;
            this.title = structureMap.title;
            this.status = structureMap.status;
            this.experimental = structureMap.experimental;
            this.date = structureMap.date;
            this.publisher = structureMap.publisher;
            this.contact.addAll(structureMap.contact);
            this.description = structureMap.description;
            this.useContext.addAll(structureMap.useContext);
            this.jurisdiction.addAll(structureMap.jurisdiction);
            this.purpose = structureMap.purpose;
            this.copyright = structureMap.copyright;
            this.structure.addAll(structureMap.structure);
            this._import.addAll(structureMap._import);
            this.group.addAll(structureMap.group);
            return this;
        }
    }
}

