/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class SubstanceNucleicAcid
extends DomainResource {
    @Summary
    private final CodeableConcept sequenceType;
    @Summary
    private final Integer numberOfSubunits;
    @Summary
    private final String areaOfHybridisation;
    @Summary
    private final CodeableConcept oligoNucleotideType;
    @Summary
    private final List<Subunit> subunit;
    private volatile int hashCode;

    private SubstanceNucleicAcid(Builder builder) {
        super(builder);
        this.sequenceType = builder.sequenceType;
        this.numberOfSubunits = builder.numberOfSubunits;
        this.areaOfHybridisation = builder.areaOfHybridisation;
        this.oligoNucleotideType = builder.oligoNucleotideType;
        this.subunit = Collections.unmodifiableList(ValidationSupport.checkList(builder.subunit, "subunit", Subunit.class));
    }

    public CodeableConcept getSequenceType() {
        return this.sequenceType;
    }

    public Integer getNumberOfSubunits() {
        return this.numberOfSubunits;
    }

    public String getAreaOfHybridisation() {
        return this.areaOfHybridisation;
    }

    public CodeableConcept getOligoNucleotideType() {
        return this.oligoNucleotideType;
    }

    public List<Subunit> getSubunit() {
        return this.subunit;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.sequenceType != null || this.numberOfSubunits != null || this.areaOfHybridisation != null || this.oligoNucleotideType != null || !this.subunit.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.sequenceType, "sequenceType", visitor);
                this.accept(this.numberOfSubunits, "numberOfSubunits", visitor);
                this.accept(this.areaOfHybridisation, "areaOfHybridisation", visitor);
                this.accept(this.oligoNucleotideType, "oligoNucleotideType", visitor);
                this.accept(this.subunit, "subunit", visitor, Subunit.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstanceNucleicAcid other = (SubstanceNucleicAcid)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequenceType, other.sequenceType) && Objects.equals(this.numberOfSubunits, other.numberOfSubunits) && Objects.equals(this.areaOfHybridisation, other.areaOfHybridisation) && Objects.equals(this.oligoNucleotideType, other.oligoNucleotideType) && Objects.equals(this.subunit, other.subunit);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.sequenceType, this.numberOfSubunits, this.areaOfHybridisation, this.oligoNucleotideType, this.subunit);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Subunit
    extends BackboneElement {
        @Summary
        private final Integer subunit;
        @Summary
        private final String sequence;
        @Summary
        private final Integer length;
        @Summary
        private final Attachment sequenceAttachment;
        @Summary
        private final CodeableConcept fivePrime;
        @Summary
        private final CodeableConcept threePrime;
        @Summary
        private final List<Linkage> linkage;
        @Summary
        private final List<Sugar> sugar;
        private volatile int hashCode;

        private Subunit(Builder builder) {
            super(builder);
            this.subunit = builder.subunit;
            this.sequence = builder.sequence;
            this.length = builder.length;
            this.sequenceAttachment = builder.sequenceAttachment;
            this.fivePrime = builder.fivePrime;
            this.threePrime = builder.threePrime;
            this.linkage = Collections.unmodifiableList(ValidationSupport.checkList(builder.linkage, "linkage", Linkage.class));
            this.sugar = Collections.unmodifiableList(ValidationSupport.checkList(builder.sugar, "sugar", Sugar.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public Integer getSubunit() {
            return this.subunit;
        }

        public String getSequence() {
            return this.sequence;
        }

        public Integer getLength() {
            return this.length;
        }

        public Attachment getSequenceAttachment() {
            return this.sequenceAttachment;
        }

        public CodeableConcept getFivePrime() {
            return this.fivePrime;
        }

        public CodeableConcept getThreePrime() {
            return this.threePrime;
        }

        public List<Linkage> getLinkage() {
            return this.linkage;
        }

        public List<Sugar> getSugar() {
            return this.sugar;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.subunit != null || this.sequence != null || this.length != null || this.sequenceAttachment != null || this.fivePrime != null || this.threePrime != null || !this.linkage.isEmpty() || !this.sugar.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.subunit, "subunit", visitor);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.length, "length", visitor);
                    this.accept(this.sequenceAttachment, "sequenceAttachment", visitor);
                    this.accept(this.fivePrime, "fivePrime", visitor);
                    this.accept(this.threePrime, "threePrime", visitor);
                    this.accept(this.linkage, "linkage", visitor, Linkage.class);
                    this.accept(this.sugar, "sugar", visitor, Sugar.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subunit other = (Subunit)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.subunit, other.subunit) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.length, other.length) && Objects.equals(this.sequenceAttachment, other.sequenceAttachment) && Objects.equals(this.fivePrime, other.fivePrime) && Objects.equals(this.threePrime, other.threePrime) && Objects.equals(this.linkage, other.linkage) && Objects.equals(this.sugar, other.sugar);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.subunit, this.sequence, this.length, this.sequenceAttachment, this.fivePrime, this.threePrime, this.linkage, this.sugar);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Sugar
        extends BackboneElement {
            @Summary
            private final Identifier identifier;
            @Summary
            private final String name;
            @Summary
            private final String residueSite;
            private volatile int hashCode;

            private Sugar(Builder builder) {
                super(builder);
                this.identifier = builder.identifier;
                this.name = builder.name;
                this.residueSite = builder.residueSite;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Identifier getIdentifier() {
                return this.identifier;
            }

            public String getName() {
                return this.name;
            }

            public String getResidueSite() {
                return this.residueSite;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.identifier != null || this.name != null || this.residueSite != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.identifier, "identifier", visitor);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.residueSite, "residueSite", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Sugar other = (Sugar)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.residueSite, other.residueSite);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.name, this.residueSite);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Identifier identifier;
                private String name;
                private String residueSite;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder identifier(Identifier identifier) {
                    this.identifier = identifier;
                    return this;
                }

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder residueSite(String residueSite) {
                    this.residueSite = residueSite;
                    return this;
                }

                @Override
                public Sugar build() {
                    return new Sugar(this);
                }

                protected Builder from(Sugar sugar) {
                    super.from(sugar);
                    this.identifier = sugar.identifier;
                    this.name = sugar.name;
                    this.residueSite = sugar.residueSite;
                    return this;
                }
            }
        }

        public static class Linkage
        extends BackboneElement {
            @Summary
            private final String connectivity;
            @Summary
            private final Identifier identifier;
            @Summary
            private final String name;
            @Summary
            private final String residueSite;
            private volatile int hashCode;

            private Linkage(Builder builder) {
                super(builder);
                this.connectivity = builder.connectivity;
                this.identifier = builder.identifier;
                this.name = builder.name;
                this.residueSite = builder.residueSite;
                ValidationSupport.requireValueOrChildren(this);
            }

            public String getConnectivity() {
                return this.connectivity;
            }

            public Identifier getIdentifier() {
                return this.identifier;
            }

            public String getName() {
                return this.name;
            }

            public String getResidueSite() {
                return this.residueSite;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.connectivity != null || this.identifier != null || this.name != null || this.residueSite != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.connectivity, "connectivity", visitor);
                        this.accept(this.identifier, "identifier", visitor);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.residueSite, "residueSite", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Linkage other = (Linkage)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.connectivity, other.connectivity) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.residueSite, other.residueSite);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.connectivity, this.identifier, this.name, this.residueSite);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String connectivity;
                private Identifier identifier;
                private String name;
                private String residueSite;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder connectivity(String connectivity) {
                    this.connectivity = connectivity;
                    return this;
                }

                public Builder identifier(Identifier identifier) {
                    this.identifier = identifier;
                    return this;
                }

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder residueSite(String residueSite) {
                    this.residueSite = residueSite;
                    return this;
                }

                @Override
                public Linkage build() {
                    return new Linkage(this);
                }

                protected Builder from(Linkage linkage) {
                    super.from(linkage);
                    this.connectivity = linkage.connectivity;
                    this.identifier = linkage.identifier;
                    this.name = linkage.name;
                    this.residueSite = linkage.residueSite;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Integer subunit;
            private String sequence;
            private Integer length;
            private Attachment sequenceAttachment;
            private CodeableConcept fivePrime;
            private CodeableConcept threePrime;
            private List<Linkage> linkage = new ArrayList<Linkage>();
            private List<Sugar> sugar = new ArrayList<Sugar>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder subunit(Integer subunit) {
                this.subunit = subunit;
                return this;
            }

            public Builder sequence(String sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder length(Integer length) {
                this.length = length;
                return this;
            }

            public Builder sequenceAttachment(Attachment sequenceAttachment) {
                this.sequenceAttachment = sequenceAttachment;
                return this;
            }

            public Builder fivePrime(CodeableConcept fivePrime) {
                this.fivePrime = fivePrime;
                return this;
            }

            public Builder threePrime(CodeableConcept threePrime) {
                this.threePrime = threePrime;
                return this;
            }

            public Builder linkage(Linkage ... linkage) {
                for (Linkage value : linkage) {
                    this.linkage.add(value);
                }
                return this;
            }

            public Builder linkage(Collection<Linkage> linkage) {
                this.linkage = new ArrayList<Linkage>(linkage);
                return this;
            }

            public Builder sugar(Sugar ... sugar) {
                for (Sugar value : sugar) {
                    this.sugar.add(value);
                }
                return this;
            }

            public Builder sugar(Collection<Sugar> sugar) {
                this.sugar = new ArrayList<Sugar>(sugar);
                return this;
            }

            @Override
            public Subunit build() {
                return new Subunit(this);
            }

            protected Builder from(Subunit subunit) {
                super.from(subunit);
                this.subunit = subunit.subunit;
                this.sequence = subunit.sequence;
                this.length = subunit.length;
                this.sequenceAttachment = subunit.sequenceAttachment;
                this.fivePrime = subunit.fivePrime;
                this.threePrime = subunit.threePrime;
                this.linkage.addAll(subunit.linkage);
                this.sugar.addAll(subunit.sugar);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private CodeableConcept sequenceType;
        private Integer numberOfSubunits;
        private String areaOfHybridisation;
        private CodeableConcept oligoNucleotideType;
        private List<Subunit> subunit = new ArrayList<Subunit>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder sequenceType(CodeableConcept sequenceType) {
            this.sequenceType = sequenceType;
            return this;
        }

        public Builder numberOfSubunits(Integer numberOfSubunits) {
            this.numberOfSubunits = numberOfSubunits;
            return this;
        }

        public Builder areaOfHybridisation(String areaOfHybridisation) {
            this.areaOfHybridisation = areaOfHybridisation;
            return this;
        }

        public Builder oligoNucleotideType(CodeableConcept oligoNucleotideType) {
            this.oligoNucleotideType = oligoNucleotideType;
            return this;
        }

        public Builder subunit(Subunit ... subunit) {
            for (Subunit value : subunit) {
                this.subunit.add(value);
            }
            return this;
        }

        public Builder subunit(Collection<Subunit> subunit) {
            this.subunit = new ArrayList<Subunit>(subunit);
            return this;
        }

        @Override
        public SubstanceNucleicAcid build() {
            return new SubstanceNucleicAcid(this);
        }

        protected Builder from(SubstanceNucleicAcid substanceNucleicAcid) {
            super.from(substanceNucleicAcid);
            this.sequenceType = substanceNucleicAcid.sequenceType;
            this.numberOfSubunits = substanceNucleicAcid.numberOfSubunits;
            this.areaOfHybridisation = substanceNucleicAcid.areaOfHybridisation;
            this.oligoNucleotideType = substanceNucleicAcid.oligoNucleotideType;
            this.subunit.addAll(substanceNucleicAcid.subunit);
            return this;
        }
    }
}

