/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.SubstanceAmount;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class SubstancePolymer
extends DomainResource {
    @Summary
    private final CodeableConcept clazz;
    @Summary
    private final CodeableConcept geometry;
    @Summary
    private final List<CodeableConcept> copolymerConnectivity;
    @Summary
    private final List<String> modification;
    @Summary
    private final List<MonomerSet> monomerSet;
    @Summary
    private final List<Repeat> repeat;
    private volatile int hashCode;

    private SubstancePolymer(Builder builder) {
        super(builder);
        this.clazz = builder.clazz;
        this.geometry = builder.geometry;
        this.copolymerConnectivity = Collections.unmodifiableList(ValidationSupport.checkList(builder.copolymerConnectivity, "copolymerConnectivity", CodeableConcept.class));
        this.modification = Collections.unmodifiableList(ValidationSupport.checkList(builder.modification, "modification", String.class));
        this.monomerSet = Collections.unmodifiableList(ValidationSupport.checkList(builder.monomerSet, "monomerSet", MonomerSet.class));
        this.repeat = Collections.unmodifiableList(ValidationSupport.checkList(builder.repeat, "repeat", Repeat.class));
    }

    public CodeableConcept getClazz() {
        return this.clazz;
    }

    public CodeableConcept getGeometry() {
        return this.geometry;
    }

    public List<CodeableConcept> getCopolymerConnectivity() {
        return this.copolymerConnectivity;
    }

    public List<String> getModification() {
        return this.modification;
    }

    public List<MonomerSet> getMonomerSet() {
        return this.monomerSet;
    }

    public List<Repeat> getRepeat() {
        return this.repeat;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.clazz != null || this.geometry != null || !this.copolymerConnectivity.isEmpty() || !this.modification.isEmpty() || !this.monomerSet.isEmpty() || !this.repeat.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.clazz, "class", visitor);
                this.accept(this.geometry, "geometry", visitor);
                this.accept(this.copolymerConnectivity, "copolymerConnectivity", visitor, CodeableConcept.class);
                this.accept(this.modification, "modification", visitor, String.class);
                this.accept(this.monomerSet, "monomerSet", visitor, MonomerSet.class);
                this.accept(this.repeat, "repeat", visitor, Repeat.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstancePolymer other = (SubstancePolymer)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.clazz, other.clazz) && Objects.equals(this.geometry, other.geometry) && Objects.equals(this.copolymerConnectivity, other.copolymerConnectivity) && Objects.equals(this.modification, other.modification) && Objects.equals(this.monomerSet, other.monomerSet) && Objects.equals(this.repeat, other.repeat);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.clazz, this.geometry, this.copolymerConnectivity, this.modification, this.monomerSet, this.repeat);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Repeat
    extends BackboneElement {
        @Summary
        private final Integer numberOfUnits;
        @Summary
        private final String averageMolecularFormula;
        @Summary
        private final CodeableConcept repeatUnitAmountType;
        @Summary
        private final List<RepeatUnit> repeatUnit;
        private volatile int hashCode;

        private Repeat(Builder builder) {
            super(builder);
            this.numberOfUnits = builder.numberOfUnits;
            this.averageMolecularFormula = builder.averageMolecularFormula;
            this.repeatUnitAmountType = builder.repeatUnitAmountType;
            this.repeatUnit = Collections.unmodifiableList(ValidationSupport.checkList(builder.repeatUnit, "repeatUnit", RepeatUnit.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public Integer getNumberOfUnits() {
            return this.numberOfUnits;
        }

        public String getAverageMolecularFormula() {
            return this.averageMolecularFormula;
        }

        public CodeableConcept getRepeatUnitAmountType() {
            return this.repeatUnitAmountType;
        }

        public List<RepeatUnit> getRepeatUnit() {
            return this.repeatUnit;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.numberOfUnits != null || this.averageMolecularFormula != null || this.repeatUnitAmountType != null || !this.repeatUnit.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.numberOfUnits, "numberOfUnits", visitor);
                    this.accept(this.averageMolecularFormula, "averageMolecularFormula", visitor);
                    this.accept(this.repeatUnitAmountType, "repeatUnitAmountType", visitor);
                    this.accept(this.repeatUnit, "repeatUnit", visitor, RepeatUnit.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Repeat other = (Repeat)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.numberOfUnits, other.numberOfUnits) && Objects.equals(this.averageMolecularFormula, other.averageMolecularFormula) && Objects.equals(this.repeatUnitAmountType, other.repeatUnitAmountType) && Objects.equals(this.repeatUnit, other.repeatUnit);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.numberOfUnits, this.averageMolecularFormula, this.repeatUnitAmountType, this.repeatUnit);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class RepeatUnit
        extends BackboneElement {
            @Summary
            private final CodeableConcept orientationOfPolymerisation;
            @Summary
            private final String repeatUnit;
            @Summary
            private final SubstanceAmount amount;
            @Summary
            private final List<DegreeOfPolymerisation> degreeOfPolymerisation;
            @Summary
            private final List<StructuralRepresentation> structuralRepresentation;
            private volatile int hashCode;

            private RepeatUnit(Builder builder) {
                super(builder);
                this.orientationOfPolymerisation = builder.orientationOfPolymerisation;
                this.repeatUnit = builder.repeatUnit;
                this.amount = builder.amount;
                this.degreeOfPolymerisation = Collections.unmodifiableList(ValidationSupport.checkList(builder.degreeOfPolymerisation, "degreeOfPolymerisation", DegreeOfPolymerisation.class));
                this.structuralRepresentation = Collections.unmodifiableList(ValidationSupport.checkList(builder.structuralRepresentation, "structuralRepresentation", StructuralRepresentation.class));
                ValidationSupport.requireValueOrChildren(this);
            }

            public CodeableConcept getOrientationOfPolymerisation() {
                return this.orientationOfPolymerisation;
            }

            public String getRepeatUnit() {
                return this.repeatUnit;
            }

            public SubstanceAmount getAmount() {
                return this.amount;
            }

            public List<DegreeOfPolymerisation> getDegreeOfPolymerisation() {
                return this.degreeOfPolymerisation;
            }

            public List<StructuralRepresentation> getStructuralRepresentation() {
                return this.structuralRepresentation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.orientationOfPolymerisation != null || this.repeatUnit != null || this.amount != null || !this.degreeOfPolymerisation.isEmpty() || !this.structuralRepresentation.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.orientationOfPolymerisation, "orientationOfPolymerisation", visitor);
                        this.accept(this.repeatUnit, "repeatUnit", visitor);
                        this.accept(this.amount, "amount", visitor);
                        this.accept(this.degreeOfPolymerisation, "degreeOfPolymerisation", visitor, DegreeOfPolymerisation.class);
                        this.accept(this.structuralRepresentation, "structuralRepresentation", visitor, StructuralRepresentation.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                RepeatUnit other = (RepeatUnit)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.orientationOfPolymerisation, other.orientationOfPolymerisation) && Objects.equals(this.repeatUnit, other.repeatUnit) && Objects.equals(this.amount, other.amount) && Objects.equals(this.degreeOfPolymerisation, other.degreeOfPolymerisation) && Objects.equals(this.structuralRepresentation, other.structuralRepresentation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.orientationOfPolymerisation, this.repeatUnit, this.amount, this.degreeOfPolymerisation, this.structuralRepresentation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class StructuralRepresentation
            extends BackboneElement {
                @Summary
                private final CodeableConcept type;
                @Summary
                private final String representation;
                @Summary
                private final Attachment attachment;
                private volatile int hashCode;

                private StructuralRepresentation(Builder builder) {
                    super(builder);
                    this.type = builder.type;
                    this.representation = builder.representation;
                    this.attachment = builder.attachment;
                    ValidationSupport.requireValueOrChildren(this);
                }

                public CodeableConcept getType() {
                    return this.type;
                }

                public String getRepresentation() {
                    return this.representation;
                }

                public Attachment getAttachment() {
                    return this.attachment;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.type != null || this.representation != null || this.attachment != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.representation, "representation", visitor);
                            this.accept(this.attachment, "attachment", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    StructuralRepresentation other = (StructuralRepresentation)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.representation, other.representation) && Objects.equals(this.attachment, other.attachment);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.representation, this.attachment);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept type;
                    private String representation;
                    private Attachment attachment;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder type(CodeableConcept type) {
                        this.type = type;
                        return this;
                    }

                    public Builder representation(String representation) {
                        this.representation = representation;
                        return this;
                    }

                    public Builder attachment(Attachment attachment) {
                        this.attachment = attachment;
                        return this;
                    }

                    @Override
                    public StructuralRepresentation build() {
                        return new StructuralRepresentation(this);
                    }

                    protected Builder from(StructuralRepresentation structuralRepresentation) {
                        super.from(structuralRepresentation);
                        this.type = structuralRepresentation.type;
                        this.representation = structuralRepresentation.representation;
                        this.attachment = structuralRepresentation.attachment;
                        return this;
                    }
                }
            }

            public static class DegreeOfPolymerisation
            extends BackboneElement {
                @Summary
                private final CodeableConcept degree;
                @Summary
                private final SubstanceAmount amount;
                private volatile int hashCode;

                private DegreeOfPolymerisation(Builder builder) {
                    super(builder);
                    this.degree = builder.degree;
                    this.amount = builder.amount;
                    ValidationSupport.requireValueOrChildren(this);
                }

                public CodeableConcept getDegree() {
                    return this.degree;
                }

                public SubstanceAmount getAmount() {
                    return this.amount;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.degree != null || this.amount != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.degree, "degree", visitor);
                            this.accept(this.amount, "amount", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    DegreeOfPolymerisation other = (DegreeOfPolymerisation)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.degree, other.degree) && Objects.equals(this.amount, other.amount);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.degree, this.amount);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept degree;
                    private SubstanceAmount amount;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder degree(CodeableConcept degree) {
                        this.degree = degree;
                        return this;
                    }

                    public Builder amount(SubstanceAmount amount) {
                        this.amount = amount;
                        return this;
                    }

                    @Override
                    public DegreeOfPolymerisation build() {
                        return new DegreeOfPolymerisation(this);
                    }

                    protected Builder from(DegreeOfPolymerisation degreeOfPolymerisation) {
                        super.from(degreeOfPolymerisation);
                        this.degree = degreeOfPolymerisation.degree;
                        this.amount = degreeOfPolymerisation.amount;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept orientationOfPolymerisation;
                private String repeatUnit;
                private SubstanceAmount amount;
                private List<DegreeOfPolymerisation> degreeOfPolymerisation = new ArrayList<DegreeOfPolymerisation>();
                private List<StructuralRepresentation> structuralRepresentation = new ArrayList<StructuralRepresentation>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder orientationOfPolymerisation(CodeableConcept orientationOfPolymerisation) {
                    this.orientationOfPolymerisation = orientationOfPolymerisation;
                    return this;
                }

                public Builder repeatUnit(String repeatUnit) {
                    this.repeatUnit = repeatUnit;
                    return this;
                }

                public Builder amount(SubstanceAmount amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder degreeOfPolymerisation(DegreeOfPolymerisation ... degreeOfPolymerisation) {
                    for (DegreeOfPolymerisation value : degreeOfPolymerisation) {
                        this.degreeOfPolymerisation.add(value);
                    }
                    return this;
                }

                public Builder degreeOfPolymerisation(Collection<DegreeOfPolymerisation> degreeOfPolymerisation) {
                    this.degreeOfPolymerisation = new ArrayList<DegreeOfPolymerisation>(degreeOfPolymerisation);
                    return this;
                }

                public Builder structuralRepresentation(StructuralRepresentation ... structuralRepresentation) {
                    for (StructuralRepresentation value : structuralRepresentation) {
                        this.structuralRepresentation.add(value);
                    }
                    return this;
                }

                public Builder structuralRepresentation(Collection<StructuralRepresentation> structuralRepresentation) {
                    this.structuralRepresentation = new ArrayList<StructuralRepresentation>(structuralRepresentation);
                    return this;
                }

                @Override
                public RepeatUnit build() {
                    return new RepeatUnit(this);
                }

                protected Builder from(RepeatUnit repeatUnit) {
                    super.from(repeatUnit);
                    this.orientationOfPolymerisation = repeatUnit.orientationOfPolymerisation;
                    this.repeatUnit = repeatUnit.repeatUnit;
                    this.amount = repeatUnit.amount;
                    this.degreeOfPolymerisation.addAll(repeatUnit.degreeOfPolymerisation);
                    this.structuralRepresentation.addAll(repeatUnit.structuralRepresentation);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Integer numberOfUnits;
            private String averageMolecularFormula;
            private CodeableConcept repeatUnitAmountType;
            private List<RepeatUnit> repeatUnit = new ArrayList<RepeatUnit>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder numberOfUnits(Integer numberOfUnits) {
                this.numberOfUnits = numberOfUnits;
                return this;
            }

            public Builder averageMolecularFormula(String averageMolecularFormula) {
                this.averageMolecularFormula = averageMolecularFormula;
                return this;
            }

            public Builder repeatUnitAmountType(CodeableConcept repeatUnitAmountType) {
                this.repeatUnitAmountType = repeatUnitAmountType;
                return this;
            }

            public Builder repeatUnit(RepeatUnit ... repeatUnit) {
                for (RepeatUnit value : repeatUnit) {
                    this.repeatUnit.add(value);
                }
                return this;
            }

            public Builder repeatUnit(Collection<RepeatUnit> repeatUnit) {
                this.repeatUnit = new ArrayList<RepeatUnit>(repeatUnit);
                return this;
            }

            @Override
            public Repeat build() {
                return new Repeat(this);
            }

            protected Builder from(Repeat repeat) {
                super.from(repeat);
                this.numberOfUnits = repeat.numberOfUnits;
                this.averageMolecularFormula = repeat.averageMolecularFormula;
                this.repeatUnitAmountType = repeat.repeatUnitAmountType;
                this.repeatUnit.addAll(repeat.repeatUnit);
                return this;
            }
        }
    }

    public static class MonomerSet
    extends BackboneElement {
        @Summary
        private final CodeableConcept ratioType;
        @Summary
        private final List<StartingMaterial> startingMaterial;
        private volatile int hashCode;

        private MonomerSet(Builder builder) {
            super(builder);
            this.ratioType = builder.ratioType;
            this.startingMaterial = Collections.unmodifiableList(ValidationSupport.checkList(builder.startingMaterial, "startingMaterial", StartingMaterial.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getRatioType() {
            return this.ratioType;
        }

        public List<StartingMaterial> getStartingMaterial() {
            return this.startingMaterial;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.ratioType != null || !this.startingMaterial.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.ratioType, "ratioType", visitor);
                    this.accept(this.startingMaterial, "startingMaterial", visitor, StartingMaterial.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MonomerSet other = (MonomerSet)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.ratioType, other.ratioType) && Objects.equals(this.startingMaterial, other.startingMaterial);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.ratioType, this.startingMaterial);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class StartingMaterial
        extends BackboneElement {
            @Summary
            private final CodeableConcept material;
            @Summary
            private final CodeableConcept type;
            @Summary
            private final Boolean isDefining;
            @Summary
            private final SubstanceAmount amount;
            private volatile int hashCode;

            private StartingMaterial(Builder builder) {
                super(builder);
                this.material = builder.material;
                this.type = builder.type;
                this.isDefining = builder.isDefining;
                this.amount = builder.amount;
                ValidationSupport.requireValueOrChildren(this);
            }

            public CodeableConcept getMaterial() {
                return this.material;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Boolean getIsDefining() {
                return this.isDefining;
            }

            public SubstanceAmount getAmount() {
                return this.amount;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.material != null || this.type != null || this.isDefining != null || this.amount != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.material, "material", visitor);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.isDefining, "isDefining", visitor);
                        this.accept(this.amount, "amount", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StartingMaterial other = (StartingMaterial)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.material, other.material) && Objects.equals(this.type, other.type) && Objects.equals(this.isDefining, other.isDefining) && Objects.equals(this.amount, other.amount);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.material, this.type, this.isDefining, this.amount);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept material;
                private CodeableConcept type;
                private Boolean isDefining;
                private SubstanceAmount amount;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder material(CodeableConcept material) {
                    this.material = material;
                    return this;
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder isDefining(Boolean isDefining) {
                    this.isDefining = isDefining;
                    return this;
                }

                public Builder amount(SubstanceAmount amount) {
                    this.amount = amount;
                    return this;
                }

                @Override
                public StartingMaterial build() {
                    return new StartingMaterial(this);
                }

                protected Builder from(StartingMaterial startingMaterial) {
                    super.from(startingMaterial);
                    this.material = startingMaterial.material;
                    this.type = startingMaterial.type;
                    this.isDefining = startingMaterial.isDefining;
                    this.amount = startingMaterial.amount;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept ratioType;
            private List<StartingMaterial> startingMaterial = new ArrayList<StartingMaterial>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder ratioType(CodeableConcept ratioType) {
                this.ratioType = ratioType;
                return this;
            }

            public Builder startingMaterial(StartingMaterial ... startingMaterial) {
                for (StartingMaterial value : startingMaterial) {
                    this.startingMaterial.add(value);
                }
                return this;
            }

            public Builder startingMaterial(Collection<StartingMaterial> startingMaterial) {
                this.startingMaterial = new ArrayList<StartingMaterial>(startingMaterial);
                return this;
            }

            @Override
            public MonomerSet build() {
                return new MonomerSet(this);
            }

            protected Builder from(MonomerSet monomerSet) {
                super.from(monomerSet);
                this.ratioType = monomerSet.ratioType;
                this.startingMaterial.addAll(monomerSet.startingMaterial);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private CodeableConcept clazz;
        private CodeableConcept geometry;
        private List<CodeableConcept> copolymerConnectivity = new ArrayList<CodeableConcept>();
        private List<String> modification = new ArrayList<String>();
        private List<MonomerSet> monomerSet = new ArrayList<MonomerSet>();
        private List<Repeat> repeat = new ArrayList<Repeat>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder clazz(CodeableConcept clazz) {
            this.clazz = clazz;
            return this;
        }

        public Builder geometry(CodeableConcept geometry) {
            this.geometry = geometry;
            return this;
        }

        public Builder copolymerConnectivity(CodeableConcept ... copolymerConnectivity) {
            for (CodeableConcept value : copolymerConnectivity) {
                this.copolymerConnectivity.add(value);
            }
            return this;
        }

        public Builder copolymerConnectivity(Collection<CodeableConcept> copolymerConnectivity) {
            this.copolymerConnectivity = new ArrayList<CodeableConcept>(copolymerConnectivity);
            return this;
        }

        public Builder modification(String ... modification) {
            for (String value : modification) {
                this.modification.add(value);
            }
            return this;
        }

        public Builder modification(Collection<String> modification) {
            this.modification = new ArrayList<String>(modification);
            return this;
        }

        public Builder monomerSet(MonomerSet ... monomerSet) {
            for (MonomerSet value : monomerSet) {
                this.monomerSet.add(value);
            }
            return this;
        }

        public Builder monomerSet(Collection<MonomerSet> monomerSet) {
            this.monomerSet = new ArrayList<MonomerSet>(monomerSet);
            return this;
        }

        public Builder repeat(Repeat ... repeat) {
            for (Repeat value : repeat) {
                this.repeat.add(value);
            }
            return this;
        }

        public Builder repeat(Collection<Repeat> repeat) {
            this.repeat = new ArrayList<Repeat>(repeat);
            return this;
        }

        @Override
        public SubstancePolymer build() {
            return new SubstancePolymer(this);
        }

        protected Builder from(SubstancePolymer substancePolymer) {
            super.from(substancePolymer);
            this.clazz = substancePolymer.clazz;
            this.geometry = substancePolymer.geometry;
            this.copolymerConnectivity.addAll(substancePolymer.copolymerConnectivity);
            this.modification.addAll(substancePolymer.modification);
            this.monomerSet.addAll(substancePolymer.monomerSet);
            this.repeat.addAll(substancePolymer.repeat);
            return this;
        }
    }
}

