/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class SubstanceProtein
extends DomainResource {
    @Summary
    private final CodeableConcept sequenceType;
    @Summary
    private final Integer numberOfSubunits;
    @Summary
    private final List<String> disulfideLinkage;
    @Summary
    private final List<Subunit> subunit;
    private volatile int hashCode;

    private SubstanceProtein(Builder builder) {
        super(builder);
        this.sequenceType = builder.sequenceType;
        this.numberOfSubunits = builder.numberOfSubunits;
        this.disulfideLinkage = Collections.unmodifiableList(ValidationSupport.checkList(builder.disulfideLinkage, "disulfideLinkage", String.class));
        this.subunit = Collections.unmodifiableList(ValidationSupport.checkList(builder.subunit, "subunit", Subunit.class));
    }

    public CodeableConcept getSequenceType() {
        return this.sequenceType;
    }

    public Integer getNumberOfSubunits() {
        return this.numberOfSubunits;
    }

    public List<String> getDisulfideLinkage() {
        return this.disulfideLinkage;
    }

    public List<Subunit> getSubunit() {
        return this.subunit;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.sequenceType != null || this.numberOfSubunits != null || !this.disulfideLinkage.isEmpty() || !this.subunit.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.sequenceType, "sequenceType", visitor);
                this.accept(this.numberOfSubunits, "numberOfSubunits", visitor);
                this.accept(this.disulfideLinkage, "disulfideLinkage", visitor, String.class);
                this.accept(this.subunit, "subunit", visitor, Subunit.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstanceProtein other = (SubstanceProtein)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequenceType, other.sequenceType) && Objects.equals(this.numberOfSubunits, other.numberOfSubunits) && Objects.equals(this.disulfideLinkage, other.disulfideLinkage) && Objects.equals(this.subunit, other.subunit);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.sequenceType, this.numberOfSubunits, this.disulfideLinkage, this.subunit);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Subunit
    extends BackboneElement {
        @Summary
        private final Integer subunit;
        @Summary
        private final String sequence;
        @Summary
        private final Integer length;
        @Summary
        private final Attachment sequenceAttachment;
        @Summary
        private final Identifier nTerminalModificationId;
        @Summary
        private final String nTerminalModification;
        @Summary
        private final Identifier cTerminalModificationId;
        @Summary
        private final String cTerminalModification;
        private volatile int hashCode;

        private Subunit(Builder builder) {
            super(builder);
            this.subunit = builder.subunit;
            this.sequence = builder.sequence;
            this.length = builder.length;
            this.sequenceAttachment = builder.sequenceAttachment;
            this.nTerminalModificationId = builder.nTerminalModificationId;
            this.nTerminalModification = builder.nTerminalModification;
            this.cTerminalModificationId = builder.cTerminalModificationId;
            this.cTerminalModification = builder.cTerminalModification;
            ValidationSupport.requireValueOrChildren(this);
        }

        public Integer getSubunit() {
            return this.subunit;
        }

        public String getSequence() {
            return this.sequence;
        }

        public Integer getLength() {
            return this.length;
        }

        public Attachment getSequenceAttachment() {
            return this.sequenceAttachment;
        }

        public Identifier getNTerminalModificationId() {
            return this.nTerminalModificationId;
        }

        public String getNTerminalModification() {
            return this.nTerminalModification;
        }

        public Identifier getCTerminalModificationId() {
            return this.cTerminalModificationId;
        }

        public String getCTerminalModification() {
            return this.cTerminalModification;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.subunit != null || this.sequence != null || this.length != null || this.sequenceAttachment != null || this.nTerminalModificationId != null || this.nTerminalModification != null || this.cTerminalModificationId != null || this.cTerminalModification != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.subunit, "subunit", visitor);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.length, "length", visitor);
                    this.accept(this.sequenceAttachment, "sequenceAttachment", visitor);
                    this.accept(this.nTerminalModificationId, "nTerminalModificationId", visitor);
                    this.accept(this.nTerminalModification, "nTerminalModification", visitor);
                    this.accept(this.cTerminalModificationId, "cTerminalModificationId", visitor);
                    this.accept(this.cTerminalModification, "cTerminalModification", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subunit other = (Subunit)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.subunit, other.subunit) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.length, other.length) && Objects.equals(this.sequenceAttachment, other.sequenceAttachment) && Objects.equals(this.nTerminalModificationId, other.nTerminalModificationId) && Objects.equals(this.nTerminalModification, other.nTerminalModification) && Objects.equals(this.cTerminalModificationId, other.cTerminalModificationId) && Objects.equals(this.cTerminalModification, other.cTerminalModification);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.subunit, this.sequence, this.length, this.sequenceAttachment, this.nTerminalModificationId, this.nTerminalModification, this.cTerminalModificationId, this.cTerminalModification);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Integer subunit;
            private String sequence;
            private Integer length;
            private Attachment sequenceAttachment;
            private Identifier nTerminalModificationId;
            private String nTerminalModification;
            private Identifier cTerminalModificationId;
            private String cTerminalModification;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder subunit(Integer subunit) {
                this.subunit = subunit;
                return this;
            }

            public Builder sequence(String sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder length(Integer length) {
                this.length = length;
                return this;
            }

            public Builder sequenceAttachment(Attachment sequenceAttachment) {
                this.sequenceAttachment = sequenceAttachment;
                return this;
            }

            public Builder nTerminalModificationId(Identifier nTerminalModificationId) {
                this.nTerminalModificationId = nTerminalModificationId;
                return this;
            }

            public Builder nTerminalModification(String nTerminalModification) {
                this.nTerminalModification = nTerminalModification;
                return this;
            }

            public Builder cTerminalModificationId(Identifier cTerminalModificationId) {
                this.cTerminalModificationId = cTerminalModificationId;
                return this;
            }

            public Builder cTerminalModification(String cTerminalModification) {
                this.cTerminalModification = cTerminalModification;
                return this;
            }

            @Override
            public Subunit build() {
                return new Subunit(this);
            }

            protected Builder from(Subunit subunit) {
                super.from(subunit);
                this.subunit = subunit.subunit;
                this.sequence = subunit.sequence;
                this.length = subunit.length;
                this.sequenceAttachment = subunit.sequenceAttachment;
                this.nTerminalModificationId = subunit.nTerminalModificationId;
                this.nTerminalModification = subunit.nTerminalModification;
                this.cTerminalModificationId = subunit.cTerminalModificationId;
                this.cTerminalModification = subunit.cTerminalModification;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private CodeableConcept sequenceType;
        private Integer numberOfSubunits;
        private List<String> disulfideLinkage = new ArrayList<String>();
        private List<Subunit> subunit = new ArrayList<Subunit>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder sequenceType(CodeableConcept sequenceType) {
            this.sequenceType = sequenceType;
            return this;
        }

        public Builder numberOfSubunits(Integer numberOfSubunits) {
            this.numberOfSubunits = numberOfSubunits;
            return this;
        }

        public Builder disulfideLinkage(String ... disulfideLinkage) {
            for (String value : disulfideLinkage) {
                this.disulfideLinkage.add(value);
            }
            return this;
        }

        public Builder disulfideLinkage(Collection<String> disulfideLinkage) {
            this.disulfideLinkage = new ArrayList<String>(disulfideLinkage);
            return this;
        }

        public Builder subunit(Subunit ... subunit) {
            for (Subunit value : subunit) {
                this.subunit.add(value);
            }
            return this;
        }

        public Builder subunit(Collection<Subunit> subunit) {
            this.subunit = new ArrayList<Subunit>(subunit);
            return this;
        }

        @Override
        public SubstanceProtein build() {
            return new SubstanceProtein(this);
        }

        protected Builder from(SubstanceProtein substanceProtein) {
            super.from(substanceProtein);
            this.sequenceType = substanceProtein.sequenceType;
            this.numberOfSubunits = substanceProtein.numberOfSubunits;
            this.disulfideLinkage.addAll(substanceProtein.disulfideLinkage);
            this.subunit.addAll(substanceProtein.subunit);
            return this;
        }
    }
}

