/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class SubstanceReferenceInformation
extends DomainResource {
    @Summary
    private final String comment;
    @Summary
    private final List<Gene> gene;
    @Summary
    private final List<GeneElement> geneElement;
    @Summary
    private final List<Classification> classification;
    @Summary
    private final List<Target> target;
    private volatile int hashCode;

    private SubstanceReferenceInformation(Builder builder) {
        super(builder);
        this.comment = builder.comment;
        this.gene = Collections.unmodifiableList(ValidationSupport.checkList(builder.gene, "gene", Gene.class));
        this.geneElement = Collections.unmodifiableList(ValidationSupport.checkList(builder.geneElement, "geneElement", GeneElement.class));
        this.classification = Collections.unmodifiableList(ValidationSupport.checkList(builder.classification, "classification", Classification.class));
        this.target = Collections.unmodifiableList(ValidationSupport.checkList(builder.target, "target", Target.class));
    }

    public String getComment() {
        return this.comment;
    }

    public List<Gene> getGene() {
        return this.gene;
    }

    public List<GeneElement> getGeneElement() {
        return this.geneElement;
    }

    public List<Classification> getClassification() {
        return this.classification;
    }

    public List<Target> getTarget() {
        return this.target;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.comment != null || !this.gene.isEmpty() || !this.geneElement.isEmpty() || !this.classification.isEmpty() || !this.target.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.comment, "comment", visitor);
                this.accept(this.gene, "gene", visitor, Gene.class);
                this.accept(this.geneElement, "geneElement", visitor, GeneElement.class);
                this.accept(this.classification, "classification", visitor, Classification.class);
                this.accept(this.target, "target", visitor, Target.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstanceReferenceInformation other = (SubstanceReferenceInformation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.comment, other.comment) && Objects.equals(this.gene, other.gene) && Objects.equals(this.geneElement, other.geneElement) && Objects.equals(this.classification, other.classification) && Objects.equals(this.target, other.target);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.comment, this.gene, this.geneElement, this.classification, this.target);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Target
    extends BackboneElement {
        @Summary
        private final Identifier target;
        @Summary
        private final CodeableConcept type;
        @Summary
        private final CodeableConcept interaction;
        @Summary
        private final CodeableConcept organism;
        @Summary
        private final CodeableConcept organismType;
        @Summary
        @Choice(value={Quantity.class, Range.class, String.class})
        private final Element amount;
        @Summary
        private final CodeableConcept amountType;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        private volatile int hashCode;

        private Target(Builder builder) {
            super(builder);
            this.target = builder.target;
            this.type = builder.type;
            this.interaction = builder.interaction;
            this.organism = builder.organism;
            this.organismType = builder.organismType;
            this.amount = ValidationSupport.choiceElement(builder.amount, "amount", Quantity.class, Range.class, String.class);
            this.amountType = builder.amountType;
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Identifier getTarget() {
            return this.target;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getInteraction() {
            return this.interaction;
        }

        public CodeableConcept getOrganism() {
            return this.organism;
        }

        public CodeableConcept getOrganismType() {
            return this.organismType;
        }

        public Element getAmount() {
            return this.amount;
        }

        public CodeableConcept getAmountType() {
            return this.amountType;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.target != null || this.type != null || this.interaction != null || this.organism != null || this.organismType != null || this.amount != null || this.amountType != null || !this.source.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.target, "target", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.interaction, "interaction", visitor);
                    this.accept(this.organism, "organism", visitor);
                    this.accept(this.organismType, "organismType", visitor);
                    this.accept(this.amount, "amount", visitor);
                    this.accept(this.amountType, "amountType", visitor);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Target other = (Target)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.target, other.target) && Objects.equals(this.type, other.type) && Objects.equals(this.interaction, other.interaction) && Objects.equals(this.organism, other.organism) && Objects.equals(this.organismType, other.organismType) && Objects.equals(this.amount, other.amount) && Objects.equals(this.amountType, other.amountType) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.target, this.type, this.interaction, this.organism, this.organismType, this.amount, this.amountType, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier target;
            private CodeableConcept type;
            private CodeableConcept interaction;
            private CodeableConcept organism;
            private CodeableConcept organismType;
            private Element amount;
            private CodeableConcept amountType;
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder target(Identifier target) {
                this.target = target;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder interaction(CodeableConcept interaction) {
                this.interaction = interaction;
                return this;
            }

            public Builder organism(CodeableConcept organism) {
                this.organism = organism;
                return this;
            }

            public Builder organismType(CodeableConcept organismType) {
                this.organismType = organismType;
                return this;
            }

            public Builder amount(Element amount) {
                this.amount = amount;
                return this;
            }

            public Builder amountType(CodeableConcept amountType) {
                this.amountType = amountType;
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Target build() {
                return new Target(this);
            }

            protected Builder from(Target target) {
                super.from(target);
                this.target = target.target;
                this.type = target.type;
                this.interaction = target.interaction;
                this.organism = target.organism;
                this.organismType = target.organismType;
                this.amount = target.amount;
                this.amountType = target.amountType;
                this.source.addAll(target.source);
                return this;
            }
        }
    }

    public static class Classification
    extends BackboneElement {
        @Summary
        private final CodeableConcept domain;
        @Summary
        private final CodeableConcept classification;
        @Summary
        private final List<CodeableConcept> subtype;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        private volatile int hashCode;

        private Classification(Builder builder) {
            super(builder);
            this.domain = builder.domain;
            this.classification = builder.classification;
            this.subtype = Collections.unmodifiableList(ValidationSupport.checkList(builder.subtype, "subtype", CodeableConcept.class));
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getDomain() {
            return this.domain;
        }

        public CodeableConcept getClassification() {
            return this.classification;
        }

        public List<CodeableConcept> getSubtype() {
            return this.subtype;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.domain != null || this.classification != null || !this.subtype.isEmpty() || !this.source.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.domain, "domain", visitor);
                    this.accept(this.classification, "classification", visitor);
                    this.accept(this.subtype, "subtype", visitor, CodeableConcept.class);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Classification other = (Classification)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.domain, other.domain) && Objects.equals(this.classification, other.classification) && Objects.equals(this.subtype, other.subtype) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.domain, this.classification, this.subtype, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept domain;
            private CodeableConcept classification;
            private List<CodeableConcept> subtype = new ArrayList<CodeableConcept>();
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder domain(CodeableConcept domain) {
                this.domain = domain;
                return this;
            }

            public Builder classification(CodeableConcept classification) {
                this.classification = classification;
                return this;
            }

            public Builder subtype(CodeableConcept ... subtype) {
                for (CodeableConcept value : subtype) {
                    this.subtype.add(value);
                }
                return this;
            }

            public Builder subtype(Collection<CodeableConcept> subtype) {
                this.subtype = new ArrayList<CodeableConcept>(subtype);
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Classification build() {
                return new Classification(this);
            }

            protected Builder from(Classification classification) {
                super.from(classification);
                this.domain = classification.domain;
                this.classification = classification.classification;
                this.subtype.addAll(classification.subtype);
                this.source.addAll(classification.source);
                return this;
            }
        }
    }

    public static class GeneElement
    extends BackboneElement {
        @Summary
        private final CodeableConcept type;
        @Summary
        private final Identifier element;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        private volatile int hashCode;

        private GeneElement(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.element = builder.element;
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Identifier getElement() {
            return this.element;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.element != null || !this.source.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.element, "element", visitor);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneElement other = (GeneElement)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.element, other.element) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.element, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Identifier element;
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder element(Identifier element) {
                this.element = element;
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public GeneElement build() {
                return new GeneElement(this);
            }

            protected Builder from(GeneElement geneElement) {
                super.from(geneElement);
                this.type = geneElement.type;
                this.element = geneElement.element;
                this.source.addAll(geneElement.source);
                return this;
            }
        }
    }

    public static class Gene
    extends BackboneElement {
        @Summary
        private final CodeableConcept geneSequenceOrigin;
        @Summary
        private final CodeableConcept gene;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        private volatile int hashCode;

        private Gene(Builder builder) {
            super(builder);
            this.geneSequenceOrigin = builder.geneSequenceOrigin;
            this.gene = builder.gene;
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getGeneSequenceOrigin() {
            return this.geneSequenceOrigin;
        }

        public CodeableConcept getGene() {
            return this.gene;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.geneSequenceOrigin != null || this.gene != null || !this.source.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.geneSequenceOrigin, "geneSequenceOrigin", visitor);
                    this.accept(this.gene, "gene", visitor);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Gene other = (Gene)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.geneSequenceOrigin, other.geneSequenceOrigin) && Objects.equals(this.gene, other.gene) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.geneSequenceOrigin, this.gene, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept geneSequenceOrigin;
            private CodeableConcept gene;
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder geneSequenceOrigin(CodeableConcept geneSequenceOrigin) {
                this.geneSequenceOrigin = geneSequenceOrigin;
                return this;
            }

            public Builder gene(CodeableConcept gene) {
                this.gene = gene;
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Gene build() {
                return new Gene(this);
            }

            protected Builder from(Gene gene) {
                super.from(gene);
                this.geneSequenceOrigin = gene.geneSequenceOrigin;
                this.gene = gene.gene;
                this.source.addAll(gene.source);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private String comment;
        private List<Gene> gene = new ArrayList<Gene>();
        private List<GeneElement> geneElement = new ArrayList<GeneElement>();
        private List<Classification> classification = new ArrayList<Classification>();
        private List<Target> target = new ArrayList<Target>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder gene(Gene ... gene) {
            for (Gene value : gene) {
                this.gene.add(value);
            }
            return this;
        }

        public Builder gene(Collection<Gene> gene) {
            this.gene = new ArrayList<Gene>(gene);
            return this;
        }

        public Builder geneElement(GeneElement ... geneElement) {
            for (GeneElement value : geneElement) {
                this.geneElement.add(value);
            }
            return this;
        }

        public Builder geneElement(Collection<GeneElement> geneElement) {
            this.geneElement = new ArrayList<GeneElement>(geneElement);
            return this;
        }

        public Builder classification(Classification ... classification) {
            for (Classification value : classification) {
                this.classification.add(value);
            }
            return this;
        }

        public Builder classification(Collection<Classification> classification) {
            this.classification = new ArrayList<Classification>(classification);
            return this;
        }

        public Builder target(Target ... target) {
            for (Target value : target) {
                this.target.add(value);
            }
            return this;
        }

        public Builder target(Collection<Target> target) {
            this.target = new ArrayList<Target>(target);
            return this;
        }

        @Override
        public SubstanceReferenceInformation build() {
            return new SubstanceReferenceInformation(this);
        }

        protected Builder from(SubstanceReferenceInformation substanceReferenceInformation) {
            super.from(substanceReferenceInformation);
            this.comment = substanceReferenceInformation.comment;
            this.gene.addAll(substanceReferenceInformation.gene);
            this.geneElement.addAll(substanceReferenceInformation.geneElement);
            this.classification.addAll(substanceReferenceInformation.classification);
            this.target.addAll(substanceReferenceInformation.target);
            return this;
        }
    }
}

