/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class SubstanceSpecification
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    private final CodeableConcept type;
    @Summary
    private final CodeableConcept status;
    @Summary
    private final CodeableConcept domain;
    @Summary
    private final String description;
    @Summary
    @ReferenceTarget(value={"DocumentReference"})
    private final List<Reference> source;
    @Summary
    private final String comment;
    @Summary
    private final List<Moiety> moiety;
    @Summary
    private final List<Property> property;
    @Summary
    @ReferenceTarget(value={"SubstanceReferenceInformation"})
    private final Reference referenceInformation;
    @Summary
    private final Structure structure;
    @Summary
    private final List<Code> code;
    @Summary
    private final List<Name> name;
    @Summary
    private final List<Structure.Isotope.MolecularWeight> molecularWeight;
    @Summary
    private final List<Relationship> relationship;
    @Summary
    @ReferenceTarget(value={"SubstanceNucleicAcid"})
    private final Reference nucleicAcid;
    @Summary
    @ReferenceTarget(value={"SubstancePolymer"})
    private final Reference polymer;
    @Summary
    @ReferenceTarget(value={"SubstanceProtein"})
    private final Reference protein;
    @Summary
    @ReferenceTarget(value={"SubstanceSourceMaterial"})
    private final Reference sourceMaterial;
    private volatile int hashCode;

    private SubstanceSpecification(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.type = builder.type;
        this.status = builder.status;
        this.domain = builder.domain;
        this.description = builder.description;
        this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
        this.comment = builder.comment;
        this.moiety = Collections.unmodifiableList(ValidationSupport.checkList(builder.moiety, "moiety", Moiety.class));
        this.property = Collections.unmodifiableList(ValidationSupport.checkList(builder.property, "property", Property.class));
        this.referenceInformation = builder.referenceInformation;
        this.structure = builder.structure;
        this.code = Collections.unmodifiableList(ValidationSupport.checkList(builder.code, "code", Code.class));
        this.name = Collections.unmodifiableList(ValidationSupport.checkList(builder.name, "name", Name.class));
        this.molecularWeight = Collections.unmodifiableList(ValidationSupport.checkList(builder.molecularWeight, "molecularWeight", Structure.Isotope.MolecularWeight.class));
        this.relationship = Collections.unmodifiableList(ValidationSupport.checkList(builder.relationship, "relationship", Relationship.class));
        this.nucleicAcid = builder.nucleicAcid;
        this.polymer = builder.polymer;
        this.protein = builder.protein;
        this.sourceMaterial = builder.sourceMaterial;
        ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
        ValidationSupport.checkReferenceType(this.referenceInformation, "referenceInformation", "SubstanceReferenceInformation");
        ValidationSupport.checkReferenceType(this.nucleicAcid, "nucleicAcid", "SubstanceNucleicAcid");
        ValidationSupport.checkReferenceType(this.polymer, "polymer", "SubstancePolymer");
        ValidationSupport.checkReferenceType(this.protein, "protein", "SubstanceProtein");
        ValidationSupport.checkReferenceType(this.sourceMaterial, "sourceMaterial", "SubstanceSourceMaterial");
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public CodeableConcept getDomain() {
        return this.domain;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Reference> getSource() {
        return this.source;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Moiety> getMoiety() {
        return this.moiety;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    public Reference getReferenceInformation() {
        return this.referenceInformation;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public List<Code> getCode() {
        return this.code;
    }

    public List<Name> getName() {
        return this.name;
    }

    public List<Structure.Isotope.MolecularWeight> getMolecularWeight() {
        return this.molecularWeight;
    }

    public List<Relationship> getRelationship() {
        return this.relationship;
    }

    public Reference getNucleicAcid() {
        return this.nucleicAcid;
    }

    public Reference getPolymer() {
        return this.polymer;
    }

    public Reference getProtein() {
        return this.protein;
    }

    public Reference getSourceMaterial() {
        return this.sourceMaterial;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.type != null || this.status != null || this.domain != null || this.description != null || !this.source.isEmpty() || this.comment != null || !this.moiety.isEmpty() || !this.property.isEmpty() || this.referenceInformation != null || this.structure != null || !this.code.isEmpty() || !this.name.isEmpty() || !this.molecularWeight.isEmpty() || !this.relationship.isEmpty() || this.nucleicAcid != null || this.polymer != null || this.protein != null || this.sourceMaterial != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.domain, "domain", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.source, "source", visitor, Reference.class);
                this.accept(this.comment, "comment", visitor);
                this.accept(this.moiety, "moiety", visitor, Moiety.class);
                this.accept(this.property, "property", visitor, Property.class);
                this.accept(this.referenceInformation, "referenceInformation", visitor);
                this.accept(this.structure, "structure", visitor);
                this.accept(this.code, "code", visitor, Code.class);
                this.accept(this.name, "name", visitor, Name.class);
                this.accept(this.molecularWeight, "molecularWeight", visitor, Structure.Isotope.MolecularWeight.class);
                this.accept(this.relationship, "relationship", visitor, Relationship.class);
                this.accept(this.nucleicAcid, "nucleicAcid", visitor);
                this.accept(this.polymer, "polymer", visitor);
                this.accept(this.protein, "protein", visitor);
                this.accept(this.sourceMaterial, "sourceMaterial", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstanceSpecification other = (SubstanceSpecification)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.status, other.status) && Objects.equals(this.domain, other.domain) && Objects.equals(this.description, other.description) && Objects.equals(this.source, other.source) && Objects.equals(this.comment, other.comment) && Objects.equals(this.moiety, other.moiety) && Objects.equals(this.property, other.property) && Objects.equals(this.referenceInformation, other.referenceInformation) && Objects.equals(this.structure, other.structure) && Objects.equals(this.code, other.code) && Objects.equals(this.name, other.name) && Objects.equals(this.molecularWeight, other.molecularWeight) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.nucleicAcid, other.nucleicAcid) && Objects.equals(this.polymer, other.polymer) && Objects.equals(this.protein, other.protein) && Objects.equals(this.sourceMaterial, other.sourceMaterial);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.type, this.status, this.domain, this.description, this.source, this.comment, this.moiety, this.property, this.referenceInformation, this.structure, this.code, this.name, this.molecularWeight, this.relationship, this.nucleicAcid, this.polymer, this.protein, this.sourceMaterial);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Relationship
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"SubstanceSpecification"})
        @Choice(value={Reference.class, CodeableConcept.class})
        private final Element substance;
        @Summary
        private final CodeableConcept relationship;
        @Summary
        private final Boolean isDefining;
        @Summary
        @Choice(value={Quantity.class, Range.class, Ratio.class, String.class})
        private final Element amount;
        @Summary
        private final Ratio amountRatioLowLimit;
        @Summary
        private final CodeableConcept amountType;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        private volatile int hashCode;

        private Relationship(Builder builder) {
            super(builder);
            this.substance = ValidationSupport.choiceElement(builder.substance, "substance", Reference.class, CodeableConcept.class);
            this.relationship = builder.relationship;
            this.isDefining = builder.isDefining;
            this.amount = ValidationSupport.choiceElement(builder.amount, "amount", Quantity.class, Range.class, Ratio.class, String.class);
            this.amountRatioLowLimit = builder.amountRatioLowLimit;
            this.amountType = builder.amountType;
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            ValidationSupport.checkReferenceType(this.substance, "substance", "SubstanceSpecification");
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Element getSubstance() {
            return this.substance;
        }

        public CodeableConcept getRelationship() {
            return this.relationship;
        }

        public Boolean getIsDefining() {
            return this.isDefining;
        }

        public Element getAmount() {
            return this.amount;
        }

        public Ratio getAmountRatioLowLimit() {
            return this.amountRatioLowLimit;
        }

        public CodeableConcept getAmountType() {
            return this.amountType;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.substance != null || this.relationship != null || this.isDefining != null || this.amount != null || this.amountRatioLowLimit != null || this.amountType != null || !this.source.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.substance, "substance", visitor);
                    this.accept(this.relationship, "relationship", visitor);
                    this.accept(this.isDefining, "isDefining", visitor);
                    this.accept(this.amount, "amount", visitor);
                    this.accept(this.amountRatioLowLimit, "amountRatioLowLimit", visitor);
                    this.accept(this.amountType, "amountType", visitor);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Relationship other = (Relationship)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.substance, other.substance) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.isDefining, other.isDefining) && Objects.equals(this.amount, other.amount) && Objects.equals(this.amountRatioLowLimit, other.amountRatioLowLimit) && Objects.equals(this.amountType, other.amountType) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.substance, this.relationship, this.isDefining, this.amount, this.amountRatioLowLimit, this.amountType, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element substance;
            private CodeableConcept relationship;
            private Boolean isDefining;
            private Element amount;
            private Ratio amountRatioLowLimit;
            private CodeableConcept amountType;
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder substance(Element substance) {
                this.substance = substance;
                return this;
            }

            public Builder relationship(CodeableConcept relationship) {
                this.relationship = relationship;
                return this;
            }

            public Builder isDefining(Boolean isDefining) {
                this.isDefining = isDefining;
                return this;
            }

            public Builder amount(Element amount) {
                this.amount = amount;
                return this;
            }

            public Builder amountRatioLowLimit(Ratio amountRatioLowLimit) {
                this.amountRatioLowLimit = amountRatioLowLimit;
                return this;
            }

            public Builder amountType(CodeableConcept amountType) {
                this.amountType = amountType;
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Relationship build() {
                return new Relationship(this);
            }

            protected Builder from(Relationship relationship) {
                super.from(relationship);
                this.substance = relationship.substance;
                this.relationship = relationship.relationship;
                this.isDefining = relationship.isDefining;
                this.amount = relationship.amount;
                this.amountRatioLowLimit = relationship.amountRatioLowLimit;
                this.amountType = relationship.amountType;
                this.source.addAll(relationship.source);
                return this;
            }
        }
    }

    public static class Name
    extends BackboneElement {
        @Summary
        @Required
        private final String name;
        @Summary
        private final CodeableConcept type;
        @Summary
        private final CodeableConcept status;
        @Summary
        private final Boolean preferred;
        @Summary
        private final List<CodeableConcept> language;
        @Summary
        private final List<CodeableConcept> domain;
        @Summary
        private final List<CodeableConcept> jurisdiction;
        @Summary
        private final List<Name> synonym;
        @Summary
        private final List<Name> translation;
        @Summary
        private final List<Official> official;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        private volatile int hashCode;

        private Name(Builder builder) {
            super(builder);
            this.name = ValidationSupport.requireNonNull(builder.name, "name");
            this.type = builder.type;
            this.status = builder.status;
            this.preferred = builder.preferred;
            this.language = Collections.unmodifiableList(ValidationSupport.checkList(builder.language, "language", CodeableConcept.class));
            this.domain = Collections.unmodifiableList(ValidationSupport.checkList(builder.domain, "domain", CodeableConcept.class));
            this.jurisdiction = Collections.unmodifiableList(ValidationSupport.checkList(builder.jurisdiction, "jurisdiction", CodeableConcept.class));
            this.synonym = Collections.unmodifiableList(ValidationSupport.checkList(builder.synonym, "synonym", Name.class));
            this.translation = Collections.unmodifiableList(ValidationSupport.checkList(builder.translation, "translation", Name.class));
            this.official = Collections.unmodifiableList(ValidationSupport.checkList(builder.official, "official", Official.class));
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public String getName() {
            return this.name;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        public Boolean getPreferred() {
            return this.preferred;
        }

        public List<CodeableConcept> getLanguage() {
            return this.language;
        }

        public List<CodeableConcept> getDomain() {
            return this.domain;
        }

        public List<CodeableConcept> getJurisdiction() {
            return this.jurisdiction;
        }

        public List<Name> getSynonym() {
            return this.synonym;
        }

        public List<Name> getTranslation() {
            return this.translation;
        }

        public List<Official> getOfficial() {
            return this.official;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.type != null || this.status != null || this.preferred != null || !this.language.isEmpty() || !this.domain.isEmpty() || !this.jurisdiction.isEmpty() || !this.synonym.isEmpty() || !this.translation.isEmpty() || !this.official.isEmpty() || !this.source.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.preferred, "preferred", visitor);
                    this.accept(this.language, "language", visitor, CodeableConcept.class);
                    this.accept(this.domain, "domain", visitor, CodeableConcept.class);
                    this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                    this.accept(this.synonym, "synonym", visitor, Name.class);
                    this.accept(this.translation, "translation", visitor, Name.class);
                    this.accept(this.official, "official", visitor, Official.class);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Name other = (Name)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.status, other.status) && Objects.equals(this.preferred, other.preferred) && Objects.equals(this.language, other.language) && Objects.equals(this.domain, other.domain) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.synonym, other.synonym) && Objects.equals(this.translation, other.translation) && Objects.equals(this.official, other.official) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.type, this.status, this.preferred, this.language, this.domain, this.jurisdiction, this.synonym, this.translation, this.official, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Official
        extends BackboneElement {
            @Summary
            private final CodeableConcept authority;
            @Summary
            private final CodeableConcept status;
            @Summary
            private final DateTime date;
            private volatile int hashCode;

            private Official(Builder builder) {
                super(builder);
                this.authority = builder.authority;
                this.status = builder.status;
                this.date = builder.date;
                ValidationSupport.requireValueOrChildren(this);
            }

            public CodeableConcept getAuthority() {
                return this.authority;
            }

            public CodeableConcept getStatus() {
                return this.status;
            }

            public DateTime getDate() {
                return this.date;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.authority != null || this.status != null || this.date != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.authority, "authority", visitor);
                        this.accept(this.status, "status", visitor);
                        this.accept(this.date, "date", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Official other = (Official)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.authority, other.authority) && Objects.equals(this.status, other.status) && Objects.equals(this.date, other.date);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.authority, this.status, this.date);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept authority;
                private CodeableConcept status;
                private DateTime date;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder authority(CodeableConcept authority) {
                    this.authority = authority;
                    return this;
                }

                public Builder status(CodeableConcept status) {
                    this.status = status;
                    return this;
                }

                public Builder date(DateTime date) {
                    this.date = date;
                    return this;
                }

                @Override
                public Official build() {
                    return new Official(this);
                }

                protected Builder from(Official official) {
                    super.from(official);
                    this.authority = official.authority;
                    this.status = official.status;
                    this.date = official.date;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private CodeableConcept type;
            private CodeableConcept status;
            private Boolean preferred;
            private List<CodeableConcept> language = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> domain = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
            private List<Name> synonym = new ArrayList<Name>();
            private List<Name> translation = new ArrayList<Name>();
            private List<Official> official = new ArrayList<Official>();
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            public Builder preferred(Boolean preferred) {
                this.preferred = preferred;
                return this;
            }

            public Builder language(CodeableConcept ... language) {
                for (CodeableConcept value : language) {
                    this.language.add(value);
                }
                return this;
            }

            public Builder language(Collection<CodeableConcept> language) {
                this.language = new ArrayList<CodeableConcept>(language);
                return this;
            }

            public Builder domain(CodeableConcept ... domain) {
                for (CodeableConcept value : domain) {
                    this.domain.add(value);
                }
                return this;
            }

            public Builder domain(Collection<CodeableConcept> domain) {
                this.domain = new ArrayList<CodeableConcept>(domain);
                return this;
            }

            public Builder jurisdiction(CodeableConcept ... jurisdiction) {
                for (CodeableConcept value : jurisdiction) {
                    this.jurisdiction.add(value);
                }
                return this;
            }

            public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
                this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
                return this;
            }

            public Builder synonym(Name ... synonym) {
                for (Name value : synonym) {
                    this.synonym.add(value);
                }
                return this;
            }

            public Builder synonym(Collection<Name> synonym) {
                this.synonym = new ArrayList<Name>(synonym);
                return this;
            }

            public Builder translation(Name ... translation) {
                for (Name value : translation) {
                    this.translation.add(value);
                }
                return this;
            }

            public Builder translation(Collection<Name> translation) {
                this.translation = new ArrayList<Name>(translation);
                return this;
            }

            public Builder official(Official ... official) {
                for (Official value : official) {
                    this.official.add(value);
                }
                return this;
            }

            public Builder official(Collection<Official> official) {
                this.official = new ArrayList<Official>(official);
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Name build() {
                return new Name(this);
            }

            protected Builder from(Name name) {
                super.from(name);
                this.name = name.name;
                this.type = name.type;
                this.status = name.status;
                this.preferred = name.preferred;
                this.language.addAll(name.language);
                this.domain.addAll(name.domain);
                this.jurisdiction.addAll(name.jurisdiction);
                this.synonym.addAll(name.synonym);
                this.translation.addAll(name.translation);
                this.official.addAll(name.official);
                this.source.addAll(name.source);
                return this;
            }
        }
    }

    public static class Code
    extends BackboneElement {
        @Summary
        private final CodeableConcept code;
        @Summary
        private final CodeableConcept status;
        @Summary
        private final DateTime statusDate;
        @Summary
        private final String comment;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        private volatile int hashCode;

        private Code(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.status = builder.status;
            this.statusDate = builder.statusDate;
            this.comment = builder.comment;
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        public DateTime getStatusDate() {
            return this.statusDate;
        }

        public String getComment() {
            return this.comment;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.status != null || this.statusDate != null || this.comment != null || !this.source.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.statusDate, "statusDate", visitor);
                    this.accept(this.comment, "comment", visitor);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Code other = (Code)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.status, other.status) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.comment, other.comment) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.status, this.statusDate, this.comment, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private CodeableConcept status;
            private DateTime statusDate;
            private String comment;
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            public Builder statusDate(DateTime statusDate) {
                this.statusDate = statusDate;
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Code build() {
                return new Code(this);
            }

            protected Builder from(Code code) {
                super.from(code);
                this.code = code.code;
                this.status = code.status;
                this.statusDate = code.statusDate;
                this.comment = code.comment;
                this.source.addAll(code.source);
                return this;
            }
        }
    }

    public static class Structure
    extends BackboneElement {
        @Summary
        private final CodeableConcept stereochemistry;
        @Summary
        private final CodeableConcept opticalActivity;
        @Summary
        private final String molecularFormula;
        @Summary
        private final String molecularFormulaByMoiety;
        @Summary
        private final List<Isotope> isotope;
        @Summary
        private final Isotope.MolecularWeight molecularWeight;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;
        @Summary
        private final List<Representation> representation;
        private volatile int hashCode;

        private Structure(Builder builder) {
            super(builder);
            this.stereochemistry = builder.stereochemistry;
            this.opticalActivity = builder.opticalActivity;
            this.molecularFormula = builder.molecularFormula;
            this.molecularFormulaByMoiety = builder.molecularFormulaByMoiety;
            this.isotope = Collections.unmodifiableList(ValidationSupport.checkList(builder.isotope, "isotope", Isotope.class));
            this.molecularWeight = builder.molecularWeight;
            this.source = Collections.unmodifiableList(ValidationSupport.checkList(builder.source, "source", Reference.class));
            this.representation = Collections.unmodifiableList(ValidationSupport.checkList(builder.representation, "representation", Representation.class));
            ValidationSupport.checkReferenceType(this.source, "source", "DocumentReference");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getStereochemistry() {
            return this.stereochemistry;
        }

        public CodeableConcept getOpticalActivity() {
            return this.opticalActivity;
        }

        public String getMolecularFormula() {
            return this.molecularFormula;
        }

        public String getMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety;
        }

        public List<Isotope> getIsotope() {
            return this.isotope;
        }

        public Isotope.MolecularWeight getMolecularWeight() {
            return this.molecularWeight;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        public List<Representation> getRepresentation() {
            return this.representation;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.stereochemistry != null || this.opticalActivity != null || this.molecularFormula != null || this.molecularFormulaByMoiety != null || !this.isotope.isEmpty() || this.molecularWeight != null || !this.source.isEmpty() || !this.representation.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.stereochemistry, "stereochemistry", visitor);
                    this.accept(this.opticalActivity, "opticalActivity", visitor);
                    this.accept(this.molecularFormula, "molecularFormula", visitor);
                    this.accept(this.molecularFormulaByMoiety, "molecularFormulaByMoiety", visitor);
                    this.accept(this.isotope, "isotope", visitor, Isotope.class);
                    this.accept(this.molecularWeight, "molecularWeight", visitor);
                    this.accept(this.source, "source", visitor, Reference.class);
                    this.accept(this.representation, "representation", visitor, Representation.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Structure other = (Structure)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.stereochemistry, other.stereochemistry) && Objects.equals(this.opticalActivity, other.opticalActivity) && Objects.equals(this.molecularFormula, other.molecularFormula) && Objects.equals(this.molecularFormulaByMoiety, other.molecularFormulaByMoiety) && Objects.equals(this.isotope, other.isotope) && Objects.equals(this.molecularWeight, other.molecularWeight) && Objects.equals(this.source, other.source) && Objects.equals(this.representation, other.representation);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.molecularFormulaByMoiety, this.isotope, this.molecularWeight, this.source, this.representation);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Representation
        extends BackboneElement {
            @Summary
            private final CodeableConcept type;
            @Summary
            private final String representation;
            @Summary
            private final Attachment attachment;
            private volatile int hashCode;

            private Representation(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.representation = builder.representation;
                this.attachment = builder.attachment;
                ValidationSupport.requireValueOrChildren(this);
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public String getRepresentation() {
                return this.representation;
            }

            public Attachment getAttachment() {
                return this.attachment;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.representation != null || this.attachment != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.representation, "representation", visitor);
                        this.accept(this.attachment, "attachment", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Representation other = (Representation)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.representation, other.representation) && Objects.equals(this.attachment, other.attachment);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.representation, this.attachment);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private String representation;
                private Attachment attachment;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder representation(String representation) {
                    this.representation = representation;
                    return this;
                }

                public Builder attachment(Attachment attachment) {
                    this.attachment = attachment;
                    return this;
                }

                @Override
                public Representation build() {
                    return new Representation(this);
                }

                protected Builder from(Representation representation) {
                    super.from(representation);
                    this.type = representation.type;
                    this.representation = representation.representation;
                    this.attachment = representation.attachment;
                    return this;
                }
            }
        }

        public static class Isotope
        extends BackboneElement {
            @Summary
            private final Identifier identifier;
            @Summary
            private final CodeableConcept name;
            @Summary
            private final CodeableConcept substitution;
            @Summary
            private final Quantity halfLife;
            @Summary
            private final MolecularWeight molecularWeight;
            private volatile int hashCode;

            private Isotope(Builder builder) {
                super(builder);
                this.identifier = builder.identifier;
                this.name = builder.name;
                this.substitution = builder.substitution;
                this.halfLife = builder.halfLife;
                this.molecularWeight = builder.molecularWeight;
                ValidationSupport.requireValueOrChildren(this);
            }

            public Identifier getIdentifier() {
                return this.identifier;
            }

            public CodeableConcept getName() {
                return this.name;
            }

            public CodeableConcept getSubstitution() {
                return this.substitution;
            }

            public Quantity getHalfLife() {
                return this.halfLife;
            }

            public MolecularWeight getMolecularWeight() {
                return this.molecularWeight;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.identifier != null || this.name != null || this.substitution != null || this.halfLife != null || this.molecularWeight != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.identifier, "identifier", visitor);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.substitution, "substitution", visitor);
                        this.accept(this.halfLife, "halfLife", visitor);
                        this.accept(this.molecularWeight, "molecularWeight", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Isotope other = (Isotope)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.substitution, other.substitution) && Objects.equals(this.halfLife, other.halfLife) && Objects.equals(this.molecularWeight, other.molecularWeight);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.name, this.substitution, this.halfLife, this.molecularWeight);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class MolecularWeight
            extends BackboneElement {
                @Summary
                private final CodeableConcept method;
                @Summary
                private final CodeableConcept type;
                @Summary
                private final Quantity amount;
                private volatile int hashCode;

                private MolecularWeight(Builder builder) {
                    super(builder);
                    this.method = builder.method;
                    this.type = builder.type;
                    this.amount = builder.amount;
                    ValidationSupport.requireValueOrChildren(this);
                }

                public CodeableConcept getMethod() {
                    return this.method;
                }

                public CodeableConcept getType() {
                    return this.type;
                }

                public Quantity getAmount() {
                    return this.amount;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.method != null || this.type != null || this.amount != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.method, "method", visitor);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.amount, "amount", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    MolecularWeight other = (MolecularWeight)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.method, other.method) && Objects.equals(this.type, other.type) && Objects.equals(this.amount, other.amount);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.method, this.type, this.amount);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept method;
                    private CodeableConcept type;
                    private Quantity amount;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder method(CodeableConcept method) {
                        this.method = method;
                        return this;
                    }

                    public Builder type(CodeableConcept type) {
                        this.type = type;
                        return this;
                    }

                    public Builder amount(Quantity amount) {
                        this.amount = amount;
                        return this;
                    }

                    @Override
                    public MolecularWeight build() {
                        return new MolecularWeight(this);
                    }

                    protected Builder from(MolecularWeight molecularWeight) {
                        super.from(molecularWeight);
                        this.method = molecularWeight.method;
                        this.type = molecularWeight.type;
                        this.amount = molecularWeight.amount;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Identifier identifier;
                private CodeableConcept name;
                private CodeableConcept substitution;
                private Quantity halfLife;
                private MolecularWeight molecularWeight;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder identifier(Identifier identifier) {
                    this.identifier = identifier;
                    return this;
                }

                public Builder name(CodeableConcept name) {
                    this.name = name;
                    return this;
                }

                public Builder substitution(CodeableConcept substitution) {
                    this.substitution = substitution;
                    return this;
                }

                public Builder halfLife(Quantity halfLife) {
                    this.halfLife = halfLife;
                    return this;
                }

                public Builder molecularWeight(MolecularWeight molecularWeight) {
                    this.molecularWeight = molecularWeight;
                    return this;
                }

                @Override
                public Isotope build() {
                    return new Isotope(this);
                }

                protected Builder from(Isotope isotope) {
                    super.from(isotope);
                    this.identifier = isotope.identifier;
                    this.name = isotope.name;
                    this.substitution = isotope.substitution;
                    this.halfLife = isotope.halfLife;
                    this.molecularWeight = isotope.molecularWeight;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept stereochemistry;
            private CodeableConcept opticalActivity;
            private String molecularFormula;
            private String molecularFormulaByMoiety;
            private List<Isotope> isotope = new ArrayList<Isotope>();
            private Isotope.MolecularWeight molecularWeight;
            private List<Reference> source = new ArrayList<Reference>();
            private List<Representation> representation = new ArrayList<Representation>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder stereochemistry(CodeableConcept stereochemistry) {
                this.stereochemistry = stereochemistry;
                return this;
            }

            public Builder opticalActivity(CodeableConcept opticalActivity) {
                this.opticalActivity = opticalActivity;
                return this;
            }

            public Builder molecularFormula(String molecularFormula) {
                this.molecularFormula = molecularFormula;
                return this;
            }

            public Builder molecularFormulaByMoiety(String molecularFormulaByMoiety) {
                this.molecularFormulaByMoiety = molecularFormulaByMoiety;
                return this;
            }

            public Builder isotope(Isotope ... isotope) {
                for (Isotope value : isotope) {
                    this.isotope.add(value);
                }
                return this;
            }

            public Builder isotope(Collection<Isotope> isotope) {
                this.isotope = new ArrayList<Isotope>(isotope);
                return this;
            }

            public Builder molecularWeight(Isotope.MolecularWeight molecularWeight) {
                this.molecularWeight = molecularWeight;
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            public Builder representation(Representation ... representation) {
                for (Representation value : representation) {
                    this.representation.add(value);
                }
                return this;
            }

            public Builder representation(Collection<Representation> representation) {
                this.representation = new ArrayList<Representation>(representation);
                return this;
            }

            @Override
            public Structure build() {
                return new Structure(this);
            }

            protected Builder from(Structure structure) {
                super.from(structure);
                this.stereochemistry = structure.stereochemistry;
                this.opticalActivity = structure.opticalActivity;
                this.molecularFormula = structure.molecularFormula;
                this.molecularFormulaByMoiety = structure.molecularFormulaByMoiety;
                this.isotope.addAll(structure.isotope);
                this.molecularWeight = structure.molecularWeight;
                this.source.addAll(structure.source);
                this.representation.addAll(structure.representation);
                return this;
            }
        }
    }

    public static class Property
    extends BackboneElement {
        @Summary
        private final CodeableConcept category;
        @Summary
        private final CodeableConcept code;
        @Summary
        private final String parameters;
        @Summary
        @ReferenceTarget(value={"SubstanceSpecification", "Substance"})
        @Choice(value={Reference.class, CodeableConcept.class})
        private final Element definingSubstance;
        @Summary
        @Choice(value={Quantity.class, String.class})
        private final Element amount;
        private volatile int hashCode;

        private Property(Builder builder) {
            super(builder);
            this.category = builder.category;
            this.code = builder.code;
            this.parameters = builder.parameters;
            this.definingSubstance = ValidationSupport.choiceElement(builder.definingSubstance, "definingSubstance", Reference.class, CodeableConcept.class);
            this.amount = ValidationSupport.choiceElement(builder.amount, "amount", Quantity.class, String.class);
            ValidationSupport.checkReferenceType(this.definingSubstance, "definingSubstance", "SubstanceSpecification", "Substance");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getCategory() {
            return this.category;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public String getParameters() {
            return this.parameters;
        }

        public Element getDefiningSubstance() {
            return this.definingSubstance;
        }

        public Element getAmount() {
            return this.amount;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.category != null || this.code != null || this.parameters != null || this.definingSubstance != null || this.amount != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.parameters, "parameters", visitor);
                    this.accept(this.definingSubstance, "definingSubstance", visitor);
                    this.accept(this.amount, "amount", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.definingSubstance, other.definingSubstance) && Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.category, this.code, this.parameters, this.definingSubstance, this.amount);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept category;
            private CodeableConcept code;
            private String parameters;
            private Element definingSubstance;
            private Element amount;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder category(CodeableConcept category) {
                this.category = category;
                return this;
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder parameters(String parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder definingSubstance(Element definingSubstance) {
                this.definingSubstance = definingSubstance;
                return this;
            }

            public Builder amount(Element amount) {
                this.amount = amount;
                return this;
            }

            @Override
            public Property build() {
                return new Property(this);
            }

            protected Builder from(Property property) {
                super.from(property);
                this.category = property.category;
                this.code = property.code;
                this.parameters = property.parameters;
                this.definingSubstance = property.definingSubstance;
                this.amount = property.amount;
                return this;
            }
        }
    }

    public static class Moiety
    extends BackboneElement {
        @Summary
        private final CodeableConcept role;
        @Summary
        private final Identifier identifier;
        @Summary
        private final String name;
        @Summary
        private final CodeableConcept stereochemistry;
        @Summary
        private final CodeableConcept opticalActivity;
        @Summary
        private final String molecularFormula;
        @Summary
        @Choice(value={Quantity.class, String.class})
        private final Element amount;
        private volatile int hashCode;

        private Moiety(Builder builder) {
            super(builder);
            this.role = builder.role;
            this.identifier = builder.identifier;
            this.name = builder.name;
            this.stereochemistry = builder.stereochemistry;
            this.opticalActivity = builder.opticalActivity;
            this.molecularFormula = builder.molecularFormula;
            this.amount = ValidationSupport.choiceElement(builder.amount, "amount", Quantity.class, String.class);
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }

        public CodeableConcept getStereochemistry() {
            return this.stereochemistry;
        }

        public CodeableConcept getOpticalActivity() {
            return this.opticalActivity;
        }

        public String getMolecularFormula() {
            return this.molecularFormula;
        }

        public Element getAmount() {
            return this.amount;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.role != null || this.identifier != null || this.name != null || this.stereochemistry != null || this.opticalActivity != null || this.molecularFormula != null || this.amount != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.stereochemistry, "stereochemistry", visitor);
                    this.accept(this.opticalActivity, "opticalActivity", visitor);
                    this.accept(this.molecularFormula, "molecularFormula", visitor);
                    this.accept(this.amount, "amount", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Moiety other = (Moiety)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.role, other.role) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.stereochemistry, other.stereochemistry) && Objects.equals(this.opticalActivity, other.opticalActivity) && Objects.equals(this.molecularFormula, other.molecularFormula) && Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.role, this.identifier, this.name, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.amount);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept role;
            private Identifier identifier;
            private String name;
            private CodeableConcept stereochemistry;
            private CodeableConcept opticalActivity;
            private String molecularFormula;
            private Element amount;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder role(CodeableConcept role) {
                this.role = role;
                return this;
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder stereochemistry(CodeableConcept stereochemistry) {
                this.stereochemistry = stereochemistry;
                return this;
            }

            public Builder opticalActivity(CodeableConcept opticalActivity) {
                this.opticalActivity = opticalActivity;
                return this;
            }

            public Builder molecularFormula(String molecularFormula) {
                this.molecularFormula = molecularFormula;
                return this;
            }

            public Builder amount(Element amount) {
                this.amount = amount;
                return this;
            }

            @Override
            public Moiety build() {
                return new Moiety(this);
            }

            protected Builder from(Moiety moiety) {
                super.from(moiety);
                this.role = moiety.role;
                this.identifier = moiety.identifier;
                this.name = moiety.name;
                this.stereochemistry = moiety.stereochemistry;
                this.opticalActivity = moiety.opticalActivity;
                this.molecularFormula = moiety.molecularFormula;
                this.amount = moiety.amount;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private CodeableConcept type;
        private CodeableConcept status;
        private CodeableConcept domain;
        private String description;
        private List<Reference> source = new ArrayList<Reference>();
        private String comment;
        private List<Moiety> moiety = new ArrayList<Moiety>();
        private List<Property> property = new ArrayList<Property>();
        private Reference referenceInformation;
        private Structure structure;
        private List<Code> code = new ArrayList<Code>();
        private List<Name> name = new ArrayList<Name>();
        private List<Structure.Isotope.MolecularWeight> molecularWeight = new ArrayList<Structure.Isotope.MolecularWeight>();
        private List<Relationship> relationship = new ArrayList<Relationship>();
        private Reference nucleicAcid;
        private Reference polymer;
        private Reference protein;
        private Reference sourceMaterial;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(com.ibm.fhir.model.type.Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder domain(CodeableConcept domain) {
            this.domain = domain;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder source(Reference ... source) {
            for (Reference value : source) {
                this.source.add(value);
            }
            return this;
        }

        public Builder source(Collection<Reference> source) {
            this.source = new ArrayList<Reference>(source);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder moiety(Moiety ... moiety) {
            for (Moiety value : moiety) {
                this.moiety.add(value);
            }
            return this;
        }

        public Builder moiety(Collection<Moiety> moiety) {
            this.moiety = new ArrayList<Moiety>(moiety);
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        public Builder referenceInformation(Reference referenceInformation) {
            this.referenceInformation = referenceInformation;
            return this;
        }

        public Builder structure(Structure structure) {
            this.structure = structure;
            return this;
        }

        public Builder code(Code ... code) {
            for (Code value : code) {
                this.code.add(value);
            }
            return this;
        }

        public Builder code(Collection<Code> code) {
            this.code = new ArrayList<Code>(code);
            return this;
        }

        public Builder name(Name ... name) {
            for (Name value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<Name> name) {
            this.name = new ArrayList<Name>(name);
            return this;
        }

        public Builder molecularWeight(Structure.Isotope.MolecularWeight ... molecularWeight) {
            for (Structure.Isotope.MolecularWeight value : molecularWeight) {
                this.molecularWeight.add(value);
            }
            return this;
        }

        public Builder molecularWeight(Collection<Structure.Isotope.MolecularWeight> molecularWeight) {
            this.molecularWeight = new ArrayList<Structure.Isotope.MolecularWeight>(molecularWeight);
            return this;
        }

        public Builder relationship(Relationship ... relationship) {
            for (Relationship value : relationship) {
                this.relationship.add(value);
            }
            return this;
        }

        public Builder relationship(Collection<Relationship> relationship) {
            this.relationship = new ArrayList<Relationship>(relationship);
            return this;
        }

        public Builder nucleicAcid(Reference nucleicAcid) {
            this.nucleicAcid = nucleicAcid;
            return this;
        }

        public Builder polymer(Reference polymer) {
            this.polymer = polymer;
            return this;
        }

        public Builder protein(Reference protein) {
            this.protein = protein;
            return this;
        }

        public Builder sourceMaterial(Reference sourceMaterial) {
            this.sourceMaterial = sourceMaterial;
            return this;
        }

        @Override
        public SubstanceSpecification build() {
            return new SubstanceSpecification(this);
        }

        protected Builder from(SubstanceSpecification substanceSpecification) {
            super.from(substanceSpecification);
            this.identifier = substanceSpecification.identifier;
            this.type = substanceSpecification.type;
            this.status = substanceSpecification.status;
            this.domain = substanceSpecification.domain;
            this.description = substanceSpecification.description;
            this.source.addAll(substanceSpecification.source);
            this.comment = substanceSpecification.comment;
            this.moiety.addAll(substanceSpecification.moiety);
            this.property.addAll(substanceSpecification.property);
            this.referenceInformation = substanceSpecification.referenceInformation;
            this.structure = substanceSpecification.structure;
            this.code.addAll(substanceSpecification.code);
            this.name.addAll(substanceSpecification.name);
            this.molecularWeight.addAll(substanceSpecification.molecularWeight);
            this.relationship.addAll(substanceSpecification.relationship);
            this.nucleicAcid = substanceSpecification.nucleicAcid;
            this.polymer = substanceSpecification.polymer;
            this.protein = substanceSpecification.protein;
            this.sourceMaterial = substanceSpecification.sourceMaterial;
            return this;
        }
    }
}

