/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.SupplyDeliveryStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.ValueSet.TRIAL_USE)
public class SupplyDelivery
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"SupplyRequest"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"SupplyDelivery", "Contract"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="SupplyDeliveryStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Status of the supply delivery.", valueSet="http://hl7.org/fhir/ValueSet/supplydelivery-status|4.0.1")
    private final SupplyDeliveryStatus status;
    @ReferenceTarget(value={"Patient"})
    private final Reference patient;
    @Binding(bindingName="SupplyDeliveryType", strength=BindingStrength.ValueSet.REQUIRED, description="The type of supply dispense.", valueSet="http://hl7.org/fhir/ValueSet/supplydelivery-type|4.0.1")
    private final CodeableConcept type;
    private final SuppliedItem suppliedItem;
    @Summary
    @Choice(value={DateTime.class, Period.class, Timing.class})
    private final Element occurrence;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference supplier;
    @ReferenceTarget(value={"Location"})
    private final Reference destination;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final List<Reference> receiver;
    private volatile int hashCode;

    private SupplyDelivery(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.partOf = Collections.unmodifiableList(ValidationSupport.checkList(builder.partOf, "partOf", Reference.class));
        this.status = builder.status;
        this.patient = builder.patient;
        this.type = builder.type;
        this.suppliedItem = builder.suppliedItem;
        this.occurrence = ValidationSupport.choiceElement(builder.occurrence, "occurrence", DateTime.class, Period.class, Timing.class);
        this.supplier = builder.supplier;
        this.destination = builder.destination;
        this.receiver = Collections.unmodifiableList(ValidationSupport.checkList(builder.receiver, "receiver", Reference.class));
        ValidationSupport.checkValueSetBinding(this.type, "type", "http://hl7.org/fhir/ValueSet/supplydelivery-type", "http://terminology.hl7.org/CodeSystem/supply-item-type", "medication", "device");
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "SupplyRequest");
        ValidationSupport.checkReferenceType(this.partOf, "partOf", "SupplyDelivery", "Contract");
        ValidationSupport.checkReferenceType(this.patient, "patient", "Patient");
        ValidationSupport.checkReferenceType(this.supplier, "supplier", "Practitioner", "PractitionerRole", "Organization");
        ValidationSupport.checkReferenceType(this.destination, "destination", "Location");
        ValidationSupport.checkReferenceType(this.receiver, "receiver", "Practitioner", "PractitionerRole");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public SupplyDeliveryStatus getStatus() {
        return this.status;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public SuppliedItem getSuppliedItem() {
        return this.suppliedItem;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public Reference getSupplier() {
        return this.supplier;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public List<Reference> getReceiver() {
        return this.receiver;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.basedOn.isEmpty() || !this.partOf.isEmpty() || this.status != null || this.patient != null || this.type != null || this.suppliedItem != null || this.occurrence != null || this.supplier != null || this.destination != null || !this.receiver.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.suppliedItem, "suppliedItem", visitor);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.supplier, "supplier", visitor);
                this.accept(this.destination, "destination", visitor);
                this.accept(this.receiver, "receiver", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupplyDelivery other = (SupplyDelivery)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.patient, other.patient) && Objects.equals(this.type, other.type) && Objects.equals(this.suppliedItem, other.suppliedItem) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.supplier, other.supplier) && Objects.equals(this.destination, other.destination) && Objects.equals(this.receiver, other.receiver);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.partOf, this.status, this.patient, this.type, this.suppliedItem, this.occurrence, this.supplier, this.destination, this.receiver);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SuppliedItem
    extends BackboneElement {
        private final SimpleQuantity quantity;
        @ReferenceTarget(value={"Medication", "Substance", "Device"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Binding(bindingName="SupplyDeliveryItem", strength=BindingStrength.ValueSet.EXAMPLE, description="The item that was delivered.", valueSet="http://hl7.org/fhir/ValueSet/supply-item")
        private final Element item;
        private volatile int hashCode;

        private SuppliedItem(Builder builder) {
            super(builder);
            this.quantity = builder.quantity;
            this.item = ValidationSupport.choiceElement(builder.item, "item", CodeableConcept.class, Reference.class);
            ValidationSupport.checkReferenceType(this.item, "item", "Medication", "Substance", "Device");
            ValidationSupport.requireValueOrChildren(this);
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public Element getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.quantity != null || this.item != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.item, "item", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuppliedItem other = (SuppliedItem)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.quantity, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private SimpleQuantity quantity;
            private Element item;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder item(Element item) {
                this.item = item;
                return this;
            }

            @Override
            public SuppliedItem build() {
                return new SuppliedItem(this);
            }

            protected Builder from(SuppliedItem suppliedItem) {
                super.from(suppliedItem);
                this.quantity = suppliedItem.quantity;
                this.item = suppliedItem.item;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private SupplyDeliveryStatus status;
        private Reference patient;
        private CodeableConcept type;
        private SuppliedItem suppliedItem;
        private Element occurrence;
        private Reference supplier;
        private Reference destination;
        private List<Reference> receiver = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(SupplyDeliveryStatus status) {
            this.status = status;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder suppliedItem(SuppliedItem suppliedItem) {
            this.suppliedItem = suppliedItem;
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder supplier(Reference supplier) {
            this.supplier = supplier;
            return this;
        }

        public Builder destination(Reference destination) {
            this.destination = destination;
            return this;
        }

        public Builder receiver(Reference ... receiver) {
            for (Reference value : receiver) {
                this.receiver.add(value);
            }
            return this;
        }

        public Builder receiver(Collection<Reference> receiver) {
            this.receiver = new ArrayList<Reference>(receiver);
            return this;
        }

        @Override
        public SupplyDelivery build() {
            return new SupplyDelivery(this);
        }

        protected Builder from(SupplyDelivery supplyDelivery) {
            super.from(supplyDelivery);
            this.identifier.addAll(supplyDelivery.identifier);
            this.basedOn.addAll(supplyDelivery.basedOn);
            this.partOf.addAll(supplyDelivery.partOf);
            this.status = supplyDelivery.status;
            this.patient = supplyDelivery.patient;
            this.type = supplyDelivery.type;
            this.suppliedItem = supplyDelivery.suppliedItem;
            this.occurrence = supplyDelivery.occurrence;
            this.supplier = supplyDelivery.supplier;
            this.destination = supplyDelivery.destination;
            this.receiver.addAll(supplyDelivery.receiver);
            return this;
        }
    }
}

