/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Contributor;
import com.ibm.fhir.model.type.Count;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Distance;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Oid;
import com.ibm.fhir.model.type.ParameterDefinition;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.SampledData;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.TriggerDefinition;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.Uuid;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.TaskIntent;
import com.ibm.fhir.model.type.code.TaskPriority;
import com.ibm.fhir.model.type.code.TaskStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="inv-1", level="Rule", location="(base)", description="Last modified date must be greater than or equal to authored-on date.", expression="lastModified.exists().not() or authoredOn.exists().not() or lastModified >= authoredOn"), @Constraint(id="task-2", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/performer-role", expression="performerType.exists() implies (performerType.all(memberOf('http://hl7.org/fhir/ValueSet/performer-role', 'preferred')))", generated=true)})
public class Task
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    private final Canonical instantiatesCanonical;
    @Summary
    private final Uri instantiatesUri;
    @Summary
    private final List<Reference> basedOn;
    @Summary
    private final Identifier groupIdentifier;
    @Summary
    @ReferenceTarget(value={"Task"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="TaskStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The current status of the task.", valueSet="http://hl7.org/fhir/ValueSet/task-status|4.0.1")
    @Required
    private final TaskStatus status;
    @Summary
    @Binding(bindingName="TaskStatusReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes to identify the reason for current status.  These will typically be specific to a particular workflow.")
    private final CodeableConcept statusReason;
    @Summary
    @Binding(bindingName="TaskBusinessStatus", strength=BindingStrength.ValueSet.EXAMPLE, description="The domain-specific business-contextual sub-state of the task.  For example: \"Blood drawn\", \"IV inserted\", \"Awaiting physician signature\", etc.")
    private final CodeableConcept businessStatus;
    @Summary
    @Binding(bindingName="TaskIntent", strength=BindingStrength.ValueSet.REQUIRED, description="Distinguishes whether the task is a proposal, plan or full order.", valueSet="http://hl7.org/fhir/ValueSet/task-intent|4.0.1")
    @Required
    private final TaskIntent intent;
    @Binding(bindingName="TaskPriority", strength=BindingStrength.ValueSet.REQUIRED, description="The task's priority.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.0.1")
    private final TaskPriority priority;
    @Summary
    @Binding(bindingName="TaskCode", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes to identify what the task involves.  These will typically be specific to a particular workflow.", valueSet="http://hl7.org/fhir/ValueSet/task-code")
    private final CodeableConcept code;
    @Summary
    private final String description;
    @Summary
    private final Reference focus;
    @Summary
    private final Reference _for;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    private final Period executionPeriod;
    private final DateTime authoredOn;
    @Summary
    private final DateTime lastModified;
    @Summary
    @ReferenceTarget(value={"Device", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
    private final Reference requester;
    @Binding(bindingName="TaskPerformerType", strength=BindingStrength.ValueSet.PREFERRED, description="The type(s) of task performers allowed.", valueSet="http://hl7.org/fhir/ValueSet/performer-role")
    private final List<CodeableConcept> performerType;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam", "HealthcareService", "Patient", "Device", "RelatedPerson"})
    private final Reference owner;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    @Binding(bindingName="TaskReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Indicates why the task is needed.  E.g. Suspended because patient admitted to hospital.")
    private final CodeableConcept reasonCode;
    private final Reference reasonReference;
    @ReferenceTarget(value={"Coverage", "ClaimResponse"})
    private final List<Reference> insurance;
    private final List<Annotation> note;
    @ReferenceTarget(value={"Provenance"})
    private final List<Reference> relevantHistory;
    private final Restriction restriction;
    private final List<Input> input;
    private final List<Output> output;
    private volatile int hashCode;

    private Task(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.instantiatesCanonical = builder.instantiatesCanonical;
        this.instantiatesUri = builder.instantiatesUri;
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.groupIdentifier = builder.groupIdentifier;
        this.partOf = Collections.unmodifiableList(ValidationSupport.checkList(builder.partOf, "partOf", Reference.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.statusReason = builder.statusReason;
        this.businessStatus = builder.businessStatus;
        this.intent = ValidationSupport.requireNonNull(builder.intent, "intent");
        this.priority = builder.priority;
        this.code = builder.code;
        this.description = builder.description;
        this.focus = builder.focus;
        this._for = builder._for;
        this.encounter = builder.encounter;
        this.executionPeriod = builder.executionPeriod;
        this.authoredOn = builder.authoredOn;
        this.lastModified = builder.lastModified;
        this.requester = builder.requester;
        this.performerType = Collections.unmodifiableList(ValidationSupport.checkList(builder.performerType, "performerType", CodeableConcept.class));
        this.owner = builder.owner;
        this.location = builder.location;
        this.reasonCode = builder.reasonCode;
        this.reasonReference = builder.reasonReference;
        this.insurance = Collections.unmodifiableList(ValidationSupport.checkList(builder.insurance, "insurance", Reference.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.relevantHistory = Collections.unmodifiableList(ValidationSupport.checkList(builder.relevantHistory, "relevantHistory", Reference.class));
        this.restriction = builder.restriction;
        this.input = Collections.unmodifiableList(ValidationSupport.checkList(builder.input, "input", Input.class));
        this.output = Collections.unmodifiableList(ValidationSupport.checkList(builder.output, "output", Output.class));
        ValidationSupport.checkReferenceType(this.partOf, "partOf", "Task");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.requester, "requester", "Device", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
        ValidationSupport.checkReferenceType(this.owner, "owner", "Practitioner", "PractitionerRole", "Organization", "CareTeam", "HealthcareService", "Patient", "Device", "RelatedPerson");
        ValidationSupport.checkReferenceType(this.location, "location", "Location");
        ValidationSupport.checkReferenceType(this.insurance, "insurance", "Coverage", "ClaimResponse");
        ValidationSupport.checkReferenceType(this.relevantHistory, "relevantHistory", "Provenance");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Canonical getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public Uri getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public Identifier getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getBusinessStatus() {
        return this.businessStatus;
    }

    public TaskIntent getIntent() {
        return this.intent;
    }

    public TaskPriority getPriority() {
        return this.priority;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Reference getFocus() {
        return this.focus;
    }

    public Reference getFor() {
        return this._for;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Period getExecutionPeriod() {
        return this.executionPeriod;
    }

    public DateTime getAuthoredOn() {
        return this.authoredOn;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public List<CodeableConcept> getPerformerType() {
        return this.performerType;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public Reference getLocation() {
        return this.location;
    }

    public CodeableConcept getReasonCode() {
        return this.reasonCode;
    }

    public Reference getReasonReference() {
        return this.reasonReference;
    }

    public List<Reference> getInsurance() {
        return this.insurance;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Reference> getRelevantHistory() {
        return this.relevantHistory;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public List<Input> getInput() {
        return this.input;
    }

    public List<Output> getOutput() {
        return this.output;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.instantiatesCanonical != null || this.instantiatesUri != null || !this.basedOn.isEmpty() || this.groupIdentifier != null || !this.partOf.isEmpty() || this.status != null || this.statusReason != null || this.businessStatus != null || this.intent != null || this.priority != null || this.code != null || this.description != null || this.focus != null || this._for != null || this.encounter != null || this.executionPeriod != null || this.authoredOn != null || this.lastModified != null || this.requester != null || !this.performerType.isEmpty() || this.owner != null || this.location != null || this.reasonCode != null || this.reasonReference != null || !this.insurance.isEmpty() || !this.note.isEmpty() || !this.relevantHistory.isEmpty() || this.restriction != null || !this.input.isEmpty() || !this.output.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.groupIdentifier, "groupIdentifier", visitor);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.businessStatus, "businessStatus", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.focus, "focus", visitor);
                this.accept(this._for, "for", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.executionPeriod, "executionPeriod", visitor);
                this.accept(this.authoredOn, "authoredOn", visitor);
                this.accept(this.lastModified, "lastModified", visitor);
                this.accept(this.requester, "requester", visitor);
                this.accept(this.performerType, "performerType", visitor, CodeableConcept.class);
                this.accept(this.owner, "owner", visitor);
                this.accept(this.location, "location", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor);
                this.accept(this.reasonReference, "reasonReference", visitor);
                this.accept(this.insurance, "insurance", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.relevantHistory, "relevantHistory", visitor, Reference.class);
                this.accept(this.restriction, "restriction", visitor);
                this.accept(this.input, "input", visitor, Input.class);
                this.accept(this.output, "output", visitor, Output.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.groupIdentifier, other.groupIdentifier) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.businessStatus, other.businessStatus) && Objects.equals(this.intent, other.intent) && Objects.equals(this.priority, other.priority) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.focus, other.focus) && Objects.equals(this._for, other._for) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.executionPeriod, other.executionPeriod) && Objects.equals(this.authoredOn, other.authoredOn) && Objects.equals(this.lastModified, other.lastModified) && Objects.equals(this.requester, other.requester) && Objects.equals(this.performerType, other.performerType) && Objects.equals(this.owner, other.owner) && Objects.equals(this.location, other.location) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.note, other.note) && Objects.equals(this.relevantHistory, other.relevantHistory) && Objects.equals(this.restriction, other.restriction) && Objects.equals(this.input, other.input) && Objects.equals(this.output, other.output);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.groupIdentifier, this.partOf, this.status, this.statusReason, this.businessStatus, this.intent, this.priority, this.code, this.description, this.focus, this._for, this.encounter, this.executionPeriod, this.authoredOn, this.lastModified, this.requester, this.performerType, this.owner, this.location, this.reasonCode, this.reasonReference, this.insurance, this.note, this.relevantHistory, this.restriction, this.input, this.output);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Output
    extends BackboneElement {
        @Binding(bindingName="TaskOutputParameterType", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes to identify types of input parameters.  These will typically be specific to a particular workflow.  E.g. \"Identified issues\", \"Preliminary results\", \"Filler order\", \"Final results\", etc.")
        @Required
        private final CodeableConcept type;
        @Choice(value={Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class})
        @Required
        private final Element value;
        private volatile int hashCode;

        private Output(Builder builder) {
            super(builder);
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            this.value = ValidationSupport.requireChoiceElement(builder.value, "value", Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class);
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Output other = (Output)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Output build() {
                return new Output(this);
            }

            protected Builder from(Output output) {
                super.from(output);
                this.type = output.type;
                this.value = output.value;
                return this;
            }
        }
    }

    public static class Input
    extends BackboneElement {
        @Binding(bindingName="TaskInputParameterType", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes to identify types of input parameters.  These will typically be specific to a particular workflow.  E.g. \"Comparison source\", \"Applicable consent\", \"Concomitent Medications\", etc.")
        @Required
        private final CodeableConcept type;
        @Choice(value={Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class})
        @Required
        private final Element value;
        private volatile int hashCode;

        private Input(Builder builder) {
            super(builder);
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            this.value = ValidationSupport.requireChoiceElement(builder.value, "value", Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class);
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Input other = (Input)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Input build() {
                return new Input(this);
            }

            protected Builder from(Input input) {
                super.from(input);
                this.type = input.type;
                this.value = input.value;
                return this;
            }
        }
    }

    public static class Restriction
    extends BackboneElement {
        private final PositiveInt repetitions;
        private final Period period;
        @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Group", "Organization"})
        private final List<Reference> recipient;
        private volatile int hashCode;

        private Restriction(Builder builder) {
            super(builder);
            this.repetitions = builder.repetitions;
            this.period = builder.period;
            this.recipient = Collections.unmodifiableList(ValidationSupport.checkList(builder.recipient, "recipient", Reference.class));
            ValidationSupport.checkReferenceType(this.recipient, "recipient", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Group", "Organization");
            ValidationSupport.requireValueOrChildren(this);
        }

        public PositiveInt getRepetitions() {
            return this.repetitions;
        }

        public Period getPeriod() {
            return this.period;
        }

        public List<Reference> getRecipient() {
            return this.recipient;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.repetitions != null || this.period != null || !this.recipient.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.repetitions, "repetitions", visitor);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.recipient, "recipient", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Restriction other = (Restriction)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.repetitions, other.repetitions) && Objects.equals(this.period, other.period) && Objects.equals(this.recipient, other.recipient);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.repetitions, this.period, this.recipient);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt repetitions;
            private Period period;
            private List<Reference> recipient = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder repetitions(PositiveInt repetitions) {
                this.repetitions = repetitions;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            public Builder recipient(Reference ... recipient) {
                for (Reference value : recipient) {
                    this.recipient.add(value);
                }
                return this;
            }

            public Builder recipient(Collection<Reference> recipient) {
                this.recipient = new ArrayList<Reference>(recipient);
                return this;
            }

            @Override
            public Restriction build() {
                return new Restriction(this);
            }

            protected Builder from(Restriction restriction) {
                super.from(restriction);
                this.repetitions = restriction.repetitions;
                this.period = restriction.period;
                this.recipient.addAll(restriction.recipient);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Canonical instantiatesCanonical;
        private Uri instantiatesUri;
        private List<Reference> basedOn = new ArrayList<Reference>();
        private Identifier groupIdentifier;
        private List<Reference> partOf = new ArrayList<Reference>();
        private TaskStatus status;
        private CodeableConcept statusReason;
        private CodeableConcept businessStatus;
        private TaskIntent intent;
        private TaskPriority priority;
        private CodeableConcept code;
        private String description;
        private Reference focus;
        private Reference _for;
        private Reference encounter;
        private Period executionPeriod;
        private DateTime authoredOn;
        private DateTime lastModified;
        private Reference requester;
        private List<CodeableConcept> performerType = new ArrayList<CodeableConcept>();
        private Reference owner;
        private Reference location;
        private CodeableConcept reasonCode;
        private Reference reasonReference;
        private List<Reference> insurance = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Reference> relevantHistory = new ArrayList<Reference>();
        private Restriction restriction;
        private List<Input> input = new ArrayList<Input>();
        private List<Output> output = new ArrayList<Output>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical instantiatesCanonical) {
            this.instantiatesCanonical = instantiatesCanonical;
            return this;
        }

        public Builder instantiatesUri(Uri instantiatesUri) {
            this.instantiatesUri = instantiatesUri;
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder groupIdentifier(Identifier groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder businessStatus(CodeableConcept businessStatus) {
            this.businessStatus = businessStatus;
            return this;
        }

        public Builder intent(TaskIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder priority(TaskPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder focus(Reference focus) {
            this.focus = focus;
            return this;
        }

        public Builder _for(Reference _for) {
            this._for = _for;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder executionPeriod(Period executionPeriod) {
            this.executionPeriod = executionPeriod;
            return this;
        }

        public Builder authoredOn(DateTime authoredOn) {
            this.authoredOn = authoredOn;
            return this;
        }

        public Builder lastModified(DateTime lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder requester(Reference requester) {
            this.requester = requester;
            return this;
        }

        public Builder performerType(CodeableConcept ... performerType) {
            for (CodeableConcept value : performerType) {
                this.performerType.add(value);
            }
            return this;
        }

        public Builder performerType(Collection<CodeableConcept> performerType) {
            this.performerType = new ArrayList<CodeableConcept>(performerType);
            return this;
        }

        public Builder owner(Reference owner) {
            this.owner = owner;
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder reasonCode(CodeableConcept reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public Builder reasonReference(Reference reasonReference) {
            this.reasonReference = reasonReference;
            return this;
        }

        public Builder insurance(Reference ... insurance) {
            for (Reference value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Reference> insurance) {
            this.insurance = new ArrayList<Reference>(insurance);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder relevantHistory(Reference ... relevantHistory) {
            for (Reference value : relevantHistory) {
                this.relevantHistory.add(value);
            }
            return this;
        }

        public Builder relevantHistory(Collection<Reference> relevantHistory) {
            this.relevantHistory = new ArrayList<Reference>(relevantHistory);
            return this;
        }

        public Builder restriction(Restriction restriction) {
            this.restriction = restriction;
            return this;
        }

        public Builder input(Input ... input) {
            for (Input value : input) {
                this.input.add(value);
            }
            return this;
        }

        public Builder input(Collection<Input> input) {
            this.input = new ArrayList<Input>(input);
            return this;
        }

        public Builder output(Output ... output) {
            for (Output value : output) {
                this.output.add(value);
            }
            return this;
        }

        public Builder output(Collection<Output> output) {
            this.output = new ArrayList<Output>(output);
            return this;
        }

        @Override
        public Task build() {
            return new Task(this);
        }

        protected Builder from(Task task) {
            super.from(task);
            this.identifier.addAll(task.identifier);
            this.instantiatesCanonical = task.instantiatesCanonical;
            this.instantiatesUri = task.instantiatesUri;
            this.basedOn.addAll(task.basedOn);
            this.groupIdentifier = task.groupIdentifier;
            this.partOf.addAll(task.partOf);
            this.status = task.status;
            this.statusReason = task.statusReason;
            this.businessStatus = task.businessStatus;
            this.intent = task.intent;
            this.priority = task.priority;
            this.code = task.code;
            this.description = task.description;
            this.focus = task.focus;
            this._for = task._for;
            this.encounter = task.encounter;
            this.executionPeriod = task.executionPeriod;
            this.authoredOn = task.authoredOn;
            this.lastModified = task.lastModified;
            this.requester = task.requester;
            this.performerType.addAll(task.performerType);
            this.owner = task.owner;
            this.location = task.location;
            this.reasonCode = task.reasonCode;
            this.reasonReference = task.reasonReference;
            this.insurance.addAll(task.insurance);
            this.note.addAll(task.note);
            this.relevantHistory.addAll(task.relevantHistory);
            this.restriction = task.restriction;
            this.input.addAll(task.input);
            this.output.addAll(task.output);
            return this;
        }
    }
}

