/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.util.ValidationSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class BackboneElement
extends Element {
    @Summary
    protected final List<Extension> modifierExtension;

    protected BackboneElement(Builder builder) {
        super(builder);
        this.modifierExtension = Collections.unmodifiableList(ValidationSupport.checkList(builder.modifierExtension, "modifierExtension", Extension.class));
    }

    public List<Extension> getModifierExtension() {
        return this.modifierExtension;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.modifierExtension.isEmpty();
    }

    @Override
    public abstract Builder toBuilder();

    public static abstract class Builder
    extends Element.Builder {
        protected List<Extension> modifierExtension = new ArrayList<Extension>();

        protected Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder modifierExtension(Extension ... modifierExtension) {
            for (Extension value : modifierExtension) {
                this.modifierExtension.add(value);
            }
            return this;
        }

        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            this.modifierExtension = new ArrayList<Extension>(modifierExtension);
            return this;
        }

        @Override
        public abstract BackboneElement build();

        protected Builder from(BackboneElement backboneElement) {
            super.from(backboneElement);
            this.modifierExtension.addAll(backboneElement.modifierExtension);
            return this;
        }
    }
}

