/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ContributorType;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Contributor
extends Element {
    @Summary
    @Binding(bindingName="ContributorType", strength=BindingStrength.ValueSet.REQUIRED, description="The type of contributor.", valueSet="http://hl7.org/fhir/ValueSet/contributor-type|4.0.1")
    @Required
    private final ContributorType type;
    @Summary
    @Required
    private final String name;
    @Summary
    private final List<ContactDetail> contact;
    private volatile int hashCode;

    private Contributor(Builder builder) {
        super(builder);
        this.type = ValidationSupport.requireNonNull(builder.type, "type");
        this.name = ValidationSupport.requireNonNull(builder.name, "name");
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactDetail.class));
        ValidationSupport.requireValueOrChildren(this);
    }

    public ContributorType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.type != null || this.name != null || !this.contact.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Contributor other = (Contributor)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.contact, other.contact);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.type, this.name, this.contact);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private ContributorType type;
        private String name;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder type(ContributorType type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        @Override
        public Contributor build() {
            return new Contributor(this);
        }

        protected Builder from(Contributor contributor) {
            super.from(contributor);
            this.type = contributor.type;
            this.name = contributor.name;
            this.contact.addAll(contributor.contact);
            return this;
        }
    }
}

