/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Objects;

public class Date
extends Element {
    public static final DateTimeFormatter PARSER_FORMATTER = DateTimeFormatter.ofPattern("[yyyy[-MM[-dd]]]");
    private final TemporalAccessor value;
    private volatile int hashCode;

    private Date(Builder builder) {
        super(builder);
        this.value = builder.value;
        ValidationSupport.checkValueType(this.value, LocalDate.class, YearMonth.class, Year.class);
        ValidationSupport.requireValueOrChildren(this);
    }

    public TemporalAccessor getValue() {
        return this.value;
    }

    public boolean isPartial() {
        return !(this.value instanceof LocalDate);
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren();
    }

    public static Date of(TemporalAccessor value) {
        return Date.builder().value(value).build();
    }

    public static Date of(String value) {
        return Date.builder().value(value).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Date other = (Date)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private TemporalAccessor value;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder value(TemporalAccessor value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            this.value = PARSER_FORMATTER.parseBest(value, LocalDate::from, YearMonth::from, Year::from);
            return this;
        }

        @Override
        public Date build() {
            return new Date(this);
        }

        protected Builder from(Date date) {
            super.from(date);
            this.value = date.value;
            return this;
        }
    }
}

