/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;

public class Decimal
extends Element {
    private final BigDecimal value;
    private volatile int hashCode;

    private Decimal(Builder builder) {
        super(builder);
        this.value = builder.value;
        ValidationSupport.requireValueOrChildren(this);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren();
    }

    public static Decimal of(BigDecimal value) {
        return Decimal.builder().value(value).build();
    }

    public static Decimal of(Number value) {
        return Decimal.builder().value(value.toString()).build();
    }

    public static Decimal of(String value) {
        return Decimal.builder().value(value).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Decimal other = (Decimal)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private BigDecimal value;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder value(BigDecimal value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            this.value = new BigDecimal(value);
            return this;
        }

        @Override
        public Decimal build() {
            return new Decimal(this);
        }

        protected Builder from(Decimal decimal) {
            super.from(decimal);
            this.value = decimal.value;
            return this;
        }
    }
}

