/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.builder.AbstractBuilder;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.AbstractVisitable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Constraint(id="ele-1", level="Rule", location="(base)", description="All FHIR elements must have a @value or children", expression="hasValue() or (children().count() > id.count())", modelChecked=true)
public abstract class Element
extends AbstractVisitable {
    protected final String id;
    protected final List<Extension> extension;

    protected Element(Builder builder) {
        this.id = builder.id;
        this.extension = Collections.unmodifiableList(ValidationSupport.checkList(builder.extension, "extension", Extension.class));
        ValidationSupport.checkString(this.id);
    }

    public String getId() {
        return this.id;
    }

    public List<Extension> getExtension() {
        return this.extension;
    }

    public <T extends Element> boolean is(Class<T> elementType) {
        return elementType.isInstance(this);
    }

    public <T extends Element> T as(Class<T> elementType) {
        return (T)((Element)elementType.cast(this));
    }

    public boolean hasValue() {
        return false;
    }

    public boolean hasChildren() {
        return !this.extension.isEmpty();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder
    extends AbstractBuilder<Element> {
        protected String id;
        protected List<Extension> extension = new ArrayList<Extension>();

        protected Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder extension(Extension ... extension) {
            for (Extension value : extension) {
                this.extension.add(value);
            }
            return this;
        }

        public Builder extension(Collection<Extension> extension) {
            this.extension = new ArrayList<Extension>(extension);
            return this;
        }

        @Override
        public abstract Element build();

        protected Builder from(Element element) {
            this.id = element.id;
            this.extension.addAll(element.extension);
            return this;
        }
    }
}

