/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraints(value={@Constraint(id="exp-1", level="Rule", location="(base)", description="An expression or a reference must be provided", expression="expression.exists() or reference.exists()"), @Constraint(id="expression-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/expression-language", expression="language.exists() and language.memberOf('http://hl7.org/fhir/ValueSet/expression-language', 'extensible')", generated=true)})
public class Expression
extends Element {
    @Summary
    private final String description;
    @Summary
    private final Id name;
    @Summary
    @Binding(bindingName="ExpressionLanguage", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The media type of the expression language.", valueSet="http://hl7.org/fhir/ValueSet/expression-language", maxValueSet="http://www.rfc-editor.org/bcp/bcp13.txt")
    @Required
    private final Code language;
    @Summary
    private final String expression;
    @Summary
    private final Uri reference;
    private volatile int hashCode;

    private Expression(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.language = ValidationSupport.requireNonNull(builder.language, "language");
        this.expression = builder.expression;
        this.reference = builder.reference;
        ValidationSupport.requireValueOrChildren(this);
    }

    public String getDescription() {
        return this.description;
    }

    public Id getName() {
        return this.name;
    }

    public Code getLanguage() {
        return this.language;
    }

    public String getExpression() {
        return this.expression;
    }

    public Uri getReference() {
        return this.reference;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.description != null || this.name != null || this.language != null || this.expression != null || this.reference != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.expression, "expression", visitor);
                this.accept(this.reference, "reference", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.description, other.description) && Objects.equals(this.name, other.name) && Objects.equals(this.language, other.language) && Objects.equals(this.expression, other.expression) && Objects.equals(this.reference, other.reference);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.description, this.name, this.language, this.expression, this.reference);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private String description;
        private Id name;
        private Code language;
        private String expression;
        private Uri reference;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(Id name) {
            this.name = name;
            return this;
        }

        public Builder language(Code language) {
            this.language = language;
            return this;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder reference(Uri reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public Expression build() {
            return new Expression(this);
        }

        protected Builder from(Expression expression) {
            super.from(expression);
            this.description = expression.description;
            this.name = expression.name;
            this.language = expression.language;
            this.expression = expression.expression;
            this.reference = expression.reference;
            return this;
        }
    }
}

