/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.IdentifierUse;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="identifier-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/identifier-type", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/identifier-type', 'extensible'))", generated=true)
public class Identifier
extends Element {
    @Summary
    @Binding(bindingName="IdentifierUse", strength=BindingStrength.ValueSet.REQUIRED, description="Identifies the purpose for this identifier, if known .", valueSet="http://hl7.org/fhir/ValueSet/identifier-use|4.0.1")
    private final IdentifierUse use;
    @Summary
    @Binding(bindingName="IdentifierType", strength=BindingStrength.ValueSet.EXTENSIBLE, description="A coded type for an identifier that can be used to determine which identifier to use for a specific purpose.", valueSet="http://hl7.org/fhir/ValueSet/identifier-type")
    private final CodeableConcept type;
    @Summary
    private final Uri system;
    @Summary
    private final String value;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference assigner;
    private volatile int hashCode;

    private Identifier(Builder builder) {
        super(builder);
        this.use = builder.use;
        this.type = builder.type;
        this.system = builder.system;
        this.value = builder.value;
        this.period = builder.period;
        this.assigner = builder.assigner;
        ValidationSupport.checkReferenceType(this.assigner, "assigner", "Organization");
        ValidationSupport.requireValueOrChildren(this);
    }

    public IdentifierUse getUse() {
        return this.use;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Uri getSystem() {
        return this.system;
    }

    public String getValue() {
        return this.value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getAssigner() {
        return this.assigner;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.use != null || this.type != null || this.system != null || this.value != null || this.period != null || this.assigner != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.use, "use", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.system, "system", visitor);
                this.accept(this.value, "value", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.assigner, "assigner", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.use, other.use) && Objects.equals(this.type, other.type) && Objects.equals(this.system, other.system) && Objects.equals(this.value, other.value) && Objects.equals(this.period, other.period) && Objects.equals(this.assigner, other.assigner);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.use, this.type, this.system, this.value, this.period, this.assigner);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private IdentifierUse use;
        private CodeableConcept type;
        private Uri system;
        private String value;
        private Period period;
        private Reference assigner;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder use(IdentifierUse use) {
            this.use = use;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder system(Uri system) {
            this.system = system;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder assigner(Reference assigner) {
            this.assigner = assigner;
            return this;
        }

        @Override
        public Identifier build() {
            return new Identifier(this);
        }

        protected Builder from(Identifier identifier) {
            super.from(identifier);
            this.use = identifier.use;
            this.type = identifier.type;
            this.system = identifier.system;
            this.value = identifier.value;
            this.period = identifier.period;
            this.assigner = identifier.assigner;
            return this;
        }
    }
}

