/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Objects;

public class Instant
extends Element {
    public static final DateTimeFormatter PARSER_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().appendPattern("XXX").toFormatter();
    private final ZonedDateTime value;
    private volatile int hashCode;

    private Instant(Builder builder) {
        super(builder);
        this.value = ModelSupport.truncateTime(builder.value, ChronoUnit.MICROS);
        ValidationSupport.requireValueOrChildren(this);
    }

    public ZonedDateTime getValue() {
        return this.value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren();
    }

    public static Instant of(ZonedDateTime value) {
        return Instant.builder().value(value).build();
    }

    public static Instant of(String value) {
        return Instant.builder().value(value).build();
    }

    public static Instant now() {
        return Instant.builder().value(ZonedDateTime.now()).build();
    }

    public static Instant now(ZoneOffset offset) {
        return Instant.builder().value(ZonedDateTime.now(offset)).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instant other = (Instant)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private ZonedDateTime value;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder value(ZonedDateTime value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            this.value = PARSER_FORMATTER.parse((CharSequence)value, ZonedDateTime::from);
            return this;
        }

        @Override
        public Instant build() {
            return new Instant(this);
        }

        protected Builder from(Instant instant) {
            super.from(instant);
            this.value = instant.value;
            return this;
        }
    }
}

