/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="per-1", level="Rule", location="(base)", description="If present, start SHALL have a lower value than end", expression="start.hasValue().not() or end.hasValue().not() or (start <= end)")
public class Period
extends Element {
    @Summary
    private final DateTime start;
    @Summary
    private final DateTime end;
    private volatile int hashCode;

    private Period(Builder builder) {
        super(builder);
        this.start = builder.start;
        this.end = builder.end;
        ValidationSupport.requireValueOrChildren(this);
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.start != null || this.end != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.start, "start", visitor);
                this.accept(this.end, "end", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.start, this.end);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private DateTime start;
        private DateTime end;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder start(DateTime start) {
            this.start = start;
            return this;
        }

        public Builder end(DateTime end) {
            this.end = end;
            return this;
        }

        @Override
        public Period build() {
            return new Period(this);
        }

        protected Builder from(Period period) {
            super.from(period);
            this.start = period.start;
            this.end = period.end;
            return this;
        }
    }
}

