/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

public class Population
extends BackboneElement {
    @Summary
    @Choice(value={Range.class, CodeableConcept.class})
    private final Element age;
    @Summary
    private final CodeableConcept gender;
    @Summary
    private final CodeableConcept race;
    @Summary
    private final CodeableConcept physiologicalCondition;
    private volatile int hashCode;

    private Population(Builder builder) {
        super(builder);
        this.age = ValidationSupport.choiceElement(builder.age, "age", Range.class, CodeableConcept.class);
        this.gender = builder.gender;
        this.race = builder.race;
        this.physiologicalCondition = builder.physiologicalCondition;
        ValidationSupport.requireValueOrChildren(this);
    }

    public Element getAge() {
        return this.age;
    }

    public CodeableConcept getGender() {
        return this.gender;
    }

    public CodeableConcept getRace() {
        return this.race;
    }

    public CodeableConcept getPhysiologicalCondition() {
        return this.physiologicalCondition;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.age != null || this.gender != null || this.race != null || this.physiologicalCondition != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.age, "age", visitor);
                this.accept(this.gender, "gender", visitor);
                this.accept(this.race, "race", visitor);
                this.accept(this.physiologicalCondition, "physiologicalCondition", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Population other = (Population)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.age, other.age) && Objects.equals(this.gender, other.gender) && Objects.equals(this.race, other.race) && Objects.equals(this.physiologicalCondition, other.physiologicalCondition);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.age, this.gender, this.race, this.physiologicalCondition);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BackboneElement.Builder {
        private Element age;
        private CodeableConcept gender;
        private CodeableConcept race;
        private CodeableConcept physiologicalCondition;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder age(Element age) {
            this.age = age;
            return this;
        }

        public Builder gender(CodeableConcept gender) {
            this.gender = gender;
            return this;
        }

        public Builder race(CodeableConcept race) {
            this.race = race;
            return this;
        }

        public Builder physiologicalCondition(CodeableConcept physiologicalCondition) {
            this.physiologicalCondition = physiologicalCondition;
            return this;
        }

        @Override
        public Population build() {
            return new Population(this);
        }

        protected Builder from(Population population) {
            super.from(population);
            this.age = population.age;
            this.gender = population.gender;
            this.race = population.race;
            this.physiologicalCondition = population.physiologicalCondition;
            return this;
        }
    }
}

