/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductShelfLife
extends BackboneElement {
    @Summary
    private final Identifier identifier;
    @Summary
    @Required
    private final CodeableConcept type;
    @Summary
    @Required
    private final Quantity period;
    @Summary
    private final List<CodeableConcept> specialPrecautionsForStorage;
    private volatile int hashCode;

    private ProductShelfLife(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.type = ValidationSupport.requireNonNull(builder.type, "type");
        this.period = ValidationSupport.requireNonNull(builder.period, "period");
        this.specialPrecautionsForStorage = Collections.unmodifiableList(ValidationSupport.checkList(builder.specialPrecautionsForStorage, "specialPrecautionsForStorage", CodeableConcept.class));
        ValidationSupport.requireValueOrChildren(this);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Quantity getPeriod() {
        return this.period;
    }

    public List<CodeableConcept> getSpecialPrecautionsForStorage() {
        return this.specialPrecautionsForStorage;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.type != null || this.period != null || !this.specialPrecautionsForStorage.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.specialPrecautionsForStorage, "specialPrecautionsForStorage", visitor, CodeableConcept.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductShelfLife other = (ProductShelfLife)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.period, other.period) && Objects.equals(this.specialPrecautionsForStorage, other.specialPrecautionsForStorage);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.type, this.period, this.specialPrecautionsForStorage);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BackboneElement.Builder {
        private Identifier identifier;
        private CodeableConcept type;
        private Quantity period;
        private List<CodeableConcept> specialPrecautionsForStorage = new ArrayList<CodeableConcept>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder period(Quantity period) {
            this.period = period;
            return this;
        }

        public Builder specialPrecautionsForStorage(CodeableConcept ... specialPrecautionsForStorage) {
            for (CodeableConcept value : specialPrecautionsForStorage) {
                this.specialPrecautionsForStorage.add(value);
            }
            return this;
        }

        public Builder specialPrecautionsForStorage(Collection<CodeableConcept> specialPrecautionsForStorage) {
            this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>(specialPrecautionsForStorage);
            return this;
        }

        @Override
        public ProductShelfLife build() {
            return new ProductShelfLife(this);
        }

        protected Builder from(ProductShelfLife productShelfLife) {
            super.from(productShelfLife);
            this.identifier = productShelfLife.identifier;
            this.type = productShelfLife.type;
            this.period = productShelfLife.period;
            this.specialPrecautionsForStorage.addAll(productShelfLife.specialPrecautionsForStorage);
            return this;
        }
    }
}

