/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.QuantityComparator;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="qty-3", level="Rule", location="(base)", description="If a code for the unit is present, the system SHALL also be present", expression="code.empty() or system.exists()")
public class Quantity
extends Element {
    @Summary
    protected final Decimal value;
    @Summary
    @Binding(bindingName="QuantityComparator", strength=BindingStrength.ValueSet.REQUIRED, description="How the Quantity should be understood and represented.", valueSet="http://hl7.org/fhir/ValueSet/quantity-comparator|4.0.1")
    protected final QuantityComparator comparator;
    @Summary
    protected final String unit;
    @Summary
    protected final Uri system;
    @Summary
    protected final Code code;
    private volatile int hashCode;

    protected Quantity(Builder builder) {
        super(builder);
        this.value = builder.value;
        this.comparator = builder.comparator;
        this.unit = builder.unit;
        this.system = builder.system;
        this.code = builder.code;
        ValidationSupport.requireValueOrChildren(this);
    }

    public Decimal getValue() {
        return this.value;
    }

    public QuantityComparator getComparator() {
        return this.comparator;
    }

    public String getUnit() {
        return this.unit;
    }

    public Uri getSystem() {
        return this.system;
    }

    public Code getCode() {
        return this.code;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.value != null || this.comparator != null || this.unit != null || this.system != null || this.code != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
                this.accept(this.comparator, "comparator", visitor);
                this.accept(this.unit, "unit", visitor);
                this.accept(this.system, "system", visitor);
                this.accept(this.code, "code", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantity other = (Quantity)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.unit, other.unit) && Objects.equals(this.system, other.system) && Objects.equals(this.code, other.code);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value, this.comparator, this.unit, this.system, this.code);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        protected Decimal value;
        protected QuantityComparator comparator;
        protected String unit;
        protected Uri system;
        protected Code code;

        protected Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder value(Decimal value) {
            this.value = value;
            return this;
        }

        public Builder comparator(QuantityComparator comparator) {
            this.comparator = comparator;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder system(Uri system) {
            this.system = system;
            return this;
        }

        public Builder code(Code code) {
            this.code = code;
            return this;
        }

        @Override
        public Quantity build() {
            return new Quantity(this);
        }

        protected Builder from(Quantity quantity) {
            super.from(quantity);
            this.value = quantity.value;
            this.comparator = quantity.comparator;
            this.unit = quantity.unit;
            this.system = quantity.system;
            this.code = quantity.code;
            return this;
        }
    }
}

