/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/appointmentstatus")
public class AppointmentStatus
extends Code {
    public static final AppointmentStatus PROPOSED = AppointmentStatus.builder().value(ValueSet.PROPOSED).build();
    public static final AppointmentStatus PENDING = AppointmentStatus.builder().value(ValueSet.PENDING).build();
    public static final AppointmentStatus BOOKED = AppointmentStatus.builder().value(ValueSet.BOOKED).build();
    public static final AppointmentStatus ARRIVED = AppointmentStatus.builder().value(ValueSet.ARRIVED).build();
    public static final AppointmentStatus FULFILLED = AppointmentStatus.builder().value(ValueSet.FULFILLED).build();
    public static final AppointmentStatus CANCELLED = AppointmentStatus.builder().value(ValueSet.CANCELLED).build();
    public static final AppointmentStatus NOSHOW = AppointmentStatus.builder().value(ValueSet.NOSHOW).build();
    public static final AppointmentStatus ENTERED_IN_ERROR = AppointmentStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final AppointmentStatus CHECKED_IN = AppointmentStatus.builder().value(ValueSet.CHECKED_IN).build();
    public static final AppointmentStatus WAITLIST = AppointmentStatus.builder().value(ValueSet.WAITLIST).build();
    private volatile int hashCode;

    private AppointmentStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static AppointmentStatus of(ValueSet value) {
        switch (value) {
            case PROPOSED: {
                return PROPOSED;
            }
            case PENDING: {
                return PENDING;
            }
            case BOOKED: {
                return BOOKED;
            }
            case ARRIVED: {
                return ARRIVED;
            }
            case FULFILLED: {
                return FULFILLED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case NOSHOW: {
                return NOSHOW;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case CHECKED_IN: {
                return CHECKED_IN;
            }
            case WAITLIST: {
                return WAITLIST;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AppointmentStatus of(java.lang.String value) {
        return AppointmentStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return AppointmentStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return AppointmentStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppointmentStatus other = (AppointmentStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        PROPOSED("proposed"),
        PENDING("pending"),
        BOOKED("booked"),
        ARRIVED("arrived"),
        FULFILLED("fulfilled"),
        CANCELLED("cancelled"),
        NOSHOW("noshow"),
        ENTERED_IN_ERROR("entered-in-error"),
        CHECKED_IN("checked-in"),
        WAITLIST("waitlist");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public AppointmentStatus build() {
            return new AppointmentStatus(this);
        }
    }
}

