/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/bundle-type")
public class BundleType
extends Code {
    public static final BundleType DOCUMENT = BundleType.builder().value(ValueSet.DOCUMENT).build();
    public static final BundleType MESSAGE = BundleType.builder().value(ValueSet.MESSAGE).build();
    public static final BundleType TRANSACTION = BundleType.builder().value(ValueSet.TRANSACTION).build();
    public static final BundleType TRANSACTION_RESPONSE = BundleType.builder().value(ValueSet.TRANSACTION_RESPONSE).build();
    public static final BundleType BATCH = BundleType.builder().value(ValueSet.BATCH).build();
    public static final BundleType BATCH_RESPONSE = BundleType.builder().value(ValueSet.BATCH_RESPONSE).build();
    public static final BundleType HISTORY = BundleType.builder().value(ValueSet.HISTORY).build();
    public static final BundleType SEARCHSET = BundleType.builder().value(ValueSet.SEARCHSET).build();
    public static final BundleType COLLECTION = BundleType.builder().value(ValueSet.COLLECTION).build();
    private volatile int hashCode;

    private BundleType(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static BundleType of(ValueSet value) {
        switch (value) {
            case DOCUMENT: {
                return DOCUMENT;
            }
            case MESSAGE: {
                return MESSAGE;
            }
            case TRANSACTION: {
                return TRANSACTION;
            }
            case TRANSACTION_RESPONSE: {
                return TRANSACTION_RESPONSE;
            }
            case BATCH: {
                return BATCH;
            }
            case BATCH_RESPONSE: {
                return BATCH_RESPONSE;
            }
            case HISTORY: {
                return HISTORY;
            }
            case SEARCHSET: {
                return SEARCHSET;
            }
            case COLLECTION: {
                return COLLECTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static BundleType of(java.lang.String value) {
        return BundleType.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return BundleType.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return BundleType.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleType other = (BundleType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        DOCUMENT("document"),
        MESSAGE("message"),
        TRANSACTION("transaction"),
        TRANSACTION_RESPONSE("transaction-response"),
        BATCH("batch"),
        BATCH_RESPONSE("batch-response"),
        HISTORY("history"),
        SEARCHSET("searchset"),
        COLLECTION("collection");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public BundleType build() {
            return new BundleType(this);
        }
    }
}

