/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/care-plan-activity-status")
public class CarePlanActivityStatus
extends Code {
    public static final CarePlanActivityStatus NOT_STARTED = CarePlanActivityStatus.builder().value(ValueSet.NOT_STARTED).build();
    public static final CarePlanActivityStatus SCHEDULED = CarePlanActivityStatus.builder().value(ValueSet.SCHEDULED).build();
    public static final CarePlanActivityStatus IN_PROGRESS = CarePlanActivityStatus.builder().value(ValueSet.IN_PROGRESS).build();
    public static final CarePlanActivityStatus ON_HOLD = CarePlanActivityStatus.builder().value(ValueSet.ON_HOLD).build();
    public static final CarePlanActivityStatus COMPLETED = CarePlanActivityStatus.builder().value(ValueSet.COMPLETED).build();
    public static final CarePlanActivityStatus CANCELLED = CarePlanActivityStatus.builder().value(ValueSet.CANCELLED).build();
    public static final CarePlanActivityStatus STOPPED = CarePlanActivityStatus.builder().value(ValueSet.STOPPED).build();
    public static final CarePlanActivityStatus UNKNOWN = CarePlanActivityStatus.builder().value(ValueSet.UNKNOWN).build();
    public static final CarePlanActivityStatus ENTERED_IN_ERROR = CarePlanActivityStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private CarePlanActivityStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static CarePlanActivityStatus of(ValueSet value) {
        switch (value) {
            case NOT_STARTED: {
                return NOT_STARTED;
            }
            case SCHEDULED: {
                return SCHEDULED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case STOPPED: {
                return STOPPED;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CarePlanActivityStatus of(java.lang.String value) {
        return CarePlanActivityStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return CarePlanActivityStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return CarePlanActivityStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarePlanActivityStatus other = (CarePlanActivityStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        NOT_STARTED("not-started"),
        SCHEDULED("scheduled"),
        IN_PROGRESS("in-progress"),
        ON_HOLD("on-hold"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        STOPPED("stopped"),
        UNKNOWN("unknown"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CarePlanActivityStatus build() {
            return new CarePlanActivityStatus(this);
        }
    }
}

