/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/event-status")
public class CommunicationStatus
extends Code {
    public static final CommunicationStatus PREPARATION = CommunicationStatus.builder().value(ValueSet.PREPARATION).build();
    public static final CommunicationStatus IN_PROGRESS = CommunicationStatus.builder().value(ValueSet.IN_PROGRESS).build();
    public static final CommunicationStatus NOT_DONE = CommunicationStatus.builder().value(ValueSet.NOT_DONE).build();
    public static final CommunicationStatus ON_HOLD = CommunicationStatus.builder().value(ValueSet.ON_HOLD).build();
    public static final CommunicationStatus STOPPED = CommunicationStatus.builder().value(ValueSet.STOPPED).build();
    public static final CommunicationStatus COMPLETED = CommunicationStatus.builder().value(ValueSet.COMPLETED).build();
    public static final CommunicationStatus ENTERED_IN_ERROR = CommunicationStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final CommunicationStatus UNKNOWN = CommunicationStatus.builder().value(ValueSet.UNKNOWN).build();
    private volatile int hashCode;

    private CommunicationStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static CommunicationStatus of(ValueSet value) {
        switch (value) {
            case PREPARATION: {
                return PREPARATION;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case NOT_DONE: {
                return NOT_DONE;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case STOPPED: {
                return STOPPED;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CommunicationStatus of(java.lang.String value) {
        return CommunicationStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return CommunicationStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return CommunicationStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommunicationStatus other = (CommunicationStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        PREPARATION("preparation"),
        IN_PROGRESS("in-progress"),
        NOT_DONE("not-done"),
        ON_HOLD("on-hold"),
        STOPPED("stopped"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CommunicationStatus build() {
            return new CommunicationStatus(this);
        }
    }
}

