/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/concept-map-equivalence")
public class ConceptMapEquivalence
extends Code {
    public static final ConceptMapEquivalence RELATEDTO = ConceptMapEquivalence.builder().value(ValueSet.RELATEDTO).build();
    public static final ConceptMapEquivalence EQUIVALENT = ConceptMapEquivalence.builder().value(ValueSet.EQUIVALENT).build();
    public static final ConceptMapEquivalence EQUAL = ConceptMapEquivalence.builder().value(ValueSet.EQUAL).build();
    public static final ConceptMapEquivalence WIDER = ConceptMapEquivalence.builder().value(ValueSet.WIDER).build();
    public static final ConceptMapEquivalence SUBSUMES = ConceptMapEquivalence.builder().value(ValueSet.SUBSUMES).build();
    public static final ConceptMapEquivalence NARROWER = ConceptMapEquivalence.builder().value(ValueSet.NARROWER).build();
    public static final ConceptMapEquivalence SPECIALIZES = ConceptMapEquivalence.builder().value(ValueSet.SPECIALIZES).build();
    public static final ConceptMapEquivalence INEXACT = ConceptMapEquivalence.builder().value(ValueSet.INEXACT).build();
    public static final ConceptMapEquivalence UNMATCHED = ConceptMapEquivalence.builder().value(ValueSet.UNMATCHED).build();
    public static final ConceptMapEquivalence DISJOINT = ConceptMapEquivalence.builder().value(ValueSet.DISJOINT).build();
    private volatile int hashCode;

    private ConceptMapEquivalence(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static ConceptMapEquivalence of(ValueSet value) {
        switch (value) {
            case RELATEDTO: {
                return RELATEDTO;
            }
            case EQUIVALENT: {
                return EQUIVALENT;
            }
            case EQUAL: {
                return EQUAL;
            }
            case WIDER: {
                return WIDER;
            }
            case SUBSUMES: {
                return SUBSUMES;
            }
            case NARROWER: {
                return NARROWER;
            }
            case SPECIALIZES: {
                return SPECIALIZES;
            }
            case INEXACT: {
                return INEXACT;
            }
            case UNMATCHED: {
                return UNMATCHED;
            }
            case DISJOINT: {
                return DISJOINT;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ConceptMapEquivalence of(java.lang.String value) {
        return ConceptMapEquivalence.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return ConceptMapEquivalence.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return ConceptMapEquivalence.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConceptMapEquivalence other = (ConceptMapEquivalence)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        RELATEDTO("relatedto"),
        EQUIVALENT("equivalent"),
        EQUAL("equal"),
        WIDER("wider"),
        SUBSUMES("subsumes"),
        NARROWER("narrower"),
        SPECIALIZES("specializes"),
        INEXACT("inexact"),
        UNMATCHED("unmatched"),
        DISJOINT("disjoint");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ConceptMapEquivalence build() {
            return new ConceptMapEquivalence(this);
        }
    }
}

