/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/contract-status")
public class ContractStatus
extends Code {
    public static final ContractStatus AMENDED = ContractStatus.builder().value(ValueSet.AMENDED).build();
    public static final ContractStatus APPENDED = ContractStatus.builder().value(ValueSet.APPENDED).build();
    public static final ContractStatus CANCELLED = ContractStatus.builder().value(ValueSet.CANCELLED).build();
    public static final ContractStatus DISPUTED = ContractStatus.builder().value(ValueSet.DISPUTED).build();
    public static final ContractStatus ENTERED_IN_ERROR = ContractStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final ContractStatus EXECUTABLE = ContractStatus.builder().value(ValueSet.EXECUTABLE).build();
    public static final ContractStatus EXECUTED = ContractStatus.builder().value(ValueSet.EXECUTED).build();
    public static final ContractStatus NEGOTIABLE = ContractStatus.builder().value(ValueSet.NEGOTIABLE).build();
    public static final ContractStatus OFFERED = ContractStatus.builder().value(ValueSet.OFFERED).build();
    public static final ContractStatus POLICY = ContractStatus.builder().value(ValueSet.POLICY).build();
    public static final ContractStatus REJECTED = ContractStatus.builder().value(ValueSet.REJECTED).build();
    public static final ContractStatus RENEWED = ContractStatus.builder().value(ValueSet.RENEWED).build();
    public static final ContractStatus REVOKED = ContractStatus.builder().value(ValueSet.REVOKED).build();
    public static final ContractStatus RESOLVED = ContractStatus.builder().value(ValueSet.RESOLVED).build();
    public static final ContractStatus TERMINATED = ContractStatus.builder().value(ValueSet.TERMINATED).build();
    private volatile int hashCode;

    private ContractStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static ContractStatus of(ValueSet value) {
        switch (value) {
            case AMENDED: {
                return AMENDED;
            }
            case APPENDED: {
                return APPENDED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case DISPUTED: {
                return DISPUTED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case EXECUTABLE: {
                return EXECUTABLE;
            }
            case EXECUTED: {
                return EXECUTED;
            }
            case NEGOTIABLE: {
                return NEGOTIABLE;
            }
            case OFFERED: {
                return OFFERED;
            }
            case POLICY: {
                return POLICY;
            }
            case REJECTED: {
                return REJECTED;
            }
            case RENEWED: {
                return RENEWED;
            }
            case REVOKED: {
                return REVOKED;
            }
            case RESOLVED: {
                return RESOLVED;
            }
            case TERMINATED: {
                return TERMINATED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ContractStatus of(java.lang.String value) {
        return ContractStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return ContractStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return ContractStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContractStatus other = (ContractStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        AMENDED("amended"),
        APPENDED("appended"),
        CANCELLED("cancelled"),
        DISPUTED("disputed"),
        ENTERED_IN_ERROR("entered-in-error"),
        EXECUTABLE("executable"),
        EXECUTED("executed"),
        NEGOTIABLE("negotiable"),
        OFFERED("offered"),
        POLICY("policy"),
        REJECTED("rejected"),
        RENEWED("renewed"),
        REVOKED("revoked"),
        RESOLVED("resolved"),
        TERMINATED("terminated");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ContractStatus build() {
            return new ContractStatus(this);
        }
    }
}

