/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://terminology.hl7.org/CodeSystem/data-absent-reason")
public class DataAbsentReason
extends Code {
    public static final DataAbsentReason UNKNOWN = DataAbsentReason.builder().value(ValueSet.UNKNOWN).build();
    public static final DataAbsentReason ASKED_UNKNOWN = DataAbsentReason.builder().value(ValueSet.ASKED_UNKNOWN).build();
    public static final DataAbsentReason TEMP_UNKNOWN = DataAbsentReason.builder().value(ValueSet.TEMP_UNKNOWN).build();
    public static final DataAbsentReason NOT_ASKED = DataAbsentReason.builder().value(ValueSet.NOT_ASKED).build();
    public static final DataAbsentReason ASKED_DECLINED = DataAbsentReason.builder().value(ValueSet.ASKED_DECLINED).build();
    public static final DataAbsentReason MASKED = DataAbsentReason.builder().value(ValueSet.MASKED).build();
    public static final DataAbsentReason NOT_APPLICABLE = DataAbsentReason.builder().value(ValueSet.NOT_APPLICABLE).build();
    public static final DataAbsentReason UNSUPPORTED = DataAbsentReason.builder().value(ValueSet.UNSUPPORTED).build();
    public static final DataAbsentReason AS_TEXT = DataAbsentReason.builder().value(ValueSet.AS_TEXT).build();
    public static final DataAbsentReason ERROR = DataAbsentReason.builder().value(ValueSet.ERROR).build();
    public static final DataAbsentReason NOT_A_NUMBER = DataAbsentReason.builder().value(ValueSet.NOT_A_NUMBER).build();
    public static final DataAbsentReason NEGATIVE_INFINITY = DataAbsentReason.builder().value(ValueSet.NEGATIVE_INFINITY).build();
    public static final DataAbsentReason POSITIVE_INFINITY = DataAbsentReason.builder().value(ValueSet.POSITIVE_INFINITY).build();
    public static final DataAbsentReason NOT_PERFORMED = DataAbsentReason.builder().value(ValueSet.NOT_PERFORMED).build();
    public static final DataAbsentReason NOT_PERMITTED = DataAbsentReason.builder().value(ValueSet.NOT_PERMITTED).build();
    private volatile int hashCode;

    private DataAbsentReason(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static DataAbsentReason of(ValueSet value) {
        switch (value) {
            case UNKNOWN: {
                return UNKNOWN;
            }
            case ASKED_UNKNOWN: {
                return ASKED_UNKNOWN;
            }
            case TEMP_UNKNOWN: {
                return TEMP_UNKNOWN;
            }
            case NOT_ASKED: {
                return NOT_ASKED;
            }
            case ASKED_DECLINED: {
                return ASKED_DECLINED;
            }
            case MASKED: {
                return MASKED;
            }
            case NOT_APPLICABLE: {
                return NOT_APPLICABLE;
            }
            case UNSUPPORTED: {
                return UNSUPPORTED;
            }
            case AS_TEXT: {
                return AS_TEXT;
            }
            case ERROR: {
                return ERROR;
            }
            case NOT_A_NUMBER: {
                return NOT_A_NUMBER;
            }
            case NEGATIVE_INFINITY: {
                return NEGATIVE_INFINITY;
            }
            case POSITIVE_INFINITY: {
                return POSITIVE_INFINITY;
            }
            case NOT_PERFORMED: {
                return NOT_PERFORMED;
            }
            case NOT_PERMITTED: {
                return NOT_PERMITTED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DataAbsentReason of(java.lang.String value) {
        return DataAbsentReason.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return DataAbsentReason.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return DataAbsentReason.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataAbsentReason other = (DataAbsentReason)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        UNKNOWN("unknown"),
        ASKED_UNKNOWN("asked-unknown"),
        TEMP_UNKNOWN("temp-unknown"),
        NOT_ASKED("not-asked"),
        ASKED_DECLINED("asked-declined"),
        MASKED("masked"),
        NOT_APPLICABLE("not-applicable"),
        UNSUPPORTED("unsupported"),
        AS_TEXT("as-text"),
        ERROR("error"),
        NOT_A_NUMBER("not-a-number"),
        NEGATIVE_INFINITY("negative-infinity"),
        POSITIVE_INFINITY("positive-infinity"),
        NOT_PERFORMED("not-performed"),
        NOT_PERMITTED("not-permitted");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DataAbsentReason build() {
            return new DataAbsentReason(this);
        }
    }
}

