/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/observation-status")
public class DetectedIssueStatus
extends Code {
    public static final DetectedIssueStatus REGISTERED = DetectedIssueStatus.builder().value(ValueSet.REGISTERED).build();
    public static final DetectedIssueStatus PRELIMINARY = DetectedIssueStatus.builder().value(ValueSet.PRELIMINARY).build();
    public static final DetectedIssueStatus FINAL = DetectedIssueStatus.builder().value(ValueSet.FINAL).build();
    public static final DetectedIssueStatus AMENDED = DetectedIssueStatus.builder().value(ValueSet.AMENDED).build();
    public static final DetectedIssueStatus CORRECTED = DetectedIssueStatus.builder().value(ValueSet.CORRECTED).build();
    public static final DetectedIssueStatus CANCELLED = DetectedIssueStatus.builder().value(ValueSet.CANCELLED).build();
    public static final DetectedIssueStatus ENTERED_IN_ERROR = DetectedIssueStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final DetectedIssueStatus UNKNOWN = DetectedIssueStatus.builder().value(ValueSet.UNKNOWN).build();
    private volatile int hashCode;

    private DetectedIssueStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static DetectedIssueStatus of(ValueSet value) {
        switch (value) {
            case REGISTERED: {
                return REGISTERED;
            }
            case PRELIMINARY: {
                return PRELIMINARY;
            }
            case FINAL: {
                return FINAL;
            }
            case AMENDED: {
                return AMENDED;
            }
            case CORRECTED: {
                return CORRECTED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DetectedIssueStatus of(java.lang.String value) {
        return DetectedIssueStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return DetectedIssueStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return DetectedIssueStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DetectedIssueStatus other = (DetectedIssueStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        REGISTERED("registered"),
        PRELIMINARY("preliminary"),
        FINAL("final"),
        AMENDED("amended"),
        CORRECTED("corrected"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DetectedIssueStatus build() {
            return new DetectedIssueStatus(this);
        }
    }
}

