/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/device-nametype")
public class DeviceNameType
extends Code {
    public static final DeviceNameType UDI_LABEL_NAME = DeviceNameType.builder().value(ValueSet.UDI_LABEL_NAME).build();
    public static final DeviceNameType USER_FRIENDLY_NAME = DeviceNameType.builder().value(ValueSet.USER_FRIENDLY_NAME).build();
    public static final DeviceNameType PATIENT_REPORTED_NAME = DeviceNameType.builder().value(ValueSet.PATIENT_REPORTED_NAME).build();
    public static final DeviceNameType MANUFACTURER_NAME = DeviceNameType.builder().value(ValueSet.MANUFACTURER_NAME).build();
    public static final DeviceNameType MODEL_NAME = DeviceNameType.builder().value(ValueSet.MODEL_NAME).build();
    public static final DeviceNameType OTHER = DeviceNameType.builder().value(ValueSet.OTHER).build();
    private volatile int hashCode;

    private DeviceNameType(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static DeviceNameType of(ValueSet value) {
        switch (value) {
            case UDI_LABEL_NAME: {
                return UDI_LABEL_NAME;
            }
            case USER_FRIENDLY_NAME: {
                return USER_FRIENDLY_NAME;
            }
            case PATIENT_REPORTED_NAME: {
                return PATIENT_REPORTED_NAME;
            }
            case MANUFACTURER_NAME: {
                return MANUFACTURER_NAME;
            }
            case MODEL_NAME: {
                return MODEL_NAME;
            }
            case OTHER: {
                return OTHER;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DeviceNameType of(java.lang.String value) {
        return DeviceNameType.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return DeviceNameType.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return DeviceNameType.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceNameType other = (DeviceNameType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        UDI_LABEL_NAME("udi-label-name"),
        USER_FRIENDLY_NAME("user-friendly-name"),
        PATIENT_REPORTED_NAME("patient-reported-name"),
        MANUFACTURER_NAME("manufacturer-name"),
        MODEL_NAME("model-name"),
        OTHER("other");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DeviceNameType build() {
            return new DeviceNameType(this);
        }
    }
}

