/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/data-types")
public class FHIRDefinedType
extends Code {
    public static final FHIRDefinedType ADDRESS = FHIRDefinedType.builder().value(ValueSet.ADDRESS).build();
    public static final FHIRDefinedType AGE = FHIRDefinedType.builder().value(ValueSet.AGE).build();
    public static final FHIRDefinedType ANNOTATION = FHIRDefinedType.builder().value(ValueSet.ANNOTATION).build();
    public static final FHIRDefinedType ATTACHMENT = FHIRDefinedType.builder().value(ValueSet.ATTACHMENT).build();
    public static final FHIRDefinedType BACKBONE_ELEMENT = FHIRDefinedType.builder().value(ValueSet.BACKBONE_ELEMENT).build();
    public static final FHIRDefinedType CODEABLE_CONCEPT = FHIRDefinedType.builder().value(ValueSet.CODEABLE_CONCEPT).build();
    public static final FHIRDefinedType CODING = FHIRDefinedType.builder().value(ValueSet.CODING).build();
    public static final FHIRDefinedType CONTACT_DETAIL = FHIRDefinedType.builder().value(ValueSet.CONTACT_DETAIL).build();
    public static final FHIRDefinedType CONTACT_POINT = FHIRDefinedType.builder().value(ValueSet.CONTACT_POINT).build();
    public static final FHIRDefinedType CONTRIBUTOR = FHIRDefinedType.builder().value(ValueSet.CONTRIBUTOR).build();
    public static final FHIRDefinedType COUNT = FHIRDefinedType.builder().value(ValueSet.COUNT).build();
    public static final FHIRDefinedType DATA_REQUIREMENT = FHIRDefinedType.builder().value(ValueSet.DATA_REQUIREMENT).build();
    public static final FHIRDefinedType DISTANCE = FHIRDefinedType.builder().value(ValueSet.DISTANCE).build();
    public static final FHIRDefinedType DOSAGE = FHIRDefinedType.builder().value(ValueSet.DOSAGE).build();
    public static final FHIRDefinedType DURATION = FHIRDefinedType.builder().value(ValueSet.DURATION).build();
    public static final FHIRDefinedType ELEMENT = FHIRDefinedType.builder().value(ValueSet.ELEMENT).build();
    public static final FHIRDefinedType ELEMENT_DEFINITION = FHIRDefinedType.builder().value(ValueSet.ELEMENT_DEFINITION).build();
    public static final FHIRDefinedType EXPRESSION = FHIRDefinedType.builder().value(ValueSet.EXPRESSION).build();
    public static final FHIRDefinedType EXTENSION = FHIRDefinedType.builder().value(ValueSet.EXTENSION).build();
    public static final FHIRDefinedType HUMAN_NAME = FHIRDefinedType.builder().value(ValueSet.HUMAN_NAME).build();
    public static final FHIRDefinedType IDENTIFIER = FHIRDefinedType.builder().value(ValueSet.IDENTIFIER).build();
    public static final FHIRDefinedType MARKETING_STATUS = FHIRDefinedType.builder().value(ValueSet.MARKETING_STATUS).build();
    public static final FHIRDefinedType META = FHIRDefinedType.builder().value(ValueSet.META).build();
    public static final FHIRDefinedType MONEY = FHIRDefinedType.builder().value(ValueSet.MONEY).build();
    public static final FHIRDefinedType MONEY_QUANTITY = FHIRDefinedType.builder().value(ValueSet.MONEY_QUANTITY).build();
    public static final FHIRDefinedType NARRATIVE = FHIRDefinedType.builder().value(ValueSet.NARRATIVE).build();
    public static final FHIRDefinedType PARAMETER_DEFINITION = FHIRDefinedType.builder().value(ValueSet.PARAMETER_DEFINITION).build();
    public static final FHIRDefinedType PERIOD = FHIRDefinedType.builder().value(ValueSet.PERIOD).build();
    public static final FHIRDefinedType POPULATION = FHIRDefinedType.builder().value(ValueSet.POPULATION).build();
    public static final FHIRDefinedType PROD_CHARACTERISTIC = FHIRDefinedType.builder().value(ValueSet.PROD_CHARACTERISTIC).build();
    public static final FHIRDefinedType PRODUCT_SHELF_LIFE = FHIRDefinedType.builder().value(ValueSet.PRODUCT_SHELF_LIFE).build();
    public static final FHIRDefinedType QUANTITY = FHIRDefinedType.builder().value(ValueSet.QUANTITY).build();
    public static final FHIRDefinedType RANGE = FHIRDefinedType.builder().value(ValueSet.RANGE).build();
    public static final FHIRDefinedType RATIO = FHIRDefinedType.builder().value(ValueSet.RATIO).build();
    public static final FHIRDefinedType REFERENCE = FHIRDefinedType.builder().value(ValueSet.REFERENCE).build();
    public static final FHIRDefinedType RELATED_ARTIFACT = FHIRDefinedType.builder().value(ValueSet.RELATED_ARTIFACT).build();
    public static final FHIRDefinedType SAMPLED_DATA = FHIRDefinedType.builder().value(ValueSet.SAMPLED_DATA).build();
    public static final FHIRDefinedType SIGNATURE = FHIRDefinedType.builder().value(ValueSet.SIGNATURE).build();
    public static final FHIRDefinedType SIMPLE_QUANTITY = FHIRDefinedType.builder().value(ValueSet.SIMPLE_QUANTITY).build();
    public static final FHIRDefinedType SUBSTANCE_AMOUNT = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE_AMOUNT).build();
    public static final FHIRDefinedType TIMING = FHIRDefinedType.builder().value(ValueSet.TIMING).build();
    public static final FHIRDefinedType TRIGGER_DEFINITION = FHIRDefinedType.builder().value(ValueSet.TRIGGER_DEFINITION).build();
    public static final FHIRDefinedType USAGE_CONTEXT = FHIRDefinedType.builder().value(ValueSet.USAGE_CONTEXT).build();
    public static final FHIRDefinedType BASE64BINARY = FHIRDefinedType.builder().value(ValueSet.BASE64BINARY).build();
    public static final FHIRDefinedType BOOLEAN = FHIRDefinedType.builder().value(ValueSet.BOOLEAN).build();
    public static final FHIRDefinedType CANONICAL = FHIRDefinedType.builder().value(ValueSet.CANONICAL).build();
    public static final FHIRDefinedType CODE = FHIRDefinedType.builder().value(ValueSet.CODE).build();
    public static final FHIRDefinedType DATE = FHIRDefinedType.builder().value(ValueSet.DATE).build();
    public static final FHIRDefinedType DATE_TIME = FHIRDefinedType.builder().value(ValueSet.DATE_TIME).build();
    public static final FHIRDefinedType DECIMAL = FHIRDefinedType.builder().value(ValueSet.DECIMAL).build();
    public static final FHIRDefinedType ID = FHIRDefinedType.builder().value(ValueSet.ID).build();
    public static final FHIRDefinedType INSTANT = FHIRDefinedType.builder().value(ValueSet.INSTANT).build();
    public static final FHIRDefinedType INTEGER = FHIRDefinedType.builder().value(ValueSet.INTEGER).build();
    public static final FHIRDefinedType MARKDOWN = FHIRDefinedType.builder().value(ValueSet.MARKDOWN).build();
    public static final FHIRDefinedType OID = FHIRDefinedType.builder().value(ValueSet.OID).build();
    public static final FHIRDefinedType POSITIVE_INT = FHIRDefinedType.builder().value(ValueSet.POSITIVE_INT).build();
    public static final FHIRDefinedType STRING = FHIRDefinedType.builder().value(ValueSet.STRING).build();
    public static final FHIRDefinedType TIME = FHIRDefinedType.builder().value(ValueSet.TIME).build();
    public static final FHIRDefinedType UNSIGNED_INT = FHIRDefinedType.builder().value(ValueSet.UNSIGNED_INT).build();
    public static final FHIRDefinedType URI = FHIRDefinedType.builder().value(ValueSet.URI).build();
    public static final FHIRDefinedType URL = FHIRDefinedType.builder().value(ValueSet.URL).build();
    public static final FHIRDefinedType UUID = FHIRDefinedType.builder().value(ValueSet.UUID).build();
    public static final FHIRDefinedType XHTML = FHIRDefinedType.builder().value(ValueSet.XHTML).build();
    public static final FHIRDefinedType ACCOUNT = FHIRDefinedType.builder().value(ValueSet.ACCOUNT).build();
    public static final FHIRDefinedType ACTIVITY_DEFINITION = FHIRDefinedType.builder().value(ValueSet.ACTIVITY_DEFINITION).build();
    public static final FHIRDefinedType ADVERSE_EVENT = FHIRDefinedType.builder().value(ValueSet.ADVERSE_EVENT).build();
    public static final FHIRDefinedType ALLERGY_INTOLERANCE = FHIRDefinedType.builder().value(ValueSet.ALLERGY_INTOLERANCE).build();
    public static final FHIRDefinedType APPOINTMENT = FHIRDefinedType.builder().value(ValueSet.APPOINTMENT).build();
    public static final FHIRDefinedType APPOINTMENT_RESPONSE = FHIRDefinedType.builder().value(ValueSet.APPOINTMENT_RESPONSE).build();
    public static final FHIRDefinedType AUDIT_EVENT = FHIRDefinedType.builder().value(ValueSet.AUDIT_EVENT).build();
    public static final FHIRDefinedType BASIC = FHIRDefinedType.builder().value(ValueSet.BASIC).build();
    public static final FHIRDefinedType BINARY = FHIRDefinedType.builder().value(ValueSet.BINARY).build();
    public static final FHIRDefinedType BIOLOGICALLY_DERIVED_PRODUCT = FHIRDefinedType.builder().value(ValueSet.BIOLOGICALLY_DERIVED_PRODUCT).build();
    public static final FHIRDefinedType BODY_STRUCTURE = FHIRDefinedType.builder().value(ValueSet.BODY_STRUCTURE).build();
    public static final FHIRDefinedType BUNDLE = FHIRDefinedType.builder().value(ValueSet.BUNDLE).build();
    public static final FHIRDefinedType CAPABILITY_STATEMENT = FHIRDefinedType.builder().value(ValueSet.CAPABILITY_STATEMENT).build();
    public static final FHIRDefinedType CARE_PLAN = FHIRDefinedType.builder().value(ValueSet.CARE_PLAN).build();
    public static final FHIRDefinedType CARE_TEAM = FHIRDefinedType.builder().value(ValueSet.CARE_TEAM).build();
    public static final FHIRDefinedType CATALOG_ENTRY = FHIRDefinedType.builder().value(ValueSet.CATALOG_ENTRY).build();
    public static final FHIRDefinedType CHARGE_ITEM = FHIRDefinedType.builder().value(ValueSet.CHARGE_ITEM).build();
    public static final FHIRDefinedType CHARGE_ITEM_DEFINITION = FHIRDefinedType.builder().value(ValueSet.CHARGE_ITEM_DEFINITION).build();
    public static final FHIRDefinedType CLAIM = FHIRDefinedType.builder().value(ValueSet.CLAIM).build();
    public static final FHIRDefinedType CLAIM_RESPONSE = FHIRDefinedType.builder().value(ValueSet.CLAIM_RESPONSE).build();
    public static final FHIRDefinedType CLINICAL_IMPRESSION = FHIRDefinedType.builder().value(ValueSet.CLINICAL_IMPRESSION).build();
    public static final FHIRDefinedType CODE_SYSTEM = FHIRDefinedType.builder().value(ValueSet.CODE_SYSTEM).build();
    public static final FHIRDefinedType COMMUNICATION = FHIRDefinedType.builder().value(ValueSet.COMMUNICATION).build();
    public static final FHIRDefinedType COMMUNICATION_REQUEST = FHIRDefinedType.builder().value(ValueSet.COMMUNICATION_REQUEST).build();
    public static final FHIRDefinedType COMPARTMENT_DEFINITION = FHIRDefinedType.builder().value(ValueSet.COMPARTMENT_DEFINITION).build();
    public static final FHIRDefinedType COMPOSITION = FHIRDefinedType.builder().value(ValueSet.COMPOSITION).build();
    public static final FHIRDefinedType CONCEPT_MAP = FHIRDefinedType.builder().value(ValueSet.CONCEPT_MAP).build();
    public static final FHIRDefinedType CONDITION = FHIRDefinedType.builder().value(ValueSet.CONDITION).build();
    public static final FHIRDefinedType CONSENT = FHIRDefinedType.builder().value(ValueSet.CONSENT).build();
    public static final FHIRDefinedType CONTRACT = FHIRDefinedType.builder().value(ValueSet.CONTRACT).build();
    public static final FHIRDefinedType COVERAGE = FHIRDefinedType.builder().value(ValueSet.COVERAGE).build();
    public static final FHIRDefinedType COVERAGE_ELIGIBILITY_REQUEST = FHIRDefinedType.builder().value(ValueSet.COVERAGE_ELIGIBILITY_REQUEST).build();
    public static final FHIRDefinedType COVERAGE_ELIGIBILITY_RESPONSE = FHIRDefinedType.builder().value(ValueSet.COVERAGE_ELIGIBILITY_RESPONSE).build();
    public static final FHIRDefinedType DETECTED_ISSUE = FHIRDefinedType.builder().value(ValueSet.DETECTED_ISSUE).build();
    public static final FHIRDefinedType DEVICE = FHIRDefinedType.builder().value(ValueSet.DEVICE).build();
    public static final FHIRDefinedType DEVICE_DEFINITION = FHIRDefinedType.builder().value(ValueSet.DEVICE_DEFINITION).build();
    public static final FHIRDefinedType DEVICE_METRIC = FHIRDefinedType.builder().value(ValueSet.DEVICE_METRIC).build();
    public static final FHIRDefinedType DEVICE_REQUEST = FHIRDefinedType.builder().value(ValueSet.DEVICE_REQUEST).build();
    public static final FHIRDefinedType DEVICE_USE_STATEMENT = FHIRDefinedType.builder().value(ValueSet.DEVICE_USE_STATEMENT).build();
    public static final FHIRDefinedType DIAGNOSTIC_REPORT = FHIRDefinedType.builder().value(ValueSet.DIAGNOSTIC_REPORT).build();
    public static final FHIRDefinedType DOCUMENT_MANIFEST = FHIRDefinedType.builder().value(ValueSet.DOCUMENT_MANIFEST).build();
    public static final FHIRDefinedType DOCUMENT_REFERENCE = FHIRDefinedType.builder().value(ValueSet.DOCUMENT_REFERENCE).build();
    public static final FHIRDefinedType DOMAIN_RESOURCE = FHIRDefinedType.builder().value(ValueSet.DOMAIN_RESOURCE).build();
    public static final FHIRDefinedType EFFECT_EVIDENCE_SYNTHESIS = FHIRDefinedType.builder().value(ValueSet.EFFECT_EVIDENCE_SYNTHESIS).build();
    public static final FHIRDefinedType ENCOUNTER = FHIRDefinedType.builder().value(ValueSet.ENCOUNTER).build();
    public static final FHIRDefinedType ENDPOINT = FHIRDefinedType.builder().value(ValueSet.ENDPOINT).build();
    public static final FHIRDefinedType ENROLLMENT_REQUEST = FHIRDefinedType.builder().value(ValueSet.ENROLLMENT_REQUEST).build();
    public static final FHIRDefinedType ENROLLMENT_RESPONSE = FHIRDefinedType.builder().value(ValueSet.ENROLLMENT_RESPONSE).build();
    public static final FHIRDefinedType EPISODE_OF_CARE = FHIRDefinedType.builder().value(ValueSet.EPISODE_OF_CARE).build();
    public static final FHIRDefinedType EVENT_DEFINITION = FHIRDefinedType.builder().value(ValueSet.EVENT_DEFINITION).build();
    public static final FHIRDefinedType EVIDENCE = FHIRDefinedType.builder().value(ValueSet.EVIDENCE).build();
    public static final FHIRDefinedType EVIDENCE_VARIABLE = FHIRDefinedType.builder().value(ValueSet.EVIDENCE_VARIABLE).build();
    public static final FHIRDefinedType EXAMPLE_SCENARIO = FHIRDefinedType.builder().value(ValueSet.EXAMPLE_SCENARIO).build();
    public static final FHIRDefinedType EXPLANATION_OF_BENEFIT = FHIRDefinedType.builder().value(ValueSet.EXPLANATION_OF_BENEFIT).build();
    public static final FHIRDefinedType FAMILY_MEMBER_HISTORY = FHIRDefinedType.builder().value(ValueSet.FAMILY_MEMBER_HISTORY).build();
    public static final FHIRDefinedType FLAG = FHIRDefinedType.builder().value(ValueSet.FLAG).build();
    public static final FHIRDefinedType GOAL = FHIRDefinedType.builder().value(ValueSet.GOAL).build();
    public static final FHIRDefinedType GRAPH_DEFINITION = FHIRDefinedType.builder().value(ValueSet.GRAPH_DEFINITION).build();
    public static final FHIRDefinedType GROUP = FHIRDefinedType.builder().value(ValueSet.GROUP).build();
    public static final FHIRDefinedType GUIDANCE_RESPONSE = FHIRDefinedType.builder().value(ValueSet.GUIDANCE_RESPONSE).build();
    public static final FHIRDefinedType HEALTHCARE_SERVICE = FHIRDefinedType.builder().value(ValueSet.HEALTHCARE_SERVICE).build();
    public static final FHIRDefinedType IMAGING_STUDY = FHIRDefinedType.builder().value(ValueSet.IMAGING_STUDY).build();
    public static final FHIRDefinedType IMMUNIZATION = FHIRDefinedType.builder().value(ValueSet.IMMUNIZATION).build();
    public static final FHIRDefinedType IMMUNIZATION_EVALUATION = FHIRDefinedType.builder().value(ValueSet.IMMUNIZATION_EVALUATION).build();
    public static final FHIRDefinedType IMMUNIZATION_RECOMMENDATION = FHIRDefinedType.builder().value(ValueSet.IMMUNIZATION_RECOMMENDATION).build();
    public static final FHIRDefinedType IMPLEMENTATION_GUIDE = FHIRDefinedType.builder().value(ValueSet.IMPLEMENTATION_GUIDE).build();
    public static final FHIRDefinedType INSURANCE_PLAN = FHIRDefinedType.builder().value(ValueSet.INSURANCE_PLAN).build();
    public static final FHIRDefinedType INVOICE = FHIRDefinedType.builder().value(ValueSet.INVOICE).build();
    public static final FHIRDefinedType LIBRARY = FHIRDefinedType.builder().value(ValueSet.LIBRARY).build();
    public static final FHIRDefinedType LINKAGE = FHIRDefinedType.builder().value(ValueSet.LINKAGE).build();
    public static final FHIRDefinedType LIST = FHIRDefinedType.builder().value(ValueSet.LIST).build();
    public static final FHIRDefinedType LOCATION = FHIRDefinedType.builder().value(ValueSet.LOCATION).build();
    public static final FHIRDefinedType MEASURE = FHIRDefinedType.builder().value(ValueSet.MEASURE).build();
    public static final FHIRDefinedType MEASURE_REPORT = FHIRDefinedType.builder().value(ValueSet.MEASURE_REPORT).build();
    public static final FHIRDefinedType MEDIA = FHIRDefinedType.builder().value(ValueSet.MEDIA).build();
    public static final FHIRDefinedType MEDICATION = FHIRDefinedType.builder().value(ValueSet.MEDICATION).build();
    public static final FHIRDefinedType MEDICATION_ADMINISTRATION = FHIRDefinedType.builder().value(ValueSet.MEDICATION_ADMINISTRATION).build();
    public static final FHIRDefinedType MEDICATION_DISPENSE = FHIRDefinedType.builder().value(ValueSet.MEDICATION_DISPENSE).build();
    public static final FHIRDefinedType MEDICATION_KNOWLEDGE = FHIRDefinedType.builder().value(ValueSet.MEDICATION_KNOWLEDGE).build();
    public static final FHIRDefinedType MEDICATION_REQUEST = FHIRDefinedType.builder().value(ValueSet.MEDICATION_REQUEST).build();
    public static final FHIRDefinedType MEDICATION_STATEMENT = FHIRDefinedType.builder().value(ValueSet.MEDICATION_STATEMENT).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_AUTHORIZATION = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_AUTHORIZATION).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_CONTRAINDICATION = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_CONTRAINDICATION).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_INDICATION = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_INDICATION).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_INGREDIENT = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_INGREDIENT).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_INTERACTION = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_INTERACTION).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_MANUFACTURED = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_MANUFACTURED).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_PACKAGED = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_PACKAGED).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_PHARMACEUTICAL = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_PHARMACEUTICAL).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT = FHIRDefinedType.builder().value(ValueSet.MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT).build();
    public static final FHIRDefinedType MESSAGE_DEFINITION = FHIRDefinedType.builder().value(ValueSet.MESSAGE_DEFINITION).build();
    public static final FHIRDefinedType MESSAGE_HEADER = FHIRDefinedType.builder().value(ValueSet.MESSAGE_HEADER).build();
    public static final FHIRDefinedType MOLECULAR_SEQUENCE = FHIRDefinedType.builder().value(ValueSet.MOLECULAR_SEQUENCE).build();
    public static final FHIRDefinedType NAMING_SYSTEM = FHIRDefinedType.builder().value(ValueSet.NAMING_SYSTEM).build();
    public static final FHIRDefinedType NUTRITION_ORDER = FHIRDefinedType.builder().value(ValueSet.NUTRITION_ORDER).build();
    public static final FHIRDefinedType OBSERVATION = FHIRDefinedType.builder().value(ValueSet.OBSERVATION).build();
    public static final FHIRDefinedType OBSERVATION_DEFINITION = FHIRDefinedType.builder().value(ValueSet.OBSERVATION_DEFINITION).build();
    public static final FHIRDefinedType OPERATION_DEFINITION = FHIRDefinedType.builder().value(ValueSet.OPERATION_DEFINITION).build();
    public static final FHIRDefinedType OPERATION_OUTCOME = FHIRDefinedType.builder().value(ValueSet.OPERATION_OUTCOME).build();
    public static final FHIRDefinedType ORGANIZATION = FHIRDefinedType.builder().value(ValueSet.ORGANIZATION).build();
    public static final FHIRDefinedType ORGANIZATION_AFFILIATION = FHIRDefinedType.builder().value(ValueSet.ORGANIZATION_AFFILIATION).build();
    public static final FHIRDefinedType PARAMETERS = FHIRDefinedType.builder().value(ValueSet.PARAMETERS).build();
    public static final FHIRDefinedType PATIENT = FHIRDefinedType.builder().value(ValueSet.PATIENT).build();
    public static final FHIRDefinedType PAYMENT_NOTICE = FHIRDefinedType.builder().value(ValueSet.PAYMENT_NOTICE).build();
    public static final FHIRDefinedType PAYMENT_RECONCILIATION = FHIRDefinedType.builder().value(ValueSet.PAYMENT_RECONCILIATION).build();
    public static final FHIRDefinedType PERSON = FHIRDefinedType.builder().value(ValueSet.PERSON).build();
    public static final FHIRDefinedType PLAN_DEFINITION = FHIRDefinedType.builder().value(ValueSet.PLAN_DEFINITION).build();
    public static final FHIRDefinedType PRACTITIONER = FHIRDefinedType.builder().value(ValueSet.PRACTITIONER).build();
    public static final FHIRDefinedType PRACTITIONER_ROLE = FHIRDefinedType.builder().value(ValueSet.PRACTITIONER_ROLE).build();
    public static final FHIRDefinedType PROCEDURE = FHIRDefinedType.builder().value(ValueSet.PROCEDURE).build();
    public static final FHIRDefinedType PROVENANCE = FHIRDefinedType.builder().value(ValueSet.PROVENANCE).build();
    public static final FHIRDefinedType QUESTIONNAIRE = FHIRDefinedType.builder().value(ValueSet.QUESTIONNAIRE).build();
    public static final FHIRDefinedType QUESTIONNAIRE_RESPONSE = FHIRDefinedType.builder().value(ValueSet.QUESTIONNAIRE_RESPONSE).build();
    public static final FHIRDefinedType RELATED_PERSON = FHIRDefinedType.builder().value(ValueSet.RELATED_PERSON).build();
    public static final FHIRDefinedType REQUEST_GROUP = FHIRDefinedType.builder().value(ValueSet.REQUEST_GROUP).build();
    public static final FHIRDefinedType RESEARCH_DEFINITION = FHIRDefinedType.builder().value(ValueSet.RESEARCH_DEFINITION).build();
    public static final FHIRDefinedType RESEARCH_ELEMENT_DEFINITION = FHIRDefinedType.builder().value(ValueSet.RESEARCH_ELEMENT_DEFINITION).build();
    public static final FHIRDefinedType RESEARCH_STUDY = FHIRDefinedType.builder().value(ValueSet.RESEARCH_STUDY).build();
    public static final FHIRDefinedType RESEARCH_SUBJECT = FHIRDefinedType.builder().value(ValueSet.RESEARCH_SUBJECT).build();
    public static final FHIRDefinedType RESOURCE = FHIRDefinedType.builder().value(ValueSet.RESOURCE).build();
    public static final FHIRDefinedType RISK_ASSESSMENT = FHIRDefinedType.builder().value(ValueSet.RISK_ASSESSMENT).build();
    public static final FHIRDefinedType RISK_EVIDENCE_SYNTHESIS = FHIRDefinedType.builder().value(ValueSet.RISK_EVIDENCE_SYNTHESIS).build();
    public static final FHIRDefinedType SCHEDULE = FHIRDefinedType.builder().value(ValueSet.SCHEDULE).build();
    public static final FHIRDefinedType SEARCH_PARAMETER = FHIRDefinedType.builder().value(ValueSet.SEARCH_PARAMETER).build();
    public static final FHIRDefinedType SERVICE_REQUEST = FHIRDefinedType.builder().value(ValueSet.SERVICE_REQUEST).build();
    public static final FHIRDefinedType SLOT = FHIRDefinedType.builder().value(ValueSet.SLOT).build();
    public static final FHIRDefinedType SPECIMEN = FHIRDefinedType.builder().value(ValueSet.SPECIMEN).build();
    public static final FHIRDefinedType SPECIMEN_DEFINITION = FHIRDefinedType.builder().value(ValueSet.SPECIMEN_DEFINITION).build();
    public static final FHIRDefinedType STRUCTURE_DEFINITION = FHIRDefinedType.builder().value(ValueSet.STRUCTURE_DEFINITION).build();
    public static final FHIRDefinedType STRUCTURE_MAP = FHIRDefinedType.builder().value(ValueSet.STRUCTURE_MAP).build();
    public static final FHIRDefinedType SUBSCRIPTION = FHIRDefinedType.builder().value(ValueSet.SUBSCRIPTION).build();
    public static final FHIRDefinedType SUBSTANCE = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE).build();
    public static final FHIRDefinedType SUBSTANCE_NUCLEIC_ACID = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE_NUCLEIC_ACID).build();
    public static final FHIRDefinedType SUBSTANCE_POLYMER = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE_POLYMER).build();
    public static final FHIRDefinedType SUBSTANCE_PROTEIN = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE_PROTEIN).build();
    public static final FHIRDefinedType SUBSTANCE_REFERENCE_INFORMATION = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE_REFERENCE_INFORMATION).build();
    public static final FHIRDefinedType SUBSTANCE_SOURCE_MATERIAL = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE_SOURCE_MATERIAL).build();
    public static final FHIRDefinedType SUBSTANCE_SPECIFICATION = FHIRDefinedType.builder().value(ValueSet.SUBSTANCE_SPECIFICATION).build();
    public static final FHIRDefinedType SUPPLY_DELIVERY = FHIRDefinedType.builder().value(ValueSet.SUPPLY_DELIVERY).build();
    public static final FHIRDefinedType SUPPLY_REQUEST = FHIRDefinedType.builder().value(ValueSet.SUPPLY_REQUEST).build();
    public static final FHIRDefinedType TASK = FHIRDefinedType.builder().value(ValueSet.TASK).build();
    public static final FHIRDefinedType TERMINOLOGY_CAPABILITIES = FHIRDefinedType.builder().value(ValueSet.TERMINOLOGY_CAPABILITIES).build();
    public static final FHIRDefinedType TEST_REPORT = FHIRDefinedType.builder().value(ValueSet.TEST_REPORT).build();
    public static final FHIRDefinedType TEST_SCRIPT = FHIRDefinedType.builder().value(ValueSet.TEST_SCRIPT).build();
    public static final FHIRDefinedType VALUE_SET = FHIRDefinedType.builder().value(ValueSet.VALUE_SET).build();
    public static final FHIRDefinedType VERIFICATION_RESULT = FHIRDefinedType.builder().value(ValueSet.VERIFICATION_RESULT).build();
    public static final FHIRDefinedType VISION_PRESCRIPTION = FHIRDefinedType.builder().value(ValueSet.VISION_PRESCRIPTION).build();
    private volatile int hashCode;

    private FHIRDefinedType(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static FHIRDefinedType of(ValueSet value) {
        switch (value) {
            case ADDRESS: {
                return ADDRESS;
            }
            case AGE: {
                return AGE;
            }
            case ANNOTATION: {
                return ANNOTATION;
            }
            case ATTACHMENT: {
                return ATTACHMENT;
            }
            case BACKBONE_ELEMENT: {
                return BACKBONE_ELEMENT;
            }
            case CODEABLE_CONCEPT: {
                return CODEABLE_CONCEPT;
            }
            case CODING: {
                return CODING;
            }
            case CONTACT_DETAIL: {
                return CONTACT_DETAIL;
            }
            case CONTACT_POINT: {
                return CONTACT_POINT;
            }
            case CONTRIBUTOR: {
                return CONTRIBUTOR;
            }
            case COUNT: {
                return COUNT;
            }
            case DATA_REQUIREMENT: {
                return DATA_REQUIREMENT;
            }
            case DISTANCE: {
                return DISTANCE;
            }
            case DOSAGE: {
                return DOSAGE;
            }
            case DURATION: {
                return DURATION;
            }
            case ELEMENT: {
                return ELEMENT;
            }
            case ELEMENT_DEFINITION: {
                return ELEMENT_DEFINITION;
            }
            case EXPRESSION: {
                return EXPRESSION;
            }
            case EXTENSION: {
                return EXTENSION;
            }
            case HUMAN_NAME: {
                return HUMAN_NAME;
            }
            case IDENTIFIER: {
                return IDENTIFIER;
            }
            case MARKETING_STATUS: {
                return MARKETING_STATUS;
            }
            case META: {
                return META;
            }
            case MONEY: {
                return MONEY;
            }
            case MONEY_QUANTITY: {
                return MONEY_QUANTITY;
            }
            case NARRATIVE: {
                return NARRATIVE;
            }
            case PARAMETER_DEFINITION: {
                return PARAMETER_DEFINITION;
            }
            case PERIOD: {
                return PERIOD;
            }
            case POPULATION: {
                return POPULATION;
            }
            case PROD_CHARACTERISTIC: {
                return PROD_CHARACTERISTIC;
            }
            case PRODUCT_SHELF_LIFE: {
                return PRODUCT_SHELF_LIFE;
            }
            case QUANTITY: {
                return QUANTITY;
            }
            case RANGE: {
                return RANGE;
            }
            case RATIO: {
                return RATIO;
            }
            case REFERENCE: {
                return REFERENCE;
            }
            case RELATED_ARTIFACT: {
                return RELATED_ARTIFACT;
            }
            case SAMPLED_DATA: {
                return SAMPLED_DATA;
            }
            case SIGNATURE: {
                return SIGNATURE;
            }
            case SIMPLE_QUANTITY: {
                return SIMPLE_QUANTITY;
            }
            case SUBSTANCE_AMOUNT: {
                return SUBSTANCE_AMOUNT;
            }
            case TIMING: {
                return TIMING;
            }
            case TRIGGER_DEFINITION: {
                return TRIGGER_DEFINITION;
            }
            case USAGE_CONTEXT: {
                return USAGE_CONTEXT;
            }
            case BASE64BINARY: {
                return BASE64BINARY;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case CANONICAL: {
                return CANONICAL;
            }
            case CODE: {
                return CODE;
            }
            case DATE: {
                return DATE;
            }
            case DATE_TIME: {
                return DATE_TIME;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case ID: {
                return ID;
            }
            case INSTANT: {
                return INSTANT;
            }
            case INTEGER: {
                return INTEGER;
            }
            case MARKDOWN: {
                return MARKDOWN;
            }
            case OID: {
                return OID;
            }
            case POSITIVE_INT: {
                return POSITIVE_INT;
            }
            case STRING: {
                return STRING;
            }
            case TIME: {
                return TIME;
            }
            case UNSIGNED_INT: {
                return UNSIGNED_INT;
            }
            case URI: {
                return URI;
            }
            case URL: {
                return URL;
            }
            case UUID: {
                return UUID;
            }
            case XHTML: {
                return XHTML;
            }
            case ACCOUNT: {
                return ACCOUNT;
            }
            case ACTIVITY_DEFINITION: {
                return ACTIVITY_DEFINITION;
            }
            case ADVERSE_EVENT: {
                return ADVERSE_EVENT;
            }
            case ALLERGY_INTOLERANCE: {
                return ALLERGY_INTOLERANCE;
            }
            case APPOINTMENT: {
                return APPOINTMENT;
            }
            case APPOINTMENT_RESPONSE: {
                return APPOINTMENT_RESPONSE;
            }
            case AUDIT_EVENT: {
                return AUDIT_EVENT;
            }
            case BASIC: {
                return BASIC;
            }
            case BINARY: {
                return BINARY;
            }
            case BIOLOGICALLY_DERIVED_PRODUCT: {
                return BIOLOGICALLY_DERIVED_PRODUCT;
            }
            case BODY_STRUCTURE: {
                return BODY_STRUCTURE;
            }
            case BUNDLE: {
                return BUNDLE;
            }
            case CAPABILITY_STATEMENT: {
                return CAPABILITY_STATEMENT;
            }
            case CARE_PLAN: {
                return CARE_PLAN;
            }
            case CARE_TEAM: {
                return CARE_TEAM;
            }
            case CATALOG_ENTRY: {
                return CATALOG_ENTRY;
            }
            case CHARGE_ITEM: {
                return CHARGE_ITEM;
            }
            case CHARGE_ITEM_DEFINITION: {
                return CHARGE_ITEM_DEFINITION;
            }
            case CLAIM: {
                return CLAIM;
            }
            case CLAIM_RESPONSE: {
                return CLAIM_RESPONSE;
            }
            case CLINICAL_IMPRESSION: {
                return CLINICAL_IMPRESSION;
            }
            case CODE_SYSTEM: {
                return CODE_SYSTEM;
            }
            case COMMUNICATION: {
                return COMMUNICATION;
            }
            case COMMUNICATION_REQUEST: {
                return COMMUNICATION_REQUEST;
            }
            case COMPARTMENT_DEFINITION: {
                return COMPARTMENT_DEFINITION;
            }
            case COMPOSITION: {
                return COMPOSITION;
            }
            case CONCEPT_MAP: {
                return CONCEPT_MAP;
            }
            case CONDITION: {
                return CONDITION;
            }
            case CONSENT: {
                return CONSENT;
            }
            case CONTRACT: {
                return CONTRACT;
            }
            case COVERAGE: {
                return COVERAGE;
            }
            case COVERAGE_ELIGIBILITY_REQUEST: {
                return COVERAGE_ELIGIBILITY_REQUEST;
            }
            case COVERAGE_ELIGIBILITY_RESPONSE: {
                return COVERAGE_ELIGIBILITY_RESPONSE;
            }
            case DETECTED_ISSUE: {
                return DETECTED_ISSUE;
            }
            case DEVICE: {
                return DEVICE;
            }
            case DEVICE_DEFINITION: {
                return DEVICE_DEFINITION;
            }
            case DEVICE_METRIC: {
                return DEVICE_METRIC;
            }
            case DEVICE_REQUEST: {
                return DEVICE_REQUEST;
            }
            case DEVICE_USE_STATEMENT: {
                return DEVICE_USE_STATEMENT;
            }
            case DIAGNOSTIC_REPORT: {
                return DIAGNOSTIC_REPORT;
            }
            case DOCUMENT_MANIFEST: {
                return DOCUMENT_MANIFEST;
            }
            case DOCUMENT_REFERENCE: {
                return DOCUMENT_REFERENCE;
            }
            case DOMAIN_RESOURCE: {
                return DOMAIN_RESOURCE;
            }
            case EFFECT_EVIDENCE_SYNTHESIS: {
                return EFFECT_EVIDENCE_SYNTHESIS;
            }
            case ENCOUNTER: {
                return ENCOUNTER;
            }
            case ENDPOINT: {
                return ENDPOINT;
            }
            case ENROLLMENT_REQUEST: {
                return ENROLLMENT_REQUEST;
            }
            case ENROLLMENT_RESPONSE: {
                return ENROLLMENT_RESPONSE;
            }
            case EPISODE_OF_CARE: {
                return EPISODE_OF_CARE;
            }
            case EVENT_DEFINITION: {
                return EVENT_DEFINITION;
            }
            case EVIDENCE: {
                return EVIDENCE;
            }
            case EVIDENCE_VARIABLE: {
                return EVIDENCE_VARIABLE;
            }
            case EXAMPLE_SCENARIO: {
                return EXAMPLE_SCENARIO;
            }
            case EXPLANATION_OF_BENEFIT: {
                return EXPLANATION_OF_BENEFIT;
            }
            case FAMILY_MEMBER_HISTORY: {
                return FAMILY_MEMBER_HISTORY;
            }
            case FLAG: {
                return FLAG;
            }
            case GOAL: {
                return GOAL;
            }
            case GRAPH_DEFINITION: {
                return GRAPH_DEFINITION;
            }
            case GROUP: {
                return GROUP;
            }
            case GUIDANCE_RESPONSE: {
                return GUIDANCE_RESPONSE;
            }
            case HEALTHCARE_SERVICE: {
                return HEALTHCARE_SERVICE;
            }
            case IMAGING_STUDY: {
                return IMAGING_STUDY;
            }
            case IMMUNIZATION: {
                return IMMUNIZATION;
            }
            case IMMUNIZATION_EVALUATION: {
                return IMMUNIZATION_EVALUATION;
            }
            case IMMUNIZATION_RECOMMENDATION: {
                return IMMUNIZATION_RECOMMENDATION;
            }
            case IMPLEMENTATION_GUIDE: {
                return IMPLEMENTATION_GUIDE;
            }
            case INSURANCE_PLAN: {
                return INSURANCE_PLAN;
            }
            case INVOICE: {
                return INVOICE;
            }
            case LIBRARY: {
                return LIBRARY;
            }
            case LINKAGE: {
                return LINKAGE;
            }
            case LIST: {
                return LIST;
            }
            case LOCATION: {
                return LOCATION;
            }
            case MEASURE: {
                return MEASURE;
            }
            case MEASURE_REPORT: {
                return MEASURE_REPORT;
            }
            case MEDIA: {
                return MEDIA;
            }
            case MEDICATION: {
                return MEDICATION;
            }
            case MEDICATION_ADMINISTRATION: {
                return MEDICATION_ADMINISTRATION;
            }
            case MEDICATION_DISPENSE: {
                return MEDICATION_DISPENSE;
            }
            case MEDICATION_KNOWLEDGE: {
                return MEDICATION_KNOWLEDGE;
            }
            case MEDICATION_REQUEST: {
                return MEDICATION_REQUEST;
            }
            case MEDICATION_STATEMENT: {
                return MEDICATION_STATEMENT;
            }
            case MEDICINAL_PRODUCT: {
                return MEDICINAL_PRODUCT;
            }
            case MEDICINAL_PRODUCT_AUTHORIZATION: {
                return MEDICINAL_PRODUCT_AUTHORIZATION;
            }
            case MEDICINAL_PRODUCT_CONTRAINDICATION: {
                return MEDICINAL_PRODUCT_CONTRAINDICATION;
            }
            case MEDICINAL_PRODUCT_INDICATION: {
                return MEDICINAL_PRODUCT_INDICATION;
            }
            case MEDICINAL_PRODUCT_INGREDIENT: {
                return MEDICINAL_PRODUCT_INGREDIENT;
            }
            case MEDICINAL_PRODUCT_INTERACTION: {
                return MEDICINAL_PRODUCT_INTERACTION;
            }
            case MEDICINAL_PRODUCT_MANUFACTURED: {
                return MEDICINAL_PRODUCT_MANUFACTURED;
            }
            case MEDICINAL_PRODUCT_PACKAGED: {
                return MEDICINAL_PRODUCT_PACKAGED;
            }
            case MEDICINAL_PRODUCT_PHARMACEUTICAL: {
                return MEDICINAL_PRODUCT_PHARMACEUTICAL;
            }
            case MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT: {
                return MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT;
            }
            case MESSAGE_DEFINITION: {
                return MESSAGE_DEFINITION;
            }
            case MESSAGE_HEADER: {
                return MESSAGE_HEADER;
            }
            case MOLECULAR_SEQUENCE: {
                return MOLECULAR_SEQUENCE;
            }
            case NAMING_SYSTEM: {
                return NAMING_SYSTEM;
            }
            case NUTRITION_ORDER: {
                return NUTRITION_ORDER;
            }
            case OBSERVATION: {
                return OBSERVATION;
            }
            case OBSERVATION_DEFINITION: {
                return OBSERVATION_DEFINITION;
            }
            case OPERATION_DEFINITION: {
                return OPERATION_DEFINITION;
            }
            case OPERATION_OUTCOME: {
                return OPERATION_OUTCOME;
            }
            case ORGANIZATION: {
                return ORGANIZATION;
            }
            case ORGANIZATION_AFFILIATION: {
                return ORGANIZATION_AFFILIATION;
            }
            case PARAMETERS: {
                return PARAMETERS;
            }
            case PATIENT: {
                return PATIENT;
            }
            case PAYMENT_NOTICE: {
                return PAYMENT_NOTICE;
            }
            case PAYMENT_RECONCILIATION: {
                return PAYMENT_RECONCILIATION;
            }
            case PERSON: {
                return PERSON;
            }
            case PLAN_DEFINITION: {
                return PLAN_DEFINITION;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case PRACTITIONER_ROLE: {
                return PRACTITIONER_ROLE;
            }
            case PROCEDURE: {
                return PROCEDURE;
            }
            case PROVENANCE: {
                return PROVENANCE;
            }
            case QUESTIONNAIRE: {
                return QUESTIONNAIRE;
            }
            case QUESTIONNAIRE_RESPONSE: {
                return QUESTIONNAIRE_RESPONSE;
            }
            case RELATED_PERSON: {
                return RELATED_PERSON;
            }
            case REQUEST_GROUP: {
                return REQUEST_GROUP;
            }
            case RESEARCH_DEFINITION: {
                return RESEARCH_DEFINITION;
            }
            case RESEARCH_ELEMENT_DEFINITION: {
                return RESEARCH_ELEMENT_DEFINITION;
            }
            case RESEARCH_STUDY: {
                return RESEARCH_STUDY;
            }
            case RESEARCH_SUBJECT: {
                return RESEARCH_SUBJECT;
            }
            case RESOURCE: {
                return RESOURCE;
            }
            case RISK_ASSESSMENT: {
                return RISK_ASSESSMENT;
            }
            case RISK_EVIDENCE_SYNTHESIS: {
                return RISK_EVIDENCE_SYNTHESIS;
            }
            case SCHEDULE: {
                return SCHEDULE;
            }
            case SEARCH_PARAMETER: {
                return SEARCH_PARAMETER;
            }
            case SERVICE_REQUEST: {
                return SERVICE_REQUEST;
            }
            case SLOT: {
                return SLOT;
            }
            case SPECIMEN: {
                return SPECIMEN;
            }
            case SPECIMEN_DEFINITION: {
                return SPECIMEN_DEFINITION;
            }
            case STRUCTURE_DEFINITION: {
                return STRUCTURE_DEFINITION;
            }
            case STRUCTURE_MAP: {
                return STRUCTURE_MAP;
            }
            case SUBSCRIPTION: {
                return SUBSCRIPTION;
            }
            case SUBSTANCE: {
                return SUBSTANCE;
            }
            case SUBSTANCE_NUCLEIC_ACID: {
                return SUBSTANCE_NUCLEIC_ACID;
            }
            case SUBSTANCE_POLYMER: {
                return SUBSTANCE_POLYMER;
            }
            case SUBSTANCE_PROTEIN: {
                return SUBSTANCE_PROTEIN;
            }
            case SUBSTANCE_REFERENCE_INFORMATION: {
                return SUBSTANCE_REFERENCE_INFORMATION;
            }
            case SUBSTANCE_SOURCE_MATERIAL: {
                return SUBSTANCE_SOURCE_MATERIAL;
            }
            case SUBSTANCE_SPECIFICATION: {
                return SUBSTANCE_SPECIFICATION;
            }
            case SUPPLY_DELIVERY: {
                return SUPPLY_DELIVERY;
            }
            case SUPPLY_REQUEST: {
                return SUPPLY_REQUEST;
            }
            case TASK: {
                return TASK;
            }
            case TERMINOLOGY_CAPABILITIES: {
                return TERMINOLOGY_CAPABILITIES;
            }
            case TEST_REPORT: {
                return TEST_REPORT;
            }
            case TEST_SCRIPT: {
                return TEST_SCRIPT;
            }
            case VALUE_SET: {
                return VALUE_SET;
            }
            case VERIFICATION_RESULT: {
                return VERIFICATION_RESULT;
            }
            case VISION_PRESCRIPTION: {
                return VISION_PRESCRIPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static FHIRDefinedType of(java.lang.String value) {
        return FHIRDefinedType.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return FHIRDefinedType.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return FHIRDefinedType.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FHIRDefinedType other = (FHIRDefinedType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        ADDRESS("Address"),
        AGE("Age"),
        ANNOTATION("Annotation"),
        ATTACHMENT("Attachment"),
        BACKBONE_ELEMENT("BackboneElement"),
        CODEABLE_CONCEPT("CodeableConcept"),
        CODING("Coding"),
        CONTACT_DETAIL("ContactDetail"),
        CONTACT_POINT("ContactPoint"),
        CONTRIBUTOR("Contributor"),
        COUNT("Count"),
        DATA_REQUIREMENT("DataRequirement"),
        DISTANCE("Distance"),
        DOSAGE("Dosage"),
        DURATION("Duration"),
        ELEMENT("Element"),
        ELEMENT_DEFINITION("ElementDefinition"),
        EXPRESSION("Expression"),
        EXTENSION("Extension"),
        HUMAN_NAME("HumanName"),
        IDENTIFIER("Identifier"),
        MARKETING_STATUS("MarketingStatus"),
        META("Meta"),
        MONEY("Money"),
        MONEY_QUANTITY("MoneyQuantity"),
        NARRATIVE("Narrative"),
        PARAMETER_DEFINITION("ParameterDefinition"),
        PERIOD("Period"),
        POPULATION("Population"),
        PROD_CHARACTERISTIC("ProdCharacteristic"),
        PRODUCT_SHELF_LIFE("ProductShelfLife"),
        QUANTITY("Quantity"),
        RANGE("Range"),
        RATIO("Ratio"),
        REFERENCE("Reference"),
        RELATED_ARTIFACT("RelatedArtifact"),
        SAMPLED_DATA("SampledData"),
        SIGNATURE("Signature"),
        SIMPLE_QUANTITY("SimpleQuantity"),
        SUBSTANCE_AMOUNT("SubstanceAmount"),
        TIMING("Timing"),
        TRIGGER_DEFINITION("TriggerDefinition"),
        USAGE_CONTEXT("UsageContext"),
        BASE64BINARY("base64Binary"),
        BOOLEAN("boolean"),
        CANONICAL("canonical"),
        CODE("code"),
        DATE("date"),
        DATE_TIME("dateTime"),
        DECIMAL("decimal"),
        ID("id"),
        INSTANT("instant"),
        INTEGER("integer"),
        MARKDOWN("markdown"),
        OID("oid"),
        POSITIVE_INT("positiveInt"),
        STRING("string"),
        TIME("time"),
        UNSIGNED_INT("unsignedInt"),
        URI("uri"),
        URL("url"),
        UUID("uuid"),
        XHTML("xhtml"),
        ACCOUNT("Account"),
        ACTIVITY_DEFINITION("ActivityDefinition"),
        ADVERSE_EVENT("AdverseEvent"),
        ALLERGY_INTOLERANCE("AllergyIntolerance"),
        APPOINTMENT("Appointment"),
        APPOINTMENT_RESPONSE("AppointmentResponse"),
        AUDIT_EVENT("AuditEvent"),
        BASIC("Basic"),
        BINARY("Binary"),
        BIOLOGICALLY_DERIVED_PRODUCT("BiologicallyDerivedProduct"),
        BODY_STRUCTURE("BodyStructure"),
        BUNDLE("Bundle"),
        CAPABILITY_STATEMENT("CapabilityStatement"),
        CARE_PLAN("CarePlan"),
        CARE_TEAM("CareTeam"),
        CATALOG_ENTRY("CatalogEntry"),
        CHARGE_ITEM("ChargeItem"),
        CHARGE_ITEM_DEFINITION("ChargeItemDefinition"),
        CLAIM("Claim"),
        CLAIM_RESPONSE("ClaimResponse"),
        CLINICAL_IMPRESSION("ClinicalImpression"),
        CODE_SYSTEM("CodeSystem"),
        COMMUNICATION("Communication"),
        COMMUNICATION_REQUEST("CommunicationRequest"),
        COMPARTMENT_DEFINITION("CompartmentDefinition"),
        COMPOSITION("Composition"),
        CONCEPT_MAP("ConceptMap"),
        CONDITION("Condition"),
        CONSENT("Consent"),
        CONTRACT("Contract"),
        COVERAGE("Coverage"),
        COVERAGE_ELIGIBILITY_REQUEST("CoverageEligibilityRequest"),
        COVERAGE_ELIGIBILITY_RESPONSE("CoverageEligibilityResponse"),
        DETECTED_ISSUE("DetectedIssue"),
        DEVICE("Device"),
        DEVICE_DEFINITION("DeviceDefinition"),
        DEVICE_METRIC("DeviceMetric"),
        DEVICE_REQUEST("DeviceRequest"),
        DEVICE_USE_STATEMENT("DeviceUseStatement"),
        DIAGNOSTIC_REPORT("DiagnosticReport"),
        DOCUMENT_MANIFEST("DocumentManifest"),
        DOCUMENT_REFERENCE("DocumentReference"),
        DOMAIN_RESOURCE("DomainResource"),
        EFFECT_EVIDENCE_SYNTHESIS("EffectEvidenceSynthesis"),
        ENCOUNTER("Encounter"),
        ENDPOINT("Endpoint"),
        ENROLLMENT_REQUEST("EnrollmentRequest"),
        ENROLLMENT_RESPONSE("EnrollmentResponse"),
        EPISODE_OF_CARE("EpisodeOfCare"),
        EVENT_DEFINITION("EventDefinition"),
        EVIDENCE("Evidence"),
        EVIDENCE_VARIABLE("EvidenceVariable"),
        EXAMPLE_SCENARIO("ExampleScenario"),
        EXPLANATION_OF_BENEFIT("ExplanationOfBenefit"),
        FAMILY_MEMBER_HISTORY("FamilyMemberHistory"),
        FLAG("Flag"),
        GOAL("Goal"),
        GRAPH_DEFINITION("GraphDefinition"),
        GROUP("Group"),
        GUIDANCE_RESPONSE("GuidanceResponse"),
        HEALTHCARE_SERVICE("HealthcareService"),
        IMAGING_STUDY("ImagingStudy"),
        IMMUNIZATION("Immunization"),
        IMMUNIZATION_EVALUATION("ImmunizationEvaluation"),
        IMMUNIZATION_RECOMMENDATION("ImmunizationRecommendation"),
        IMPLEMENTATION_GUIDE("ImplementationGuide"),
        INSURANCE_PLAN("InsurancePlan"),
        INVOICE("Invoice"),
        LIBRARY("Library"),
        LINKAGE("Linkage"),
        LIST("List"),
        LOCATION("Location"),
        MEASURE("Measure"),
        MEASURE_REPORT("MeasureReport"),
        MEDIA("Media"),
        MEDICATION("Medication"),
        MEDICATION_ADMINISTRATION("MedicationAdministration"),
        MEDICATION_DISPENSE("MedicationDispense"),
        MEDICATION_KNOWLEDGE("MedicationKnowledge"),
        MEDICATION_REQUEST("MedicationRequest"),
        MEDICATION_STATEMENT("MedicationStatement"),
        MEDICINAL_PRODUCT("MedicinalProduct"),
        MEDICINAL_PRODUCT_AUTHORIZATION("MedicinalProductAuthorization"),
        MEDICINAL_PRODUCT_CONTRAINDICATION("MedicinalProductContraindication"),
        MEDICINAL_PRODUCT_INDICATION("MedicinalProductIndication"),
        MEDICINAL_PRODUCT_INGREDIENT("MedicinalProductIngredient"),
        MEDICINAL_PRODUCT_INTERACTION("MedicinalProductInteraction"),
        MEDICINAL_PRODUCT_MANUFACTURED("MedicinalProductManufactured"),
        MEDICINAL_PRODUCT_PACKAGED("MedicinalProductPackaged"),
        MEDICINAL_PRODUCT_PHARMACEUTICAL("MedicinalProductPharmaceutical"),
        MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT("MedicinalProductUndesirableEffect"),
        MESSAGE_DEFINITION("MessageDefinition"),
        MESSAGE_HEADER("MessageHeader"),
        MOLECULAR_SEQUENCE("MolecularSequence"),
        NAMING_SYSTEM("NamingSystem"),
        NUTRITION_ORDER("NutritionOrder"),
        OBSERVATION("Observation"),
        OBSERVATION_DEFINITION("ObservationDefinition"),
        OPERATION_DEFINITION("OperationDefinition"),
        OPERATION_OUTCOME("OperationOutcome"),
        ORGANIZATION("Organization"),
        ORGANIZATION_AFFILIATION("OrganizationAffiliation"),
        PARAMETERS("Parameters"),
        PATIENT("Patient"),
        PAYMENT_NOTICE("PaymentNotice"),
        PAYMENT_RECONCILIATION("PaymentReconciliation"),
        PERSON("Person"),
        PLAN_DEFINITION("PlanDefinition"),
        PRACTITIONER("Practitioner"),
        PRACTITIONER_ROLE("PractitionerRole"),
        PROCEDURE("Procedure"),
        PROVENANCE("Provenance"),
        QUESTIONNAIRE("Questionnaire"),
        QUESTIONNAIRE_RESPONSE("QuestionnaireResponse"),
        RELATED_PERSON("RelatedPerson"),
        REQUEST_GROUP("RequestGroup"),
        RESEARCH_DEFINITION("ResearchDefinition"),
        RESEARCH_ELEMENT_DEFINITION("ResearchElementDefinition"),
        RESEARCH_STUDY("ResearchStudy"),
        RESEARCH_SUBJECT("ResearchSubject"),
        RESOURCE("Resource"),
        RISK_ASSESSMENT("RiskAssessment"),
        RISK_EVIDENCE_SYNTHESIS("RiskEvidenceSynthesis"),
        SCHEDULE("Schedule"),
        SEARCH_PARAMETER("SearchParameter"),
        SERVICE_REQUEST("ServiceRequest"),
        SLOT("Slot"),
        SPECIMEN("Specimen"),
        SPECIMEN_DEFINITION("SpecimenDefinition"),
        STRUCTURE_DEFINITION("StructureDefinition"),
        STRUCTURE_MAP("StructureMap"),
        SUBSCRIPTION("Subscription"),
        SUBSTANCE("Substance"),
        SUBSTANCE_NUCLEIC_ACID("SubstanceNucleicAcid"),
        SUBSTANCE_POLYMER("SubstancePolymer"),
        SUBSTANCE_PROTEIN("SubstanceProtein"),
        SUBSTANCE_REFERENCE_INFORMATION("SubstanceReferenceInformation"),
        SUBSTANCE_SOURCE_MATERIAL("SubstanceSourceMaterial"),
        SUBSTANCE_SPECIFICATION("SubstanceSpecification"),
        SUPPLY_DELIVERY("SupplyDelivery"),
        SUPPLY_REQUEST("SupplyRequest"),
        TASK("Task"),
        TERMINOLOGY_CAPABILITIES("TerminologyCapabilities"),
        TEST_REPORT("TestReport"),
        TEST_SCRIPT("TestScript"),
        VALUE_SET("ValueSet"),
        VERIFICATION_RESULT("VerificationResult"),
        VISION_PRESCRIPTION("VisionPrescription");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public FHIRDefinedType build() {
            return new FHIRDefinedType(this);
        }
    }
}

